/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.storage;

import com.falsepattern.chunk.api.DataManager;
import com.falsepattern.chunk.api.DataRegistry;
import com.falsepattern.lumi.api.chunk.LumiChunk;
import com.falsepattern.lumi.api.chunk.LumiSubChunk;
import com.falsepattern.lumi.api.lighting.LumiLightingEngine;
import com.falsepattern.lumi.api.world.LumiWorld;
import com.falsepattern.lumi.api.world.LumiWorldProvider;
import com.falsepattern.lumi.internal.Lumi;
import com.falsepattern.lumi.internal.event.EventPoster;
import com.falsepattern.lumi.internal.world.WorldProviderManager;
import java.nio.ByteBuffer;
import lombok.Generated;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ChunkPacketManager
implements DataManager.PacketDataManager {
    private static final Logger LOG = Lumi.createLogger("Chunk Packet Manager");
    private static final ChunkPacketManager INSTANCE = new ChunkPacketManager();
    private static final int BLOCKS_PER_SUB_CHUNK = 4096;
    private static final int BITS_PER_BLOCK = 8;
    private static final int BYTES_PER_BLOCK = 1;
    private static final int MAX_PACKET_SIZE_BYTES_PER_WORLD_PROVIDER = 4097;
    private static final int PROVIDER_ID_SIZE_BYTES = 4;
    private static final int PROVIDER_WRITTEN_BYTES_SIZE_BYTES = 4;
    private static final int HEADER_SIZE_BYTES = 8;
    private int maxPacketSize = 0;
    private boolean isRegistered = false;

    public static ChunkPacketManager chunkPacketManager() {
        return INSTANCE;
    }

    public void registerDataManager() {
        if (this.isRegistered) {
            return;
        }
        int worldProviderCount = WorldProviderManager.worldProviderManager().worldProviderCount();
        int subChunkMaxPacketSize = 4097 * worldProviderCount;
        this.maxPacketSize = EventPoster.postChunkPacketSizeEvent(0, subChunkMaxPacketSize, 0);
        int maxHeaderSize = worldProviderCount * 8;
        this.maxPacketSize += maxHeaderSize;
        DataRegistry.registerDataManager((DataManager)this);
        this.isRegistered = true;
        LOG.info("Registered data manager");
    }

    public String domain() {
        return "lumi";
    }

    public String id() {
        return "lumi_packet";
    }

    public void writeToBuffer(Chunk chunkBase, int subChunkMask, boolean forceUpdate, ByteBuffer output) {
        World worldBase = chunkBase.field_76637_e;
        WorldProviderManager worldProviderManager = WorldProviderManager.worldProviderManager();
        int worldProviderCount = worldProviderManager.worldProviderCount();
        for (int providerInternalID = 0; providerInternalID < worldProviderCount; ++providerInternalID) {
            LumiSubChunk subChunk;
            int chunkPosY;
            LumiWorld world;
            LumiWorldProvider worldProvider = worldProviderManager.getWorldProviderByInternalID(providerInternalID);
            if (worldProvider == null || (world = worldProvider.provideWorld(worldBase)) == null) continue;
            output.putInt(providerInternalID);
            int lengthPosition = output.position();
            output.position(lengthPosition + 4);
            LumiChunk chunk = world.lumi$wrap(chunkBase);
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            chunk.lumi$writeToPacket(output);
            for (chunkPosY = 0; chunkPosY < 16; ++chunkPosY) {
                subChunk = ChunkPacketManager.getSubChunk(chunk, subChunkMask, chunkPosY);
                if (subChunk == null) continue;
                subChunk.lumi$writeToPacket(output);
            }
            lightingEngine.writeChunkToPacket(chunk, output);
            for (chunkPosY = 0; chunkPosY < 16; ++chunkPosY) {
                subChunk = ChunkPacketManager.getSubChunk(chunk, subChunkMask, chunkPosY);
                if (subChunk == null) continue;
                lightingEngine.writeSubChunkToPacket(chunk, subChunk, output);
            }
            int length = output.position() - 4 - lengthPosition;
            output.putInt(lengthPosition, length);
        }
    }

    public void readFromBuffer(Chunk chunkBase, int subChunkMask, boolean forceUpdate, ByteBuffer input) {
        World worldBase = chunkBase.field_76637_e;
        WorldProviderManager worldProviderManager = WorldProviderManager.worldProviderManager();
        while (input.remaining() > 0) {
            LumiSubChunk subChunk;
            int chunkPosY;
            int providerInternalID = input.getInt();
            int length = input.getInt();
            if (length == 0) continue;
            int startPosition = input.position();
            LumiWorldProvider worldProvider = worldProviderManager.getWorldProviderByInternalID(providerInternalID);
            if (worldProvider == null) {
                input.position(startPosition + length);
                continue;
            }
            LumiWorld world = worldProvider.provideWorld(worldBase);
            if (world == null) {
                input.position(startPosition + length);
                continue;
            }
            LumiChunk chunk = world.lumi$wrap(chunkBase);
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            chunk.lumi$readFromPacket(input);
            for (chunkPosY = 0; chunkPosY < 16; ++chunkPosY) {
                subChunk = ChunkPacketManager.getSubChunk(chunk, subChunkMask, chunkPosY);
                if (subChunk == null) continue;
                subChunk.lumi$readFromPacket(input);
            }
            lightingEngine.readChunkFromPacket(chunk, input);
            for (chunkPosY = 0; chunkPosY < 16; ++chunkPosY) {
                subChunk = ChunkPacketManager.getSubChunk(chunk, subChunkMask, chunkPosY);
                if (subChunk == null) continue;
                lightingEngine.readSubChunkFromPacket(chunk, subChunk, input);
            }
            input.position(startPosition + length);
        }
    }

    @Nullable
    private static LumiSubChunk getSubChunk(LumiChunk chunk, int subChunkMask, int chunkPosY) {
        if ((subChunkMask & 1 << chunkPosY) == 0) {
            return null;
        }
        return chunk.lumi$getSubChunk(chunkPosY);
    }

    @Generated
    private ChunkPacketManager() {
    }

    @Generated
    public int maxPacketSize() {
        return this.maxPacketSize;
    }
}

