/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.mixin.mixins.common.lumi;

import com.falsepattern.lumi.api.chunk.LumiChunkRoot;
import com.falsepattern.lumi.api.world.LumiWorld;
import com.falsepattern.lumi.api.world.LumiWorldRoot;
import com.falsepattern.lumi.internal.mixin.interfaces.LumiWorldRootCache;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Unique
@Mixin(value={World.class}, priority=950)
public abstract class LumiWorldRootImplMixin
implements IBlockAccess,
LumiWorldRoot,
LumiWorldRootCache {
    @Final
    @Shadow
    public WorldProvider field_73011_w;
    @Shadow
    protected IChunkProvider field_73020_y;
    @Shadow
    public boolean field_72995_K;
    private LumiWorld[] lumi$lumiWorlds;

    @Shadow
    public abstract Block func_147439_a(int var1, int var2, int var3);

    @Shadow
    public abstract boolean func_147437_c(int var1, int var2, int var3);

    @Shadow
    public abstract boolean func_72873_a(int var1, int var2, int var3, int var4);

    @Shadow
    public abstract boolean func_72904_c(int var1, int var2, int var3, int var4, int var5, int var6);

    @Shadow
    public abstract int func_72805_g(int var1, int var2, int var3);

    @Shadow
    public abstract void func_147479_m(int var1, int var2, int var3);

    @Shadow
    public abstract TileEntity func_147438_o(int var1, int var2, int var3);

    @Shadow
    public abstract boolean func_147451_t(int var1, int var2, int var3);

    @Override
    public LumiWorld[] lumi$getLumiWorlds() {
        return this.lumi$lumiWorlds;
    }

    @Override
    public void lumi$setLumiWorlds(LumiWorld[] lumiWorlds) {
        this.lumi$lumiWorlds = lumiWorlds;
    }

    @Inject(method={"lumi$onWorldInit()V"}, at={@At(value="RETURN")}, remap=false, require=1)
    @Dynamic(value="Implemented by [Lumi] with the interface [com.falsepattern.lumi.api.init.LumiWorldInitHook]")
    private void lumiWorldRootInit(CallbackInfo ci) {
    }

    @Override
    @NotNull
    public String lumi$worldRootID() {
        return "lumi_world_root";
    }

    @Override
    public void lumi$markBlockForRenderUpdate(int posX, int posY, int posZ) {
        if (this.field_72995_K) {
            this.func_147479_m(posX, posY, posZ);
        }
    }

    @Override
    public void lumi$scheduleLightingUpdate(int posX, int posY, int posZ) {
        this.func_147451_t(posX, posY, posZ);
    }

    @Override
    @NotNull
    public IChunkProvider lumi$chunkProvider() {
        return this.field_73020_y;
    }

    @Override
    public boolean lumi$doChunksExistInRange(int minPosX, int minPosY, int minPosZ, int maxPosX, int maxPosY, int maxPosZ) {
        return this.func_72904_c(minPosX, minPosY, minPosZ, maxPosX, maxPosY, maxPosZ);
    }

    @Override
    public boolean lumi$doChunksExistInRange(int centerPosX, int centerPosY, int centerPosZ, int blockRange) {
        return this.func_72873_a(centerPosX, centerPosY, centerPosZ, blockRange);
    }

    @Override
    @Nullable
    public LumiChunkRoot lumi$getChunkRootFromBlockPosIfExists(int posX, int posZ) {
        int chunkPosX = posX >> 4;
        int chunkPosZ = posZ >> 4;
        return this.lumi$getChunkRootFromChunkPosIfExists(chunkPosX, chunkPosZ);
    }

    @Override
    @Nullable
    public LumiChunkRoot lumi$getChunkRootFromChunkPosIfExists(int chunkPosX, int chunkPosZ) {
        Chunk chunk;
        if (this.field_73020_y == null) {
            return null;
        }
        if (this.field_73020_y instanceof ChunkProviderServer) {
            Object chunk2;
            ChunkProviderServer chunkProviderServer = (ChunkProviderServer)this.field_73020_y;
            LongHashMap loadedChunks = chunkProviderServer.field_73244_f;
            if (loadedChunks != null && (chunk2 = loadedChunks.func_76164_a(ChunkCoordIntPair.func_77272_a((int)chunkPosX, (int)chunkPosZ))) instanceof LumiChunkRoot && !(chunk2 instanceof EmptyChunk)) {
                return (LumiChunkRoot)chunk2;
            }
            return null;
        }
        if (this.field_73020_y.func_73149_a(chunkPosX, chunkPosZ) && (chunk = this.field_73020_y.func_73154_d(chunkPosX, chunkPosZ)) instanceof LumiChunkRoot && !(chunk instanceof EmptyChunk)) {
            return (LumiChunkRoot)chunk;
        }
        return null;
    }

    @Override
    @NotNull
    public String lumi$blockStorageRootID() {
        return "lumi_world_root";
    }

    @Override
    public boolean lumi$isClientSide() {
        return this.field_72995_K;
    }

    @Override
    public boolean lumi$hasSky() {
        return !this.field_73011_w.field_76576_e;
    }

    @Override
    @NotNull
    public Block lumi$getBlock(int posX, int posY, int posZ) {
        return this.func_147439_a(posX, posY, posZ);
    }

    @Override
    public int lumi$getBlockMeta(int posX, int posY, int posZ) {
        return this.func_72805_g(posX, posY, posZ);
    }

    @Override
    public boolean lumi$isAirBlock(int posX, int posY, int posZ) {
        return this.func_147437_c(posX, posY, posZ);
    }

    @Override
    @Nullable
    public TileEntity lumi$getTileEntity(int posX, int posY, int posZ) {
        return this.func_147438_o(posX, posY, posZ);
    }
}

