/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.mixin.mixins.common;

import com.falsepattern.lumi.internal.mixin.hook.LightingHooks;
import net.minecraft.block.Block;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Chunk.class})
public abstract class ChunkMixin {
    @Shadow
    public boolean field_76646_k;
    @Shadow
    public boolean field_150814_l;

    @Inject(method={"onChunkLoad"}, at={@At(value="RETURN")}, require=1)
    private void handleChunkLoad(CallbackInfo ci) {
        LightingHooks.handleChunkLoad(this.thiz());
    }

    @Redirect(method={"setLightValue"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;generateSkylightMap()V"), require=1)
    private void initSubChunkSkyLightOnSet(Chunk thiz, EnumSkyBlock baseLightType, int subChunkPosX, int posY, int subChunkPosZ, int value) {
        int chunkPosY = posY / 16;
        LightingHooks.handleSubChunkInit(thiz, chunkPosY);
    }

    @Overwrite
    public void func_76615_h(int subChunkPosX, int posY, int subChunkPosZ) {
    }

    @Overwrite
    public void func_76603_b() {
        LightingHooks.handleChunkInit(this.thiz());
    }

    @Overwrite
    public int func_76614_a(EnumSkyBlock baseLightType, int subChunkPosX, int posY, int subChunkPosZ) {
        return LightingHooks.getCurrentLightValue(this.thiz(), baseLightType, subChunkPosX, posY, subChunkPosZ);
    }

    @Overwrite
    public void func_150809_p() {
        this.field_76646_k = true;
        this.field_150814_l = LightingHooks.isChunkFullyLit(this.thiz());
    }

    @Overwrite
    private void func_150803_c(boolean onlyOne) {
    }

    @Redirect(method={"func_150807_a"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;generateSkylightMap()V"), require=1)
    private void skipSkyLightGeneration(Chunk thiz) {
    }

    @Redirect(method={"func_150807_a"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;propagateSkylightOcclusion(II)V"), require=1)
    private void skipSkyLightPropagation(Chunk thiz, int posX, int posZ) {
    }

    @Redirect(method={"func_150807_a(IIILnet/minecraft/block/Block;I)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;getSavedLightValue(Lnet/minecraft/world/EnumSkyBlock;III)I"), require=2)
    private int alwaysZeroLightValue(Chunk thiz, EnumSkyBlock baseLightType, int posX, int posY, int posZ) {
        return 0;
    }

    @Redirect(method={"func_150807_a"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;getLightOpacity(Lnet/minecraft/world/IBlockAccess;III)I"), require=2)
    private int alwaysZeroLightOpacity(Block block, IBlockAccess worldBase, int posX, int posY, int posZ) {
        return 0;
    }

    @Inject(method={"func_150807_a"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/chunk/storage/ExtendedBlockStorage;setExtBlockMetadata(IIII)V", ordinal=1, shift=At.Shift.AFTER)}, require=1)
    private void updateLightOnBlockUpdate(int subChunkPosX, int posY, int subChunkPosZ, Block block, int posX, CallbackInfoReturnable<Boolean> cir) {
        LightingHooks.updateLightingForBlock(this.thiz(), subChunkPosX, posY, subChunkPosZ);
    }

    @Redirect(method={"func_150807_a"}, at=@At(value="NEW", args={"class=net/minecraft/world/chunk/storage/ExtendedBlockStorage"}), require=1)
    private ExtendedBlockStorage createSubChunkWithInitializedSkyLight(int posY, boolean hasSky) {
        ExtendedBlockStorage subChunkBase = new ExtendedBlockStorage(posY, hasSky);
        LightingHooks.handleSubChunkInit(this.thiz(), subChunkBase);
        return subChunkBase;
    }

    @Inject(method={"resetRelightChecks"}, at={@At(value="RETURN")}, require=1)
    private void resetQueuedRandomLightUpdates(CallbackInfo cir) {
        LightingHooks.resetQueuedRandomLightUpdates(this.thiz());
    }

    @Overwrite
    public void func_76594_o() {
        LightingHooks.doRandomChunkLightingUpdates(this.thiz());
    }

    private Chunk thiz() {
        return (Chunk)this;
    }
}

