/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.mixin.hook;

import com.falsepattern.lumi.api.LumiChunkAPI;
import com.falsepattern.lumi.api.chunk.LumiChunk;
import com.falsepattern.lumi.api.chunk.LumiSubChunk;
import com.falsepattern.lumi.api.lighting.LightType;
import com.falsepattern.lumi.api.lighting.LumiLightingEngine;
import com.falsepattern.lumi.api.world.LumiWorld;
import com.falsepattern.lumi.internal.config.LumiConfig;
import com.falsepattern.lumi.internal.world.WorldProviderManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import lombok.Generated;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public final class LightingHooks {
    private static final int DEFAULT_PRECIPITATION_HEIGHT = -999;

    public static int getCurrentLightValue(Chunk chunkBase, EnumSkyBlock baseLightType, int subChunkPosX, int posY, int subChunkPosZ) {
        World worldBase = chunkBase.field_76637_e;
        LightType lightType = LightType.of(baseLightType);
        int maxLightValue = 0;
        LumiWorld[] lumiWorldsFromBaseWorld = LightingHooks.lumiWorldsFromBaseWorld(worldBase);
        for (int i = 0; i < lumiWorldsFromBaseWorld.length; ++i) {
            LumiWorld world = lumiWorldsFromBaseWorld[i];
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            int lightValue = lightingEngine.getCurrentLightValueChunk(chunkBase, lightType, subChunkPosX, posY, subChunkPosZ);
            maxLightValue = Math.max(maxLightValue, lightValue);
        }
        return maxLightValue;
    }

    public static int getCurrentLightValueUncached(Chunk chunkBase, EnumSkyBlock baseLightType, int subChunkPosX, int posY, int subChunkPosZ) {
        World worldBase = chunkBase.field_76637_e;
        LightType lightType = LightType.of(baseLightType);
        int maxLightValue = 0;
        LumiWorld[] lumiWorldsFromBaseWorld = LightingHooks.lumiWorldsFromBaseWorld(worldBase);
        for (int i = 0; i < lumiWorldsFromBaseWorld.length; ++i) {
            LumiWorld world = lumiWorldsFromBaseWorld[i];
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            int lightValue = lightingEngine.getCurrentLightValueChunk(chunkBase, lightType, subChunkPosX, posY, subChunkPosZ);
            maxLightValue = Math.max(maxLightValue, lightValue);
        }
        return maxLightValue;
    }

    public static int getMaxBrightness(Chunk chunkBase, EnumSkyBlock baseLightType, int subChunkPosX, int posY, int subChunkPosZ) {
        World worldBase = chunkBase.field_76637_e;
        LightType lightType = LightType.of(baseLightType);
        int posX = (chunkBase.field_76635_g << 4) + subChunkPosX;
        int posZ = (chunkBase.field_76647_h << 4) + subChunkPosZ;
        int maxLightValue = 0;
        LumiWorld[] lumiWorldsFromBaseWorld = LightingHooks.lumiWorldsFromBaseWorld(worldBase);
        for (int i = 0; i < lumiWorldsFromBaseWorld.length; ++i) {
            LumiWorld world = lumiWorldsFromBaseWorld[i];
            int lightValue = world.lumi$getBrightness(lightType, posX, posY, posZ);
            maxLightValue = Math.max(maxLightValue, lightValue);
        }
        return maxLightValue;
    }

    public static boolean isChunkFullyLit(Chunk chunkBase) {
        World worldBase = chunkBase.field_76637_e;
        boolean chunkHasLighting = true;
        LumiWorld[] lumiWorldsFromBaseWorld = LightingHooks.lumiWorldsFromBaseWorld(worldBase);
        for (int i = 0; i < lumiWorldsFromBaseWorld.length; ++i) {
            LumiWorld world = lumiWorldsFromBaseWorld[i];
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            LumiChunk chunk = world.lumi$wrap(chunkBase);
            chunkHasLighting &= lightingEngine.isChunkFullyLit(chunk);
        }
        return chunkHasLighting;
    }

    public static void handleChunkInit(Chunk chunkBase) {
        World worldBase = chunkBase.field_76637_e;
        LightingHooks.resetPrecipitationHeightMap(chunkBase);
        LumiWorld[] lumiWorldsFromBaseWorld = LightingHooks.lumiWorldsFromBaseWorld(worldBase);
        for (int i = 0; i < lumiWorldsFromBaseWorld.length; ++i) {
            LumiWorld world = lumiWorldsFromBaseWorld[i];
            LumiChunk chunk = world.lumi$wrap(chunkBase);
            LumiChunkAPI.scheduleChunkLightingEngineInit(chunk);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleClientChunkInit(Chunk chunkBase) {
        World worldBase = chunkBase.field_76637_e;
        LightingHooks.resetPrecipitationHeightMap(chunkBase);
        LumiWorld[] lumiWorldsFromBaseWorld = LightingHooks.lumiWorldsFromBaseWorld(worldBase);
        for (int i = 0; i < lumiWorldsFromBaseWorld.length; ++i) {
            LumiWorld world = lumiWorldsFromBaseWorld[i];
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            LumiChunk chunk = world.lumi$wrap(chunkBase);
            lightingEngine.handleClientChunkInit(chunk);
        }
    }

    public static void handleSubChunkInit(Chunk chunkBase, ExtendedBlockStorage subChunkBase) {
        World worldBase = chunkBase.field_76637_e;
        LumiWorld[] lumiWorldsFromBaseWorld = LightingHooks.lumiWorldsFromBaseWorld(worldBase);
        for (int i = 0; i < lumiWorldsFromBaseWorld.length; ++i) {
            LumiWorld world = lumiWorldsFromBaseWorld[i];
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            LumiChunk chunk = world.lumi$wrap(chunkBase);
            LumiSubChunk subChunk = world.lumi$wrap(subChunkBase);
            lightingEngine.handleSubChunkInit(chunk, subChunk);
        }
    }

    public static void handleSubChunkInit(Chunk chunkBase, int chunkPosY) {
        World worldBase = chunkBase.field_76637_e;
        LumiWorld[] lumiWorldsFromBaseWorld = LightingHooks.lumiWorldsFromBaseWorld(worldBase);
        for (int i = 0; i < lumiWorldsFromBaseWorld.length; ++i) {
            LumiWorld world = lumiWorldsFromBaseWorld[i];
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            LumiChunk chunk = world.lumi$wrap(chunkBase);
            LumiSubChunk subChunk = chunk.lumi$getSubChunk(chunkPosY);
            lightingEngine.handleSubChunkInit(chunk, subChunk);
        }
    }

    public static void handleChunkLoad(Chunk chunkBase) {
        World worldBase = chunkBase.field_76637_e;
        LumiWorld[] lumiWorldsFromBaseWorld = LightingHooks.lumiWorldsFromBaseWorld(worldBase);
        for (int i = 0; i < lumiWorldsFromBaseWorld.length; ++i) {
            LumiWorld world = lumiWorldsFromBaseWorld[i];
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            LumiChunk chunk = world.lumi$wrap(chunkBase);
            lightingEngine.handleChunkLoad(chunk);
        }
    }

    public static void doRandomChunkLightingUpdates(Chunk chunkBase) {
        if (!LumiConfig.DO_RANDOM_LIGHT_UPDATES) {
            return;
        }
        if (!chunkBase.field_76637_e.field_72995_K && chunkBase.field_111204_q < 200L) {
            return;
        }
        World worldBase = chunkBase.field_76637_e;
        LumiWorld[] lumiWorldsFromBaseWorld = LightingHooks.lumiWorldsFromBaseWorld(worldBase);
        for (int i = 0; i < lumiWorldsFromBaseWorld.length; ++i) {
            LumiWorld world = lumiWorldsFromBaseWorld[i];
            LumiChunk chunk = world.lumi$wrap(chunkBase);
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            lightingEngine.doRandomChunkLightingUpdates(chunk);
        }
    }

    public static void resetQueuedRandomLightUpdates(Chunk chunkBase) {
        World worldBase = chunkBase.field_76637_e;
        LumiWorld[] lumiWorldsFromBaseWorld = LightingHooks.lumiWorldsFromBaseWorld(worldBase);
        for (int i = 0; i < lumiWorldsFromBaseWorld.length; ++i) {
            LumiWorld world = lumiWorldsFromBaseWorld[i];
            LumiChunk chunk = world.lumi$wrap(chunkBase);
            chunk.lumi$resetQueuedRandomLightUpdates();
        }
    }

    public static void updateLightingForBlock(Chunk chunkBase, int subChunkPosX, int posY, int subChunkPosZ) {
        World worldBase = chunkBase.field_76637_e;
        int posX = (chunkBase.field_76635_g << 4) + subChunkPosX;
        int posZ = (chunkBase.field_76647_h << 4) + subChunkPosZ;
        LumiWorld[] lumiWorldsFromBaseWorld = LightingHooks.lumiWorldsFromBaseWorld(worldBase);
        for (int i = 0; i < lumiWorldsFromBaseWorld.length; ++i) {
            LumiWorld world = lumiWorldsFromBaseWorld[i];
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            lightingEngine.updateLightingForBlock(posX, posY, posZ);
        }
    }

    public static void scheduleLightingUpdate(World worldBase, EnumSkyBlock baseLightType, int posX, int posY, int posZ) {
        LightType lightType = LightType.of(baseLightType);
        LightingHooks.scheduleLightingUpdate(worldBase, lightType, posX, posY, posZ);
    }

    public static void scheduleLightingUpdate(World worldBase, LightType lightType, int posX, int posY, int posZ) {
        LumiWorld[] lumiWorldsFromBaseWorld = LightingHooks.lumiWorldsFromBaseWorld(worldBase);
        for (int i = 0; i < lumiWorldsFromBaseWorld.length; ++i) {
            LumiWorld world = lumiWorldsFromBaseWorld[i];
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            lightingEngine.scheduleLightingUpdate(lightType, posX, posY, posZ);
        }
    }

    public static void processLightingUpdatesForAllTypes(Chunk chunkBase) {
        World worldBase = chunkBase.field_76637_e;
        LightingHooks.processLightingUpdatesForAllTypes(worldBase);
    }

    public static void processLightingUpdatesForAllTypes(World worldBase) {
        LumiWorld[] lumiWorldsFromBaseWorld = LightingHooks.lumiWorldsFromBaseWorld(worldBase);
        for (int i = 0; i < lumiWorldsFromBaseWorld.length; ++i) {
            LumiWorld world = lumiWorldsFromBaseWorld[i];
            LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
            lightingEngine.processLightingUpdatesForAllTypes();
        }
    }

    private static LumiWorld[] lumiWorldsFromBaseWorld(World worldBase) {
        return WorldProviderManager.worldProviderManager().lumiWorldsFromBaseWorld(worldBase);
    }

    private static void resetPrecipitationHeightMap(Chunk chunkBase) {
        Arrays.fill(chunkBase.field_76638_b, -999);
    }

    @Generated
    private LightingHooks() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

