/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.lighting.phosphor;

import com.falsepattern.lumi.api.chunk.LumiChunk;
import com.falsepattern.lumi.api.world.LumiWorld;
import java.util.BitSet;

final class WorldChunkSlice {
    private static final int DIAMETER = 5;
    private static final int RADIUS = 2;
    private final LumiWorld world;
    private final int minChunkPosX;
    private final int minChunkPosZ;
    private final BitSet checkedChunks;
    private final LumiChunk[] chunks;

    WorldChunkSlice(LumiWorld world, int chunkPosX, int chunkPosZ) {
        this.world = world;
        this.minChunkPosX = chunkPosX - 2;
        this.minChunkPosZ = chunkPosZ - 2;
        this.checkedChunks = new BitSet(25);
        this.chunks = new LumiChunk[25];
    }

    LumiChunk getChunkFromWorldCoords(int x, int z) {
        return this.getChunk((x >> 4) - this.minChunkPosX, (z >> 4) - this.minChunkPosZ);
    }

    boolean isLoaded(int x, int z, int radius) {
        return this.isLoaded(x - radius, z - radius, x + radius, z + radius);
    }

    boolean isLoaded(int xStart, int zStart, int xEnd, int zEnd) {
        xStart = (xStart >> 4) - this.minChunkPosX;
        zStart = (zStart >> 4) - this.minChunkPosZ;
        xEnd = (xEnd >> 4) - this.minChunkPosX;
        zEnd = (zEnd >> 4) - this.minChunkPosZ;
        for (int i = xStart; i <= xEnd; ++i) {
            for (int j = zStart; j <= zEnd; ++j) {
                if (this.getChunk(i, j) != null) continue;
                return false;
            }
        }
        return true;
    }

    private LumiChunk getChunk(int x, int z) {
        LumiChunk chunk;
        int index = x * 5 + z;
        if (this.checkedChunks.get(index)) {
            return this.chunks[index];
        }
        this.chunks[index] = chunk = this.world.lumi$getChunkFromChunkPosIfExists(this.minChunkPosX + x, this.minChunkPosZ + z);
        this.checkedChunks.set(index);
        return chunk;
    }
}

