/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.lighting.phosphor;

import com.falsepattern.chunk.api.ArrayUtil;
import com.falsepattern.lib.util.MathUtil;
import com.falsepattern.lumi.api.chunk.LumiChunk;
import com.falsepattern.lumi.api.lighting.LightType;
import com.falsepattern.lumi.api.lighting.LumiLightingEngine;
import com.falsepattern.lumi.api.world.LumiWorld;
import com.falsepattern.lumi.internal.Share;
import com.falsepattern.lumi.internal.lighting.phosphor.Direction;
import com.falsepattern.lumi.internal.lighting.phosphor.DirectionSign;
import com.falsepattern.lumi.internal.lighting.phosphor.FacingDirection;
import com.falsepattern.lumi.internal.lighting.phosphor.PhosphorChunk;
import com.falsepattern.lumi.internal.lighting.phosphor.WorldChunkSlice;
import lombok.Generated;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.profiler.Profiler;
import org.jetbrains.annotations.Nullable;

final class PhosphorUtil {
    static final int MIN_LIGHT_VALUE = 0;
    static final int MAX_LIGHT_VALUE = 15;
    static final int MIN_BLOCK_LIGHT_OPACITY = 1;
    static final int MAX_BLOCK_LIGHT_OPACITY = 15;
    static final int MIN_SKY_LIGHT_OPACITY = 0;
    static final int MAX_SKY_LIGHT_OPACITY = 15;
    static final int LIGHT_VALUE_RANGE = 16;
    private static final String NEIGHBOR_LIGHT_CHECKS_NBT_TAG_NAME = "neighbor_light_checks";

    static int clampLightValue(int lightValue) {
        return MathUtil.clamp((int)lightValue, (int)0, (int)15);
    }

    static int clampBlockLightOpacity(int opacityValue) {
        return MathUtil.clamp((int)opacityValue, (int)1, (int)15);
    }

    static int clampSkyLightOpacity(int opacityValue) {
        return MathUtil.clamp((int)opacityValue, (int)0, (int)15);
    }

    static boolean scheduleRelightChecksForChunkBoundaries(LumiWorld world, LumiChunk chunk) {
        int chunkBasePosX = chunk.lumi$chunkPosX();
        int chunkBasePosZ = chunk.lumi$chunkPosZ();
        boolean scheduledSkyLightUpdates = false;
        for (int i = 0; i < 4; ++i) {
            Direction direction = Direction.HORIZONTAL_DIRECTIONS[i];
            int xOffset = direction.xOffset;
            int neighbourChunkPosX = chunkBasePosX + xOffset;
            int zOffset = direction.zOffset;
            int neighbourChunkPosZ = chunkBasePosZ + zOffset;
            LumiChunk neighbourChunk = PhosphorUtil.getLoadedChunk(world, neighbourChunkPosX, neighbourChunkPosZ);
            if (neighbourChunk == null) continue;
            for (LightType lightType : LightType.values()) {
                for (DirectionSign directionSign : DirectionSign.values()) {
                    PhosphorUtil.mergeFlags(lightType, chunk, neighbourChunk, direction, directionSign);
                    PhosphorUtil.mergeFlags(lightType, neighbourChunk, chunk, direction.opposite(), directionSign);
                    scheduledSkyLightUpdates = PhosphorUtil.scheduleRelightChecksForBoundary(world, chunk, neighbourChunk, null, lightType, xOffset, zOffset, directionSign) || PhosphorUtil.scheduleRelightChecksForBoundary(world, neighbourChunk, chunk, null, lightType, -xOffset, -zOffset, directionSign) || PhosphorUtil.scheduleRelightChecksForBoundary(world, neighbourChunk, null, chunk, lightType, zOffset != 0 ? directionSign.sign() : 0, xOffset != 0 ? directionSign.sign() : 0, DirectionSign.of(direction.opposite()));
                }
            }
        }
        return scheduledSkyLightUpdates;
    }

    static boolean isChunkFullyLit(LumiWorld world, LumiChunk chunk, Profiler profiler) {
        if (!chunk.lumi$isLightingInitialized() && !PhosphorUtil.initChunkLighting(world, chunk, profiler)) {
            return false;
        }
        for (int zOffset = -1; zOffset <= 1; ++zOffset) {
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                int chunkPosZ;
                int chunkPosX;
                LumiChunk chunkNeighbour;
                if (xOffset == 0 && zOffset == 0 || (chunkNeighbour = PhosphorUtil.getLoadedChunk(world, chunkPosX = chunk.lumi$chunkPosX() + xOffset, chunkPosZ = chunk.lumi$chunkPosZ() + zOffset)) != null && chunkNeighbour.lumi$isLightingInitialized()) continue;
                return false;
            }
        }
        return true;
    }

    static void writeNeighborLightChecksToNBT(LumiChunk lumiChunk, NBTTagCompound output) {
        if (!(lumiChunk instanceof PhosphorChunk)) {
            return;
        }
        PhosphorChunk chunk = (PhosphorChunk)lumiChunk;
        short[] flags = chunk.phosphor$lightCheckFlags();
        NBTTagList flagList = new NBTTagList();
        boolean flagsSet = false;
        for (int i = 0; i < 32; ++i) {
            short flag = flags[i];
            NBTTagShort flagTag = new NBTTagShort(flag);
            flagList.func_74742_a((NBTBase)flagTag);
            if (flag == 0) continue;
            flagsSet = true;
        }
        if (flagsSet) {
            output.func_74782_a(NEIGHBOR_LIGHT_CHECKS_NBT_TAG_NAME, (NBTBase)flagList);
        }
    }

    static void readNeighborLightChecksFromNBT(LumiChunk lumiChunk, NBTTagCompound input) {
        if (!(lumiChunk instanceof PhosphorChunk)) {
            return;
        }
        PhosphorChunk chunk = (PhosphorChunk)lumiChunk;
        if (!input.func_150297_b(NEIGHBOR_LIGHT_CHECKS_NBT_TAG_NAME, 9)) {
            return;
        }
        NBTTagList list = input.func_150295_c(NEIGHBOR_LIGHT_CHECKS_NBT_TAG_NAME, 2);
        if (list.func_74745_c() != 32) {
            Share.LOG.warn("Chunk field {} had invalid length, ignoring it (chunk coordinates: {} {})", new Object[]{NEIGHBOR_LIGHT_CHECKS_NBT_TAG_NAME, lumiChunk.lumi$chunkPosX(), lumiChunk.lumi$chunkPosZ()});
            return;
        }
        short[] flags = chunk.phosphor$lightCheckFlags();
        for (int flagIndex = 0; flagIndex < 32; ++flagIndex) {
            short flag;
            NBTTagShort flagTag = (NBTTagShort)list.field_74747_a.get(flagIndex);
            flags[flagIndex] = flag = flagTag.func_150289_e();
        }
    }

    static void cloneNeighborLightChecks(LumiChunk lumiFrom, LumiChunk lumiTo) {
        if (!(lumiFrom instanceof PhosphorChunk) || !(lumiTo instanceof PhosphorChunk)) {
            return;
        }
        PhosphorChunk from = (PhosphorChunk)lumiFrom;
        PhosphorChunk to = (PhosphorChunk)lumiTo;
        ArrayUtil.copyArray((short[])from.phosphor$lightCheckFlags(), (short[])to.phosphor$lightCheckFlags());
    }

    @Nullable
    static LumiChunk getLoadedChunk(LumiWorld world, int chunkPosX, int chunkPosZ) {
        return world.lumi$getChunkFromChunkPosIfExists(chunkPosX, chunkPosZ);
    }

    static void relightSkyLightColumn(LumiLightingEngine lightingEngine, LumiWorld world, LumiChunk chunk, int subChunkPosX, int subChunkPosZ, int startPosY, int endPosY) {
        int minPosY = Math.min(startPosY, endPosY);
        int maxPosY = Math.max(startPosY, endPosY) - 1;
        startPosY = minPosY;
        endPosY = maxPosY;
        int basePosX = (chunk.lumi$chunkPosX() << 4) + subChunkPosX;
        int basePosZ = (chunk.lumi$chunkPosZ() << 4) + subChunkPosZ;
        lightingEngine.scheduleLightingUpdateForColumn(LightType.SKY_LIGHT_TYPE, basePosX, basePosZ, startPosY, endPosY);
    }

    private static void doRecheckGaps(LumiChunk chunk, WorldChunkSlice slice, Profiler profiler) {
        profiler.func_76320_a("recheckGaps");
        for (int subChunkPosZ = 0; subChunkPosZ < 16; ++subChunkPosZ) {
            for (int subChunkPosX = 0; subChunkPosX < 16; ++subChunkPosX) {
                PhosphorUtil.recheckGapsForColumn(chunk, slice, subChunkPosX, subChunkPosZ);
            }
        }
        profiler.func_76319_b();
    }

    private static void recheckGapsForColumn(LumiChunk chunk, WorldChunkSlice slice, int subChunkPosX, int subChunkPosZ) {
        if (!chunk.lumi$isHeightOutdated(subChunkPosX, subChunkPosZ)) {
            return;
        }
        int posX = chunk.lumi$chunkPosX() * 16 + subChunkPosX;
        int posZ = chunk.lumi$chunkPosZ() * 16 + subChunkPosZ;
        int minPosY = PhosphorUtil.recheckGapsGetLowestHeight(slice, posX, posZ);
        int maxPosY = chunk.lumi$skyLightHeight(subChunkPosX, subChunkPosZ);
        PhosphorUtil.recheckGapsSkylightNeighborHeight(chunk, slice, posX, posZ, maxPosY, minPosY);
        chunk.lumi$isHeightOutdated(subChunkPosX, subChunkPosZ, false);
    }

    private static int recheckGapsGetLowestHeight(WorldChunkSlice slice, int posX, int posZ) {
        int minPosY = Integer.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            Direction direction = Direction.HORIZONTAL_DIRECTIONS[i];
            int neighbourPosX = posX + direction.xOffset;
            int neighbourPosZ = posZ + direction.zOffset;
            LumiChunk chunk = slice.getChunkFromWorldCoords(neighbourPosX, neighbourPosZ);
            minPosY = Math.min(minPosY, chunk.lumi$minSkyLightHeight());
        }
        return minPosY;
    }

    private static void recheckGapsSkylightNeighborHeight(LumiChunk chunk, WorldChunkSlice slice, int posX, int posZ, int height, int max) {
        PhosphorUtil.checkSkylightNeighborHeight(chunk, slice, posX, posZ, max);
        for (int i = 0; i < 4; ++i) {
            Direction direction = Direction.HORIZONTAL_DIRECTIONS[i];
            int neighbourPosX = posX + direction.xOffset;
            int neighbourPosZ = posZ + direction.zOffset;
            PhosphorUtil.checkSkylightNeighborHeight(chunk, slice, neighbourPosX, neighbourPosZ, height);
        }
    }

    private static void checkSkylightNeighborHeight(LumiChunk chunk, WorldChunkSlice slice, int posX, int posZ, int maxValue) {
        int subChunkPosX = posX & 0xF;
        int subChunkPosZ = posZ & 0xF;
        LumiChunk neighbourChunk = slice.getChunkFromWorldCoords(posX, posZ);
        int neighbourSkyLightHeight = neighbourChunk.lumi$skyLightHeight(subChunkPosX, subChunkPosZ);
        if (neighbourSkyLightHeight > maxValue) {
            int maxPosY = neighbourSkyLightHeight + 1;
            PhosphorUtil.updateSkylightNeighborHeight(chunk, slice, posX, posZ, maxValue, maxPosY);
        } else if (neighbourSkyLightHeight < maxValue) {
            int maxPosY = maxValue + 1;
            PhosphorUtil.updateSkylightNeighborHeight(chunk, slice, posX, posZ, neighbourSkyLightHeight, maxPosY);
        }
    }

    private static void updateSkylightNeighborHeight(LumiChunk chunk, WorldChunkSlice slice, int posX, int posZ, int minPosY, int maxPosY) {
        if (!slice.isLoaded(posX, posZ, 16)) {
            return;
        }
        LumiLightingEngine lightingEngine = chunk.lumi$world().lumi$lightingEngine();
        lightingEngine.scheduleLightingUpdateForColumn(LightType.SKY_LIGHT_TYPE, posX, posZ, minPosY, maxPosY);
        chunk.lumi$root().lumi$markDirty();
    }

    private static void flagChunkBoundaryForUpdate(LumiChunk lumiChunk, short subChunkMask, Direction direction, DirectionSign directionSign) {
        int flagIndex;
        if (!(lumiChunk instanceof PhosphorChunk)) {
            return;
        }
        PhosphorChunk chunk = (PhosphorChunk)lumiChunk;
        short[] flags = chunk.phosphor$lightCheckFlags();
        int n = flagIndex = PhosphorUtil.getFlagIndex(LightType.SKY_LIGHT_TYPE, direction, directionSign, FacingDirection.OUTPUT);
        flags[n] = (short)(flags[n] | subChunkMask);
        lumiChunk.lumi$root().lumi$markDirty();
    }

    private static void mergeFlags(LightType lightType, LumiChunk lumiDestinationChunk, LumiChunk lumiSourceChunk, Direction direction, DirectionSign directionSign) {
        if (!(lumiDestinationChunk instanceof PhosphorChunk) || !(lumiSourceChunk instanceof PhosphorChunk)) {
            return;
        }
        PhosphorChunk destinationChunk = (PhosphorChunk)lumiDestinationChunk;
        PhosphorChunk sourceChunk = (PhosphorChunk)lumiSourceChunk;
        short[] destinationFlags = destinationChunk.phosphor$lightCheckFlags();
        short[] sourceFlags = sourceChunk.phosphor$lightCheckFlags();
        int destinationFlagIndex = PhosphorUtil.getFlagIndex(lightType, direction, directionSign, FacingDirection.INPUT);
        int sourceFlagIndex = PhosphorUtil.getFlagIndex(lightType, direction.opposite(), directionSign, FacingDirection.OUTPUT);
        int n = destinationFlagIndex;
        destinationFlags[n] = (short)(destinationFlags[n] | sourceFlags[sourceFlagIndex]);
    }

    private static boolean scheduleRelightChecksForBoundary(LumiWorld world, LumiChunk lumiChunk, LumiChunk lumiNChunk, LumiChunk lumiSChunk, LightType lightType, int xOffset, int zOffset, DirectionSign directionSign) {
        int chunkPosZ;
        int chunkPosX;
        int inFlagIndex;
        if (!(lumiChunk instanceof PhosphorChunk)) {
            return false;
        }
        PhosphorChunk chunk = (PhosphorChunk)lumiChunk;
        short[] flags = chunk.phosphor$lightCheckFlags();
        short flag = flags[inFlagIndex = PhosphorUtil.getFlagIndex(lightType, xOffset, zOffset, directionSign, FacingDirection.INPUT)];
        if (flag == 0) {
            return false;
        }
        int chunkBasePosX = lumiChunk.lumi$chunkPosX();
        int chunkBasePosZ = lumiChunk.lumi$chunkPosZ();
        if (lumiNChunk == null && (lumiNChunk = PhosphorUtil.getLoadedChunk(world, chunkPosX = chunkBasePosX + xOffset, chunkPosZ = chunkBasePosZ + zOffset)) == null) {
            return false;
        }
        if (lumiSChunk == null && (lumiSChunk = PhosphorUtil.getLoadedChunk(world, chunkPosX = chunkBasePosX + (zOffset != 0 ? directionSign.sign() : 0), chunkPosZ = chunkBasePosZ + (xOffset != 0 ? directionSign.sign() : 0))) == null) {
            return false;
        }
        if (!(lumiNChunk instanceof PhosphorChunk)) {
            return false;
        }
        PhosphorChunk nChunk = (PhosphorChunk)lumiNChunk;
        short[] nFlags = nChunk.phosphor$lightCheckFlags();
        int outFlagIndex = PhosphorUtil.getFlagIndex(lightType, -xOffset, -zOffset, directionSign, FacingDirection.OUTPUT);
        flags[inFlagIndex] = 0;
        nFlags[outFlagIndex] = 0;
        lumiChunk.lumi$root().lumi$markDirty();
        lumiNChunk.lumi$root().lumi$markDirty();
        LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
        int minPosX = lumiChunk.lumi$chunkPosX() << 4;
        int minPosZ = lumiChunk.lumi$chunkPosZ() << 4;
        if ((xOffset | zOffset) > 0) {
            minPosX += xOffset * 15;
            minPosZ += zOffset * 15;
        }
        if (directionSign == DirectionSign.POSITIVE) {
            minPosX += (zOffset & 1) * 8;
            minPosZ += (xOffset & 1) * 8;
        }
        int maxPosX = 7 * (zOffset & 1) + minPosX;
        int maxPosZ = 7 * (xOffset & 1) + minPosZ;
        boolean scheduledSkyLightUpdates = false;
        for (int chunkPosY = 0; chunkPosY < 16; ++chunkPosY) {
            if ((flag & 1 << chunkPosY) == 0) continue;
            int minPosY = chunkPosY * 16;
            int maxPosY = minPosY + 15;
            lightingEngine.scheduleLightingUpdateForRange(lightType, minPosX, minPosY, minPosZ, maxPosX, maxPosY, maxPosZ);
            scheduledSkyLightUpdates = true;
        }
        return scheduledSkyLightUpdates;
    }

    private static int getFlagIndex(LightType lightType, Direction direction, DirectionSign directionSign, FacingDirection facingDirection) {
        int xOffset = direction.xOffset;
        int zOffset = direction.zOffset;
        return PhosphorUtil.getFlagIndex(lightType, xOffset, zOffset, directionSign, facingDirection);
    }

    private static int getFlagIndex(LightType lightType, int facingOffsetX, int facingOffsetZ, DirectionSign directionSign, FacingDirection facingDirection) {
        int lightTypeBits;
        switch (lightType) {
            default: {
                lightTypeBits = 0;
                break;
            }
            case SKY_LIGHT_TYPE: {
                lightTypeBits = 16;
            }
        }
        int facingOffsetXBits = facingOffsetX + 1 << 2;
        int facingOffsetZBits = facingOffsetZ + 1 << 1;
        int axisDirectionOffsetBits = directionSign.sign() + 1;
        int boundaryFacingBits = facingDirection.ordinal();
        return lightTypeBits | facingOffsetXBits | facingOffsetZBits | axisDirectionOffsetBits | boundaryFacingBits;
    }

    private static boolean initChunkLighting(LumiWorld world, LumiChunk chunk, Profiler profiler) {
        int basePosZ;
        int centerPosZ;
        int basePosX;
        int centerPosX;
        int chunkPosZ;
        int chunkPosX = chunk.lumi$chunkPosX();
        WorldChunkSlice slice = new WorldChunkSlice(world, chunkPosX, chunkPosZ = chunk.lumi$chunkPosZ());
        if (!slice.isLoaded(centerPosX = (basePosX = chunkPosX << 4) + 8, centerPosZ = (basePosZ = chunkPosZ << 4) + 8, 16)) {
            return false;
        }
        LumiLightingEngine lightingEngine = world.lumi$lightingEngine();
        boolean scheduledBlockUpdate = false;
        for (int chunkPosY = 0; chunkPosY < 16; ++chunkPosY) {
            int basePosY = chunkPosY * 16;
            for (int subChunkPosY = 0; subChunkPosY < 16; ++subChunkPosY) {
                for (int subChunkPosZ = 0; subChunkPosZ < 16; ++subChunkPosZ) {
                    for (int subChunkPosX = 0; subChunkPosX < 16; ++subChunkPosX) {
                        int posY = basePosY + subChunkPosY;
                        int brightness = chunk.lumi$getBlockBrightness(subChunkPosX, posY, subChunkPosZ);
                        if (brightness <= 0) continue;
                        int posX = basePosX + subChunkPosX;
                        int posZ = basePosZ + subChunkPosZ;
                        lightingEngine.scheduleLightingUpdate(LightType.BLOCK_LIGHT_TYPE, posX, posY, posZ);
                        scheduledBlockUpdate = true;
                    }
                }
            }
        }
        if (scheduledBlockUpdate) {
            lightingEngine.processLightingUpdatesForType(LightType.BLOCK_LIGHT_TYPE);
        }
        if (world.lumi$root().lumi$hasSky()) {
            chunk.lumi$resetOutdatedHeightFlags();
            PhosphorUtil.doRecheckGaps(chunk, slice, profiler);
        }
        chunk.lumi$isLightingInitialized(true);
        return true;
    }

    @Generated
    private PhosphorUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

