/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.lighting.phosphor;

import com.falsepattern.lib.compat.BlockPos;
import com.falsepattern.lumi.api.chunk.LumiChunk;
import com.falsepattern.lumi.api.chunk.LumiChunkRoot;
import com.falsepattern.lumi.api.chunk.LumiSubChunk;
import com.falsepattern.lumi.api.chunk.LumiSubChunkRoot;
import com.falsepattern.lumi.api.lighting.LightType;
import com.falsepattern.lumi.api.lighting.LumiLightingEngine;
import com.falsepattern.lumi.api.world.LumiWorld;
import com.falsepattern.lumi.api.world.LumiWorldRoot;
import com.falsepattern.lumi.internal.Lumi;
import com.falsepattern.lumi.internal.config.LumiConfig;
import com.falsepattern.lumi.internal.lighting.phosphor.Direction;
import com.falsepattern.lumi.internal.lighting.phosphor.DummyLock;
import com.falsepattern.lumi.internal.lighting.phosphor.PhosphorUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.profiler.Profiler;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhosphorLightingEngine
implements LumiLightingEngine {
    private static final Logger LOG = Lumi.createLogger("Phosphor");
    private static final int MAX_SCHEDULED_BLOCK_LIGHT_UPDATES_SERVER = 1 << (LumiConfig.I_HAVE_ENOUGH_RAM ? 18 : 14);
    private static final int MAX_SCHEDULED_SKY_LIGHT_UPDATES_SERVER = 1 << (LumiConfig.I_HAVE_ENOUGH_RAM ? 18 : 14);
    private static final int MAX_SCHEDULED_BLOCK_LIGHT_UPDATES_CLIENT = 1024;
    private static final int MAX_SCHEDULED_SKY_LIGHT_UPDATES_CLIENT = 1024;
    private static final int POS_Z_BIT_LENGTH = 26;
    private static final int POS_X_BIT_LENGTH = 26;
    private static final int POS_Y_BIT_LENGTH = 8;
    private static final int LIGHT_VALUE_BIT_LENGTH = 4;
    private static final int POS_Z_BIT_SHIFT = 0;
    private static final int POS_X_BIT_SHIFT = 26;
    private static final int POS_Y_BIT_SHIFT = 52;
    private static final int LIGHT_VALUE_BIT_SHIFT = 60;
    private static final long POS_Z_BIT_MASK = 0x3FFFFFFL;
    private static final long POS_X_BIT_MASK = 0x3FFFFFFL;
    private static final long POS_Y_BIT_MASK = 255L;
    private static final long LIGHT_VALUE_BIT_MASK = 15L;
    private static final long BLOCK_POS_BIT_MASK = 0xFFFFFFFFFFFFFFFL;
    private static final long BLOCK_POS_CHUNK_BIT_MASK = 4503598620737520L;
    private static final long POS_OVERFLOW_CHECK_BIT_MASK = 0x1000000000000000L;
    private static final int NEIGHBOUR_COUNT = 6;
    private static final long[] BLOCK_SIDE_BIT_OFFSET = new long[6];
    private final Thread updateThread = Thread.currentThread();
    private final Lock lock = LumiConfig.ENABLE_LOCKS ? new ReentrantLock() : DummyLock.getDummyLock();
    private final LumiWorld world;
    private final LumiWorldRoot worldRoot;
    private final boolean isClientSide;
    private final Profiler profiler;
    private final int maxBlockLightUpdates;
    private final int maxSkyLightUpdates;
    private final LongList blockLightUpdateQueue;
    private final LongList skyLightUpdateQueue;
    private final LongList[] brighteningQueues;
    private final LongList[] darkeningQueues;
    private final LongList initialBrighteningQueue;
    private final LongList initialDarkeningQueue;
    @Nullable
    private LightType currentLightType;
    @Nullable
    private LongList currentQueue;
    private int currentQueueSize;
    private int currentQueueIndex;
    private final BlockReference cursor;
    private final BlockReference[] neighbors;
    private boolean areNeighboursBlocksValid;
    private static final String MARKER = "$LUMI_NO_RELIGHT";
    private static final ThreadLocal<Boolean> THREAD_ALLOWED_TO_RELIGHT;

    PhosphorLightingEngine(LumiWorld world, Profiler profiler) {
        int i;
        this.world = world;
        this.worldRoot = world.lumi$root();
        this.isClientSide = this.worldRoot.lumi$isClientSide();
        this.profiler = profiler;
        this.maxBlockLightUpdates = this.isClientSide ? 1024 : MAX_SCHEDULED_BLOCK_LIGHT_UPDATES_SERVER;
        this.maxSkyLightUpdates = this.isClientSide ? 1024 : MAX_SCHEDULED_SKY_LIGHT_UPDATES_SERVER;
        this.blockLightUpdateQueue = new LongArrayList(this.maxBlockLightUpdates);
        this.skyLightUpdateQueue = new LongArrayList(this.maxSkyLightUpdates);
        this.brighteningQueues = new LongArrayList[16];
        for (i = 0; i < 16; ++i) {
            this.brighteningQueues[i] = new LongArrayList();
        }
        this.darkeningQueues = new LongArrayList[16];
        for (i = 0; i < 16; ++i) {
            this.darkeningQueues[i] = new LongArrayList();
        }
        this.initialBrighteningQueue = new LongArrayList();
        this.initialDarkeningQueue = new LongArrayList();
        this.neighbors = new BlockReference[6];
        for (i = 0; i < 6; ++i) {
            BlockReference neighbor = new BlockReference();
            neighbor.neighbourBlockSideBitOffset = BLOCK_SIDE_BIT_OFFSET[i];
            this.neighbors[i] = neighbor;
        }
        this.areNeighboursBlocksValid = false;
        this.cursor = new BlockReference();
        this.currentLightType = null;
        this.currentQueue = null;
        this.currentQueueSize = 0;
        this.currentQueueIndex = 0;
    }

    @Override
    @NotNull
    public String lightingEngineID() {
        return "phosphor";
    }

    @Override
    public void writeChunkToNBT(@NotNull LumiChunk chunk, @NotNull NBTTagCompound output) {
        PhosphorUtil.writeNeighborLightChecksToNBT(chunk, output);
    }

    @Override
    public void readChunkFromNBT(@NotNull LumiChunk chunk, @NotNull NBTTagCompound input) {
        PhosphorUtil.readNeighborLightChecksFromNBT(chunk, input);
    }

    @Override
    public void cloneChunk(@NotNull LumiChunk from, @NotNull LumiChunk to) {
        PhosphorUtil.cloneNeighborLightChecks(from, to);
    }

    @Override
    public void writeSubChunkToNBT(@NotNull LumiChunk chunk, @NotNull LumiSubChunk subChunk, @NotNull NBTTagCompound output) {
    }

    @Override
    public void readSubChunkFromNBT(@NotNull LumiChunk chunk, @NotNull LumiSubChunk subChunk, @NotNull NBTTagCompound input) {
    }

    @Override
    public void cloneSubChunk(@NotNull LumiChunk fromChunk, @NotNull LumiSubChunk from, @NotNull LumiSubChunk to) {
    }

    @Override
    public void writeChunkToPacket(@NotNull LumiChunk chunk, @NotNull ByteBuffer output) {
    }

    @Override
    public void readChunkFromPacket(@NotNull LumiChunk chunk, @NotNull ByteBuffer input) {
    }

    @Override
    public void writeSubChunkToPacket(@NotNull LumiChunk chunk, @NotNull LumiSubChunk subChunk, @NotNull ByteBuffer input) {
    }

    @Override
    public void readSubChunkFromPacket(@NotNull LumiChunk chunk, @NotNull LumiSubChunk subChunk, @NotNull ByteBuffer output) {
    }

    @Override
    public int getCurrentLightValue(@NotNull LightType lightType, @NotNull BlockPos blockPos) {
        return this.getCurrentLightValue(lightType, blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    @Override
    public int getCurrentLightValue(@NotNull LightType lightType, int posX, int posY, int posZ) {
        if (THREAD_ALLOWED_TO_RELIGHT.get().booleanValue()) {
            this.processLightingUpdatesForType(lightType);
        }
        return PhosphorUtil.clampLightValue(this.world.lumi$getLightValue(lightType, posX, posY, posZ));
    }

    @Override
    public int getCurrentLightValueChunk(@NotNull Chunk chunk, @NotNull LightType lightType, int chunkPosX, int posY, int chunkPosZ) {
        if (THREAD_ALLOWED_TO_RELIGHT.get().booleanValue()) {
            this.processLightingUpdatesForType(lightType);
        }
        return PhosphorUtil.clampLightValue(this.world.lumi$getLightValue(this.world.lumi$wrap(chunk), lightType, chunkPosX, posY, chunkPosZ));
    }

    @Override
    public boolean isChunkFullyLit(@NotNull LumiChunk chunk) {
        return PhosphorUtil.isChunkFullyLit(this.world, chunk, this.profiler);
    }

    @Override
    public void handleChunkInit(@NotNull LumiChunk chunk) {
        chunk.lumi$isLightingInitialized(false);
        boolean hasSky = this.worldRoot.lumi$hasSky();
        LumiChunkRoot chunkRoot = chunk.lumi$root();
        int basePosX = chunk.lumi$chunkPosX() << 4;
        int basePosY = chunkRoot.lumi$topPreparedSubChunkBasePosY();
        int basePosZ = chunk.lumi$chunkPosZ() << 4;
        int maxPosY = basePosY + 16;
        int minSkyLightHeight = Integer.MAX_VALUE;
        for (int subChunkPosX = 0; subChunkPosX < 16; ++subChunkPosX) {
            for (int subChunkPosZ = 0; subChunkPosZ < 16; ++subChunkPosZ) {
                int blockOpacity;
                int skyLightHeight;
                for (skyLightHeight = maxPosY; skyLightHeight > 0; --skyLightHeight) {
                    int posY = skyLightHeight - 1;
                    blockOpacity = PhosphorUtil.clampSkyLightOpacity(chunk.lumi$getBlockOpacity(subChunkPosX, posY, subChunkPosZ));
                    if (blockOpacity == 0) {
                        continue;
                    }
                    chunk.lumi$skyLightHeight(subChunkPosX, subChunkPosZ, skyLightHeight);
                    minSkyLightHeight = Math.min(minSkyLightHeight, skyLightHeight);
                    break;
                }
                if (!hasSky) continue;
                int lightLevel = 15;
                skyLightHeight = basePosY + 16 - 1;
                do {
                    if ((blockOpacity = PhosphorUtil.clampSkyLightOpacity(chunk.lumi$getBlockOpacity(subChunkPosX, skyLightHeight, subChunkPosZ))) == 0 && lightLevel != 15) {
                        blockOpacity = 1;
                    }
                    if ((lightLevel -= blockOpacity) <= 0) continue;
                    int chunkPosY = skyLightHeight / 16;
                    int subChunkPosY = skyLightHeight & 0xF;
                    LumiSubChunk subChunk = chunk.lumi$getSubChunk(chunkPosY);
                    int posX = basePosX + subChunkPosX;
                    int posZ = basePosZ + subChunkPosZ;
                    subChunk.lumi$setSkyLightValue(subChunkPosX, subChunkPosY, subChunkPosZ, lightLevel);
                    this.worldRoot.lumi$markBlockForRenderUpdate(posX, skyLightHeight, posZ);
                } while (--skyLightHeight > 0 && lightLevel > 0);
            }
        }
        chunk.lumi$minSkyLightHeight(minSkyLightHeight);
        chunkRoot.lumi$markDirty();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientChunkInit(@NotNull LumiChunk chunk) {
        LumiChunkRoot chunkRoot = chunk.lumi$root();
        int basePosY = chunkRoot.lumi$topPreparedSubChunkBasePosY();
        int maxPosY = basePosY + 15;
        int minSkyLightHeight = Integer.MAX_VALUE;
        for (int subChunkPosX = 0; subChunkPosX < 16; ++subChunkPosX) {
            block1: for (int subChunkPosZ = 0; subChunkPosZ < 16; ++subChunkPosZ) {
                for (int skyLightHeight = maxPosY; skyLightHeight > 0; --skyLightHeight) {
                    int posY = skyLightHeight - 1;
                    Block block = chunkRoot.lumi$getBlock(subChunkPosX, posY, subChunkPosZ);
                    int blockMeta = chunkRoot.lumi$getBlockMeta(subChunkPosX, posY, subChunkPosZ);
                    int blockOpacity = block == Blocks.field_150350_a ? 0 : PhosphorUtil.clampSkyLightOpacity(chunk.lumi$getBlockOpacity(block, blockMeta, subChunkPosX, posY, subChunkPosZ));
                    if (blockOpacity == 0) {
                        continue;
                    }
                    chunk.lumi$skyLightHeight(subChunkPosX, subChunkPosZ, skyLightHeight);
                    minSkyLightHeight = Math.min(minSkyLightHeight, skyLightHeight);
                    continue block1;
                }
            }
        }
        chunk.lumi$minSkyLightHeight(minSkyLightHeight);
        chunk.lumi$isLightingInitialized(true);
    }

    @Override
    public void handleSubChunkInit(@NotNull LumiChunk chunk, @NotNull LumiSubChunk subChunk) {
        if (!this.worldRoot.lumi$hasSky()) {
            return;
        }
        int maxPosY = subChunk.lumi$root().lumi$posY() + 15;
        int lightValue = LightType.SKY_LIGHT_TYPE.defaultLightValue();
        for (int subChunkPosZ = 0; subChunkPosZ < 16; ++subChunkPosZ) {
            for (int subChunkPosX = 0; subChunkPosX < 16; ++subChunkPosX) {
                if (!chunk.lumi$canBlockSeeSky(subChunkPosX, maxPosY, subChunkPosZ)) continue;
                for (int subChunkPosY = 0; subChunkPosY < 16; ++subChunkPosY) {
                    subChunk.lumi$setSkyLightValue(subChunkPosX, subChunkPosY, subChunkPosZ, lightValue);
                }
            }
        }
        chunk.lumi$root().lumi$markDirty();
    }

    @Override
    public void handleChunkLoad(@NotNull LumiChunk chunk) {
        if (PhosphorUtil.scheduleRelightChecksForChunkBoundaries(this.world, chunk)) {
            this.processLightingUpdatesForType(LightType.SKY_LIGHT_TYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRandomChunkLightingUpdates(@NotNull LumiChunk chunk) {
        LumiChunkRoot chunkRoot = chunk.lumi$root();
        int queuedRandomLightUpdates = chunk.lumi$queuedRandomLightUpdates();
        if (queuedRandomLightUpdates >= 4096) {
            return;
        }
        int maxUpdateIterations = this.isClientSide ? 64 : 32;
        int chunkPosX = chunk.lumi$chunkPosX();
        int chunkPosZ = chunk.lumi$chunkPosZ();
        int minPosX = chunkPosX << 4;
        int minPosZ = chunkPosZ << 4;
        int remainingIterations = maxUpdateIterations;
        block3: while (remainingIterations > 0) {
            if (queuedRandomLightUpdates >= 4096) {
                return;
            }
            --remainingIterations;
            int chunkPosY = queuedRandomLightUpdates % 16;
            int subChunkPosX = queuedRandomLightUpdates / 16 % 16;
            int subChunkPosZ = queuedRandomLightUpdates / 256;
            ++queuedRandomLightUpdates;
            int minPosY = chunkPosY << 4;
            int posX = minPosX + subChunkPosX;
            int posZ = minPosZ + subChunkPosZ;
            try {
                this.acquireLock();
                for (int subChunkPosY = 0; subChunkPosY < 16; ++subChunkPosY) {
                    int blockBrightness;
                    int posY = minPosY + subChunkPosY;
                    if (!(subChunkPosX != 0 && subChunkPosX != 15 || subChunkPosY != 0 && subChunkPosY != 15 || subChunkPosZ != 0 && subChunkPosZ != 15)) {
                        this.scheduleLightingUpdatePostLock(LightType.BLOCK_LIGHT_TYPE, posX, posY, posZ);
                        if (!this.worldRoot.lumi$hasSky()) continue;
                        this.scheduleLightingUpdatePostLock(LightType.SKY_LIGHT_TYPE, posX, posY, posZ);
                        continue;
                    }
                    int blockOpacity = PhosphorUtil.clampBlockLightOpacity(this.world.lumi$getBlockOpacity(posX, posY, posZ));
                    if (blockOpacity >= 15 && (blockBrightness = PhosphorUtil.clampLightValue(this.world.lumi$getBlockBrightness(posX, posY, posZ))) <= 0) {
                        int lightValue = PhosphorUtil.clampLightValue(this.world.lumi$getBlockLightValue(posX, posY, posZ));
                        if (lightValue == 0) continue;
                        chunk.lumi$setBlockLightValue(subChunkPosX, posY, subChunkPosZ, 0);
                        this.worldRoot.lumi$markBlockForRenderUpdate(posX, posY, posZ);
                        continue block3;
                    }
                    this.scheduleLightingUpdatePostLock(LightType.BLOCK_LIGHT_TYPE, posX, posY, posZ);
                    if (!this.worldRoot.lumi$hasSky()) continue block3;
                    this.scheduleLightingUpdatePostLock(LightType.SKY_LIGHT_TYPE, posX, posY, posZ);
                    continue block3;
                }
            }
            finally {
                this.releaseLock();
            }
        }
        chunk.lumi$queuedRandomLightUpdates(queuedRandomLightUpdates);
    }

    @Override
    public void updateLightingForBlock(@NotNull BlockPos blockPos) {
        this.updateLightingForBlock(blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    @Override
    public void updateLightingForBlock(int posX, int posY, int posZ) {
        int blockMeta;
        Block block;
        int chunkPosX = posX >> 4;
        int chunkPosZ = posZ >> 4;
        LumiChunk chunk = this.world.lumi$getChunkFromChunkPosIfExists(chunkPosX, chunkPosZ);
        if (chunk == null) {
            return;
        }
        int subChunkPosX = posX & 0xF;
        int subChunkPosZ = posZ & 0xF;
        int maxPosY = chunk.lumi$skyLightHeight(subChunkPosX, subChunkPosZ) & 0xFF;
        int minPosY = Math.max(posY + 1 & 0xFF, maxPosY);
        if (!chunk.lumi$canBlockSeeSky(subChunkPosX, minPosY, subChunkPosZ)) {
            return;
        }
        LumiChunkRoot chunkRoot = chunk.lumi$root();
        while (minPosY > 0 && this.world.lumi$getBlockOpacity(block = chunkRoot.lumi$getBlock(subChunkPosX, minPosY - 1, subChunkPosZ), blockMeta = chunkRoot.lumi$getBlockMeta(subChunkPosX, minPosY - 1, subChunkPosZ), posX, minPosY - 1, posZ) == 0) {
            --minPosY;
        }
        if (minPosY == maxPosY) {
            return;
        }
        chunk.lumi$skyLightHeight(subChunkPosX, subChunkPosZ, minPosY);
        if (this.worldRoot.lumi$hasSky()) {
            PhosphorUtil.relightSkyLightColumn(this, this.world, chunk, subChunkPosX, subChunkPosZ, maxPosY, minPosY);
        }
        if ((maxPosY = chunk.lumi$skyLightHeight(subChunkPosX, subChunkPosZ)) < chunk.lumi$minSkyLightHeight()) {
            chunk.lumi$minSkyLightHeight(maxPosY);
        }
        chunk.lumi$root().lumi$markDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleLightingUpdateForRange(@NotNull LightType lightType, @NotNull BlockPos minBlockPos, @NotNull BlockPos maxBlockPos) {
        int minPosX = minBlockPos.getX();
        int maxPosX = maxBlockPos.getX();
        if (maxPosX < minPosX) {
            return;
        }
        int minPosY = minBlockPos.getY();
        int maxPosY = maxBlockPos.getY();
        if (maxPosY < minPosY) {
            return;
        }
        int minPosZ = minBlockPos.getZ();
        int maxPosZ = maxBlockPos.getZ();
        if (maxPosZ < minPosZ) {
            return;
        }
        this.acquireLock();
        try {
            for (int posY = minPosY; posY < maxPosY; ++posY) {
                for (int posZ = minPosZ; posZ < maxPosZ; ++posZ) {
                    for (int posX = minPosX; posX < maxPosX; ++posX) {
                        this.scheduleLightingUpdate(lightType, PhosphorLightingEngine.posLongFromPosXYZ(posX, posY, posZ));
                    }
                }
            }
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleLightingUpdateForRange(@NotNull LightType lightType, int minPosX, int minPosY, int minPosZ, int maxPosX, int maxPosY, int maxPosZ) {
        if (maxPosX < minPosX) {
            return;
        }
        if (maxPosY < minPosY) {
            return;
        }
        if (maxPosZ < minPosZ) {
            return;
        }
        this.acquireLock();
        try {
            for (int posY = minPosY; posY < maxPosY; ++posY) {
                for (int posZ = minPosZ; posZ < maxPosZ; ++posZ) {
                    for (int posX = minPosX; posX < maxPosX; ++posX) {
                        this.scheduleLightingUpdatePostLock(lightType, posX, posY, posZ);
                    }
                }
            }
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public void scheduleLightingUpdateForColumn(@NotNull LightType lightType, int posX, int posZ) {
        this.scheduleLightingUpdateForColumn(lightType, posX, posZ, 0, 255);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleLightingUpdateForColumn(@NotNull LightType lightType, int posX, int posZ, int minPosY, int maxPosY) {
        if (maxPosY < minPosY) {
            return;
        }
        this.acquireLock();
        try {
            for (int posY = minPosY; posY < maxPosY; ++posY) {
                this.scheduleLightingUpdatePostLock(lightType, posX, posY, posZ);
            }
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public void scheduleLightingUpdate(@NotNull LightType lightType, @NotNull BlockPos blockPos) {
        this.acquireLock();
        try {
            this.scheduleLightingUpdatePostLock(lightType, PhosphorLightingEngine.posLongFromBlockPos(blockPos));
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleLightingUpdate(@NotNull LightType lightType, int posX, int posY, int posZ) {
        this.acquireLock();
        try {
            this.scheduleLightingUpdatePostLock(lightType, posX, posY, posZ);
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public void processLightingUpdatesForType(@NotNull LightType lightType) {
        LongList queue;
        if (this.isClientSide && !this.isCallingFromClientThread()) {
            return;
        }
        LongList longList = queue = lightType.isBlock() ? this.blockLightUpdateQueue : this.skyLightUpdateQueue;
        if (queue.isEmpty()) {
            return;
        }
        this.acquireLock();
        try {
            this.updateLighting(lightType);
            this.resetBlockReferences();
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public void processLightingUpdatesForAllTypes() {
        boolean hasSkyLightUpdates;
        if (this.isClientSide && !this.isCallingFromClientThread()) {
            return;
        }
        boolean hasBlockLightUpdates = !this.blockLightUpdateQueue.isEmpty();
        boolean bl = hasSkyLightUpdates = !this.skyLightUpdateQueue.isEmpty();
        if (!hasBlockLightUpdates && !hasSkyLightUpdates) {
            return;
        }
        this.acquireLock();
        try {
            if (hasBlockLightUpdates) {
                this.updateLighting(LightType.BLOCK_LIGHT_TYPE);
            }
            if (hasSkyLightUpdates) {
                this.updateLighting(LightType.SKY_LIGHT_TYPE);
            }
            this.resetBlockReferences();
        }
        finally {
            this.releaseLock();
        }
    }

    private void resetBlockReferences() {
        this.cursor.reset();
        for (int i = 0; i < 6; ++i) {
            this.neighbors[i].reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleLightingUpdate(LightType lightType, long posLong) {
        this.acquireLock();
        try {
            this.scheduleLightingUpdatePostLock(lightType, posLong);
        }
        finally {
            this.releaseLock();
        }
    }

    public void scheduleLightingUpdatePostLock(@NotNull LightType lightType, int posX, int posY, int posZ) {
        this.scheduleLightingUpdatePostLock(lightType, PhosphorLightingEngine.posLongFromPosXYZ(posX, posY, posZ));
    }

    private void scheduleLightingUpdatePostLock(LightType lightType, long posLong) {
        LongList queue;
        int maxLightUpdates;
        if (lightType.isBlock()) {
            maxLightUpdates = this.maxBlockLightUpdates;
            queue = this.blockLightUpdateQueue;
        } else {
            maxLightUpdates = this.maxSkyLightUpdates;
            queue = this.skyLightUpdateQueue;
        }
        if (queue.size() >= maxLightUpdates) {
            this.processLightingUpdatesForType(lightType);
        }
        queue.add(posLong);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isCallingFromClientThread() {
        return Minecraft.func_71410_x().func_152345_ab();
    }

    private void acquireLock() {
        Thread currentThread;
        if (this.lock.tryLock()) {
            return;
        }
        if (LumiConfig.ENABLE_ILLEGAL_THREAD_ACCESS_WARNINGS && (currentThread = Thread.currentThread()) != this.updateThread) {
            IllegalAccessException e = new IllegalAccessException(String.format("World is owned by '%s' (ID: %s), but was accessed from thread '%s' (ID: %s)", this.updateThread.getName(), this.updateThread.getId(), currentThread.getName(), currentThread.getId()));
            LOG.error("Something (likely another mod) has attempted to modify the world's state from the wrong thread!\nThis is *bad practice* and can cause severe issues in your game.\nPhosphor has done as best as it can to mitigate this violation, but it may negatively impact performance or introduce stalls.\nYou should report this issue to our issue tracker with the following stacktrace information.\n(If you are aware you have misbehaving mods and cannot resolve this issue, you can safely disable this warning by setting `enable_illegal_thread_access_warnings` to `false` in LUMIS's configuration file for the time being.)", (Throwable)e);
        }
        this.lock.lock();
    }

    private void releaseLock() {
        this.lock.unlock();
    }

    private void updateLighting(LightType lightType) {
        this.currentLightType = lightType;
        this.profiler.func_76320_a("lighting");
        this.profiler.func_76320_a("checking");
        this.processUpdateQueue();
        this.processInitialDarkening();
        this.processInitialBrightening();
        this.profiler.func_76319_b();
        for (int queueIndex = 15; queueIndex >= 0; --queueIndex) {
            this.profiler.func_76320_a("darkening");
            this.processDarkeningQueue(queueIndex);
            this.profiler.func_76318_c("brightening");
            this.processBrighteningQueue(queueIndex);
            this.profiler.func_76319_b();
        }
        this.cursor.isValid = false;
        this.profiler.func_76319_b();
    }

    private void processUpdateQueue() {
        assert (this.currentLightType != null);
        LongList updateQueue = this.currentLightType.isBlock() ? this.blockLightUpdateQueue : this.skyLightUpdateQueue;
        this.setQueue(updateQueue);
        while (this.nextItem()) {
            int cursorUpdatedLightValue = this.getCursorUpdatedLightValue();
            if (this.cursor.lightValue < cursorUpdatedLightValue) {
                long newData = (long)cursorUpdatedLightValue << 60 | this.cursor.data;
                this.initialBrighteningQueue.add(newData);
                continue;
            }
            if (this.cursor.lightValue <= cursorUpdatedLightValue) continue;
            this.initialDarkeningQueue.add(this.cursor.data);
        }
    }

    private void processInitialDarkening() {
        this.setQueue(this.initialBrighteningQueue);
        while (this.nextItem()) {
            int cursorDataLightValue = (int)(this.cursor.data >> 60 & 0xFL);
            if (cursorDataLightValue <= this.cursor.lightValue) continue;
            long posLong = this.cursor.data & 0xFFFFFFFFFFFFFFFL;
            this.enqueueBrightening(this.cursor.posX, this.cursor.posY, this.cursor.posZ, posLong, cursorDataLightValue, this.cursor.chunk);
            this.cursor.setLightValue(cursorDataLightValue);
        }
    }

    private void processInitialBrightening() {
        this.setQueue(this.initialDarkeningQueue);
        while (this.nextItem()) {
            if (this.cursor.lightValue == 0) continue;
            this.enqueueDarkening(this.cursor.posX, this.cursor.posY, this.cursor.posZ, this.cursor.data, this.cursor.lightValue, this.cursor.chunk);
            this.cursor.setLightValue(0);
        }
    }

    private void processDarkeningQueue(int queueIndex) {
        this.setQueue(this.darkeningQueues[queueIndex]);
        while (this.nextItem()) {
            if (this.cursor.lightValue >= queueIndex) continue;
            int cursorBlockOpacity = this.cursor.brightnessValue >= 14 ? 1 : this.cursor.opacityValue;
            if (this.getCursorUpdatedLightValue(this.cursor.brightnessValue, cursorBlockOpacity) >= queueIndex) {
                this.enqueueBrighteningFromCursor(queueIndex);
                continue;
            }
            int newLightValue = this.cursor.brightnessValue;
            this.updateNeighborBlocks();
            for (int i = 0; i < 6; ++i) {
                BlockReference neighbor = this.neighbors[i];
                if (!neighbor.isValid || neighbor.lightValue == 0) continue;
                if (queueIndex - neighbor.opacityValue >= neighbor.lightValue) {
                    this.enqueueDarkening(neighbor.posX, neighbor.posY, neighbor.posZ, neighbor.data, neighbor.lightValue, neighbor.chunk);
                    continue;
                }
                newLightValue = Math.max(newLightValue, neighbor.lightValue - cursorBlockOpacity);
            }
            this.enqueueBrighteningFromCursor(newLightValue);
        }
    }

    private void processBrighteningQueue(int queueIndex) {
        this.setQueue(this.brighteningQueues[queueIndex]);
        while (this.nextItem()) {
            if (this.cursor.lightValue != queueIndex) continue;
            this.worldRoot.lumi$markBlockForRenderUpdate(this.cursor.posX, this.cursor.posY, this.cursor.posZ);
            if (queueIndex <= 1) continue;
            this.spreadLightFromCursor(queueIndex);
        }
    }

    private void updateNeighborBlocks() {
        if (this.areNeighboursBlocksValid) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            this.neighbors[i].updateNeighbour();
        }
        this.areNeighboursBlocksValid = true;
    }

    private int getCursorUpdatedLightValue() {
        int cursorBrightnessValue = this.cursor.brightnessValue;
        if (cursorBrightnessValue >= 15) {
            return cursorBrightnessValue;
        }
        int cursorBlockOpacity = this.cursor.brightnessValue >= 14 ? 1 : this.cursor.opacityValue;
        return this.getCursorUpdatedLightValue(this.cursor.brightnessValue, cursorBlockOpacity);
    }

    private int getCursorUpdatedLightValue(int cursorBlockLightValue, int cursorBlockOpacity) {
        if (cursorBlockLightValue >= 15 - cursorBlockOpacity) {
            return cursorBlockLightValue;
        }
        this.updateNeighborBlocks();
        int newCursorLightValue = cursorBlockLightValue;
        for (int i = 0; i < 6; ++i) {
            BlockReference neighbor = this.neighbors[i];
            if (!neighbor.isValid) continue;
            int providedLightValue = neighbor.lightValue - cursorBlockOpacity;
            newCursorLightValue = Math.max(providedLightValue, newCursorLightValue);
        }
        return newCursorLightValue;
    }

    private void spreadLightFromCursor(int cursorLightValue) {
        this.updateNeighborBlocks();
        for (int i = 0; i < 6; ++i) {
            int newLightValue;
            BlockReference neighbor = this.neighbors[i];
            if (!neighbor.isValid || (newLightValue = cursorLightValue - neighbor.opacityValue) <= neighbor.lightValue) continue;
            this.enqueueBrightening(neighbor.posX, neighbor.posY, neighbor.posZ, neighbor.data, newLightValue, neighbor.chunk);
        }
    }

    private void enqueueBrighteningFromCursor(int lightValue) {
        if (this.cursor.isValid) {
            this.enqueueBrightening(this.cursor.posX, this.cursor.posY, this.cursor.posZ, this.cursor.data, lightValue, this.cursor.chunk);
            this.cursor.setLightValue(lightValue);
        }
    }

    private void enqueueBrightening(int posX, int posY, int posZ, long posLong, int lightValue, LumiChunk chunk) {
        assert (this.currentLightType != null);
        int subChunkPosX = posX & 0xF;
        int subChunkPosZ = posZ & 0xF;
        this.brighteningQueues[lightValue].add(posLong);
        chunk.lumi$setLightValue(this.currentLightType, subChunkPosX, posY, subChunkPosZ, lightValue);
        chunk.lumi$root().lumi$markDirty();
    }

    private void enqueueDarkening(int posX, int posY, int posZ, long posLong, int oldLightValue, LumiChunk chunk) {
        assert (this.currentLightType != null);
        int subChunkPosX = posX & 0xF;
        int subChunkPosZ = posZ & 0xF;
        this.darkeningQueues[oldLightValue].add(posLong);
        chunk.lumi$setLightValue(this.currentLightType, subChunkPosX, posY, subChunkPosZ, 0);
        chunk.lumi$root().lumi$markDirty();
    }

    private void setQueue(LongList queue) {
        this.currentQueue = queue;
        this.currentQueueSize = this.currentQueue.size();
        this.currentQueueIndex = 0;
    }

    private boolean nextItem() {
        this.areNeighboursBlocksValid = false;
        assert (this.currentQueue != null);
        while (this.currentQueueIndex < this.currentQueueSize) {
            boolean isValid = this.cursor.updateCursor(this.currentQueue.getLong(this.currentQueueIndex));
            ++this.currentQueueIndex;
            if (!isValid) continue;
            return true;
        }
        this.currentQueue.clear();
        return false;
    }

    private static long posLongFromBlockPos(BlockPos blockPos) {
        return PhosphorLightingEngine.posLongFromPosXYZ(blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    private static long posLongFromPosXYZ(int posX, int posY, int posZ) {
        return (long)posX + 0x2000000L << 26 | (long)posY << 52 | (long)posZ + 0x2000000L << 0;
    }

    static {
        for (int i = 0; i < 6; ++i) {
            Direction direction = Direction.VALID_DIRECTIONS[i];
            PhosphorLightingEngine.BLOCK_SIDE_BIT_OFFSET[i] = (long)direction.xOffset << 26 | (long)direction.yOffset << 52 | (long)direction.zOffset << 0;
        }
        THREAD_ALLOWED_TO_RELIGHT = ThreadLocal.withInitial(() -> {
            Thread t = Thread.currentThread();
            String name = t.getName();
            boolean allow = true;
            if (name.startsWith(MARKER)) {
                allow = false;
                t.setName(name.substring(MARKER.length()));
            }
            return allow;
        });
    }

    class BlockReference {
        long neighbourBlockSideBitOffset = 0L;
        boolean isValid = false;
        long data = 0L;
        long chunkLongPos = -1L;
        int posX = 0;
        int posY = 0;
        int posZ = 0;
        int chunkPosY = -1;
        int subChunkPosX = 0;
        int subChunkPosY = 0;
        int subChunkPosZ = 0;
        LumiChunk chunk = null;
        LumiSubChunk subChunk = null;
        LumiSubChunkRoot subChunkRoot = null;
        Block block;
        int blockMeta;
        int brightnessValue = 0;
        int opacityValue = 0;
        int lightValue = 0;

        BlockReference() {
        }

        boolean updateCursor(long data) {
            if (this.isValid && this.data == data) {
                return true;
            }
            this.data = data;
            this.updatePos();
            this.isValid = this.updateChunk() && this.updateSubChunk() && this.updateBlock();
            return this.isValid;
        }

        void prepareNeighbor() {
            this.chunkLongPos = ((PhosphorLightingEngine)PhosphorLightingEngine.this).cursor.chunkLongPos;
            this.chunkPosY = ((PhosphorLightingEngine)PhosphorLightingEngine.this).cursor.chunkPosY;
            this.subChunkPosX = ((PhosphorLightingEngine)PhosphorLightingEngine.this).cursor.subChunkPosX;
            this.subChunkPosY = ((PhosphorLightingEngine)PhosphorLightingEngine.this).cursor.subChunkPosY;
            this.subChunkPosZ = ((PhosphorLightingEngine)PhosphorLightingEngine.this).cursor.subChunkPosZ;
            this.chunk = ((PhosphorLightingEngine)PhosphorLightingEngine.this).cursor.chunk;
            this.subChunk = ((PhosphorLightingEngine)PhosphorLightingEngine.this).cursor.subChunk;
            this.subChunkRoot = ((PhosphorLightingEngine)PhosphorLightingEngine.this).cursor.subChunkRoot;
        }

        void updateNeighbour() {
            long data;
            this.data = data = ((PhosphorLightingEngine)PhosphorLightingEngine.this).cursor.data + this.neighbourBlockSideBitOffset;
            if ((data & 0x1000000000000000L) != 0L) {
                this.isValid = false;
                return;
            }
            this.prepareNeighbor();
            this.updatePos();
            this.isValid = this.updateChunk() && this.updateSubChunk() && this.updateBlock();
        }

        void updatePos() {
            this.posX = (int)((this.data >> 26 & 0x3FFFFFFL) - 0x2000000L);
            this.posY = (int)(this.data >> 52 & 0xFFL);
            this.posZ = (int)((this.data >> 0 & 0x3FFFFFFL) - 0x2000000L);
        }

        boolean updateChunk() {
            long chunkPosLong = this.data & 0xFFFFFC3FFFFF0L;
            if (this.chunk == null || this.chunkLongPos != chunkPosLong) {
                int chunkPosX = this.posX >> 4;
                int chunkPosZ = this.posZ >> 4;
                this.chunk = PhosphorLightingEngine.this.world.lumi$getChunkFromChunkPosIfExists(chunkPosX, chunkPosZ);
                if (this.chunk == null) {
                    return false;
                }
                this.subChunk = null;
                this.subChunkRoot = null;
            }
            this.chunkLongPos = chunkPosLong;
            return true;
        }

        boolean updateSubChunk() {
            int chunkPosY = this.posY >> 4;
            if (this.chunkPosY != chunkPosY || this.subChunk == null) {
                this.subChunk = this.chunk.lumi$getSubChunk(chunkPosY);
                this.subChunkRoot = this.subChunk.lumi$root();
            }
            this.chunkPosY = chunkPosY;
            this.subChunkPosX = this.posX & 0xF;
            this.subChunkPosY = this.posY & 0xF;
            this.subChunkPosZ = this.posZ & 0xF;
            return true;
        }

        boolean updateBlock() {
            this.block = this.subChunkRoot.lumi$getBlock(this.subChunkPosX, this.subChunkPosY, this.subChunkPosZ);
            this.blockMeta = this.subChunkRoot.lumi$getBlockMeta(this.subChunkPosX, this.subChunkPosY, this.subChunkPosZ);
            if (PhosphorLightingEngine.this.currentLightType.isBlock()) {
                this.brightnessValue = PhosphorUtil.clampLightValue(this.chunk.lumi$getBlockBrightness(this.block, this.blockMeta, this.subChunkPosX, this.posY, this.subChunkPosZ));
                this.lightValue = this.subChunk.lumi$getBlockLightValue(this.subChunkPosX, this.subChunkPosY, this.subChunkPosZ);
            } else {
                this.brightnessValue = this.chunk.lumi$canBlockSeeSky(this.subChunkPosX, this.posY, this.subChunkPosZ) ? 15 : 0;
                this.lightValue = this.subChunk.lumi$getSkyLightValue(this.subChunkPosX, this.subChunkPosY, this.subChunkPosZ);
            }
            this.opacityValue = PhosphorUtil.clampBlockLightOpacity(this.chunk.lumi$getBlockOpacity(this.block, this.blockMeta, this.subChunkPosX, this.posY, this.subChunkPosZ));
            return true;
        }

        void reset() {
            this.isValid = false;
            this.data = 0L;
            this.chunkLongPos = -1L;
            this.posX = 0;
            this.posY = 0;
            this.posZ = 0;
            this.chunkPosY = -1;
            this.subChunkPosX = 0;
            this.subChunkPosY = 0;
            this.subChunkPosZ = 0;
            this.chunk = null;
            this.subChunk = null;
            this.subChunkRoot = null;
            this.block = null;
            this.blockMeta = 0;
            this.brightnessValue = 0;
            this.opacityValue = 0;
            this.lightValue = 0;
        }

        void setLightValue(int lightValue) {
            this.lightValue = lightValue;
        }
    }
}

