/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.lighting.phosphor;

import com.falsepattern.lumi.internal.lighting.phosphor.Direction;
import lombok.Generated;

enum DirectionSign {
    POSITIVE(1),
    NEGATIVE(-1);

    private final int sign;

    DirectionSign opposite() {
        return DirectionSign.opposite(this);
    }

    static DirectionSign of(Direction direction) {
        switch (direction) {
            default: {
                return POSITIVE;
            }
            case DOWN: 
            case NORTH: 
            case WEST: 
        }
        return NEGATIVE;
    }

    static DirectionSign of(Direction direction, int facingOffsetX, int facingOffsetZ) {
        int subChunkPosX = facingOffsetX & 0xF;
        int subChunkPosZ = facingOffsetZ & 0xF;
        if (direction == Direction.EAST || direction == Direction.WEST ? subChunkPosZ < 8 : subChunkPosX < 8) {
            return NEGATIVE;
        }
        return POSITIVE;
    }

    private static DirectionSign opposite(DirectionSign directionSign) {
        switch (directionSign) {
            case POSITIVE: {
                return NEGATIVE;
            }
        }
        return POSITIVE;
    }

    @Generated
    private DirectionSign(int sign) {
        this.sign = sign;
    }

    @Generated
    public int sign() {
        return this.sign;
    }
}

