/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.lighting;

import com.falsepattern.lumi.api.lighting.LumiLightingEngine;
import com.falsepattern.lumi.api.lighting.LumiLightingEngineProvider;
import com.falsepattern.lumi.api.lighting.LumiLightingEngineRegistry;
import com.falsepattern.lumi.api.world.LumiWorld;
import com.falsepattern.lumi.internal.Lumi;
import com.falsepattern.lumi.internal.LumiDefaultValues;
import com.falsepattern.lumi.internal.event.EventPoster;
import com.falsepattern.lumi.internal.lighting.NullLightingEngine;
import lombok.Generated;
import net.minecraft.profiler.Profiler;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightingEngineManager
implements LumiLightingEngineRegistry,
LumiLightingEngineProvider {
    private static final Logger LOG = Lumi.createLogger("Lighting Provider Manager");
    private static final LightingEngineManager INSTANCE = new LightingEngineManager();
    @Nullable
    private LumiLightingEngineProvider delegate;
    private boolean isRegistered = false;

    public static LightingEngineManager lightingEngineManager() {
        return INSTANCE;
    }

    public void registerLightingEngineProvider() {
        if (this.isRegistered) {
            return;
        }
        EventPoster.postLumiLightingEngineRegistrationEvent(this);
        if (this.delegate == null) {
            LumiDefaultValues.registerDefaultLightingEngineProvider(this);
        }
        this.isRegistered = true;
    }

    @Override
    public void registerLightingEngineProvider(@NotNull LumiLightingEngineProvider lightingEngineProvider, boolean displace) {
        if (this.isRegistered) {
            LOG.error("Cannot register lighting engine provider post registration", (Throwable)new IllegalStateException());
            return;
        }
        if (lightingEngineProvider == null) {
            LOG.error("Lighting engine provider can't be null", (Throwable)new IllegalArgumentException());
            return;
        }
        String lightingEngineProviderID = lightingEngineProvider.lightingEngineProviderID();
        if (lightingEngineProviderID == null) {
            LOG.error("Lighting engine provider id can't be null", (Throwable)new IllegalArgumentException());
            return;
        }
        if (lightingEngineProviderID.isEmpty()) {
            LOG.error("Lighting engine provider id can't be empty", (Throwable)new IllegalArgumentException());
            return;
        }
        if (this.delegate == null) {
            this.delegate = lightingEngineProvider;
            LOG.info("Registered lighting engine provider: [{}]", new Object[]{lightingEngineProviderID});
            return;
        }
        if (displace) {
            String oldLightingEngineProviderID = this.delegate.lightingEngineProviderID();
            LOG.warn("Lighting engine provider [{}] has been displaced with [{}], this may indicate a mod conflict but is probably fine.", new Object[]{oldLightingEngineProviderID, lightingEngineProviderID});
            this.delegate = lightingEngineProvider;
        }
    }

    @Override
    @NotNull
    public String lightingEngineProviderID() {
        if (this.delegate != null) {
            return this.delegate.lightingEngineProviderID();
        }
        return NullLightingEngine.nullLightingEngine().lightingEngineID();
    }

    @Override
    @NotNull
    public LumiLightingEngine provideLightingEngine(@NotNull LumiWorld world, @NotNull Profiler profiler) {
        if (this.delegate != null) {
            return this.delegate.provideLightingEngine(world, profiler);
        }
        return NullLightingEngine.nullLightingEngine();
    }

    @Generated
    private LightingEngineManager() {
    }
}

