/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.config;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigurationManager;
import lombok.Generated;

@Config(modid="lumi")
public final class LumiConfig {
    @Config.Comment(value={"Use locks when accessing the lighting engine state.This option may improve performance but will allow illegal access to the lighting engine from other threads."})
    @Config.LangKey(value="config.lumi.enableLocks")
    @Config.DefaultBoolean(value=true)
    @Config.RequiresWorldRestart
    public static boolean ENABLE_LOCKS;
    @Config.Comment(value={"Print a warning when the lighting engine is accessed by the wrong thread."})
    @Config.LangKey(value="config.lumi.enableIllegalThreadAccessWarnings")
    @Config.DefaultBoolean(value=true)
    public static boolean ENABLE_ILLEGAL_THREAD_ACCESS_WARNINGS;
    @Config.Comment(value={"Random light updates are disabled by default, as the reference Phosphor implementation provided is more robust compared to vanilla."})
    @Config.LangKey(value="config.lumi.doRandomLightUpdates")
    @Config.DefaultBoolean(value=false)
    public static boolean DO_RANDOM_LIGHT_UPDATES;
    @Config.Comment(value={"Increases the lighting engine internal buffer sizes from 256kB to 4MB per serverside world. Uses more ram, but improves worldgen speed.\nNot recommended on 4GB heap or smaller."})
    @Config.LangKey(value="config.lumi.enoughRam")
    @Config.DefaultBoolean(value=false)
    @Config.RequiresMcRestart
    public static boolean I_HAVE_ENOUGH_RAM;

    public static void poke() {
    }

    @Generated
    private LumiConfig() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        ConfigurationManager.selfInit();
    }
}

