/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.collection;

import com.falsepattern.lumi.internal.util.UnsafeUtil;
import gnu.trove.set.hash.TLongHashSet;

public final class PosHashSet
extends TLongHashSet {
    private static final int HASH_PRIME = 92821;

    public PosHashSet() {
    }

    public PosHashSet(int initialCapacity, float load_factor) {
        super(initialCapacity, load_factor);
    }

    private static int ballerHash(long key) {
        int a = (int)key;
        int b = (int)(key >>> 32);
        return a + b * 92821;
    }

    public void resetQuick() {
        this._size = 0;
        this._free = this._states.length;
        UnsafeUtil.clearArray(this._set);
        UnsafeUtil.clearArray(this._states);
    }

    protected int index(long val) {
        byte[] states = this._states;
        long[] set = this._set;
        int length = states.length;
        int hash = PosHashSet.ballerHash(val) & Integer.MAX_VALUE;
        int index = hash % length;
        byte state = states[index];
        if (state == 0) {
            return -1;
        }
        if (state == 1 && set[index] == val) {
            return index;
        }
        return this.indexRehashed(val, index, hash, state);
    }

    int indexRehashed(long key, int index, int hash, byte state) {
        int length = this._set.length;
        int probe = 1 + hash % (length - 2);
        int loopIndex = index;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if ((state = this._states[index]) == 0) {
                return -1;
            }
            if (key != this._set[index] || state == 2) continue;
            return index;
        } while (index != loopIndex);
        return -1;
    }

    protected int insertKey(long val) {
        int hash = PosHashSet.ballerHash(val) & Integer.MAX_VALUE;
        int index = hash % this._states.length;
        byte state = this._states[index];
        this.consumeFreeSlot = false;
        if (state == 0) {
            this.consumeFreeSlot = true;
            this.insertKeyAt(index, val);
            return index;
        }
        if (state == 1 && this._set[index] == val) {
            return -index - 1;
        }
        return this.insertKeyRehash(val, index, hash, state);
    }

    int insertKeyRehash(long val, int index, int hash, byte state) {
        int length = this._set.length;
        int probe = 1 + hash % (length - 2);
        int loopIndex = index;
        int firstRemoved = -1;
        do {
            if (state == 2 && firstRemoved == -1) {
                firstRemoved = index;
            }
            if ((index -= probe) < 0) {
                index += length;
            }
            if ((state = this._states[index]) == 0) {
                if (firstRemoved != -1) {
                    this.insertKeyAt(firstRemoved, val);
                    return firstRemoved;
                }
                this.consumeFreeSlot = true;
                this.insertKeyAt(index, val);
                return index;
            }
            if (state != 1 || this._set[index] != val) continue;
            return -index - 1;
        } while (index != loopIndex);
        if (firstRemoved != -1) {
            this.insertKeyAt(firstRemoved, val);
            return firstRemoved;
        }
        throw new IllegalStateException("No free or removed slots available. Key set full?!!");
    }

    void insertKeyAt(int index, long val) {
        this._set[index] = val;
        this._states[index] = 1;
    }
}

