/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.asm;

import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import com.falsepattern.lumi.internal.Lumi;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PhosphorDataInjector
implements TurboClassTransformer {
    private static final Logger LOG = Lumi.createLogger("Phosphor Data Injector");
    private static final HashMap<String, TriState> MEMOIZED_CLASSES = new HashMap(1024, 0.2f);

    public String owner() {
        return "Lumi";
    }

    public String name() {
        return "PhosphorDataInjector";
    }

    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        return !className.startsWith("com.falsepattern.lumi");
    }

    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        try {
            if (PhosphorDataInjector.isValidTarget(cn, className.replace('.', '/')) != TriState.VALID) {
                return false;
            }
            PhosphorDataInjector.implementInterface(cn);
            LOG.info("Injected Phosphor Data into: {}", new Object[]{className});
            return true;
        }
        catch (Throwable ignored) {
            LOG.warn("I'm so sorry");
            return false;
        }
    }

    @Contract(value="_,_->param2")
    private static TriState memoize(String className, TriState state) {
        MEMOIZED_CLASSES.put(className, state);
        return state;
    }

    private static TriState isValidTarget(ClassNode cn, String className) {
        int access = cn.access;
        if ((access & 0x200) != 0 || (access & 0x400) != 0) {
            return TriState.INVALID;
        }
        return PhosphorDataInjector.isTarget(() -> new MiniMeta(cn.interfaces.toArray(new String[0]), cn.superName), className);
    }

    @NotNull
    private static TriState isTarget(Supplier<MiniMeta> miniMeta, String className) {
        TriState superState;
        String[] interfaces;
        if (MEMOIZED_CLASSES.containsKey(className)) {
            return MEMOIZED_CLASSES.get(className);
        }
        TriState myState = TriState.INVALID;
        MiniMeta mm = miniMeta.get();
        if (mm == null) {
            return TriState.INVALID;
        }
        block4: for (String interfaceName : interfaces = mm.interfaces) {
            if (myState != TriState.VALID && "com/falsepattern/lumi/api/chunk/LumiChunk".equals(interfaceName)) {
                myState = TriState.VALID;
                continue;
            }
            if ("com/falsepattern/lumi/internal/lighting/phosphor/PhosphorChunk".equals(interfaceName)) {
                myState = TriState.ALREADY_IMPLEMENTED;
                break;
            }
            TriState interfaceState = PhosphorDataInjector.isTarget(() -> {
                try {
                    InputStream in = Launch.classLoader.getResourceAsStream(interfaceName + ".class");
                    if (in != null) {
                        ClassReader cr = new ClassReader(IOUtils.toByteArray((InputStream)in));
                        return new MiniMeta(cr.getInterfaces(), cr.getSuperName());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }, interfaceName);
            switch (interfaceState) {
                case ALREADY_IMPLEMENTED: {
                    myState = TriState.ALREADY_IMPLEMENTED;
                    break block4;
                }
                case VALID: {
                    myState = TriState.VALID;
                }
                default: {
                    continue block4;
                }
            }
        }
        if (myState == TriState.ALREADY_IMPLEMENTED) {
            return PhosphorDataInjector.memoize(className, myState);
        }
        String superName = mm.superName;
        if (superName != null && !"java/lang/Object".equals(superName) && (superState = PhosphorDataInjector.isTarget(() -> {
            try {
                InputStream in = Launch.classLoader.getResourceAsStream(superName + ".class");
                if (in != null) {
                    ClassReader cr = new ClassReader(IOUtils.toByteArray((InputStream)in));
                    return new MiniMeta(cr.getInterfaces(), cr.getSuperName());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }, superName)) != TriState.INVALID) {
            myState = superState;
        }
        return PhosphorDataInjector.memoize(className, myState);
    }

    private static void implementInterface(ClassNode cn) {
        Type fieldType = Type.getType(short[].class);
        String fieldDesc = fieldType.getDescriptor();
        String getterDesc = Type.getMethodDescriptor((Type)fieldType, (Type[])new Type[0]);
        String fieldName = "phosphor$lightCheckFlags";
        String getterName = "phosphor$lightCheckFlags";
        int fieldAcc = 18;
        boolean getterAcc = true;
        int fieldInitSize = 32;
        String targetClass = cn.name;
        String injectedInterface = "com/falsepattern/lumi/internal/lighting/phosphor/PhosphorChunk";
        cn.interfaces.add("com/falsepattern/lumi/internal/lighting/phosphor/PhosphorChunk");
        cn.fields.add(new FieldNode(18, "phosphor$lightCheckFlags", fieldDesc, null, null));
        for (MethodNode method : cn.methods) {
            if (!"<init>".equals(method.name)) continue;
            ListIterator insnIter = method.instructions.iterator();
            while (insnIter.hasNext()) {
                AbstractInsnNode insn = (AbstractInsnNode)insnIter.next();
                if (insn.getOpcode() != 177) continue;
                insnIter.previous();
                insnIter.add(new VarInsnNode(25, 0));
                insnIter.add(new IntInsnNode(16, 32));
                insnIter.add(new IntInsnNode(188, 9));
                insnIter.add(new FieldInsnNode(181, targetClass, "phosphor$lightCheckFlags", fieldDesc));
                insnIter.next();
            }
        }
        MethodNode getter = new MethodNode(1, "phosphor$lightCheckFlags", getterDesc, null, null);
        cn.methods.add(getter);
        if (getter.visibleAnnotations == null) {
            getter.visibleAnnotations = new ArrayList(1);
        }
        getter.visibleAnnotations.add(new AnnotationNode(Type.getDescriptor(Override.class)));
        getter.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        getter.instructions.add((AbstractInsnNode)new FieldInsnNode(180, targetClass, "phosphor$lightCheckFlags", fieldDesc));
        getter.instructions.add((AbstractInsnNode)new InsnNode(176));
        getter.maxLocals = 1;
        getter.maxStack = 1;
    }

    @Generated
    public PhosphorDataInjector() {
    }

    private static class MiniMeta {
        String[] interfaces;
        String superName;

        @Generated
        public MiniMeta(String[] interfaces, String superName) {
            this.interfaces = interfaces;
            this.superName = superName;
        }
    }

    private static enum TriState {
        VALID,
        INVALID,
        ALREADY_IMPLEMENTED;

    }
}

