/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.asm;

import com.falsepattern.lumi.internal.Share;
import com.falsepattern.lumi.internal.asm.ConfigFixUtil;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConfigFixer {
    public static void fixConfigs() {
        CoreTweaksCompat.executeCoreTweaksConfigFixes();
        ArchaicFixCompat.executeArchaicFixConfigFixes();
    }

    public static class ArchaicFixCompat {
        public static void executeArchaicFixConfigFixes() {
            ConfigFixUtil.fixConfig("archaicfix.cfg", line -> {
                if (line.contains("enablePhosphor")) {
                    line = line.replace("true", "false");
                }
                return line;
            }, e -> Share.LOG.fatal("Failed to apply ArchaicFix lumi compatibility patches!"));
        }
    }

    public static class CoreTweaksCompat {
        public static void executeCoreTweaksConfigFixes() {
            AtomicBoolean marker = new AtomicBoolean(false);
            ConfigFixUtil.fixConfig("coretweaks.cfg", line -> {
                if (marker.get()) {
                    if (line.contains("S:_enabled")) {
                        line = line.replace("true", "false");
                        marker.set(false);
                    }
                } else if (line.contains("fix_heightmap_range")) {
                    marker.set(true);
                }
                return line;
            }, e -> Share.LOG.fatal("Failed to apply CoreTweaks lumi compatibility patches!"));
        }
    }
}

