/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.asm;

import com.falsepattern.lib.util.FileUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ConfigFixUtil {
    public static void fixConfig(String configFile, Function<String, String> lineTransformer, Consumer<IOException> exceptionHandler) {
        Path targetPath = FileUtil.getMinecraftHomePath().resolve("config").resolve(configFile);
        if (!Files.exists(targetPath, new LinkOption[0])) {
            return;
        }
        try {
            List<String> fileText = Files.readAllLines(targetPath);
            List result = fileText.stream().map(lineTransformer).collect(Collectors.toList());
            Files.write(targetPath, result, new OpenOption[0]);
        }
        catch (IOException e) {
            exceptionHandler.accept(e);
        }
    }
}

