/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal;

import com.falsepattern.chunk.api.DataRegistry;
import com.falsepattern.falsetweaks.api.ThreadedChunkUpdates;
import com.falsepattern.lumi.internal.Share;
import com.falsepattern.lumi.internal.lighting.LightingEngineManager;
import com.falsepattern.lumi.internal.storage.ChunkNBTManager;
import com.falsepattern.lumi.internal.storage.ChunkPacketManager;
import com.falsepattern.lumi.internal.storage.SubChunkNBTManager;
import com.falsepattern.lumi.internal.world.WorldProviderManager;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="lumi", version="1.2.0", name="Lumi", acceptedMinecraftVersions="[1.7.10]", dependencies="required-after:chunkapi@[0.6.1,);required-after:falsepatternlib@[1.6.0,);after:falsetweaks@[3.9.6,);", guiFactory="com.falsepattern.lumi.internal.config.LumiGuiFactory")
public final class Lumi {
    private static boolean falseTweaks;

    public static Logger createLogger(String name) {
        return LogManager.getLogger((String)("Lumi|" + name));
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        falseTweaks = Loader.isModLoaded((String)"falsetweaks");
    }

    public static boolean lumi$isThreadedUpdates() {
        return falseTweaks && ThreadedChunkUpdates.isEnabled();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        WorldProviderManager.worldProviderManager().registerWorldProviders();
        LightingEngineManager.lightingEngineManager().registerLightingEngineProvider();
        ChunkNBTManager.chunkNBTManager().registerDataManager();
        SubChunkNBTManager.subChunkNBTManager().registerDataManager();
        ChunkPacketManager.chunkPacketManager().registerDataManager();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        DataRegistry.disableDataManager((String)"minecraft", (String)"lighting");
        Share.LOG.info("Disabled [minecraft:lighting] data manager");
        DataRegistry.disableDataManager((String)"minecraft", (String)"blocklight");
        Share.LOG.info("Disabled [minecraft:blocklight] data manager");
        DataRegistry.disableDataManager((String)"minecraft", (String)"skylight");
        Share.LOG.info("Disabled [minecraft:skylight] data manager");
    }

    @Generated
    public Lumi() {
    }
}

