/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.api.event;

import com.falsepattern.lib.StableAPI;
import cpw.mods.fml.common.eventhandler.Event;

@StableAPI(since="__EXPERIMENTAL__")
public final class ChunkPacketSizeEvent
extends Event {
    private static final int PACKET_SIZE_BYTES_LIMIT = 0x100000;
    private int chunkMaxPacketSize;
    private int subChunkMaxPacketSize;
    private int lightingEngineMaxPacketSize;

    @StableAPI.Internal
    public ChunkPacketSizeEvent(int chunkMaxPacketSize, int subChunkMaxPacketSize, int lightingEngineMaxPacketSize) {
        this.chunkMaxPacketSize = chunkMaxPacketSize;
        this.subChunkMaxPacketSize = subChunkMaxPacketSize;
        this.lightingEngineMaxPacketSize = lightingEngineMaxPacketSize;
    }

    @StableAPI.Expose
    public void chunkMaxPacketSize(int chunkMaxPacketSize) {
        if (chunkMaxPacketSize <= 0) {
            return;
        }
        ChunkPacketSizeEvent.ensureValidPacketSize(chunkMaxPacketSize, this.subChunkMaxPacketSize, this.lightingEngineMaxPacketSize);
        this.chunkMaxPacketSize = Math.max(this.chunkMaxPacketSize, chunkMaxPacketSize);
    }

    @StableAPI.Expose
    public void lightingEngineMaxPacketSize(int lightingEngineMaxPacketSize) {
        if (lightingEngineMaxPacketSize <= 0) {
            return;
        }
        ChunkPacketSizeEvent.ensureValidPacketSize(this.chunkMaxPacketSize, this.chunkMaxPacketSize, lightingEngineMaxPacketSize);
        this.lightingEngineMaxPacketSize = Math.max(this.subChunkMaxPacketSize, lightingEngineMaxPacketSize);
    }

    @StableAPI.Expose
    public void subChunkMaxPacketSize(int subChunkMaxPacketSize) {
        if (subChunkMaxPacketSize <= 0) {
            return;
        }
        ChunkPacketSizeEvent.ensureValidPacketSize(this.chunkMaxPacketSize, subChunkMaxPacketSize, this.lightingEngineMaxPacketSize);
        this.subChunkMaxPacketSize = Math.max(this.subChunkMaxPacketSize, subChunkMaxPacketSize);
    }

    @StableAPI.Expose
    public int totalMaxPacketSize() {
        return this.chunkMaxPacketSize + this.subChunkMaxPacketSize * 16 + this.lightingEngineMaxPacketSize;
    }

    private static void ensureValidPacketSize(int chunkMaxPacketSize, int subChunkMaxPacketSize, int lightingEngineMaxPacketSize) {
        if (chunkMaxPacketSize > 0x100000) {
            throw new IllegalArgumentException("Chunk packet max packet size cannot exceed 1 MiB");
        }
        if (subChunkMaxPacketSize > 0x100000) {
            throw new IllegalArgumentException("Sub chunk packet max packet size cannot exceed 1 MiB");
        }
        if (lightingEngineMaxPacketSize > 0x100000) {
            throw new IllegalArgumentException("Lighting engine max packet size cannot exceed 1 MiB");
        }
        if (chunkMaxPacketSize + subChunkMaxPacketSize + lightingEngineMaxPacketSize > 0x100000) {
            throw new IllegalArgumentException("Total chunk data max packet size cannot exceed 1 MiB");
        }
    }
}

