/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.api;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lumi.api.chunk.LumiChunk;
import com.falsepattern.lumi.api.init.LumiChunkInitTaskQueue;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

@StableAPI(since="__EXPERIMENTAL__")
public final class LumiChunkAPI {
    private static final int[] INITIAL_HEIGHT_MAP_ARRAY = new int[256];
    private static final boolean[] INITIAL_UPDATE_SKYLIGHT_COLUMNS_ARRAY = new boolean[256];

    private LumiChunkAPI() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @StableAPI.Expose
    public static void scheduleChunkLightingEngineInit(@NotNull LumiChunk chunk) {
        LumiChunkAPI.scheduleChunkInitTask(chunk, () -> chunk.lumi$world().lumi$lightingEngine().handleChunkInit(chunk));
    }

    @StableAPI.Expose
    public static void scheduleChunkInitTask(@NotNull LumiChunk chunk, @NotNull Runnable task) {
        LumiChunkInitTaskQueue chunkInitTaskQueue = (LumiChunkInitTaskQueue)((Object)chunk.lumi$root());
        chunkInitTaskQueue.lumi$addInitTask(task);
    }

    @StableAPI.Expose
    public static void resetHeightMapArray(int @NotNull [] heightMap) {
        System.arraycopy(INITIAL_HEIGHT_MAP_ARRAY, 0, heightMap, 0, 256);
    }

    @StableAPI.Expose
    public static void resetUpdateSkylightColumns(boolean @NotNull [] updateSkylightColumns) {
        System.arraycopy(INITIAL_UPDATE_SKYLIGHT_COLUMNS_ARRAY, 0, updateSkylightColumns, 0, 256);
    }

    static {
        Arrays.fill(INITIAL_HEIGHT_MAP_ARRAY, Integer.MAX_VALUE);
        Arrays.fill(INITIAL_UPDATE_SKYLIGHT_COLUMNS_ARRAY, true);
    }
}

