/*
 * Decompiled with CFR 0.152.
 */
package cn.tesseract.worleycaves.world;

import cn.tesseract.mycelium.util.BlockPos;
import cn.tesseract.mycelium.world.ChunkPrimer;
import cn.tesseract.worleycaves.Main;
import cn.tesseract.worleycaves.config.Configs;
import cn.tesseract.worleycaves.util.FastNoise;
import cn.tesseract.worleycaves.util.WorleyUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fluids.IFluidBlock;

public class WorleyCaveGenerator
extends MapGenCaves {
    int numLogChunks = 500;
    long[] genTime = new long[this.numLogChunks];
    int currentTimeIndex = 0;
    double sum = 0.0;
    private WorleyUtil worleyF1divF3 = new WorleyUtil();
    private FastNoise displacementNoisePerlin = new FastNoise();
    private MapGenBase replacementCaves;
    private MapGenBase moddedCaveGen;
    private static Block lava;
    private static int maxCaveHeight;
    private static int minCaveHeight;
    private static float noiseCutoff;
    private static float warpAmplifier;
    private static float easeInDepth;
    private static float yCompression;
    private static float xzCompression;
    private static float surfaceCutoff;
    private static int lavaDepth;
    private static int HAS_CAVES_FLAG;

    public WorleyCaveGenerator() {
        this.worleyF1divF3.SetFrequency(0.016f);
        this.displacementNoisePerlin.SetNoiseType(FastNoise.NoiseType.Perlin);
        this.displacementNoisePerlin.SetFrequency(0.05f);
        maxCaveHeight = Configs.maxCaveHeight;
        minCaveHeight = Configs.minCaveHeight;
        noiseCutoff = Configs.noiseCutoffValue;
        warpAmplifier = Configs.warpAmplifier;
        easeInDepth = Configs.easeInDepth;
        yCompression = Configs.verticalCompressionMultiplier;
        xzCompression = Configs.horizonalCompressionMultiplier;
        surfaceCutoff = Configs.surfaceCutoffValue;
        lavaDepth = Configs.lavaDepth;
        lava = (Block)Block.field_149771_c.func_82594_a(Configs.lavaBlock);
        if (lava == null) {
            Main.LOGGER.error("Cannont find block " + Configs.lavaBlock);
            lava = Blocks.field_150350_a;
        }
        this.moddedCaveGen = TerrainGen.getModdedMapGen((MapGenBase)this, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.replacementCaves = this.moddedCaveGen != this ? this.moddedCaveGen : new MapGenCaves();
    }

    private void debugValueAdjustments() {
    }

    public void func_151539_a(IChunkProvider provider, World worldIn, int x, int z, Block[] blocks) {
        ChunkPrimer primer = new ChunkPrimer(blocks);
        int currentDim = worldIn.field_73011_w.field_76574_g;
        this.field_75039_c = worldIn;
        for (int blacklistedDim : Configs.blackListedDims) {
            if (currentDim != blacklistedDim) continue;
            this.replacementCaves.func_151539_a(provider, worldIn, x, z, blocks);
            return;
        }
        this.debugValueAdjustments();
        boolean logTime = false;
        long start = 0L;
        if (logTime) {
            start = System.nanoTime();
        }
        this.field_75039_c = worldIn;
        this.generateWorleyCaves(worldIn, x, z, primer);
        if (logTime) {
            this.genTime[this.currentTimeIndex] = System.nanoTime() - start;
            this.sum += (double)this.genTime[this.currentTimeIndex];
            ++this.currentTimeIndex;
            if (this.currentTimeIndex == this.genTime.length) {
                System.out.printf("%d chunk average: %.2f ms per chunk\n", this.numLogChunks, this.sum / (double)((float)this.numLogChunks * 1000000.0f));
                this.sum = 0.0;
                this.currentTimeIndex = 0;
            }
        }
    }

    protected void generateWorleyCaves(World worldIn, int chunkX, int chunkZ, ChunkPrimer chunkPrimerIn) {
        int chunkMaxHeight = this.getMaxSurfaceHeight(chunkPrimerIn);
        int seaLevel = 63;
        float[][][] samples = this.sampleNoise(chunkX, chunkZ, chunkMaxHeight + 1);
        float oneQuarter = 0.25f;
        float oneHalf = 0.5f;
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                int depth = 0;
                if (samples[x][HAS_CAVES_FLAG][z] == 0.0f && samples[x + 1][HAS_CAVES_FLAG][z] == 0.0f && samples[x][HAS_CAVES_FLAG][z + 1] == 0.0f && samples[x + 1][HAS_CAVES_FLAG][z + 1] == 0.0f) continue;
                for (int y = maxCaveHeight / 2 - 1; y >= 0; --y) {
                    float x0y0z0 = samples[x][y][z];
                    float x0y0z1 = samples[x][y][z + 1];
                    float x1y0z0 = samples[x + 1][y][z];
                    float x1y0z1 = samples[x + 1][y][z + 1];
                    float x0y1z0 = samples[x][y + 1][z];
                    float x0y1z1 = samples[x][y + 1][z + 1];
                    float x1y1z0 = samples[x + 1][y + 1][z];
                    float x1y1z1 = samples[x + 1][y + 1][z + 1];
                    float noiseStepY00 = (x0y1z0 - x0y0z0) * -oneHalf;
                    float noiseStepY01 = (x0y1z1 - x0y0z1) * -oneHalf;
                    float noiseStepY10 = (x1y1z0 - x1y0z0) * -oneHalf;
                    float noiseStepY11 = (x1y1z1 - x1y0z1) * -oneHalf;
                    float noiseStartX0 = x0y0z0;
                    float noiseStartX1 = x0y0z1;
                    float noiseEndX0 = x1y0z0;
                    float noiseEndX1 = x1y0z1;
                    for (int suby = 1; suby >= 0; --suby) {
                        int localY = suby + y * 2;
                        float noiseStartZ = noiseStartX0;
                        float noiseEndZ = noiseStartX1;
                        float noiseStepX0 = (noiseEndX0 - noiseStartX0) * oneQuarter;
                        float noiseStepX1 = (noiseEndX1 - noiseStartX1) * oneQuarter;
                        for (int subx = 0; subx < 4; ++subx) {
                            int localX = subx + x * 4;
                            int realX = localX + chunkX * 16;
                            float noiseStepZ = (noiseEndZ - noiseStartZ) * oneQuarter;
                            float noiseVal = noiseStartZ;
                            for (int subz = 0; subz < 4; ++subz) {
                                Block aboveBlock;
                                int localZ = subz + z * 4;
                                int realZ = localZ + chunkZ * 16;
                                BlockPos realPos = new BlockPos(realX, localY, realZ);
                                BiomeGenBase currentBiome = null;
                                if (depth == 0) {
                                    if (subx != 0 || subz != 0) continue;
                                    Block currentBlock = chunkPrimerIn.getBlockState(localX, localY, localZ);
                                    currentBiome = this.field_75039_c.field_73011_w.getBiomeGenForCoords(realPos.x, realPos.z);
                                    if (this.canReplaceBlock(currentBlock, Blocks.field_150350_a) || this.isBiomeBlock(chunkPrimerIn, realX, realZ, currentBlock, currentBiome)) {
                                        ++depth;
                                    }
                                } else if (subx == 0 && subz == 0) {
                                    ++depth;
                                }
                                float adjustedNoiseCutoff = noiseCutoff;
                                if ((float)depth < easeInDepth) {
                                    adjustedNoiseCutoff = (float)WorleyCaveGenerator.clampedLerp(noiseCutoff, surfaceCutoff, (easeInDepth - (float)depth) / easeInDepth);
                                }
                                if (localY < minCaveHeight + 5) {
                                    adjustedNoiseCutoff = (float)((double)adjustedNoiseCutoff + (double)(minCaveHeight + 5 - localY) * 0.05);
                                }
                                if (noiseVal > adjustedNoiseCutoff && (!this.isFluidBlock(aboveBlock = chunkPrimerIn.getBlockState(localX, localY + 1, localZ)) || localY <= lavaDepth)) {
                                    if (((float)depth < easeInDepth || localY > seaLevel - 8) && localY > lavaDepth && (localX < 15 && this.isFluidBlock(chunkPrimerIn.getBlockState(localX + 1, localY, localZ)) || localX > 0 && this.isFluidBlock(chunkPrimerIn.getBlockState(localX - 1, localY, localZ)) || localZ < 15 && this.isFluidBlock(chunkPrimerIn.getBlockState(localX, localY, localZ + 1)) || localZ > 0 && this.isFluidBlock(chunkPrimerIn.getBlockState(localX, localY, localZ - 1)))) continue;
                                    Block currentBlock = chunkPrimerIn.getBlockState(localX, localY, localZ);
                                    if (currentBiome == null) {
                                        currentBiome = this.field_75039_c.field_73011_w.getBiomeGenForCoords(realPos.x, realPos.z);
                                    }
                                    boolean foundTopBlock = this.isTopBlock(currentBlock, currentBiome);
                                    this.digBlock(chunkPrimerIn, localX, localY, localZ, chunkX, chunkZ, foundTopBlock, currentBlock, aboveBlock, currentBiome);
                                }
                                noiseVal += noiseStepZ;
                            }
                            noiseStartZ += noiseStepX0;
                            noiseEndZ += noiseStepX1;
                        }
                        noiseStartX0 += noiseStepY00;
                        noiseStartX1 += noiseStepY01;
                        noiseEndX0 += noiseStepY10;
                        noiseEndX1 += noiseStepY11;
                    }
                }
            }
        }
    }

    public static int getBlockIndex(int x, int y, int z) {
        return x << 12 | z << 8 | y;
    }

    public static double clampedLerp(double lowerBnd, double upperBnd, double slide) {
        if (slide < 0.0) {
            return lowerBnd;
        }
        return slide > 1.0 ? upperBnd : lowerBnd + (upperBnd - lowerBnd) * slide;
    }

    public float[][][] sampleNoise(int chunkX, int chunkZ, int maxSurfaceHeight) {
        int originalMaxHeight = 128;
        float[][][] noiseSamples = new float[5][130][5];
        for (int x = 0; x < 5; ++x) {
            int realX = x * 4 + (chunkX << 4);
            for (int z = 0; z < 5; ++z) {
                int realZ = z * 4 + (chunkZ << 4);
                boolean columnHasCaveFlag = false;
                for (int y = 128; y >= 0; --y) {
                    float noiseTwoAbove;
                    float noise;
                    float realY = y * 2;
                    if (realY > (float)maxSurfaceHeight || realY > (float)maxCaveHeight || realY < (float)minCaveHeight) {
                        noiseSamples[x][y][z] = -1.1f;
                        continue;
                    }
                    float dispAmp = (float)((double)warpAmplifier * ((double)(originalMaxHeight - y) / ((double)originalMaxHeight * 0.85)));
                    float xDisp = 0.0f;
                    float yDisp = 0.0f;
                    float zDisp = 0.0f;
                    xDisp = this.displacementNoisePerlin.GetNoise(realX, realZ) * dispAmp;
                    yDisp = this.displacementNoisePerlin.GetNoise(realX, (float)realZ + 67.0f) * dispAmp;
                    zDisp = this.displacementNoisePerlin.GetNoise(realX, (float)realZ + 149.0f) * dispAmp;
                    noiseSamples[x][y][z] = noise = this.worleyF1divF3.SingleCellular3Edge((float)realX * xzCompression + xDisp, realY * yCompression + yDisp, (float)realZ * xzCompression + zDisp);
                    if (!(noise > noiseCutoff)) continue;
                    columnHasCaveFlag = true;
                    if (x > 0) {
                        noiseSamples[x - 1][y][z] = noise * 0.2f + noiseSamples[x - 1][y][z] * 0.8f;
                    }
                    if (z > 0) {
                        noiseSamples[x][y][z - 1] = noise * 0.2f + noiseSamples[x][y][z - 1] * 0.8f;
                    }
                    if (y >= 128) continue;
                    float noiseAbove = noiseSamples[x][y + 1][z];
                    if (noise > noiseAbove) {
                        noiseSamples[x][y + 1][z] = noise * 0.8f + noiseAbove * 0.2f;
                    }
                    if (y >= 127 || !(noise > (noiseTwoAbove = noiseSamples[x][y + 2][z]))) continue;
                    noiseSamples[x][y + 2][z] = noise * 0.35f + noiseTwoAbove * 0.65f;
                }
                noiseSamples[x][WorleyCaveGenerator.HAS_CAVES_FLAG][z] = (float)columnHasCaveFlag;
            }
        }
        return noiseSamples;
    }

    private int getSurfaceHeight(ChunkPrimer chunkPrimerIn, int localX, int localZ) {
        return this.recursiveBinarySurfaceSearch(chunkPrimerIn, localX, localZ, 255, 0);
    }

    private int recursiveBinarySurfaceSearch(ChunkPrimer chunkPrimer, int localX, int localZ, int searchTop, int searchBottom) {
        int top = searchTop;
        if (searchTop > searchBottom) {
            int searchMid = (searchBottom + searchTop) / 2;
            top = this.canReplaceBlock(chunkPrimer.getBlockState(localX, searchMid, localZ), Blocks.field_150350_a) ? this.recursiveBinarySurfaceSearch(chunkPrimer, localX, localZ, searchTop, searchMid + 1) : this.recursiveBinarySurfaceSearch(chunkPrimer, localX, localZ, searchMid, searchBottom);
        }
        return top;
    }

    private int getMaxSurfaceHeight(ChunkPrimer primer) {
        int max = 0;
        int[][] testcords = new int[][]{{2, 6}, {3, 11}, {7, 2}, {9, 13}, {12, 4}, {13, 9}};
        for (int n = 0; n < testcords.length; ++n) {
            int testmax = this.getSurfaceHeight(primer, testcords[n][0], testcords[n][1]);
            if (testmax <= max || (max = testmax) <= maxCaveHeight) continue;
            return max;
        }
        return max;
    }

    private boolean isBiomeBlock(ChunkPrimer blocks, int realX, int realZ, Block block, BiomeGenBase biome) {
        return block == biome.field_76752_A || block == biome.field_76753_B;
    }

    private boolean isFluidBlock(Block blocky) {
        return blocky instanceof BlockLiquid || blocky instanceof IFluidBlock;
    }

    private boolean isTopBlock(Block block, BiomeGenBase biome) {
        return this.isExceptionBiome(biome) ? block == Blocks.field_150349_c : block == biome.field_76752_A;
    }

    private boolean isExceptionBiome(BiomeGenBase biome) {
        return biome == BiomeGenBase.field_76769_d || biome == BiomeGenBase.field_76787_r || biome == BiomeGenBase.field_76789_p;
    }

    protected boolean canReplaceBlock(Block block, Block blockUp) {
        if (block == Blocks.field_150350_a || blockUp.func_149688_o() == Material.field_151586_h) {
            return false;
        }
        return Configs.allowReplaceMoreBlocks && block.func_149688_o() == Material.field_151576_e || block == Blocks.field_150348_b || block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150405_ch || block == Blocks.field_150406_ce || block == Blocks.field_150322_A || block == Blocks.field_150391_bh || block == Blocks.field_150431_aC || block == Blocks.field_150354_m || block == Blocks.field_150351_n;
    }

    protected void digBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop, Block block, Block up, BiomeGenBase biome) {
        Block top = biome.field_76752_A;
        Block filler = biome.field_76753_B;
        if (this.canReplaceBlock(block, up) || block == top || block == filler) {
            if (y <= lavaDepth) {
                data.setBlockState(x, y, z, lava);
            } else {
                data.setBlockState(x, y, z, Blocks.field_150350_a);
                if (foundTop && data.getBlockState(x, y - 1, z) == filler) {
                    data.setBlockState(x, y - 1, z, top);
                }
                if (up == Blocks.field_150354_m) {
                    data.setBlockState(x, y + 1, z, Blocks.field_150322_A);
                } else if (up == Blocks.field_150351_n) {
                    data.setBlockState(x, y + 1, z, filler);
                }
            }
        }
    }

    static {
        HAS_CAVES_FLAG = 129;
    }
}

