/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import codechicken.nei.recipe.StackInfo;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.github.vfyjxf.nee.utils.ItemUtils;
import com.glodblock.github.common.item.ItemFluidPacket;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class PacketSlotStackChange
implements IMessage {
    private ItemStack stack;
    private List<Integer> craftingSlots;

    public PacketSlotStackChange() {
    }

    public PacketSlotStackChange(ItemStack stack, List<Integer> craftingSlots) {
        this.stack = stack;
        this.craftingSlots = craftingSlots;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public List<Integer> getCraftingSlots() {
        return this.craftingSlots;
    }

    public void fromBytes(ByteBuf buf) {
        this.stack = ItemUtils.loadItemStackFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
        int craftingSlotsSize = buf.readInt();
        this.craftingSlots = new ArrayList<Integer>(craftingSlotsSize);
        for (int i = 0; i < craftingSlotsSize; ++i) {
            int slotNumber = buf.readInt();
            this.craftingSlots.add(slotNumber);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)ItemUtils.writeItemStackToNBT(this.stack, this.stack.field_77994_a));
        buf.writeInt(this.craftingSlots.size());
        for (Integer craftingSlot : this.craftingSlots) {
            buf.writeInt(craftingSlot.intValue());
        }
    }

    public static final class Handler
    implements IMessageHandler<PacketSlotStackChange, IMessage> {
        public IMessage onMessage(PacketSlotStackChange message, MessageContext ctx) {
            Container container = ctx.getServerHandler().field_147369_b.field_71070_bA;
            ItemStack nextStack = message.getStack();
            if (nextStack != null) {
                if (GuiUtils.isFluidCraftPatternContainer(container) && StackInfo.itemStackToNBT((ItemStack)nextStack).func_74764_b("gtFluidName")) {
                    nextStack = ItemFluidPacket.newStack((FluidStack)StackInfo.getFluid((ItemStack)nextStack));
                }
                for (Integer craftingSlot : message.getCraftingSlots()) {
                    Slot currentSlot = container.func_75139_a(craftingSlot.intValue());
                    if (currentSlot == null) continue;
                    currentSlot.func_75215_d(nextStack);
                }
            }
            return null;
        }
    }
}

