/*
 * Decompiled with CFR 0.152.
 */
package enviromine.world.features.mineshaft;

import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.trackers.properties.DimensionProperties;
import enviromine.world.features.WorldFeatureGenerator;
import enviromine.world.features.mineshaft.MineSegment;
import enviromine.world.features.mineshaft.MineSegmentShaft;
import enviromine.world.features.mineshaft.designers.MineDesigner;
import enviromine.world.features.mineshaft.designers.MineDesignerComb;
import enviromine.world.features.mineshaft.designers.MineDesignerFeather;
import enviromine.world.features.mineshaft.designers.MineDesignerGrid;
import enviromine.world.features.mineshaft.designers.MineDesignerRandomized;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class MineshaftBuilder {
    public static ArrayList<MineDesigner> designers = new ArrayList();
    public static HashMap<String, Integer> scannedGrids = new HashMap();
    public static ArrayList<MineshaftBuilder> pendingBuilders = new ArrayList();
    public HashMap<String, ArrayList<MineSegment>> segmentMap = new HashMap();
    public World world;
    public Random rand;
    public int origX = 0;
    public int origZ = 0;
    public int origY = 0;
    public int rot = 0;
    public int decayAmount = 0;
    public boolean alreadyGenerating = false;

    public MineshaftBuilder(World world, int originX, int originZ, int dir) {
        this.world = world;
        this.rand = world.field_73012_v;
        this.origX = originX;
        this.origZ = originZ;
        this.origY = world.func_72825_h(originX, originZ);
        this.rot = dir % 4;
    }

    public MineshaftBuilder(World world, int originX, int originY, int originZ, int dir) {
        this.world = world;
        this.rand = world.field_73012_v;
        this.origX = originX;
        this.origZ = originZ;
        this.origY = originY;
        this.rot = dir % 4;
    }

    public static void scanGrids(World world, int chunkX, int chunkZ, Random random) {
        WorldFeatureGenerator.disableMineScan = true;
        int gridX = chunkX / 64;
        int gridZ = chunkZ / 64;
        for (int i = gridX - 1; i <= gridX + 1; ++i) {
            for (int k = gridZ - 1; k <= gridZ + 1; ++k) {
                if (scannedGrids.containsKey("" + i + "," + k + "," + world.field_73011_w.field_76574_g)) continue;
                int foundBuilders = 0;
                for (int ii = i * 64; ii <= i * 64 + 64; ii += 8) {
                    for (int kk = k * 64; kk <= k * 64 + 64; kk += 8) {
                        if (random.nextInt(100) != 0) continue;
                        int rotation = 0;
                        MineshaftBuilder tmpBuilder = new MineshaftBuilder(world, ii * 16, kk * 16, rotation);
                        tmpBuilder.decayAmount = random.nextInt(10);
                        tmpBuilder.setRandom(random);
                        if (!tmpBuilder.BuildAbandonedMine()) continue;
                        pendingBuilders.add(tmpBuilder);
                        tmpBuilder.CheckAndBuildAll();
                        if (!pendingBuilders.contains(tmpBuilder)) continue;
                        ++foundBuilders;
                    }
                }
                scannedGrids.put("" + i + "," + k + "," + world.field_73011_w.field_76574_g, foundBuilders);
            }
        }
        WorldFeatureGenerator.disableMineScan = false;
    }

    public MineshaftBuilder setRandom(Random newRand) {
        this.rand = newRand;
        return this;
    }

    public boolean checkAndBuildSegments(int chunkX, int chunkZ) {
        if (!this.alreadyGenerating) {
            this.alreadyGenerating = true;
            ArrayList<MineSegment> chunkSegments = this.segmentMap.get("" + chunkX + "," + chunkZ);
            if (chunkSegments != null) {
                for (int i = chunkSegments.size() - 1; i >= 0; --i) {
                    MineSegment segment = chunkSegments.get(i);
                    if (!segment.allChunksLoaded()) continue;
                    if (segment.canBuild()) {
                        segment.build();
                    }
                    chunkSegments.remove(i);
                }
                if (chunkSegments.size() > 0) {
                    this.segmentMap.put("" + chunkX + "," + chunkZ, chunkSegments);
                } else {
                    this.segmentMap.remove(this.segmentMap.get("" + chunkX + "," + chunkZ));
                }
            }
            this.alreadyGenerating = false;
        } else if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) {
            EnviroMine.logger.log(Level.ERROR, "EnviroMine tried to recursively generate Mineshafts! Too many villages shafts?");
        }
        return this.segmentMap.size() <= 0;
    }

    public void CheckAndBuildAll() {
        String[] keys = this.segmentMap.keySet().toArray(new String[this.segmentMap.size()]);
        for (int i = this.segmentMap.size() - 1; i >= 0; --i) {
            ArrayList<MineSegment> chunkSegments = this.segmentMap.get(keys[i]);
            if (chunkSegments == null || chunkSegments.size() <= 0) {
                this.segmentMap.remove(i);
                continue;
            }
            for (int j = chunkSegments.size() - 1; j >= 0; --j) {
                try {
                    MineSegment segment = chunkSegments.get(j);
                    if (!segment.allChunksLoaded()) continue;
                    if (segment.canBuild()) {
                        segment.build();
                    }
                    chunkSegments.remove(j);
                    continue;
                }
                catch (Exception e) {
                    if (EM_Settings.loggerVerbosity < EM_ConfigHandler.EnumLogVerbosity.ALL.getLevel()) continue;
                    EnviroMine.logger.log(Level.WARN, "An error occured while generating a section of mineshaft:", (Throwable)e);
                }
            }
            if (chunkSegments.size() > 0) continue;
            this.segmentMap.remove(i);
        }
        if (this.segmentMap.size() <= 0) {
            pendingBuilders.remove(this);
            if (scannedGrids.containsKey("" + this.origX / 1024 + "," + this.origZ / 1024 + "," + this.world.field_73011_w.field_76574_g)) {
                int remBuilders = scannedGrids.get("" + this.origX / 1024 + "," + this.origZ / 1024 + "," + this.world.field_73011_w.field_76574_g);
                scannedGrids.put("" + this.origX / 1024 + "," + this.origZ / 1024 + "," + this.world.field_73011_w.field_76574_g, remBuilders - 1);
            }
        }
    }

    public boolean BuildAbandonedMine() {
        int seaLvl;
        DimensionProperties dProps = EM_Settings.dimensionProperties.get(this.world.field_73011_w.field_76574_g);
        int n = seaLvl = dProps != null ? dProps.sealevel : 64;
        int mineDepth = dProps != null ? dProps.mineDepth : 12 + (seaLvl > 32 ? this.rand.nextInt(5) * 4 : 4 * this.rand.nextInt((seaLvl - 12) / 4));
        boolean shaft = true;
        if (mineDepth < 0) {
            shaft = false;
            this.origY = mineDepth *= -1;
        }
        int chunkY = this.origY;
        if (shaft) {
            MineSegmentShaft segment;
            if (this.world.func_147439_a(this.origX, this.origY - 1, this.origX).func_149688_o() == Material.field_151586_h || this.world.func_147439_a(this.origX, this.origY - 1, this.origX).func_149688_o() == Material.field_151587_i || (float)this.origY < (float)seaLvl * 0.75f || seaLvl < 24) {
                return false;
            }
            if (chunkY % 4 != 0) {
                segment = new MineSegmentShaft(this.world, this.xOffset(0, 0), chunkY -= 3, this.zOffset(0, 0), this.rot, this, false);
                segment.setDecay(this.decayAmount);
                segment.linkChunksToBuilder();
                chunkY -= chunkY % 4;
            }
            while (chunkY >= mineDepth) {
                segment = null;
                if (chunkY == mineDepth) {
                    segment = new MineSegmentShaft(this.world, this.xOffset(0, 0), chunkY, this.zOffset(0, 0), this.rot, this, true);
                    segment.setDecay(this.decayAmount);
                    segment.linkChunksToBuilder();
                    break;
                }
                segment = new MineSegmentShaft(this.world, this.xOffset(0, 0), chunkY, this.zOffset(0, 0), this.rot, this, false);
                segment.setDecay(this.decayAmount);
                segment.linkChunksToBuilder();
                chunkY -= 4;
            }
        }
        if (designers.size() > 0) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.ALL.getLevel()) {
                EnviroMine.logger.log(Level.INFO, "Designing new mine...");
            }
        } else {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.ALL.getLevel()) {
                EnviroMine.logger.log(Level.WARN, "Unable to construct a mineshaft! No designs registered!");
            }
            return false;
        }
        designers.get(this.rand.nextInt(designers.size())).StartDesign(this, this.rand.nextInt(64) + 64, chunkY, 3 + this.rand.nextInt(7));
        if (this.segmentMap.size() > 0) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.ALL.getLevel()) {
                EnviroMine.logger.log(Level.INFO, "New mine at " + this.origX + "," + this.origY + "," + this.origZ + " with rotation " + this.rot + " in dimension " + this.world.field_73011_w.field_76574_g);
            }
            return true;
        }
        return false;
    }

    public boolean startCaveDesign() {
        return true;
    }

    public MineSegment GetSegmentFromID(SegmentType type) {
        return null;
    }

    public int xOffset(int x, int z) {
        return MineshaftBuilder.xOffset(this.origX, this.rot, x, z);
    }

    public int yOffset(int y) {
        return MineshaftBuilder.yOffset(this.origY, y);
    }

    public int zOffset(int x, int z) {
        return MineshaftBuilder.zOffset(this.origZ, this.rot, x, z);
    }

    public static int xOffset(int pointX, int rotation, int x, int z) {
        switch (rotation) {
            case 0: {
                return x + pointX;
            }
            case 1: {
                return z + pointX;
            }
            case 2: {
                return -x + pointX;
            }
            case 3: {
                return -z + pointX;
            }
        }
        return x + pointX;
    }

    public static int yOffset(int pointY, int y) {
        return y + pointY;
    }

    public static int zOffset(int pointZ, int rotation, int x, int z) {
        switch (rotation) {
            case 0: {
                return z + pointZ;
            }
            case 1: {
                return -x + pointZ;
            }
            case 2: {
                return -z + pointZ;
            }
            case 3: {
                return x + pointZ;
            }
        }
        return z + pointZ;
    }

    public static void saveBuilders(File file) {
        block6: {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileOutputStream fos = new FileOutputStream(file);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                HashMap<String, Integer> savedGrids = new HashMap<String, Integer>();
                for (String key : scannedGrids.keySet()) {
                    Integer value = scannedGrids.get(key);
                    if (value > 0) continue;
                    savedGrids.put(key, value);
                }
                oos.writeObject(savedGrids);
                oos.close();
                bos.close();
                fos.close();
            }
            catch (FileNotFoundException e) {
                if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                    EnviroMine.logger.log(Level.WARN, "Failed to save Mineshaft Builders: FileNotFoundException");
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                if (EM_Settings.loggerVerbosity < EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) break block6;
                EnviroMine.logger.log(Level.WARN, "Failed to save Mineshaft Builders: IOException!");
                e.printStackTrace();
            }
        }
    }

    public static void loadBuilders(File file) {
        if (!file.exists()) {
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ObjectInputStream ois = new ObjectInputStream(bis);
            HashMap loadedGrids = (HashMap)ois.readObject();
            for (String key : loadedGrids.keySet()) {
                Integer value = (Integer)loadedGrids.get(key);
                if (value > 0) continue;
                scannedGrids.put(key, value);
            }
            ois.close();
            bis.close();
            fis.close();
        }
        catch (FileNotFoundException e) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.WARN, "Failed to load Mineshaft Builders: FileNotFoundException");
            }
            e.printStackTrace();
        }
        catch (IOException e) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.WARN, "Failed to load Mineshaft Builders: IOException!");
            }
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.WARN, "Failed to load Mineshaft Builders: ClassCastException! (file format error)");
            }
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.WARN, "Failed to load Mineshaft Builders: ClassNotFoundException! (file format error)");
            }
            e.printStackTrace();
        }
    }

    public static void clearBuilders() {
        scannedGrids = new HashMap();
        pendingBuilders = new ArrayList();
    }

    static {
        designers.add(new MineDesignerGrid());
        designers.add(new MineDesignerFeather());
        designers.add(new MineDesignerComb());
        designers.add(new MineDesignerRandomized());
    }

    public static enum SegmentType {
        NORMAL,
        SHAFT,
        SHAFT_PLATFORM,
        STAIR_UP,
        STAIR_DOWN,
        STOPE;

    }
}

