/*
 * Decompiled with CFR 0.152.
 */
package enviromine.world.features.mineshaft;

import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.world.features.mineshaft.MineshaftBuilder;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import org.apache.logging.log4j.Level;

public abstract class MineSegment {
    int rot = 0;
    World world;
    int posX = 0;
    int posY = 0;
    int posZ = 0;
    int minX = 0;
    int minZ = 0;
    int minY = 0;
    int maxX = 0;
    int maxY = 0;
    int maxZ = 0;
    int chunkMinX = 0;
    int chunkMaxX = 0;
    int chunkMinZ = 0;
    int chunkMaxZ = 0;
    int decay = 0;
    MineshaftBuilder builder;

    public MineSegment(World world, int x, int y, int z, int rotation, MineshaftBuilder builder) {
        this.world = world;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.rot = rotation % 4;
        this.builder = builder;
    }

    public abstract boolean build();

    void setBlockBounds(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    void setChunkBounds(int minX, int minZ, int maxX, int maxZ) {
        this.chunkMinX = minX;
        this.chunkMinZ = minZ;
        this.chunkMaxX = maxX;
        this.chunkMaxZ = maxZ;
    }

    public void setDecay(int decay) {
        this.decay = decay;
    }

    public int[] getExitPoint(int rotation) {
        return new int[]{this.posX, this.posY, this.posZ};
    }

    public int[] getExitPoint(int rotation, int yDir) {
        int[] point = this.getExitPoint(rotation);
        return point;
    }

    public boolean canBuild() {
        if (this.posY + this.maxY > 255) {
            return false;
        }
        return this.posY - this.minY >= 0;
    }

    public ArrayList<String> getRequiredChunks() {
        int tmp;
        ArrayList<String> chunks = new ArrayList<String>();
        int xOffMin = this.xOffset(this.chunkMinX, this.chunkMinZ) / 16;
        int zOffMin = this.zOffset(this.chunkMinX, this.chunkMinX) / 16;
        int xOffMax = this.xOffset(this.chunkMaxX, this.chunkMaxZ) / 16;
        int zOffMax = this.zOffset(this.chunkMaxX, this.chunkMaxZ) / 16;
        if (xOffMin > xOffMax) {
            tmp = xOffMin;
            xOffMin = xOffMax;
            xOffMax = tmp;
        }
        if (zOffMin > zOffMax) {
            tmp = zOffMin;
            zOffMin = zOffMax;
            zOffMax = tmp;
        }
        for (int i = xOffMin; i <= xOffMax; ++i) {
            for (int k = zOffMin; k <= zOffMax; ++k) {
                chunks.add("" + i + "," + k);
            }
        }
        return chunks;
    }

    public void linkChunksToBuilder() {
        ArrayList<String> chunks = this.getRequiredChunks();
        if (chunks.size() <= 0 && EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) {
            EnviroMine.logger.log(Level.WARN, "ERROR: MineSegment is registering 0 chunks! It will not generate!");
        }
        for (int i = 0; i < chunks.size(); ++i) {
            ArrayList<Object> tempList;
            if (this.builder.segmentMap.containsKey(chunks.get(i))) {
                tempList = this.builder.segmentMap.get(chunks.get(i));
                tempList.add(this);
                this.builder.segmentMap.put(chunks.get(i), tempList);
                continue;
            }
            tempList = new ArrayList<MineSegment>();
            tempList.add(this);
            this.builder.segmentMap.put(chunks.get(i), tempList);
        }
    }

    public boolean allChunksLoaded() {
        int tmp;
        int xOffMin = this.xOffset(this.chunkMinX, this.chunkMinZ) / 16;
        int zOffMin = this.zOffset(this.chunkMinX, this.chunkMinX) / 16;
        int xOffMax = this.xOffset(this.chunkMaxX, this.chunkMaxZ) / 16;
        int zOffMax = this.zOffset(this.chunkMaxX, this.chunkMaxZ) / 16;
        if (xOffMin > xOffMax) {
            tmp = xOffMin;
            xOffMin = xOffMax;
            xOffMax = tmp;
        }
        if (zOffMin > zOffMax) {
            tmp = zOffMin;
            zOffMin = zOffMax;
            zOffMax = tmp;
        }
        for (int i = xOffMin; i <= xOffMax; ++i) {
            for (int k = zOffMin; k <= zOffMax; ++k) {
                if (this.world.func_72863_F().func_73149_a(i, k)) continue;
                return false;
            }
        }
        return true;
    }

    public void fillArea(int i1, int j1, int k1, int i2, int j2, int k2, Block block, int meta) {
        for (int i = i1; i <= i2; ++i) {
            for (int j = j1; j <= j2; ++j) {
                for (int k = k1; k <= k2; ++k) {
                    this.setBlock(i, j, k, block, meta);
                }
            }
        }
    }

    public void fillAndRotate(int i1, int j1, int k1, int i2, int j2, int k2, Block block, int meta) {
        this.fillArea(i1, j1, k1, i2, j2, k2, block, this.rotateMeta(meta));
    }

    public void setBlock(int x, int y, int z, Block block, int meta) {
        if (x > this.maxX || x < this.minX || y > this.maxY || y < this.minY || z > this.maxZ || z < this.minZ) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.WARN, this.getClass().getSimpleName() + " tried to place block out of bounds!");
            }
            return;
        }
        if (this.decay == 0 || this.builder.rand.nextInt(50) > this.decay) {
            this.world.func_147465_d(this.xOffset(x, z), this.yOffset(y), this.zOffset(x, z), block, meta, 2);
        } else if (block != Blocks.field_150350_a && block.func_149688_o() == Material.field_151575_d && this.builder.rand.nextBoolean()) {
            this.world.func_147465_d(this.xOffset(x, z), this.yOffset(y), this.zOffset(x, z), Blocks.field_150395_bd, 0, 2);
        } else {
            this.world.func_147468_f(this.xOffset(x, z), this.yOffset(y), this.zOffset(x, z));
        }
    }

    public void setBlockAndRotate(int x, int y, int z, Block block, int meta) {
        this.setBlock(x, y, z, block, this.rotateMeta(meta));
    }

    public Block getBlock(int x, int y, int z) {
        return this.world.func_147439_a(this.xOffset(x, z), this.yOffset(y), this.zOffset(x, z));
    }

    public int getBlockMeta(int x, int y, int z) {
        return this.world.func_72805_g(this.xOffset(x, z), this.yOffset(y), this.zOffset(x, z));
    }

    public void addLootChest(int x, int y, int z, int itemCount) {
        int i = this.xOffset(x, z);
        int j = this.yOffset(y);
        int k = this.zOffset(x, z);
        if (this.world.func_72938_d(i, k) == null || itemCount == 0) {
            return;
        }
        this.world.func_147449_b(i, j, k, (Block)Blocks.field_150486_ae);
        TileEntityChest chestTile = (TileEntityChest)this.world.func_147438_o(i, j, k);
        if (chestTile != null) {
            WeightedRandomChestContent.func_76293_a((Random)this.builder.rand, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"dungeonChest", (Random)this.builder.rand), (IInventory)chestTile, (int)ChestGenHooks.getCount((String)"dungeonChest", (Random)this.builder.rand));
        }
    }

    public int rotateMeta(int meta) {
        if (this.rot == 0) {
            return meta;
        }
        if (this.rot == 1) {
            if (meta == 2) {
                return 4;
            }
            if (meta == 3) {
                return 5;
            }
            if (meta == 4) {
                return 3;
            }
            if (meta == 5) {
                return 2;
            }
            return meta;
        }
        if (this.rot == 2) {
            if (meta == 2) {
                return 3;
            }
            if (meta == 3) {
                return 2;
            }
            if (meta == 4) {
                return 5;
            }
            if (meta == 5) {
                return 4;
            }
            return meta;
        }
        if (this.rot == 3) {
            if (meta == 2) {
                return 5;
            }
            if (meta == 3) {
                return 4;
            }
            if (meta == 4) {
                return 2;
            }
            if (meta == 5) {
                return 3;
            }
            return meta;
        }
        return meta;
    }

    public int xOffset(int x, int z) {
        return this.xOffset(this.posX, this.rot, x, z);
    }

    public int yOffset(int y) {
        return this.yOffset(this.posY, y);
    }

    public int zOffset(int x, int z) {
        return this.zOffset(this.posZ, this.rot, x, z);
    }

    public int xOffset(int pointX, int rotation, int x, int z) {
        switch (rotation) {
            case 0: {
                return x + pointX;
            }
            case 1: {
                return z + pointX;
            }
            case 2: {
                return -x + pointX + this.maxX;
            }
            case 3: {
                return -z + pointX + this.maxX;
            }
        }
        return x + pointX;
    }

    public int yOffset(int pointY, int y) {
        return y + pointY;
    }

    public int zOffset(int pointZ, int rotation, int x, int z) {
        switch (rotation) {
            case 0: {
                return z + pointZ;
            }
            case 1: {
                return -x + pointZ + this.maxZ;
            }
            case 2: {
                return -z + pointZ + this.maxZ;
            }
            case 3: {
                return x + pointZ;
            }
        }
        return z + pointZ;
    }
}

