/*
 * Decompiled with CFR 0.152.
 */
package enviromine.world;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.EM_PhysManager;
import enviromine.network.packet.PacketEnviroMine;
import enviromine.world.ClientQuake;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;

public class Earthquake {
    public static ArrayList<Earthquake> pendingQuakes = new ArrayList();
    public static ArrayList<ClientQuake> clientQuakes = new ArrayList();
    public static int lastTickDay = 0;
    public static int tickCount = 0;
    public World world;
    public int posX;
    public int posZ;
    public int length;
    public int width;
    public float angle;
    public int passY = 1;
    ArrayList<int[]> ravineMask = new ArrayList();

    public Earthquake(World world, int i, int k, int l, int w) {
        this.posX = i;
        this.posZ = k;
        this.length = l;
        this.width = w;
        if (world != null) {
            this.world = world;
            this.angle = MathHelper.func_76131_a((float)(world.field_73012_v.nextFloat() * 4.0f - 2.0f), (float)-2.0f, (float)2.0f);
            this.markRavine(this.angle);
            pendingQuakes.add(this);
            if (EnviroMine.proxy.isClient() && !(this instanceof ClientQuake)) {
                int size = this.length > this.width ? this.length / 2 : this.width / 2;
                NBTTagCompound pData = new NBTTagCompound();
                pData.func_74768_a("id", 3);
                pData.func_74768_a("dimension", world.field_73011_w.field_76574_g);
                pData.func_74768_a("posX", this.posX);
                pData.func_74768_a("posZ", this.posZ);
                pData.func_74768_a("length", this.length);
                pData.func_74768_a("width", this.width);
                pData.func_74776_a("angle", this.angle);
                pData.func_74776_a("action", 0.0f);
                pData.func_74776_a("height", 1.0f);
                EnviroMine.instance.network.sendToAllAround((IMessage)new PacketEnviroMine(pData), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)this.posX, (double)this.passY, (double)this.posZ, (double)(128 + size)));
            }
        }
    }

    public Earthquake(World world, int i, int k, int l, int w, float a, boolean save) {
        this.posX = i;
        this.posZ = k;
        this.length = l;
        this.width = w;
        if (world != null) {
            this.world = world;
            this.angle = MathHelper.func_76131_a((float)a, (float)-2.0f, (float)2.0f);
            this.markRavine(this.angle);
            if (save) {
                pendingQuakes.add(this);
                int size = this.length > this.width ? this.length / 2 : this.width / 2;
                NBTTagCompound pData = new NBTTagCompound();
                pData.func_74768_a("id", 3);
                pData.func_74768_a("dimension", world.field_73011_w.field_76574_g);
                pData.func_74768_a("posX", this.posX);
                pData.func_74768_a("posZ", this.posZ);
                pData.func_74768_a("length", this.length);
                pData.func_74768_a("width", this.width);
                pData.func_74776_a("angle", this.angle);
                pData.func_74776_a("action", 0.0f);
                pData.func_74776_a("height", 1.0f);
                EnviroMine.instance.network.sendToAllAround((IMessage)new PacketEnviroMine(pData), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)this.posX, (double)this.passY, (double)this.posZ, (double)(128 + size)));
            }
        }
    }

    public void markRavine(float angle) {
        this.ravineMask.clear();
        for (int i = -this.length / 2; i < this.length / 2; ++i) {
            int fx = MathHelper.func_76141_d((float)(Math.abs(angle) > 1.0f ? (float)i * (angle > 0.0f ? angle - 1.0f : angle + 1.0f) : (float)i));
            int fz = MathHelper.func_76141_d((float)(Math.abs(angle) > 1.0f ? (float)i : (float)i * angle));
            int widthFactor = MathHelper.func_76143_f((double)(Math.cos((double)i / ((double)this.length / 3.0)) * (double)this.width));
            if (Math.abs(angle) <= 1.0f) {
                for (int z = fz - widthFactor / 2; z < fz + widthFactor / 2; ++z) {
                    this.ravineMask.add(new int[]{fx + this.posX, 1, z + this.posZ});
                }
                continue;
            }
            for (int x = fx - widthFactor / 2; x < fx + widthFactor / 2; ++x) {
                this.ravineMask.add(new int[]{x + this.posX, 1, fz + this.posZ});
            }
        }
        this.reOrderFromCenter();
    }

    public void reOrderFromCenter() {
        block0: for (int i = 1; i < this.ravineMask.size(); ++i) {
            int[] iEntry = this.ravineMask.get(i);
            double iDist = this.trigDist(iEntry[0], iEntry[2]);
            for (int j = i - 1; j >= 0; --j) {
                int[] jEntry = this.ravineMask.get(j);
                double jDist = this.trigDist(jEntry[0], jEntry[2]);
                if (jDist > iDist) {
                    if (j != 0) continue;
                    this.ravineMask.remove(i);
                    this.ravineMask.add(j, iEntry);
                    continue;
                }
                if (j + 1 == i) continue block0;
                this.ravineMask.remove(i);
                this.ravineMask.add(j + 1, iEntry);
                continue block0;
            }
        }
    }

    public double trigDist(double a, double b) {
        return MathHelper.func_76133_a((double)(Math.pow(a - (double)this.posX, 2.0) + Math.pow(b - (double)this.posZ, 2.0)));
    }

    public boolean removeBlock() {
        while (this.passY < 256) {
            for (int i = 0; i < this.ravineMask.size(); ++i) {
                int[] pos = this.ravineMask.get(i);
                int x = pos[0];
                int y = pos[1];
                int z = pos[2];
                boolean removed = false;
                if (y > this.passY) continue;
                for (int yy = y; yy >= 1; --yy) {
                    if ((this.world.func_147439_a(x, yy, z).func_149688_o() != Material.field_151587_i || yy <= 10) && this.world.func_147439_a(x, yy, z).func_149688_o() != Material.field_151586_h && this.world.func_147439_a(x, yy, z).func_149688_o() != Material.field_151576_e && this.world.func_147439_a(x, yy, z).func_149688_o() != Material.field_151571_B && this.world.func_147439_a(x, yy, z).func_149688_o() != Material.field_151595_p && this.world.func_147439_a(x, yy, z).func_149688_o() != Material.field_151578_c && this.world.func_147439_a(x, yy, z).func_149688_o() != Material.field_151577_b && (yy > 10 || this.world.func_147439_a(x, yy, z).func_149688_o() != Material.field_151579_a) || this.world.func_147439_a(x, yy, z).func_149712_f(this.world, x, yy, z) < 0.0f) continue;
                    if (yy <= 10) {
                        if (this.world.func_147439_a(x, yy, z).func_149688_o() == Material.field_151576_e || this.world.func_147439_a(x, yy, z).func_149688_o() == Material.field_151578_c) {
                            // empty if block
                        }
                        this.world.func_147449_b(x, yy, z, (Block)Blocks.field_150356_k);
                        if (yy != y) continue;
                        if (EM_Settings.enablePhysics && EM_Settings.quakePhysics) {
                            EM_PhysManager.schedulePhysUpdate(this.world, x, yy, z, false, "Quake");
                        }
                        this.ravineMask.set(i, new int[]{x, y + 8, z});
                        removed = true;
                        continue;
                    }
                    if (this.world.func_147439_a(x, yy, z).func_149688_o() == Material.field_151576_e || this.world.func_147439_a(x, yy, z).func_149688_o() == Material.field_151578_c) {
                        // empty if block
                    }
                    this.world.func_147468_f(x, yy, z);
                    if (yy != y) continue;
                    if (EM_Settings.enablePhysics && EM_Settings.quakePhysics) {
                        EM_PhysManager.schedulePhysUpdate(this.world, x, yy, z, false, "Quake");
                    }
                    this.ravineMask.set(i, new int[]{x, y + 8, z});
                    removed = true;
                }
                if (removed) {
                    return true;
                }
                Chunk chunk = this.world.func_72938_d(x, z);
                if (chunk != null && chunk.func_76614_a(EnumSkyBlock.Sky, x & 0xF, y, z & 0xF) >= 15 || this.world.func_72825_h(x, z) < 16 || this.world.func_72937_j(x, y, z)) {
                    this.ravineMask.remove(i);
                    continue;
                }
                this.ravineMask.set(i, new int[]{x, y + 8, z});
            }
            this.passY += 8;
            int size = this.length > this.width ? this.length / 2 : this.width / 2;
            NBTTagCompound pData = new NBTTagCompound();
            pData.func_74768_a("id", 3);
            pData.func_74768_a("dimension", this.world.field_73011_w.field_76574_g);
            pData.func_74768_a("posX", this.posX);
            pData.func_74768_a("posZ", this.posZ);
            pData.func_74768_a("length", this.length);
            pData.func_74768_a("width", this.width);
            pData.func_74776_a("angle", this.angle);
            pData.func_74776_a("action", 1.0f);
            pData.func_74776_a("height", (float)this.passY);
            EnviroMine.instance.network.sendToAllAround((IMessage)new PacketEnviroMine(pData), new NetworkRegistry.TargetPoint(this.world.field_73011_w.field_76574_g, (double)this.posX, (double)this.passY, (double)this.posZ, (double)(128 + size)));
        }
        return false;
    }

    public void removeAll() {
        for (int y = 1; y < this.world.func_72940_L(); ++y) {
            for (int i = 0; i < this.ravineMask.size(); ++i) {
                int z;
                int[] pos = this.ravineMask.get(i);
                int x = pos[0];
                if ((this.world.func_147439_a(x, y, z = pos[2]).func_149688_o() != Material.field_151587_i || y <= 10) && this.world.func_147439_a(x, y, z).func_149688_o() != Material.field_151586_h && this.world.func_147439_a(x, y, z).func_149688_o() != Material.field_151576_e && this.world.func_147439_a(x, y, z).func_149688_o() != Material.field_151571_B && this.world.func_147439_a(x, y, z).func_149688_o() != Material.field_151595_p && this.world.func_147439_a(x, y, z).func_149688_o() != Material.field_151578_c && this.world.func_147439_a(x, y, z).func_149688_o() != Material.field_151577_b && (y > 10 || this.world.func_147439_a(x, y, z).func_149688_o() != Material.field_151579_a) || this.world.func_147439_a(x, y, z).func_149712_f(this.world, x, y, z) < 0.0f) continue;
                if (y <= 10) {
                    this.world.func_147449_b(x, y, z, (Block)Blocks.field_150356_k);
                    continue;
                }
                this.world.func_147468_f(x, y, z);
            }
        }
        this.ravineMask.clear();
    }

    public static void updateEarthquakes() {
        if (!EM_Settings.enableQuakes) {
            pendingQuakes.clear();
            return;
        }
        if (tickCount < 2 * pendingQuakes.size()) {
            ++tickCount;
            return;
        }
        tickCount = 0;
        for (int i = pendingQuakes.size() - 1; i >= 0; --i) {
            Earthquake quake = pendingQuakes.get(i);
            if (quake.world.field_72995_K) {
                pendingQuakes.remove(i);
                continue;
            }
            if (quake.removeBlock() && quake.ravineMask.size() > 0) continue;
            int size = quake.length > quake.width ? quake.length / 2 : quake.width / 2;
            NBTTagCompound pData = new NBTTagCompound();
            pData.func_74768_a("id", 3);
            pData.func_74768_a("dimension", quake.world.field_73011_w.field_76574_g);
            pData.func_74768_a("posX", quake.posX);
            pData.func_74768_a("posZ", quake.posZ);
            pData.func_74768_a("length", quake.length);
            pData.func_74768_a("width", quake.width);
            pData.func_74776_a("angle", quake.angle);
            pData.func_74776_a("action", 2.0f);
            pData.func_74776_a("height", (float)quake.passY);
            EnviroMine.instance.network.sendToAllAround((IMessage)new PacketEnviroMine(pData), new NetworkRegistry.TargetPoint(quake.world.field_73011_w.field_76574_g, (double)quake.posX, (double)quake.passY, (double)quake.posZ, (double)(128 + size)));
            pendingQuakes.remove(i);
        }
    }

    public static void TickDay(World world) {
        if (world.field_73012_v.nextInt(2) == 0 && world.field_73010_i.size() > 0) {
            Entity player = (Entity)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size()));
            int posX = MathHelper.func_76128_c((double)player.field_70165_t) + (world.field_73012_v.nextInt(1024) - 512);
            int posZ = MathHelper.func_76128_c((double)player.field_70161_v) + (world.field_73012_v.nextInt(1024) - 512);
            if (world.func_72863_F().func_73149_a(posX >> 4, posZ >> 4)) {
                new Earthquake(world, posX, posZ, 32 + world.field_73012_v.nextInt(96), 4 + world.field_73012_v.nextInt(28));
                if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.ALL.getLevel()) {
                    EnviroMine.logger.log(Level.INFO, "Earthquake at (" + posX + "," + posZ + ")");
                }
            }
        }
    }

    public static void saveQuakes(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            ArrayList<float[]> savedQuakes = new ArrayList<float[]>();
            for (int i = 0; i < pendingQuakes.size(); ++i) {
                Earthquake quake = pendingQuakes.get(i);
                float[] entry = new float[7];
                entry[0] = quake.world.field_73011_w.field_76574_g;
                entry[1] = quake.posX;
                entry[2] = quake.posZ;
                entry[3] = quake.length;
                entry[4] = quake.width;
                entry[5] = quake.angle;
                savedQuakes.add(entry);
            }
            oos.writeObject(savedQuakes);
            oos.close();
            bos.close();
            fos.close();
        }
        catch (Exception e) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Failed to save Earthquakes", (Throwable)e);
            }
            e.printStackTrace();
        }
    }

    public static void loadQuakes(File file) {
        if (!file.exists()) {
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ObjectInputStream ois = new ObjectInputStream(bis);
            ArrayList loadedQuakes = (ArrayList)ois.readObject();
            for (int i = 0; i < loadedQuakes.size(); ++i) {
                float[] qData = (float[])loadedQuakes.get(i);
                int d = (int)qData[0];
                WorldServer world = MinecraftServer.func_71276_C().func_71218_a(d);
                int x = (int)qData[1];
                int y = (int)qData[2];
                int l = (int)qData[3];
                int w = (int)qData[4];
                float a = qData[5];
                new Earthquake((World)world, x, y, l, w, a, true);
            }
            ois.close();
            bis.close();
            fis.close();
        }
        catch (Exception e) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Failed to load Earthquakes", (Throwable)e);
            }
            e.printStackTrace();
        }
    }

    public static void Reset() {
        pendingQuakes.clear();
        if (EnviroMine.proxy.isClient()) {
            clientQuakes.clear();
        }
        lastTickDay = 0;
    }
}

