/*
 * Decompiled with CFR 0.152.
 */
package enviromine.utils;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.EntityRegistry;
import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import java.io.File;
import java.net.URLDecoder;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;

public class ModIdentification {
    public static HashMap<String, String> modID_Name = new HashMap();
    public static HashMap<File, String> modSource_ID = new HashMap();

    public static String nameFromObject(Object obj) {
        String modID = ModIdentification.idFromObject(obj);
        if (modID.equals("minecraft")) {
            return "Minecraft";
        }
        if (modID_Name.containsKey(modID)) {
            return modID_Name.get(modID);
        }
        return "Unknown";
    }

    public static String idFromObject(Object obj) {
        Class<?> clazz;
        String modName;
        block16: {
            if (obj instanceof ItemStack) {
                String tmpID = Item.field_150901_e.func_148750_c((Object)((ItemStack)obj).func_77973_b());
                return tmpID.isEmpty() ? "unknown" : tmpID;
            }
            if (obj instanceof Item) {
                String tmpID = Item.field_150901_e.func_148750_c(obj);
                String[] split = tmpID.split(":");
                return tmpID.isEmpty() ? "unknown" : split[0];
            }
            if (obj instanceof Block) {
                String tmpID = Block.field_149771_c.func_148750_c(obj);
                String[] split = tmpID.split(":");
                return tmpID.isEmpty() ? "unknown" : split[0];
            }
            if (obj instanceof Entity || obj instanceof Class && Entity.class.isAssignableFrom((Class)obj)) {
                Class clazz2 = obj instanceof Entity ? obj.getClass() : (Class)obj;
                EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(clazz2, true);
                if (er == null) {
                    return "minecraft";
                }
                ModContainer mc = er.getContainer();
                if (mc != null) {
                    return mc.getModId();
                }
            }
            modName = "unknown";
            String fullPath = "";
            clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
            try {
                if (clazz == null) {
                    if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                        EnviroMine.logger.log(Level.ERROR, "ModID lookup failed for: NULL");
                    }
                    return "unknown";
                }
                fullPath = clazz.getResource("").toString();
                int tmpIndex = fullPath.indexOf("file:/");
                fullPath = URLDecoder.decode(fullPath.substring(tmpIndex + "file:/".length()), "UTF-8");
                File file = new File(fullPath);
                for (File s : modSource_ID.keySet()) {
                    if (!file.equals(s) && !file.getAbsolutePath().startsWith(s.getAbsolutePath())) continue;
                    modName = modSource_ID.get(s);
                    break;
                }
            }
            catch (Exception e) {
                if ((obj instanceof Class ? ((Class)obj).getName() : obj.getClass().getName()).toLowerCase().contains("net.minecraft")) {
                    return "minecraft";
                }
                if (EM_Settings.loggerVerbosity < EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) break block16;
                EnviroMine.logger.log(Level.INFO, "ModID lookup failed for: " + (obj instanceof Class ? ((Class)obj).getName() : obj.getClass().getName()) + " {" + fullPath + "}");
            }
        }
        if (modName.equals("unknown")) {
            modName = ModIdentification.OldIdentificationMethod(clazz);
        }
        if (modName.equals("Forge") || modName.equals("FML") || modName.equals("mcp")) {
            modName = "minecraft";
        } else if (modName.equals("unknown") && EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
            EnviroMine.logger.log(Level.WARN, "Unable to find matching ModID for " + clazz.getSimpleName());
        }
        return modName;
    }

    private static String OldIdentificationMethod(Class<?> obj) {
        String modName = "unknown";
        String objPath = "";
        try {
            objPath = obj.getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (Exception e) {
            return modName;
        }
        try {
            objPath = URLDecoder.decode(objPath, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (File f : modSource_ID.keySet()) {
            if (!objPath.contains(f.getName())) continue;
            modName = modSource_ID.get(f);
            break;
        }
        return modName;
    }

    static {
        for (ModContainer mod : Loader.instance().getModList()) {
            modID_Name.put(mod.getModId(), mod.getName());
            modSource_ID.put(mod.getSource(), mod.getModId());
            if (EM_Settings.loggerVerbosity < EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) continue;
            EnviroMine.logger.log(Level.INFO, "Mapped mod: {" + mod.getSource().getAbsolutePath() + "," + mod.getName() + "," + mod.getModId() + "}");
        }
    }
}

