/*
 * Decompiled with CFR 0.152.
 */
package enviromine.utils;

import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.ObjectHandler;
import enviromine.trackers.properties.StabilityType;
import java.awt.Color;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockGlowstone;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockObsidian;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;
import thaumcraft.common.blocks.BlockMagicalLeaves;

public class EnviroUtils {
    public static final String[] reservedNames = new String[]{"CON", "COM", "PRN", "AUX", "CLOCK$", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    public static final char[] specialCharacters = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};
    private static final String IEEP_PLAYER_WITCHERY = "WitcheryExtendedPlayer";
    private static final String IEEP_PLAYER_WITCHERY_CREATURE_TYPE = "CreatureType";
    private static final String IEEP_PLAYER_WITCHERY_VAMPIRE_LEVEL = "VampireLevel";
    private static final String IEEP_PLAYER_WITCHERY_WEREWOLF_LEVEL = "WerewolfLevel";
    private static final String IEEP_PLAYER_WITCHERY_DEMON_LEVEL = "DemonLevel";
    private static final String IEEP_PLAYER_MO_ANDROID = "AndroidPlayer";
    private static final String IEEP_PLAYER_MO_ISANDROID = "isAndroid";

    public static int[] getAdjacentBlockCoordsFromSide(int x, int y, int z, int side) {
        int[] coords = new int[]{x, y, z};
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        switch (dir) {
            case NORTH: {
                coords[2] = coords[2] - 1;
                break;
            }
            case SOUTH: {
                coords[2] = coords[2] + 1;
                break;
            }
            case WEST: {
                coords[0] = coords[0] - 1;
                break;
            }
            case EAST: {
                coords[0] = coords[0] + 1;
                break;
            }
            case UP: {
                coords[1] = coords[1] + 1;
                break;
            }
            case DOWN: {
                coords[1] = coords[1] - 1;
                break;
            }
        }
        return coords;
    }

    public static String replaceULN(String unlocalizedName) {
        unlocalizedName = unlocalizedName.replaceAll("[\\(\\)]", "");
        unlocalizedName = unlocalizedName.replaceAll("\\.+", "\\_");
        return unlocalizedName;
    }

    public static float convertToFarenheit(float num) {
        return EnviroUtils.convertToFarenheit(num, 2);
    }

    public static float convertToFarenheit(float num, int decimalPlace) {
        float newNum = (float)((double)num * 1.8 + 32.0);
        BigDecimal convert = new BigDecimal(Float.toString(newNum));
        convert.setScale(decimalPlace, 4);
        return convert.floatValue();
    }

    public static float convertToCelcius(float num) {
        return (num - 32.0f) * 0.5555556f;
    }

    public static float getBiomeTemp(BiomeGenBase biome) {
        return EnviroUtils.getBiomeTemp(biome.field_76750_F);
    }

    public static float getBiomeTemp(int x, int y, int z, BiomeGenBase biome) {
        return EnviroUtils.getBiomeTemp(biome.func_150564_a(x, y, z));
    }

    private static float getBiomeTemp(float biomeTemp) {
        float maxTemp = 45.0f;
        float minTemp = -15.0f;
        return (float)(biomeTemp >= 0.0f ? Math.sin(Math.toRadians(biomeTemp * 45.0f)) * (double)maxTemp : Math.sin(Math.toRadians(biomeTemp * 45.0f)) * (double)minTemp);
    }

    public static String getBiomeWater(BiomeGenBase biome) {
        Color bColor;
        int waterColour = biome.getWaterColorMultiplier();
        boolean looksBad = false;
        if (waterColour != 0xFFFFFF && ((bColor = new Color(waterColour)).getRed() < 200 || bColor.getGreen() < 200 || bColor.getBlue() < 200)) {
            looksBad = true;
        }
        ArrayList typeList = new ArrayList();
        BiomeDictionary.Type[] typeArray = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        Collections.addAll(typeList, typeArray);
        if (typeList.contains(BiomeDictionary.Type.OCEAN) || typeList.contains(BiomeDictionary.Type.BEACH)) {
            return typeList.contains(BiomeDictionary.Type.COLD) ? "SALTY_COLD" : (typeList.contains(BiomeDictionary.Type.HOT) ? "SALTY_WARM" : "SALTY");
        }
        if (typeList.contains(BiomeDictionary.Type.RIVER)) {
            return typeList.contains(BiomeDictionary.Type.COLD) ? "CLEAN_COLD" : (typeList.contains(BiomeDictionary.Type.HOT) ? "CLEAN_WARM" : "CLEAN");
        }
        if (typeList.contains(BiomeDictionary.Type.HOT)) {
            return typeList.contains(BiomeDictionary.Type.DRY) ? "HOT" : (looksBad ? "DIRTY_WARM" : "CLEAN_WARM");
        }
        if (typeList.contains(BiomeDictionary.Type.COLD)) {
            return typeList.contains(BiomeDictionary.Type.SNOWY) || biome.field_76750_F <= 0.0f ? "FROSTY" : ((typeList.contains(BiomeDictionary.Type.WASTELAND) || looksBad) && biome.field_76750_F > 0.0f ? "DIRTY_COLD" : "CLEAN_COLD");
        }
        if (typeList.contains(BiomeDictionary.Type.SWAMP) || typeList.contains(BiomeDictionary.Type.WASTELAND) || typeList.contains(BiomeDictionary.Type.DEAD)) {
            return "DIRTY";
        }
        return "CLEAN";
    }

    public static StabilityType getDefaultStabilityType(Block block) {
        StabilityType type = null;
        Material material = block.func_149688_o();
        type = block instanceof BlockMobSpawner || block instanceof BlockLadder || block instanceof BlockWeb || block instanceof BlockSign || block instanceof BlockBed || block instanceof BlockDoor || block instanceof BlockAnvil || block instanceof BlockGravel || block instanceof BlockPortal || block instanceof BlockEndPortal || block instanceof BlockEndPortalFrame || block == Blocks.field_150349_c || block == ObjectHandler.elevator || block == Blocks.field_150377_bs || block.func_149688_o() == Material.field_151582_l || !block.func_149688_o().func_76230_c() ? EM_Settings.stabilityTypes.get("none") : (block instanceof BlockGlowstone ? EM_Settings.stabilityTypes.get("glowstone") : (EnviroMine.isTCLoaded && block instanceof BlockMagicalLeaves ? EM_Settings.stabilityTypes.get("average") : (block instanceof BlockFalling ? EM_Settings.stabilityTypes.get("sand-like") : (material == Material.field_151573_f || material == Material.field_151575_d || block instanceof BlockObsidian || block == Blocks.field_150417_aV || block == Blocks.field_150336_V || block == Blocks.field_150371_ca ? EM_Settings.stabilityTypes.get("strong") : (material == Material.field_151576_e || material == Material.field_151592_s || material == Material.field_151588_w || block instanceof BlockLeavesBase ? EM_Settings.stabilityTypes.get("average") : EM_Settings.stabilityTypes.get(EM_Settings.defaultStability))))));
        if (type == null && EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) {
            EnviroMine.logger.log(Level.ERROR, "Block " + block.func_149739_a() + " has a null StabilityType. Crash imminent!");
        }
        return type;
    }

    public static void extendPotionList() {
        int maxID = 32;
        if (EM_Settings.heatstrokePotionID >= maxID) {
            maxID = EM_Settings.heatstrokePotionID + 1;
        }
        if (EM_Settings.hypothermiaPotionID >= maxID) {
            maxID = EM_Settings.hypothermiaPotionID + 1;
        }
        if (EM_Settings.frostBitePotionID >= maxID) {
            maxID = EM_Settings.frostBitePotionID + 1;
        }
        if (EM_Settings.dehydratePotionID >= maxID) {
            maxID = EM_Settings.dehydratePotionID + 1;
        }
        if (EM_Settings.insanityPotionID >= maxID) {
            maxID = EM_Settings.insanityPotionID + 1;
        }
        if (Potion.field_76425_a.length >= maxID) {
            return;
        }
        Potion[] potionTypes = null;
        for (Field f : Potion.class.getDeclaredFields()) {
            f.setAccessible(true);
            try {
                if (!f.getName().equals("potionTypes") && !f.getName().equals("field_76425_a")) continue;
                Field modfield = Field.class.getDeclaredField("modifiers");
                modfield.setAccessible(true);
                modfield.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                potionTypes = (Potion[])f.get(null);
                Potion[] newPotionTypes = new Potion[maxID];
                System.arraycopy(potionTypes, 0, newPotionTypes, 0, potionTypes.length);
                f.set(null, newPotionTypes);
            }
            catch (Exception e) {
                if (EM_Settings.loggerVerbosity < EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) continue;
                EnviroMine.logger.log(Level.ERROR, "Failed to extend potion list for EnviroMine!", (Throwable)e);
            }
        }
    }

    public static String SafeFilename(String filename) {
        String safeName = filename;
        for (String reserved : reservedNames) {
            if (!safeName.equalsIgnoreCase(reserved)) continue;
            safeName = "_" + safeName + "_";
        }
        for (char badChar : specialCharacters) {
            safeName = safeName.replace(badChar, '_');
        }
        return safeName;
    }

    public static NBTTagCompound getIEEPTag(Entity entity, String identifier) {
        IExtendedEntityProperties ieep = entity.getExtendedProperties(identifier);
        if (ieep != null) {
            NBTTagCompound ieepnbt = new NBTTagCompound();
            ieep.saveNBTData(ieepnbt);
            if (ieepnbt.func_74764_b(identifier)) {
                return ieepnbt.func_74775_l(identifier);
            }
        }
        return null;
    }

    public static int getWitcheryCreatureType(Entity entity) {
        NBTTagCompound ieep_witchery = EnviroUtils.getIEEPTag(entity, IEEP_PLAYER_WITCHERY);
        return ieep_witchery != null && ieep_witchery.func_74764_b(IEEP_PLAYER_WITCHERY_CREATURE_TYPE) ? ieep_witchery.func_74762_e(IEEP_PLAYER_WITCHERY_CREATURE_TYPE) : -1;
    }

    public static boolean isPlayerCurrentlyWitcheryWolf(EntityPlayer player) {
        return EnviroUtils.getWitcheryCreatureType((Entity)player) == 1;
    }

    public static boolean isPlayerCurrentlyWitcheryWerewolf(EntityPlayer player) {
        return EnviroUtils.getWitcheryCreatureType((Entity)player) == 2;
    }

    public static boolean isPlayerCurrentlyWitcheryBat(EntityPlayer player) {
        return EnviroUtils.getWitcheryCreatureType((Entity)player) == 3;
    }

    public static int getWitcheryDemonLevel(Entity entity) {
        NBTTagCompound ieep_witchery = EnviroUtils.getIEEPTag(entity, IEEP_PLAYER_WITCHERY);
        return ieep_witchery != null && ieep_witchery.func_74764_b(IEEP_PLAYER_WITCHERY_DEMON_LEVEL) ? ieep_witchery.func_74762_e(IEEP_PLAYER_WITCHERY_DEMON_LEVEL) : 0;
    }

    public static boolean isPlayerADemon(EntityPlayer player) {
        return EnviroUtils.getWitcheryDemonLevel((Entity)player) > 0;
    }

    public static int getWitcheryVampireLevel(Entity entity) {
        NBTTagCompound ieep_witchery = EnviroUtils.getIEEPTag(entity, IEEP_PLAYER_WITCHERY);
        return ieep_witchery != null && ieep_witchery.func_74764_b(IEEP_PLAYER_WITCHERY_VAMPIRE_LEVEL) ? ieep_witchery.func_74762_e(IEEP_PLAYER_WITCHERY_VAMPIRE_LEVEL) : 0;
    }

    public static boolean isPlayerAVampire(EntityPlayer player) {
        return EnviroUtils.getWitcheryVampireLevel((Entity)player) > 0;
    }

    public static int getWitcheryWerewolfLevel(Entity entity) {
        NBTTagCompound ieep_witchery = EnviroUtils.getIEEPTag(entity, IEEP_PLAYER_WITCHERY);
        return ieep_witchery != null && ieep_witchery.func_74764_b(IEEP_PLAYER_WITCHERY_WEREWOLF_LEVEL) ? ieep_witchery.func_74762_e(IEEP_PLAYER_WITCHERY_WEREWOLF_LEVEL) : 0;
    }

    public static boolean isPlayerAWerewolf(EntityPlayer player) {
        return EnviroUtils.getWitcheryWerewolfLevel((Entity)player) > 0;
    }

    public static boolean isPlayerCurrentlyMOAndroid(EntityPlayer player) {
        NBTTagCompound ieep_witchery = EnviroUtils.getIEEPTag((Entity)player, IEEP_PLAYER_MO_ANDROID);
        return ieep_witchery != null && ieep_witchery.func_74764_b(IEEP_PLAYER_MO_ISANDROID) ? ieep_witchery.func_74767_n(IEEP_PLAYER_MO_ISANDROID) : false;
    }
}

