/*
 * Decompiled with CFR 0.152.
 */
package enviromine.trackers.properties;

import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.trackers.properties.helpers.PropertyBase;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class StabilityType
implements PropertyBase {
    public static final StabilityType base = new StabilityType();
    static String[] SPName = new String[6];
    public String name;
    public boolean enablePhysics;
    public int supportDist;
    public int minFall;
    public int maxFall;
    public boolean canHang;
    public boolean holdOther;

    public StabilityType() {
        if (base != null && base != this) {
            throw new IllegalStateException();
        }
    }

    public StabilityType(String name, boolean enablePhysics, int supportDist, int minFall, int maxFall, boolean canHang, boolean holdOther) {
        this.name = name;
        this.enablePhysics = enablePhysics;
        this.supportDist = supportDist;
        this.minFall = minFall;
        this.maxFall = maxFall;
        this.canHang = canHang;
        this.holdOther = holdOther;
    }

    @Override
    public String categoryName() {
        return "stability";
    }

    @Override
    public String categoryDescription() {
        return "Custom stability types for block physics";
    }

    @Override
    public void LoadProperty(Configuration config, String category) {
        config.setCategoryComment(this.categoryName(), this.categoryDescription());
        boolean physEnable = config.get(category, SPName[0], true).getBoolean(true);
        int supportDist = config.get(category, SPName[1], 0).getInt(0);
        int minFall = config.get(category, SPName[2], -1).getInt(-1);
        int maxFall = config.get(category, SPName[3], -1).getInt(-1);
        boolean canHang = config.get(category, SPName[4], false).getBoolean(false);
        boolean holdOther = config.get(category, SPName[5], false).getBoolean(false);
        String name = category.replaceFirst(this.categoryName() + ".", "");
        EM_Settings.stabilityTypes.put(name, new StabilityType(name, physEnable, supportDist, minFall, maxFall, canHang, holdOther));
    }

    @Override
    public void SaveProperty(Configuration config, String category) {
        config.get(category, SPName[0], this.enablePhysics).getBoolean(this.enablePhysics);
        config.get(category, SPName[1], this.supportDist).getInt(this.supportDist);
        config.get(category, SPName[2], this.minFall).getInt(this.minFall);
        config.get(category, SPName[3], this.maxFall).getInt(this.maxFall);
        config.get(category, SPName[4], this.canHang).getBoolean(this.canHang);
        config.get(category, SPName[5], this.holdOther).getBoolean(this.holdOther);
    }

    @Override
    public void GenDefaults() {
        File file = this.GetDefaultFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) {
                    EnviroMine.logger.log(Level.ERROR, "Failed to create file for StabilityTypes", (Throwable)e);
                }
                return;
            }
        }
        Configuration config = new Configuration(file, true);
        config.load();
        String catName = this.categoryName() + ".sand-like";
        config.get(catName, SPName[0], true).getBoolean(true);
        config.get(catName, SPName[1], 0).getInt(0);
        config.get(catName, SPName[2], -1).getInt(-1);
        config.get(catName, SPName[3], -1).getInt(-1);
        config.get(catName, SPName[4], false).getBoolean(false);
        config.get(catName, SPName[5], false).getBoolean(false);
        catName = this.categoryName() + ".loose";
        config.get(catName, SPName[0], true).getBoolean(true);
        config.get(catName, SPName[1], 1).getInt(1);
        config.get(catName, SPName[2], 10).getInt(10);
        config.get(catName, SPName[3], 15).getInt(15);
        config.get(catName, SPName[4], false).getBoolean(false);
        config.get(catName, SPName[5], false).getBoolean(false);
        catName = this.categoryName() + ".average";
        config.get(catName, SPName[0], true).getBoolean(true);
        config.get(catName, SPName[1], 2).getInt(2);
        config.get(catName, SPName[2], 15).getInt(15);
        config.get(catName, SPName[3], 22).getInt(22);
        config.get(catName, SPName[4], true).getBoolean(true);
        config.get(catName, SPName[5], false).getBoolean(false);
        catName = this.categoryName() + ".strong";
        config.get(catName, SPName[0], true).getBoolean(true);
        config.get(catName, SPName[1], 3).getInt(3);
        config.get(catName, SPName[2], 22).getInt(22);
        config.get(catName, SPName[3], 25).getInt(25);
        config.get(catName, SPName[4], true).getBoolean(true);
        config.get(catName, SPName[5], false).getBoolean(false);
        catName = this.categoryName() + ".none";
        config.get(catName, SPName[0], false).getBoolean(false);
        config.get(catName, SPName[1], 3).getInt(3);
        config.get(catName, SPName[2], 0).getInt(0);
        config.get(catName, SPName[3], 0).getInt(0);
        config.get(catName, SPName[4], true).getBoolean(true);
        config.get(catName, SPName[5], false).getBoolean(false);
        catName = this.categoryName() + ".glowstone";
        config.get(catName, SPName[0], false).getBoolean(false);
        config.get(catName, SPName[1], 3).getInt(3);
        config.get(catName, SPName[2], 0).getInt(0);
        config.get(catName, SPName[3], 0).getInt(0);
        config.get(catName, SPName[4], true).getBoolean(true);
        config.get(catName, SPName[5], true).getBoolean(true);
        config.save();
    }

    @Override
    public File GetDefaultFile() {
        return new File(EM_ConfigHandler.loadedProfile + "StabilityTypes.cfg");
    }

    @Override
    public void generateEmpty(Configuration config, Object obj) {
        if (obj == null || !(obj instanceof String)) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.ALL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Tried to register config with non string object!", (Throwable)new Exception());
            }
            return;
        }
        String catName = this.categoryName() + "." + (String)obj;
        config.get(catName, SPName[0], true).getBoolean(true);
        config.get(catName, SPName[1], 1).getInt(1);
        config.get(catName, SPName[2], 10).getInt(10);
        config.get(catName, SPName[3], 15).getInt(15);
        config.get(catName, SPName[4], false).getBoolean(false);
        config.get(catName, SPName[5], false).getBoolean(false);
    }

    @Override
    public boolean useCustomConfigs() {
        return false;
    }

    @Override
    public void customLoad() {
        Configuration config;
        File file = this.GetDefaultFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) {
                    EnviroMine.logger.log(Level.ERROR, "Failed to create file for StabilityTypes", (Throwable)e);
                }
                return;
            }
        }
        try {
            config = new Configuration(file, true);
        }
        catch (Exception e) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Failed to load stability types!", (Throwable)e);
            }
            return;
        }
        config.load();
        ArrayList<String> catagory = EM_ConfigHandler.getSubCategories(config, this.categoryName());
        Iterator<String> iterator = catagory.iterator();
        while (iterator.hasNext()) {
            this.LoadProperty(config, iterator.next());
        }
        config.save();
    }

    static {
        StabilityType.SPName[0] = "01.Enable Physics";
        StabilityType.SPName[1] = "02.Max Support Distance";
        StabilityType.SPName[2] = "03.Min Missing Blocks To Fall";
        StabilityType.SPName[3] = "04.Max Missing Blocks To Fall";
        StabilityType.SPName[4] = "05.Can Hang";
        StabilityType.SPName[5] = "06.Holds Others Up";
    }
}

