/*
 * Decompiled with CFR 0.152.
 */
package enviromine.trackers.properties;

import cpw.mods.fml.common.registry.EntityRegistry;
import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.trackers.properties.helpers.PropertyBase;
import enviromine.trackers.properties.helpers.SerialisableProperty;
import enviromine.utils.EnviroUtils;
import enviromine.utils.ModIdentification;
import java.io.File;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class EntityProperties
implements SerialisableProperty,
PropertyBase {
    public static final EntityProperties base = new EntityProperties();
    static String[] EPName = new String[15];
    public int id;
    public boolean shouldTrack;
    public boolean dehydration;
    public boolean bodyTemp;
    public boolean airQ;
    public boolean immuneToFrost;
    public boolean immuneToHeat;
    public float ambSanity;
    public float hitSanity;
    public float ambTemp;
    public float hitTemp;
    public float ambAir;
    public float hitAir;
    public float ambHydration;
    public float hitHydration;
    public String loadedFrom;

    public EntityProperties(NBTTagCompound tags) {
        this.ReadFromNBT(tags);
    }

    public EntityProperties() {
        if (base != null && base != this) {
            throw new IllegalStateException();
        }
    }

    public boolean hasProperty(Entity entity) {
        return EM_Settings.livingProperties.containsKey(this.getID(entity));
    }

    public EntityProperties getProperty(Entity entity) {
        return EM_Settings.livingProperties.get(this.getID(entity));
    }

    private int getID(Entity entity) {
        int entityid = 0;
        if (EntityList.func_75619_a((Entity)entity) > 0) {
            entityid = EntityList.func_75619_a((Entity)entity);
        } else if (EntityRegistry.instance().lookupModSpawn(entity.getClass(), false) != null) {
            entityid = EntityRegistry.instance().lookupModSpawn(entity.getClass(), false).getModEntityId() + 128;
        }
        return entityid;
    }

    public EntityProperties(int id, boolean track, boolean dehydration, boolean bodyTemp, boolean airQ, boolean immuneToFrost, boolean immuneToHeat, float aSanity, float hSanity, float aTemp, float hTemp, float aAir, float hAir, float aHyd, float hHyd, String fileName) {
        this.id = id;
        this.shouldTrack = track;
        this.dehydration = dehydration;
        this.bodyTemp = bodyTemp;
        this.airQ = airQ;
        this.immuneToFrost = immuneToFrost;
        this.immuneToHeat = immuneToHeat;
        this.ambSanity = aSanity;
        this.hitSanity = hSanity;
        this.ambTemp = aTemp;
        this.hitTemp = hTemp;
        this.ambAir = aAir;
        this.hitAir = hAir;
        this.ambHydration = aHyd;
        this.hitHydration = hHyd;
        this.loadedFrom = fileName;
    }

    @Override
    public NBTTagCompound WriteToNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("id", this.id);
        tags.func_74757_a("shouldTrack", this.shouldTrack);
        tags.func_74757_a("dehydration", this.dehydration);
        tags.func_74757_a("bodyTemp", this.bodyTemp);
        tags.func_74757_a("airQ", this.airQ);
        tags.func_74757_a("immuneToFrost", this.immuneToFrost);
        tags.func_74757_a("immuneToHeat", this.immuneToHeat);
        tags.func_74776_a("ambSanity", this.ambSanity);
        tags.func_74776_a("hitSanity", this.hitSanity);
        tags.func_74776_a("ambTemp", this.ambTemp);
        tags.func_74776_a("hitTemp", this.hitTemp);
        tags.func_74776_a("ambAir", this.ambAir);
        tags.func_74776_a("hitAir", this.hitAir);
        tags.func_74776_a("ambHydration", this.ambHydration);
        tags.func_74776_a("hitHydration", this.hitHydration);
        return tags;
    }

    @Override
    public void ReadFromNBT(NBTTagCompound tags) {
        this.id = tags.func_74762_e("id");
        this.shouldTrack = tags.func_74767_n("shouldTrack");
        this.dehydration = tags.func_74767_n("dehydration");
        this.bodyTemp = tags.func_74767_n("bodyTemp");
        this.airQ = tags.func_74767_n("airQ");
        this.immuneToFrost = tags.func_74767_n("immuneToFrost");
        this.immuneToHeat = tags.func_74767_n("immuneToHeat");
        this.ambSanity = tags.func_74760_g("ambSanity");
        this.hitSanity = tags.func_74760_g("hitSanity");
        this.ambTemp = tags.func_74760_g("ambTemp");
        this.hitTemp = tags.func_74760_g("hitTemp");
        this.ambAir = tags.func_74760_g("ambAir");
        this.hitAir = tags.func_74760_g("hitAir");
        this.ambHydration = tags.func_74760_g("ambHydration");
        this.hitHydration = tags.func_74760_g("hitHydration");
    }

    @Override
    public String categoryName() {
        return "entity";
    }

    @Override
    public String categoryDescription() {
        return "Custom properties for entities";
    }

    @Override
    public void LoadProperty(Configuration config, String category) {
        config.addCustomCategoryComment(this.categoryName(), this.categoryDescription());
        int id = config.get(category, EPName[0], 0).getInt(0);
        boolean track = config.get(category, EPName[1], true).getBoolean(true);
        boolean dehydration = config.get(category, EPName[2], true).getBoolean(true);
        boolean bodyTemp = config.get(category, EPName[3], true).getBoolean(true);
        boolean airQ = config.get(category, EPName[4], true).getBoolean(true);
        boolean immuneToFrost = config.get(category, EPName[5], false).getBoolean(false);
        boolean immuneToHeat = config.get(category, EPName[6], false).getBoolean(false);
        float aSanity = (float)config.get(category, EPName[7], 0.0).getDouble(0.0);
        float hSanity = (float)config.get(category, EPName[8], 0.0).getDouble(0.0);
        float aTemp = (float)config.get(category, EPName[9], 36.6, "Overridden by body temp").getDouble(36.6);
        float hTemp = (float)config.get(category, EPName[10], 0.0).getDouble(0.0);
        float aAir = (float)config.get(category, EPName[11], 0.0).getDouble(0.0);
        float hAir = (float)config.get(category, EPName[12], 0.0).getDouble(0.0);
        float aHyd = (float)config.get(category, EPName[13], 0.0).getDouble(0.0);
        float hHyd = (float)config.get(category, EPName[14], 0.0).getDouble(0.0);
        String filename = config.getConfigFile().getName();
        EntityProperties entry = new EntityProperties(id, track, dehydration, bodyTemp, airQ, immuneToFrost, immuneToHeat, aSanity, hSanity, aTemp, hTemp, aAir, hAir, aHyd, hHyd, filename);
        if (EM_Settings.livingProperties.containsKey(id) && !EM_ConfigHandler.loadedConfigs.contains(filename) && EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
            EnviroMine.logger.log(Level.ERROR, "CONFIG DUPLICATE: Entity ID " + id + " was already added from " + EM_Settings.livingProperties.get((Object)Integer.valueOf((int)id)).loadedFrom.toUpperCase() + " and will be overriden by " + filename.toUpperCase());
        }
        EM_Settings.livingProperties.put(id, entry);
    }

    @Override
    public void SaveProperty(Configuration config, String category) {
        config.get(category, EPName[0], this.id).getInt(this.id);
        config.get(category, EPName[1], this.shouldTrack).getBoolean(this.shouldTrack);
        config.get(category, EPName[2], this.dehydration).getBoolean(this.dehydration);
        config.get(category, EPName[3], this.bodyTemp).getBoolean(this.bodyTemp);
        config.get(category, EPName[4], this.airQ).getBoolean(this.airQ);
        config.get(category, EPName[5], this.immuneToFrost).getBoolean(this.immuneToFrost);
        config.get(category, EPName[6], this.immuneToHeat).getBoolean(this.immuneToHeat);
        config.get(category, EPName[7], (double)this.ambSanity).getDouble((double)this.ambSanity);
        config.get(category, EPName[8], (double)this.hitSanity).getDouble((double)this.hitSanity);
        config.get(category, EPName[9], (double)this.ambTemp, "Overridden by body temp").getDouble((double)this.ambTemp);
        config.get(category, EPName[10], (double)this.hitTemp).getDouble((double)this.hitTemp);
        config.get(category, EPName[11], (double)this.ambAir).getDouble((double)this.ambAir);
        config.get(category, EPName[12], (double)this.hitAir).getDouble((double)this.hitAir);
        config.get(category, EPName[13], (double)this.ambHydration).getDouble((double)this.ambHydration);
        config.get(category, EPName[14], (double)this.hitHydration).getDouble((double)this.hitHydration);
    }

    @Override
    public void GenDefaults() {
        Iterator iterator = EntityList.field_75623_d.keySet().iterator();
        while (iterator.hasNext()) {
            int eID = (Integer)iterator.next();
            Class clazz = (Class)EntityList.field_75623_d.get(eID);
            if (clazz == null || !EntityLivingBase.class.isAssignableFrom(clazz)) continue;
            String modID = ModIdentification.idFromObject(clazz);
            String eName = EntityList.func_75617_a((int)eID);
            File file = new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + EnviroUtils.SafeFilename(modID) + ".cfg");
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (Exception e) {
                    if (EM_Settings.loggerVerbosity < EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) continue;
                    EnviroMine.logger.log(Level.ERROR, "Failed to create file for default entities", (Throwable)e);
                    continue;
                }
            }
            String catName = this.categoryName() + "." + eName;
            Configuration config = new Configuration(file, true);
            config.load();
            if (eID == 65) {
                config.get(catName, EPName[0], eID).getInt(eID);
                config.get(catName, EPName[1], false).getBoolean(false);
                config.get(catName, EPName[2], false).getBoolean(false);
                config.get(catName, EPName[3], false).getBoolean(false);
                config.get(catName, EPName[4], false).getBoolean(false);
                config.get(catName, EPName[5], true).getBoolean(true);
                config.get(catName, EPName[6], true).getBoolean(true);
                config.get(catName, EPName[7], -0.05).getDouble(-0.05);
                config.get(catName, EPName[8], 0.0).getDouble(0.0);
                config.get(catName, EPName[9], 37.0, "Overridden by body temp").getDouble(37.0);
                config.get(catName, EPName[10], 0.0).getDouble(0.0);
                config.get(catName, EPName[11], 0.0).getDouble(0.0);
                config.get(catName, EPName[12], 0.0).getDouble(0.0);
                config.get(catName, EPName[13], 0.0).getDouble(0.0);
                config.get(catName, EPName[14], 0.0).getDouble(0.0);
            } else if (eID == 54) {
                config.get(catName, EPName[0], eID).getInt(eID);
                config.get(catName, EPName[1], false).getBoolean(false);
                config.get(catName, EPName[2], false).getBoolean(false);
                config.get(catName, EPName[3], false).getBoolean(false);
                config.get(catName, EPName[4], false).getBoolean(false);
                config.get(catName, EPName[5], true).getBoolean(true);
                config.get(catName, EPName[6], true).getBoolean(true);
                config.get(catName, EPName[7], -0.1).getDouble(-0.1);
                config.get(catName, EPName[8], -1.0).getDouble(-1.0);
                config.get(catName, EPName[9], 10.0, "Overridden by body temp").getDouble(10.0);
                config.get(catName, EPName[10], 0.0).getDouble(0.0);
                config.get(catName, EPName[11], 0.0).getDouble(0.0);
                config.get(catName, EPName[12], 0.0).getDouble(0.0);
                config.get(catName, EPName[13], 0.0).getDouble(0.0);
                config.get(catName, EPName[14], 0.0).getDouble(0.0);
            } else if (eID == 51) {
                config.get(catName, EPName[0], eID).getInt(eID);
                config.get(catName, EPName[1], false).getBoolean(false);
                config.get(catName, EPName[2], false).getBoolean(false);
                config.get(catName, EPName[3], false).getBoolean(false);
                config.get(catName, EPName[4], false).getBoolean(false);
                config.get(catName, EPName[5], true).getBoolean(true);
                config.get(catName, EPName[6], true).getBoolean(true);
                config.get(catName, EPName[7], -0.1).getDouble(-0.1);
                config.get(catName, EPName[8], -1.0).getDouble(-1.0);
                config.get(catName, EPName[9], 10.0, "Overridden by body temp").getDouble(10.0);
                config.get(catName, EPName[10], 0.0).getDouble(0.0);
                config.get(catName, EPName[11], 0.0).getDouble(0.0);
                config.get(catName, EPName[12], 0.0).getDouble(0.0);
                config.get(catName, EPName[13], 0.0).getDouble(0.0);
                config.get(catName, EPName[14], 0.0).getDouble(0.0);
            } else if (eID == 57) {
                config.get(catName, EPName[0], eID).getInt(eID);
                config.get(catName, EPName[1], false).getBoolean(false);
                config.get(catName, EPName[2], false).getBoolean(false);
                config.get(catName, EPName[3], false).getBoolean(false);
                config.get(catName, EPName[4], false).getBoolean(false);
                config.get(catName, EPName[5], true).getBoolean(true);
                config.get(catName, EPName[6], true).getBoolean(true);
                config.get(catName, EPName[7], -0.1).getDouble(-0.1);
                config.get(catName, EPName[8], -1.0).getDouble(-1.0);
                config.get(catName, EPName[9], 10.0, "Overridden by body temp").getDouble(10.0);
                config.get(catName, EPName[10], 0.0).getDouble(0.0);
                config.get(catName, EPName[11], 0.0).getDouble(0.0);
                config.get(catName, EPName[12], 0.0).getDouble(0.0);
                config.get(catName, EPName[13], 0.0).getDouble(0.0);
                config.get(catName, EPName[14], 0.0).getDouble(0.0);
            } else if (eID == 58) {
                config.get(catName, EPName[0], eID).getInt(eID);
                config.get(catName, EPName[1], false).getBoolean(false);
                config.get(catName, EPName[2], false).getBoolean(false);
                config.get(catName, EPName[3], false).getBoolean(false);
                config.get(catName, EPName[4], false).getBoolean(false);
                config.get(catName, EPName[5], true).getBoolean(true);
                config.get(catName, EPName[6], true).getBoolean(true);
                config.get(catName, EPName[7], -0.5).getDouble(-0.5);
                config.get(catName, EPName[8], -5.0).getDouble(-5.0);
                config.get(catName, EPName[9], 10.0, "Overridden by body temp").getDouble(10.0);
                config.get(catName, EPName[10], 0.0).getDouble(0.0);
                config.get(catName, EPName[11], 0.0).getDouble(0.0);
                config.get(catName, EPName[12], 0.0).getDouble(0.0);
                config.get(catName, EPName[13], 0.0).getDouble(0.0);
                config.get(catName, EPName[14], 0.0).getDouble(0.0);
            } else if (eID == 61) {
                config.get(catName, EPName[0], eID).getInt(eID);
                config.get(catName, EPName[1], false).getBoolean(false);
                config.get(catName, EPName[2], false).getBoolean(false);
                config.get(catName, EPName[3], false).getBoolean(false);
                config.get(catName, EPName[4], false).getBoolean(false);
                config.get(catName, EPName[5], true).getBoolean(true);
                config.get(catName, EPName[6], true).getBoolean(true);
                config.get(catName, EPName[7], 0.0).getDouble(0.0);
                config.get(catName, EPName[8], 0.0).getDouble(0.0);
                config.get(catName, EPName[9], 100.0, "Overridden by body temp").getDouble(100.0);
                config.get(catName, EPName[10], 0.5).getDouble(0.5);
                config.get(catName, EPName[11], 0.0).getDouble(0.0);
                config.get(catName, EPName[12], 0.0).getDouble(0.0);
                config.get(catName, EPName[13], -0.1).getDouble(-0.1);
                config.get(catName, EPName[14], -1.0).getDouble(-1.0);
            } else if (eID == 97) {
                config.get(catName, EPName[0], eID).getInt(eID);
                config.get(catName, EPName[1], false).getBoolean(false);
                config.get(catName, EPName[2], false).getBoolean(false);
                config.get(catName, EPName[3], false).getBoolean(false);
                config.get(catName, EPName[4], false).getBoolean(false);
                config.get(catName, EPName[5], true).getBoolean(true);
                config.get(catName, EPName[6], true).getBoolean(true);
                config.get(catName, EPName[7], 0.0).getDouble(0.0);
                config.get(catName, EPName[8], 0.0).getDouble(0.0);
                config.get(catName, EPName[9], -1.0, "Overridden by body temp").getDouble(-1.0);
                config.get(catName, EPName[10], -0.5).getDouble(-0.5);
                config.get(catName, EPName[11], 0.0).getDouble(0.0);
                config.get(catName, EPName[12], 0.0).getDouble(0.0);
                config.get(catName, EPName[13], 0.0).getDouble(0.0);
                config.get(catName, EPName[14], 0.0).getDouble(0.0);
            } else if (EM_Settings.genConfigs) {
                this.generateEmpty(config, eID);
            }
            config.save();
        }
    }

    @Override
    public File GetDefaultFile() {
        return new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + "Entities.cfg");
    }

    @Override
    public void generateEmpty(Configuration config, Object obj) {
        if (obj == null || !(obj instanceof Integer)) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.ALL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Tried to register config with non EntityLivingBase id!", (Throwable)new Exception());
            }
            return;
        }
        int id = (Integer)obj;
        String category = this.categoryName() + "." + EntityList.func_75617_a((int)id);
        config.get(category, EPName[0], id).getInt(id);
        config.get(category, EPName[1], false).getBoolean(false);
        config.get(category, EPName[2], false).getBoolean(false);
        config.get(category, EPName[3], false).getBoolean(false);
        config.get(category, EPName[4], false).getBoolean(false);
        config.get(category, EPName[5], true).getBoolean(true);
        config.get(category, EPName[6], true).getBoolean(true);
        config.get(category, EPName[7], 0.0).getDouble(0.0);
        config.get(category, EPName[8], 0.0).getDouble((double)this.hitSanity);
        config.get(category, EPName[9], 35.0, "Overridden by body temp").getDouble(35.0);
        config.get(category, EPName[10], 0.0).getDouble(0.0);
        config.get(category, EPName[11], 0.0).getDouble(0.0);
        config.get(category, EPName[12], 0.0).getDouble(0.0);
        config.get(category, EPName[13], 0.0).getDouble(0.0);
        config.get(category, EPName[14], 0.0).getDouble(0.0);
    }

    @Override
    public boolean useCustomConfigs() {
        return true;
    }

    @Override
    public void customLoad() {
    }

    static {
        EntityProperties.EPName[0] = "01.Entity ID";
        EntityProperties.EPName[1] = "02.Enable EnviroTracker";
        EntityProperties.EPName[2] = "03.Enable Dehydration";
        EntityProperties.EPName[3] = "04.Enable BodyTemp";
        EntityProperties.EPName[4] = "05.Enable Air Quality";
        EntityProperties.EPName[5] = "06.Immune To Frost";
        EntityProperties.EPName[6] = "07.Immune To Heat";
        EntityProperties.EPName[7] = "08.Ambient Sanity";
        EntityProperties.EPName[8] = "09.Hit Sanity";
        EntityProperties.EPName[9] = "10.Ambient Temperature";
        EntityProperties.EPName[10] = "11.Hit Temperature";
        EntityProperties.EPName[11] = "12.Ambient Air";
        EntityProperties.EPName[12] = "13.Hit Air";
        EntityProperties.EPName[13] = "14.Ambient Hydration";
        EntityProperties.EPName[14] = "15.Hit Hydration";
    }
}

