/*
 * Decompiled with CFR 0.152.
 */
package enviromine.trackers.properties;

import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.trackers.properties.helpers.PropertyBase;
import enviromine.utils.EnviroUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class CaveGenProperties
implements PropertyBase {
    public static final CaveGenProperties base = new CaveGenProperties();
    static String[] CGPNames;
    public Block ore;
    public int oreMeta;
    public Block source;
    public int srcMeta;
    public int veins;
    public int size;
    public int minY;
    public int maxY;

    public CaveGenProperties() {
        if (base != null && base != this) {
            throw new IllegalStateException();
        }
    }

    public CaveGenProperties(String id, int oreMeta, String source, int srcMeta, int veins, int size, int minY, int maxY) {
        this.ore = (Block)Block.field_149771_c.func_82594_a(id);
        this.oreMeta = oreMeta;
        this.source = (Block)Block.field_149771_c.func_82594_a(source);
        this.srcMeta = srcMeta;
        this.veins = veins;
        this.size = size;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public String categoryName() {
        return "Cave Ores";
    }

    @Override
    public String categoryDescription() {
        return "Changes how ores generate in the cave dimension";
    }

    @Override
    public void LoadProperty(Configuration config, String category) {
        config.setCategoryComment(this.categoryName(), this.categoryDescription());
        String nID = config.get(category, CGPNames[0], "minecraft:stone").getString();
        int nOreM = MathHelper.func_76125_a((int)config.get(category, CGPNames[1], 0).getInt(), (int)0, (int)15);
        String nSource = config.get(category, CGPNames[2], "minecraft:stone").getString();
        int nSrcM = config.get(category, CGPNames[3], 0).getInt();
        int nVeins = config.get(category, CGPNames[4], 4).getInt();
        int nSize = config.get(category, CGPNames[5], 4).getInt();
        int nMinY = config.get(category, CGPNames[6], 10).getInt();
        int nMaxY = config.get(category, CGPNames[7], 246).getInt();
        CaveGenProperties entry = new CaveGenProperties(nID, nOreM, nSource, nSrcM, nVeins, nSize, nMinY, nMaxY);
        EM_Settings.caveGenProperties.add(entry);
    }

    @Override
    public void SaveProperty(Configuration config, String category) {
        config.get(category, CGPNames[0], Block.field_149771_c.func_148757_b((Object)this.ore));
        config.get(category, CGPNames[1], this.oreMeta);
        config.get(category, CGPNames[2], Block.field_149771_c.func_148750_c((Object)this.source));
        config.get(category, CGPNames[3], this.srcMeta);
        config.get(category, CGPNames[4], this.veins);
        config.get(category, CGPNames[5], this.size);
        config.get(category, CGPNames[6], this.minY);
        config.get(category, CGPNames[7], this.maxY);
    }

    @Override
    public void GenDefaults() {
        String catName;
        File file = this.GetDefaultFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) {
                    EnviroMine.logger.log(Level.ERROR, "Failed to create file for Cave Ores", (Throwable)e);
                }
                return;
            }
        }
        Configuration config = new Configuration(file, true);
        config.load();
        if (config.hasCategory(this.categoryName())) {
            config.save();
            return;
        }
        if (!config.hasCategory(this.categoryName() + ".Coal")) {
            catName = this.categoryName() + ".Coal";
            config.get(catName, CGPNames[0], Block.field_149771_c.func_148750_c((Object)Blocks.field_150365_q));
            config.get(catName, CGPNames[1], 0);
            config.get(catName, CGPNames[2], Block.field_149771_c.func_148750_c((Object)Blocks.field_150348_b));
            config.get(catName, CGPNames[3], 0);
            config.get(catName, CGPNames[4], 32);
            config.get(catName, CGPNames[5], 16);
            config.get(catName, CGPNames[6], 10);
            config.get(catName, CGPNames[7], 246);
        }
        if (!config.hasCategory(this.categoryName() + ".Iron")) {
            catName = this.categoryName() + ".Iron";
            config.get(catName, CGPNames[0], Block.field_149771_c.func_148750_c((Object)Blocks.field_150366_p));
            config.get(catName, CGPNames[1], 0);
            config.get(catName, CGPNames[2], Block.field_149771_c.func_148750_c((Object)Blocks.field_150348_b));
            config.get(catName, CGPNames[3], 0);
            config.get(catName, CGPNames[4], 24);
            config.get(catName, CGPNames[5], 16);
            config.get(catName, CGPNames[6], 10);
            config.get(catName, CGPNames[7], 246);
        }
        if (!config.hasCategory(this.categoryName() + ".Lapis")) {
            catName = this.categoryName() + ".Lapis";
            config.get(catName, CGPNames[0], Block.field_149771_c.func_148750_c((Object)Blocks.field_150450_ax));
            config.get(catName, CGPNames[1], 0);
            config.get(catName, CGPNames[2], Block.field_149771_c.func_148750_c((Object)Blocks.field_150348_b));
            config.get(catName, CGPNames[3], 0);
            config.get(catName, CGPNames[4], 12);
            config.get(catName, CGPNames[5], 8);
            config.get(catName, CGPNames[6], 10);
            config.get(catName, CGPNames[7], 246);
        }
        if (!config.hasCategory(this.categoryName() + ".Redstone")) {
            catName = this.categoryName() + ".Redstone";
            config.get(catName, CGPNames[0], Block.field_149771_c.func_148750_c((Object)Blocks.field_150450_ax));
            config.get(catName, CGPNames[1], 0);
            config.get(catName, CGPNames[2], Block.field_149771_c.func_148750_c((Object)Blocks.field_150348_b));
            config.get(catName, CGPNames[3], 0);
            config.get(catName, CGPNames[4], 12);
            config.get(catName, CGPNames[5], 12);
            config.get(catName, CGPNames[6], 10);
            config.get(catName, CGPNames[7], 246);
        }
        if (!config.hasCategory(this.categoryName() + ".Gold")) {
            catName = this.categoryName() + ".Gold";
            config.get(catName, CGPNames[0], Block.field_149771_c.func_148750_c((Object)Blocks.field_150352_o));
            config.get(catName, CGPNames[1], 0);
            config.get(catName, CGPNames[2], Block.field_149771_c.func_148750_c((Object)Blocks.field_150348_b));
            config.get(catName, CGPNames[3], 0);
            config.get(catName, CGPNames[4], 8);
            config.get(catName, CGPNames[5], 8);
            config.get(catName, CGPNames[6], 10);
            config.get(catName, CGPNames[7], 246);
        }
        if (!config.hasCategory(this.categoryName() + ".Diamonds")) {
            catName = this.categoryName() + ".Diamonds";
            config.get(catName, CGPNames[0], Block.field_149771_c.func_148750_c((Object)Blocks.field_150482_ag));
            config.get(catName, CGPNames[1], 0);
            config.get(catName, CGPNames[2], Block.field_149771_c.func_148750_c((Object)Blocks.field_150348_b));
            config.get(catName, CGPNames[3], 0);
            config.get(catName, CGPNames[4], 4);
            config.get(catName, CGPNames[5], 8);
            config.get(catName, CGPNames[6], 10);
            config.get(catName, CGPNames[7], 246);
        }
        if (!config.hasCategory(this.categoryName() + ".Emeralds")) {
            catName = this.categoryName() + ".Emeralds";
            config.get(catName, CGPNames[0], Block.field_149771_c.func_148750_c((Object)Blocks.field_150412_bA));
            config.get(catName, CGPNames[1], 0);
            config.get(catName, CGPNames[2], Block.field_149771_c.func_148750_c((Object)Blocks.field_150348_b));
            config.get(catName, CGPNames[3], 0);
            config.get(catName, CGPNames[4], 2);
            config.get(catName, CGPNames[5], 4);
            config.get(catName, CGPNames[6], 10);
            config.get(catName, CGPNames[7], 246);
        }
        if (!config.hasCategory(this.categoryName() + ".Silverfish")) {
            catName = this.categoryName() + ".Silverfish";
            config.get(catName, CGPNames[0], Block.field_149771_c.func_148750_c((Object)Blocks.field_150418_aU));
            config.get(catName, CGPNames[1], 0);
            config.get(catName, CGPNames[2], Block.field_149771_c.func_148750_c((Object)Blocks.field_150348_b));
            config.get(catName, CGPNames[3], 0);
            config.get(catName, CGPNames[4], 48);
            config.get(catName, CGPNames[5], 24);
            config.get(catName, CGPNames[6], 10);
            config.get(catName, CGPNames[7], 246);
        }
        config.save();
    }

    @Override
    public File GetDefaultFile() {
        return new File(EM_ConfigHandler.configPath + "CaveDimension.cfg");
    }

    @Override
    public void generateEmpty(Configuration config, Object obj) {
        if (obj == null || !(obj instanceof Block)) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.ALL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Tried to register config with non block object!", (Throwable)new Exception());
            }
            return;
        }
        Block block = (Block)obj;
        String catName = this.categoryName() + "." + EnviroUtils.replaceULN(block.func_149739_a());
        config.get(catName, CGPNames[0], Block.field_149771_c.func_148750_c((Object)Blocks.field_150366_p));
        config.get(catName, CGPNames[1], 0);
        config.get(catName, CGPNames[2], Block.field_149771_c.func_148750_c((Object)Blocks.field_150348_b));
        config.get(catName, CGPNames[3], 0);
        config.get(catName, CGPNames[4], 24);
        config.get(catName, CGPNames[5], 16);
        config.get(catName, CGPNames[6], 10);
        config.get(catName, CGPNames[7], 246);
    }

    @Override
    public boolean useCustomConfigs() {
        return false;
    }

    @Override
    public void customLoad() {
        Configuration config;
        try {
            config = new Configuration(this.GetDefaultFile(), true);
        }
        catch (Exception e) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Failed to load custom configuration for " + this.getClass().getSimpleName(), (Throwable)e);
            }
            return;
        }
        config.load();
        ArrayList<String> entries = EM_ConfigHandler.getSubCategories(config, this.categoryName());
        Iterator<String> iterator = entries.iterator();
        while (iterator.hasNext()) {
            this.LoadProperty(config, iterator.next());
        }
        config.save();
    }

    static {
        EM_Settings.caveGenProperties = new ArrayList();
        CGPNames = new String[8];
        CaveGenProperties.CGPNames[0] = "01.Ore Name";
        CaveGenProperties.CGPNames[1] = "02.Ore Metadata";
        CaveGenProperties.CGPNames[2] = "03.Source Block";
        CaveGenProperties.CGPNames[3] = "04.Source Metadata";
        CaveGenProperties.CGPNames[4] = "03.Veins Per Chunk";
        CaveGenProperties.CGPNames[5] = "04.Veins Size";
        CaveGenProperties.CGPNames[6] = "05.Min Y";
        CaveGenProperties.CGPNames[7] = "06.Max Y";
    }
}

