/*
 * Decompiled with CFR 0.152.
 */
package enviromine.trackers.properties;

import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.trackers.properties.compat.BiomeProperties_LOTR;
import enviromine.trackers.properties.compat.BiomeProperties_NTM;
import enviromine.trackers.properties.compat.BiomeProperties_NTM_SPACE;
import enviromine.trackers.properties.compat.BiomeProperties_SS;
import enviromine.trackers.properties.helpers.PropertyBase;
import enviromine.trackers.properties.helpers.SerialisableProperty;
import enviromine.utils.EnviroUtils;
import enviromine.utils.ModIdentification;
import enviromine.utils.WaterUtils;
import enviromine.utils.misc.CompatSafe;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

@CompatSafe
public class BiomeProperties
implements SerialisableProperty,
PropertyBase {
    public static final BiomeProperties base = new BiomeProperties();
    static String[] BOName = new String[48];
    public int id;
    public boolean biomeOveride;
    public String waterQuality;
    public float ambientTemp;
    public float tempRate;
    public float sanityRate;
    public float dehydrateRate;
    public float airRate;
    public String loadedFrom;
    public float TemperatureMultiplier;
    public float DAWN_TEMPERATURE_DECREASE;
    public float DAY_TEMPERATURE_DECREASE;
    public float DUSK_TEMPERATURE_DECREASE;
    public float NIGHT_TEMPERATURE_DECREASE;
    public float TemperatureRainDecrease;
    public float TemperatureThunderDecrease;
    public boolean TemperatureRainBool;
    public boolean TemperatureThunderBool;
    public float TemperatureShadeDecrease;
    public float ambientTemp_TERRAFORMED;
    public float DAWN_TEMPERATURE_DECREASE_TERRAFORMED;
    public float DAY_TEMPERATURE_DECREASE_TERRAFORMED;
    public float DUSK_TEMPERATURE_DECREASE_TERRAFORMED;
    public float NIGHT_TEMPERATURE_DECREASE_TERRAFORMED;
    public float EARLY_SPRING_TEMPERATURE_DECREASE;
    public float EARLY_SUMMER_TEMPERATURE_DECREASE;
    public float EARLY_WINTER_TEMPERATURE_DECREASE;
    public float EARLY_AUTUMN_TEMPERATURE_DECREASE;
    public float MID_SPRING_TEMPERATURE_DECREASE;
    public float MID_SUMMER_TEMPERATURE_DECREASE;
    public float MID_WINTER_TEMPERATURE_DECREASE;
    public float MID_AUTUMN_TEMPERATURE_DECREASE;
    public float LATE_SPRING_TEMPERATURE_DECREASE;
    public float LATE_SUMMER_TEMPERATURE_DECREASE;
    public float LATE_WINTER_TEMPERATURE_DECREASE;
    public float LATE_AUTUMN_TEMPERATURE_DECREASE;
    public float tempRate_DAWN;
    public float tempRate_DAY;
    public float tempRate_DUSK;
    public float tempRate_NIGHT;
    public boolean tempRate_HARD;
    public float TemperatureWaterDecrease;
    public float dropSpeedWater;
    public float dropSpeedRain;
    public float dropSpeedThunder;
    public String SPRING_waterQuality;
    public String SUMMER_waterQuality;
    public String AUTUMN_waterQuality;
    public String WINTER_waterQuality;

    public BiomeProperties(NBTTagCompound tags) {
        this.ReadFromNBT(tags);
    }

    public BiomeProperties() {
        if (base != null && base != this) {
            throw new IllegalStateException();
        }
    }

    public BiomeProperties(int id, boolean biomeOveride, String waterQuality, float ambientTemp, float tempRate, float sanityRate, float dehydrateRate, float airRate, String filename, float TemperatureMultiplier, float DAWN_TEMPERATURE_DECREASE, float DAY_TEMPERATURE_DECREASE, float DUSK_TEMPERATURE_DECREASE, float NIGHT_TEMPERATURE_DECREASE, float TemperatureRainDecrease, float TemperatureThunderDecrease, boolean TemperatureRainBool, boolean TemperatureThunderBool, float TemperatureShadeDecrease, float ambientTemp_TERRAFORMED, float DAWN_TEMPERATURE_DECREASE_TERRAFORMED, float DAY_TEMPERATURE_DECREASE_TERRAFORMED, float DUSK_TEMPERATURE_DECREASE_TERRAFORMED, float NIGHT_TEMPERATURE_DECREASE_TERRAFORMED, float EARLY_SPRING_TEMPERATURE_DECREASE, float EARLY_SUMMER_TEMPERATURE_DECREASE, float EARLY_WINTER_TEMPERATURE_DECREASE, float EARLY_AUTUMN_TEMPERATURE_DECREASE, float MID_SPRING_TEMPERATURE_DECREASE, float MID_SUMMER_TEMPERATURE_DECREASE, float MID_WINTER_TEMPERATURE_DECREASE, float MID_AUTUMN_TEMPERATURE_DECREASE, float LATE_SPRING_TEMPERATURE_DECREASE, float LATE_SUMMER_TEMPERATURE_DECREASE, float LATE_WINTER_TEMPERATURE_DECREASE, float LATE_AUTUMN_TEMPERATURE_DECREASE, float tempRate_DAWN, float tempRate_DAY, float tempRate_DUSK, float tempRate_NIGHT, boolean tempRate_HARD, float TemperatureWaterDecrease, float dropSpeedWater, float dropSpeedRain, float dropSpeedThunder, String SPRING_waterQuality, String SUMMER_waterQuality, String AUTUMN_waterQuality, String WINTER_waterQuality) {
        this.id = id;
        this.biomeOveride = biomeOveride;
        this.waterQuality = waterQuality;
        this.ambientTemp = ambientTemp;
        this.tempRate = tempRate;
        this.sanityRate = sanityRate;
        this.dehydrateRate = dehydrateRate;
        this.airRate = airRate;
        this.loadedFrom = filename;
        this.TemperatureMultiplier = TemperatureMultiplier;
        this.DAWN_TEMPERATURE_DECREASE = DAWN_TEMPERATURE_DECREASE;
        this.DAY_TEMPERATURE_DECREASE = DAY_TEMPERATURE_DECREASE;
        this.DUSK_TEMPERATURE_DECREASE = DUSK_TEMPERATURE_DECREASE;
        this.NIGHT_TEMPERATURE_DECREASE = NIGHT_TEMPERATURE_DECREASE;
        this.TemperatureRainDecrease = TemperatureRainDecrease;
        this.TemperatureThunderDecrease = TemperatureThunderDecrease;
        this.TemperatureRainBool = TemperatureRainBool;
        this.TemperatureThunderBool = TemperatureThunderBool;
        this.TemperatureShadeDecrease = TemperatureShadeDecrease;
        this.ambientTemp_TERRAFORMED = ambientTemp_TERRAFORMED;
        this.DAWN_TEMPERATURE_DECREASE_TERRAFORMED = DAWN_TEMPERATURE_DECREASE_TERRAFORMED;
        this.DAY_TEMPERATURE_DECREASE_TERRAFORMED = DAY_TEMPERATURE_DECREASE_TERRAFORMED;
        this.DUSK_TEMPERATURE_DECREASE_TERRAFORMED = DUSK_TEMPERATURE_DECREASE_TERRAFORMED;
        this.NIGHT_TEMPERATURE_DECREASE_TERRAFORMED = NIGHT_TEMPERATURE_DECREASE_TERRAFORMED;
        this.EARLY_SPRING_TEMPERATURE_DECREASE = EARLY_SPRING_TEMPERATURE_DECREASE;
        this.EARLY_SUMMER_TEMPERATURE_DECREASE = EARLY_SUMMER_TEMPERATURE_DECREASE;
        this.EARLY_WINTER_TEMPERATURE_DECREASE = EARLY_WINTER_TEMPERATURE_DECREASE;
        this.EARLY_AUTUMN_TEMPERATURE_DECREASE = EARLY_AUTUMN_TEMPERATURE_DECREASE;
        this.MID_SPRING_TEMPERATURE_DECREASE = MID_SPRING_TEMPERATURE_DECREASE;
        this.MID_SUMMER_TEMPERATURE_DECREASE = MID_SUMMER_TEMPERATURE_DECREASE;
        this.MID_WINTER_TEMPERATURE_DECREASE = MID_WINTER_TEMPERATURE_DECREASE;
        this.MID_AUTUMN_TEMPERATURE_DECREASE = MID_AUTUMN_TEMPERATURE_DECREASE;
        this.LATE_SPRING_TEMPERATURE_DECREASE = LATE_SPRING_TEMPERATURE_DECREASE;
        this.LATE_SUMMER_TEMPERATURE_DECREASE = LATE_SUMMER_TEMPERATURE_DECREASE;
        this.LATE_WINTER_TEMPERATURE_DECREASE = LATE_WINTER_TEMPERATURE_DECREASE;
        this.LATE_AUTUMN_TEMPERATURE_DECREASE = LATE_AUTUMN_TEMPERATURE_DECREASE;
        this.tempRate_DAWN = tempRate_DAWN;
        this.tempRate_DAY = tempRate_DAY;
        this.tempRate_DUSK = tempRate_DUSK;
        this.tempRate_NIGHT = tempRate_NIGHT;
        this.tempRate_HARD = tempRate_HARD;
        this.TemperatureWaterDecrease = TemperatureWaterDecrease;
        this.dropSpeedWater = dropSpeedWater;
        this.dropSpeedRain = dropSpeedRain;
        this.dropSpeedThunder = dropSpeedThunder;
        this.SPRING_waterQuality = SPRING_waterQuality;
        this.SUMMER_waterQuality = SUMMER_waterQuality;
        this.AUTUMN_waterQuality = AUTUMN_waterQuality;
        this.WINTER_waterQuality = WINTER_waterQuality;
    }

    public boolean hasProperty(BiomeGenBase biome) {
        return EM_Settings.biomeProperties.containsKey(biome.field_76756_M);
    }

    public BiomeProperties getProperty(BiomeGenBase biome) {
        return EM_Settings.biomeProperties.get(biome.field_76756_M);
    }

    public WaterUtils.WATER_TYPES getWaterQuality(World world) {
        if (EnviroMine.isSereneSeasonsLoaded) {
            try {
                String seasonWater = BiomeProperties_SS.checkSeasonWater(world, this.SPRING_waterQuality, this.SUMMER_waterQuality, this.AUTUMN_waterQuality, this.WINTER_waterQuality);
                if (seasonWater != null) {
                    return WaterUtils.getTypeFromString(seasonWater);
                }
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
        return WaterUtils.getTypeFromString(this.waterQuality);
    }

    @Override
    public NBTTagCompound WriteToNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("id", this.id);
        tags.func_74757_a("biomeOveride", this.biomeOveride);
        tags.func_74778_a("waterQuality", this.waterQuality);
        tags.func_74776_a("ambientTemp", this.ambientTemp);
        tags.func_74776_a("tempRate", this.tempRate);
        tags.func_74776_a("sanityRate", this.sanityRate);
        tags.func_74776_a("dehydrateRate", this.dehydrateRate);
        tags.func_74776_a("TemperatureMultiplier", this.TemperatureMultiplier);
        tags.func_74776_a("DAWN_TEMPERATURE_DECREASE", this.DAWN_TEMPERATURE_DECREASE);
        tags.func_74776_a("DAY_TEMPERATURE_DECREASE", this.DAY_TEMPERATURE_DECREASE);
        tags.func_74776_a("DUSK_TEMPERATURE_DECREASE", this.DUSK_TEMPERATURE_DECREASE);
        tags.func_74776_a("NIGHT_TEMPERATURE_DECREASE", this.NIGHT_TEMPERATURE_DECREASE);
        tags.func_74776_a("TemperatureRainDecrease", this.TemperatureRainDecrease);
        tags.func_74776_a("TemperatureThunderDecrease", this.TemperatureThunderDecrease);
        tags.func_74757_a("TemperatureRainBool", this.TemperatureRainBool);
        tags.func_74757_a("TemperatureThunderBool", this.TemperatureThunderBool);
        tags.func_74776_a("TemperatureShadeDecrease", this.TemperatureShadeDecrease);
        tags.func_74776_a("ambientTemp_TERRAFORMED", this.ambientTemp_TERRAFORMED);
        tags.func_74776_a("DAWN_TEMPERATURE_DECREASE_TERRAFORMED", this.DAWN_TEMPERATURE_DECREASE_TERRAFORMED);
        tags.func_74776_a("DAY_TEMPERATURE_DECREASE_TERRAFORMED", this.DAY_TEMPERATURE_DECREASE_TERRAFORMED);
        tags.func_74776_a("DUSK_TEMPERATURE_DECREASE_TERRAFORMED", this.DUSK_TEMPERATURE_DECREASE_TERRAFORMED);
        tags.func_74776_a("NIGHT_TEMPERATURE_DECREASE_TERRAFORMED", this.NIGHT_TEMPERATURE_DECREASE_TERRAFORMED);
        tags.func_74776_a("EARLY_SPRING_TEMPERATURE_DECREASE", this.EARLY_SPRING_TEMPERATURE_DECREASE);
        tags.func_74776_a("EARLY_SUMMER_TEMPERATURE_DECREASE", this.EARLY_SUMMER_TEMPERATURE_DECREASE);
        tags.func_74776_a("EARLY_WINTER_TEMPERATURE_DECREASE", this.EARLY_WINTER_TEMPERATURE_DECREASE);
        tags.func_74776_a("EARLY_AUTUMN_TEMPERATURE_DECREASE", this.EARLY_AUTUMN_TEMPERATURE_DECREASE);
        tags.func_74776_a("MID_SPRING_TEMPERATURE_DECREASE", this.MID_SPRING_TEMPERATURE_DECREASE);
        tags.func_74776_a("MID_SUMMER_TEMPERATURE_DECREASE", this.MID_SUMMER_TEMPERATURE_DECREASE);
        tags.func_74776_a("MID_WINTER_TEMPERATURE_DECREASE", this.MID_WINTER_TEMPERATURE_DECREASE);
        tags.func_74776_a("MID_AUTUMN_TEMPERATURE_DECREASE", this.MID_AUTUMN_TEMPERATURE_DECREASE);
        tags.func_74776_a("LATE_SPRING_TEMPERATURE_DECREASE", this.LATE_SPRING_TEMPERATURE_DECREASE);
        tags.func_74776_a("LATE_SUMMER_TEMPERATURE_DECREASE", this.LATE_SUMMER_TEMPERATURE_DECREASE);
        tags.func_74776_a("LATE_WINTER_TEMPERATURE_DECREASE", this.LATE_WINTER_TEMPERATURE_DECREASE);
        tags.func_74776_a("LATE_AUTUMN_TEMPERATURE_DECREASE", this.LATE_AUTUMN_TEMPERATURE_DECREASE);
        tags.func_74776_a("tempRate_DAWN", this.tempRate_DAWN);
        tags.func_74776_a("tempRate_DAY", this.tempRate_DAY);
        tags.func_74776_a("tempRate_DUSK", this.tempRate_DUSK);
        tags.func_74776_a("tempRate_NIGHT", this.tempRate_NIGHT);
        tags.func_74757_a("tempRate_HARD", this.tempRate_HARD);
        tags.func_74776_a("TemperatureWaterDecrease", this.TemperatureWaterDecrease);
        tags.func_74776_a("dropSpeedWater", this.dropSpeedWater);
        tags.func_74776_a("dropSpeedRain", this.dropSpeedRain);
        tags.func_74776_a("dropSpeedThunder", this.dropSpeedThunder);
        tags.func_74778_a("SPRING_waterQuality", this.SPRING_waterQuality);
        tags.func_74778_a("SUMMER_waterQuality", this.SUMMER_waterQuality);
        tags.func_74778_a("AUTUMN_waterQuality", this.AUTUMN_waterQuality);
        tags.func_74778_a("WINTER_waterQuality", this.WINTER_waterQuality);
        return tags;
    }

    @Override
    public void ReadFromNBT(NBTTagCompound tags) {
        this.id = tags.func_74762_e("id");
        this.biomeOveride = tags.func_74767_n("biomeOveride");
        this.waterQuality = tags.func_74779_i("waterQuality");
        this.ambientTemp = tags.func_74760_g("ambientTemp");
        this.tempRate = tags.func_74760_g("tempRate");
        this.sanityRate = tags.func_74760_g("sanityRate");
        this.dehydrateRate = tags.func_74760_g("dehydrateRate");
        this.TemperatureMultiplier = tags.func_74760_g("TemperatureMultiplier");
        this.DAWN_TEMPERATURE_DECREASE = tags.func_74760_g("DAWN_TEMPERATURE_DECREASE");
        this.DAY_TEMPERATURE_DECREASE = tags.func_74760_g("DAY_TEMPERATURE_DECREASE");
        this.DUSK_TEMPERATURE_DECREASE = tags.func_74760_g("DUSK_TEMPERATURE_DECREASE");
        this.NIGHT_TEMPERATURE_DECREASE = tags.func_74760_g("NIGHT_TEMPERATURE_DECREASE");
        this.TemperatureRainDecrease = tags.func_74760_g("TemperatureRainDecrease");
        this.TemperatureThunderDecrease = tags.func_74760_g("TemperatureThunderDecrease");
        this.TemperatureRainBool = tags.func_74767_n("TemperatureRainBool");
        this.TemperatureThunderBool = tags.func_74767_n("TemperatureThunderBool");
        this.TemperatureShadeDecrease = tags.func_74760_g("TemperatureShadeDecrease");
        this.ambientTemp_TERRAFORMED = tags.func_74760_g("ambientTemp_TERRAFORMED");
        this.DAWN_TEMPERATURE_DECREASE_TERRAFORMED = tags.func_74760_g("DAWN_TEMPERATURE_DECREASE_TERRAFORMED");
        this.DAY_TEMPERATURE_DECREASE_TERRAFORMED = tags.func_74760_g("DAY_TEMPERATURE_DECREASE_TERRAFORMED");
        this.DUSK_TEMPERATURE_DECREASE_TERRAFORMED = tags.func_74760_g("DUSK_TEMPERATURE_DECREASE_TERRAFORMED");
        this.NIGHT_TEMPERATURE_DECREASE_TERRAFORMED = tags.func_74760_g("NIGHT_TEMPERATURE_DECREASE_TERRAFORMED");
        this.EARLY_SPRING_TEMPERATURE_DECREASE = tags.func_74760_g("EARLY_SPRING_TEMPERATURE_DECREASE");
        this.EARLY_SUMMER_TEMPERATURE_DECREASE = tags.func_74760_g("EARLY_SUMMER_TEMPERATURE_DECREASE");
        this.EARLY_WINTER_TEMPERATURE_DECREASE = tags.func_74760_g("EARLY_WINTER_TEMPERATURE_DECREASE");
        this.EARLY_AUTUMN_TEMPERATURE_DECREASE = tags.func_74760_g("EARLY_AUTUMN_TEMPERATURE_DECREASE");
        this.MID_SPRING_TEMPERATURE_DECREASE = tags.func_74760_g("MID_SPRING_TEMPERATURE_DECREASE");
        this.MID_SUMMER_TEMPERATURE_DECREASE = tags.func_74760_g("MID_SUMMER_TEMPERATURE_DECREASE");
        this.MID_WINTER_TEMPERATURE_DECREASE = tags.func_74760_g("MID_WINTER_TEMPERATURE_DECREASE");
        this.MID_AUTUMN_TEMPERATURE_DECREASE = tags.func_74760_g("MID_AUTUMN_TEMPERATURE_DECREASE");
        this.LATE_SPRING_TEMPERATURE_DECREASE = tags.func_74760_g("LATE_SPRING_TEMPERATURE_DECREASE");
        this.LATE_SUMMER_TEMPERATURE_DECREASE = tags.func_74760_g("LATE_SUMMER_TEMPERATURE_DECREASE");
        this.LATE_WINTER_TEMPERATURE_DECREASE = tags.func_74760_g("LATE_WINTER_TEMPERATURE_DECREASE");
        this.LATE_AUTUMN_TEMPERATURE_DECREASE = tags.func_74760_g("LATE_AUTUMN_TEMPERATURE_DECREASE");
        this.tempRate_DAWN = tags.func_74760_g("tempRate_DAWN");
        this.tempRate_DAY = tags.func_74760_g("tempRate_DAY");
        this.tempRate_DUSK = tags.func_74760_g("tempRate_DUSK");
        this.tempRate_NIGHT = tags.func_74760_g("tempRate_NIGHT");
        this.tempRate_HARD = tags.func_74767_n("tempRate_HARD");
        this.TemperatureWaterDecrease = tags.func_74760_g("TemperatureWaterDecrease");
        this.dropSpeedWater = tags.func_74760_g("dropSpeedWater");
        this.dropSpeedRain = tags.func_74760_g("dropSpeedRain");
        this.dropSpeedThunder = tags.func_74760_g("dropSpeedThunder");
        this.SPRING_waterQuality = tags.func_74779_i("SPRING_waterQuality");
        this.SUMMER_waterQuality = tags.func_74779_i("SUMMER_waterQuality");
        this.AUTUMN_waterQuality = tags.func_74779_i("AUTUMN_waterQuality");
        this.WINTER_waterQuality = tags.func_74779_i("WINTER_waterQuality");
    }

    @Override
    public String categoryName() {
        return "biomes";
    }

    @Override
    public String categoryDescription() {
        return "Manually change the environmental properties of each biome";
    }

    @Override
    public void LoadProperty(Configuration config, String category) {
        config.setCategoryComment(this.categoryName(), this.categoryDescription());
        int id = config.get(category, BOName[0], 0).getInt(0);
        boolean biomeOveride = config.get(category, BOName[1], false).getBoolean(false);
        String waterQ = config.get(category, BOName[2], "CLEAN", "Water Quality: RADIOACTIVE_FROSTY, FROSTY, RADIOACTIVE_COLD, DIRTY_COLD, SALTY_COLD, CLEAN_COLD, RADIOACTIVE, DIRTY, SALTY, CLEAN, RADIOACTIVE_WARM, DIRTY_WARM, SALTY_WARM, CLEAN_WARM, RADIOACTIVE_HOT, HOT ").getString();
        float ambTemp = (float)config.get(category, BOName[3], 25.0, "Biome temperature in celsius (Player body temp is offset by + 12C)").getDouble(25.0);
        float tempRate = (float)config.get(category, BOName[4], 0.0).getDouble(0.0);
        float sanRate = (float)config.get(category, BOName[5], 0.0).getDouble(0.0);
        float dehyRate = (float)config.get(category, BOName[6], 0.0).getDouble(0.0);
        float airRate = (float)config.get(category, BOName[7], 0.0).getDouble(0.0);
        String filename = config.getConfigFile().getName();
        float TemperatureMultiplier = (float)config.get(category, BOName[8], 1.0).getDouble(1.0);
        float DAWN_TEMPERATURE_DECREASE = (float)config.get(category, BOName[9], 4.0).getDouble(4.0);
        float DAY_TEMPERATURE_DECREASE = (float)config.get(category, BOName[10], 0.0).getDouble(0.0);
        float DUSK_TEMPERATURE_DECREASE = (float)config.get(category, BOName[11], 4.0).getDouble(4.0);
        float NIGHT_TEMPERATURE_DECREASE = (float)config.get(category, BOName[12], 8.0).getDouble(8.0);
        float TemperatureRainDecrease = (float)config.get(category, BOName[13], 6.0).getDouble(6.0);
        float TemperatureThunderDecrease = (float)config.get(category, BOName[14], 8.0).getDouble(8.0);
        boolean TemperatureRainBool = config.get(category, BOName[15], true).getBoolean(true);
        boolean TemperatureThunderBool = config.get(category, BOName[16], true).getBoolean(true);
        float TemperatureShadeDecrease = (float)config.get(category, BOName[17], 2.5).getDouble(2.5);
        float ambientTemp_TERRAFORMED = (float)config.get(category, BOName[18], 25.0).getDouble(25.0);
        float DAWN_TEMPERATURE_DECREASE_TERRAFORMED = (float)config.get(category, BOName[19], 4.0).getDouble(4.0);
        float DAY_TEMPERATURE_DECREASE_TERRAFORMED = (float)config.get(category, BOName[20], 0.0).getDouble(0.0);
        float DUSK_TEMPERATURE_DECREASE_TERRAFORMED = (float)config.get(category, BOName[21], 4.0).getDouble(4.0);
        float NIGHT_TEMPERATURE_DECREASE_TERRAFORMED = (float)config.get(category, BOName[22], 8.0).getDouble(8.0);
        float EARLY_SPRING_TEMPERATURE_DECREASE = (float)config.get(category, BOName[23], 5.0).getDouble(5.0);
        float EARLY_SUMMER_TEMPERATURE_DECREASE = (float)config.get(category, BOName[24], -1.0).getDouble(-1.0);
        float EARLY_WINTER_TEMPERATURE_DECREASE = (float)config.get(category, BOName[25], 12.0).getDouble(12.0);
        float EARLY_AUTUMN_TEMPERATURE_DECREASE = (float)config.get(category, BOName[26], 6.0).getDouble(6.0);
        float MID_SPRING_TEMPERATURE_DECREASE = (float)config.get(category, BOName[27], -2.0).getDouble(-2.0);
        float MID_SUMMER_TEMPERATURE_DECREASE = (float)config.get(category, BOName[28], -3.0).getDouble(-3.0);
        float MID_WINTER_TEMPERATURE_DECREASE = (float)config.get(category, BOName[29], 15.0).getDouble(15.0);
        float MID_AUTUMN_TEMPERATURE_DECREASE = (float)config.get(category, BOName[30], 8.0).getDouble(8.0);
        float LATE_SPRING_TEMPERATURE_DECREASE = (float)config.get(category, BOName[31], -1.0).getDouble(-1.0);
        float LATE_SUMMER_TEMPERATURE_DECREASE = (float)config.get(category, BOName[32], -1.0).getDouble(-1.0);
        float LATE_WINTER_TEMPERATURE_DECREASE = (float)config.get(category, BOName[33], 10.0).getDouble(10.0);
        float LATE_AUTUMN_TEMPERATURE_DECREASE = (float)config.get(category, BOName[34], 10.0).getDouble(10.0);
        float tempRate_DAWN = (float)config.get(category, BOName[35], 0.0).getDouble(0.0);
        float tempRate_DAY = (float)config.get(category, BOName[36], 0.0).getDouble(0.0);
        float tempRate_DUSK = (float)config.get(category, BOName[37], 0.0).getDouble(0.0);
        float tempRate_NIGHT = (float)config.get(category, BOName[38], 0.0).getDouble(0.0);
        boolean tempRate_HARD = config.get(category, BOName[39], false).getBoolean(false);
        float TemperatureWaterDecrease = (float)config.get(category, BOName[40], 10.0).getDouble(10.0);
        float dropSpeedWater = (float)config.get(category, BOName[41], 0.01).getDouble(0.01);
        float dropSpeedRain = (float)config.get(category, BOName[42], 0.01).getDouble(0.01);
        float dropSpeedThunder = (float)config.get(category, BOName[43], 0.01).getDouble(0.01);
        String SPRING_waterQuality = config.get(category, BOName[44], "CLEAN", "Water Quality at spring").getString();
        String SUMMER_waterQuality = config.get(category, BOName[45], "CLEAN", "Water Quality at summer").getString();
        String AUTUMN_waterQuality = config.get(category, BOName[46], "CLEAN", "Water Quality at autumn").getString();
        String WINTER_waterQuality = config.get(category, BOName[47], "CLEAN", "Water Quality at winter").getString();
        BiomeProperties entry = new BiomeProperties(id, biomeOveride, waterQ, ambTemp, tempRate, sanRate, dehyRate, airRate, filename, TemperatureMultiplier, DAWN_TEMPERATURE_DECREASE, DAY_TEMPERATURE_DECREASE, DUSK_TEMPERATURE_DECREASE, NIGHT_TEMPERATURE_DECREASE, TemperatureRainDecrease, TemperatureThunderDecrease, TemperatureRainBool, TemperatureThunderBool, TemperatureShadeDecrease, ambientTemp_TERRAFORMED, DAWN_TEMPERATURE_DECREASE_TERRAFORMED, DAY_TEMPERATURE_DECREASE_TERRAFORMED, DUSK_TEMPERATURE_DECREASE_TERRAFORMED, NIGHT_TEMPERATURE_DECREASE_TERRAFORMED, EARLY_SPRING_TEMPERATURE_DECREASE, EARLY_SUMMER_TEMPERATURE_DECREASE, EARLY_WINTER_TEMPERATURE_DECREASE, EARLY_AUTUMN_TEMPERATURE_DECREASE, MID_SPRING_TEMPERATURE_DECREASE, MID_SUMMER_TEMPERATURE_DECREASE, MID_WINTER_TEMPERATURE_DECREASE, MID_AUTUMN_TEMPERATURE_DECREASE, LATE_SPRING_TEMPERATURE_DECREASE, LATE_SUMMER_TEMPERATURE_DECREASE, LATE_WINTER_TEMPERATURE_DECREASE, LATE_AUTUMN_TEMPERATURE_DECREASE, tempRate_DAWN, tempRate_DAY, tempRate_DUSK, tempRate_NIGHT, tempRate_HARD, TemperatureWaterDecrease, dropSpeedWater, dropSpeedRain, dropSpeedThunder, SPRING_waterQuality, SUMMER_waterQuality, AUTUMN_waterQuality, WINTER_waterQuality);
        if (EM_Settings.biomeProperties.containsKey(id) && !EM_ConfigHandler.loadedConfigs.contains(filename) && EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
            EnviroMine.logger.log(Level.ERROR, "CONFIG DUPLICATE: Biome ID " + id + " was already added from " + EM_Settings.biomeProperties.get((Object)Integer.valueOf((int)id)).loadedFrom.toUpperCase() + " and will be overriden by " + filename.toUpperCase());
        }
        EM_Settings.biomeProperties.put(id, entry);
    }

    @Override
    public void SaveProperty(Configuration config, String category) {
        config.get(category, BOName[0], this.id).getInt(0);
        config.get(category, BOName[1], this.biomeOveride).getBoolean(this.biomeOveride);
        config.get(category, BOName[2], this.waterQuality, "Water Quality: RADIOACTIVE_FROSTY, FROSTY, RADIOACTIVE_COLD, DIRTY_COLD, SALTY_COLD, CLEAN_COLD, RADIOACTIVE, DIRTY, SALTY, CLEAN, RADIOACTIVE_WARM, DIRTY_WARM, SALTY_WARM, CLEAN_WARM, RADIOACTIVE_HOT, HOT ").getString();
        config.get(category, BOName[3], (double)this.ambientTemp, "Biome temperature in celsius (Player body temp is offset by + 12C)").getDouble((double)this.ambientTemp);
        config.get(category, BOName[4], (double)this.tempRate).getDouble((double)this.tempRate);
        config.get(category, BOName[5], (double)this.sanityRate).getDouble((double)this.sanityRate);
        config.get(category, BOName[6], (double)this.dehydrateRate).getDouble((double)this.dehydrateRate);
        config.get(category, BOName[7], (double)this.airRate).getDouble((double)this.airRate);
        config.get(category, BOName[8], (double)this.TemperatureMultiplier, "The temperatureChange will be multiplied by this number").getDouble((double)this.TemperatureMultiplier);
        config.get(category, BOName[9], (double)this.DAWN_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at dawn").getDouble((double)this.DAWN_TEMPERATURE_DECREASE);
        config.get(category, BOName[10], (double)this.DAY_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at day").getDouble((double)this.DAY_TEMPERATURE_DECREASE);
        config.get(category, BOName[11], (double)this.DUSK_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at dusk").getDouble((double)this.DUSK_TEMPERATURE_DECREASE);
        config.get(category, BOName[12], (double)this.NIGHT_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at midnight").getDouble((double)this.NIGHT_TEMPERATURE_DECREASE);
        config.get(category, BOName[13], (double)this.TemperatureRainDecrease, "Biome temperature decreases by n degrees if it rains").getDouble((double)this.TemperatureRainDecrease);
        config.get(category, BOName[14], (double)this.TemperatureThunderDecrease, "Biome temperature decreases by n degrees if there is a thunderstorm").getDouble((double)this.TemperatureThunderDecrease);
        config.get(category, BOName[15], this.TemperatureRainBool, "Should the biome temperature decreases if it rains?").getBoolean(this.TemperatureRainBool);
        config.get(category, BOName[16], this.TemperatureThunderBool, "Should the biome temperature decreases if there is a thunderstorm?").getBoolean(this.TemperatureThunderBool);
        config.get(category, BOName[17], (double)this.TemperatureShadeDecrease, "Biome temperature decreases by n degrees if player in the shadow").getDouble((double)this.TemperatureShadeDecrease);
        config.get(category, BOName[18], (double)this.ambientTemp_TERRAFORMED, "Air temperature will be equal to this number if the planet is terraformed").getDouble((double)this.ambientTemp_TERRAFORMED);
        config.get(category, BOName[19], (double)this.DAWN_TEMPERATURE_DECREASE_TERRAFORMED, "Biome temperature will decrease by this amount at dawn if the planet is terraformed").getDouble((double)this.DAWN_TEMPERATURE_DECREASE_TERRAFORMED);
        config.get(category, BOName[20], (double)this.DAY_TEMPERATURE_DECREASE_TERRAFORMED, "Biome temperature will decrease by this amount at day if the planet is terraformed").getDouble((double)this.DAY_TEMPERATURE_DECREASE_TERRAFORMED);
        config.get(category, BOName[21], (double)this.DUSK_TEMPERATURE_DECREASE_TERRAFORMED, "Biome temperature will decrease by this amount at dusk if the planet is terraformed").getDouble((double)this.DUSK_TEMPERATURE_DECREASE_TERRAFORMED);
        config.get(category, BOName[22], (double)this.NIGHT_TEMPERATURE_DECREASE_TERRAFORMED, "Biome temperature will decrease by this amount at midnight if the planet is terraformed").getDouble((double)this.NIGHT_TEMPERATURE_DECREASE_TERRAFORMED);
        config.get(category, BOName[23], (double)this.EARLY_SPRING_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at early spring").getDouble((double)this.EARLY_SPRING_TEMPERATURE_DECREASE);
        config.get(category, BOName[24], (double)this.EARLY_SUMMER_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at early summer").getDouble((double)this.EARLY_SUMMER_TEMPERATURE_DECREASE);
        config.get(category, BOName[25], (double)this.EARLY_WINTER_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at early winter").getDouble((double)this.EARLY_WINTER_TEMPERATURE_DECREASE);
        config.get(category, BOName[26], (double)this.EARLY_AUTUMN_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at early autumn").getDouble((double)this.EARLY_AUTUMN_TEMPERATURE_DECREASE);
        config.get(category, BOName[27], (double)this.MID_SPRING_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at mid spring").getDouble((double)this.MID_SPRING_TEMPERATURE_DECREASE);
        config.get(category, BOName[28], (double)this.MID_SUMMER_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at mid summer").getDouble((double)this.MID_SUMMER_TEMPERATURE_DECREASE);
        config.get(category, BOName[29], (double)this.MID_WINTER_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at mid winter").getDouble((double)this.MID_WINTER_TEMPERATURE_DECREASE);
        config.get(category, BOName[30], (double)this.MID_AUTUMN_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at mid autumn").getDouble((double)this.MID_AUTUMN_TEMPERATURE_DECREASE);
        config.get(category, BOName[31], (double)this.LATE_SPRING_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at late spring").getDouble((double)this.LATE_SPRING_TEMPERATURE_DECREASE);
        config.get(category, BOName[32], (double)this.LATE_SUMMER_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at late summer").getDouble((double)this.LATE_SUMMER_TEMPERATURE_DECREASE);
        config.get(category, BOName[33], (double)this.LATE_WINTER_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at late winter").getDouble((double)this.LATE_WINTER_TEMPERATURE_DECREASE);
        config.get(category, BOName[34], (double)this.LATE_AUTUMN_TEMPERATURE_DECREASE, "Biome temperature will decrease by this amount at late autumn").getDouble((double)this.LATE_AUTUMN_TEMPERATURE_DECREASE);
        config.get(category, BOName[35], (double)this.tempRate_DAWN, "Biome temperature rate will be this number at dawn").getDouble((double)this.tempRate_DAWN);
        config.get(category, BOName[36], (double)this.tempRate_DAY, "Biome temperature rate will be this number at day").getDouble((double)this.tempRate_DAY);
        config.get(category, BOName[37], (double)this.tempRate_DUSK, "Biome temperature rate will be this number at dusk").getDouble((double)this.tempRate_DUSK);
        config.get(category, BOName[38], (double)this.tempRate_NIGHT, "Biome temperature rate will be this number at midnight").getDouble((double)this.tempRate_NIGHT);
        config.get(category, BOName[39], this.tempRate_HARD, "The temperature of the biome is so strong that weak suits like MITTY/HEV cannot protect against it").getBoolean(this.tempRate_HARD);
        config.get(category, BOName[40], (double)this.TemperatureWaterDecrease, "Biome temperature decreases by this amount if the player is in water").getDouble((double)this.TemperatureWaterDecrease);
        config.get(category, BOName[41], (double)this.dropSpeedWater, "Biome drop speed will be this number if the player is in water").getDouble((double)this.dropSpeedWater);
        config.get(category, BOName[42], (double)this.dropSpeedRain, "Biome drop speed will be this number if it rains").getDouble((double)this.dropSpeedRain);
        config.get(category, BOName[43], (double)this.dropSpeedThunder, "Biome drop speed will be this number if there is a thunderstorm").getDouble((double)this.dropSpeedThunder);
        config.get(category, BOName[44], this.SPRING_waterQuality, "Water Quality at spring").getString();
        config.get(category, BOName[45], this.SUMMER_waterQuality, "Water Quality at summer").getString();
        config.get(category, BOName[46], this.AUTUMN_waterQuality, "Water Quality at autumn").getString();
        config.get(category, BOName[47], this.WINTER_waterQuality, "Water Quality at winter").getString();
    }

    public void GenDefaultsProperty(BiomeGenBase[] biomeArray) {
        for (BiomeGenBase biome : biomeArray) {
            if (biome == null) continue;
            String modID = ModIdentification.idFromObject(biome);
            File file = new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + EnviroUtils.SafeFilename(modID) + ".cfg");
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (Exception e) {
                    if (EM_Settings.loggerVerbosity < EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) continue;
                    EnviroMine.logger.log(Level.ERROR, "Failed to create file for biome '" + biome.field_76791_y + "'", (Throwable)e);
                    continue;
                }
            }
            Configuration config = new Configuration(file, true);
            config.load();
            this.generateEmpty(config, biome);
            config.save();
        }
    }

    @Override
    public void GenDefaults() {
        BiomeGenBase[] biomeArray = BiomeGenBase.func_150565_n();
        this.GenDefaultsProperty(biomeArray);
        if (EnviroMine.isLOTRLoaded) {
            try {
                BiomeProperties_LOTR.handleLOTRStuff(BOName);
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    @Override
    public File GetDefaultFile() {
        return new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + "Biomes.cfg");
    }

    @Override
    public void generateEmpty(Configuration config, Object obj) {
        double LATE_WINTER_TEMPERATURE_DECREASE;
        double MID_WINTER_TEMPERATURE_DECREASE;
        double EARLY_WINTER_TEMPERATURE_DECREASE;
        double LATE_AUTUMN_TEMPERATURE_DECREASE;
        double MID_AUTUMN_TEMPERATURE_DECREASE;
        double EARLY_AUTUMN_TEMPERATURE_DECREASE;
        double LATE_SUMMER_TEMPERATURE_DECREASE;
        double MID_SUMMER_TEMPERATURE_DECREASE;
        double EARLY_SUMMER_TEMPERATURE_DECREASE;
        double LATE_SPRING_TEMPERATURE_DECREASE;
        double MID_SPRING_TEMPERATURE_DECREASE;
        double EARLY_SPRING_TEMPERATURE_DECREASE;
        String WINTER_waterQuality;
        String AUTUMN_waterQuality;
        String SUMMER_waterQuality;
        String SPRING_waterQuality;
        double TemperatureRainDecrease;
        if (obj == null || !(obj instanceof BiomeGenBase)) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Tried to register config with non biome object!", (Throwable)new Exception());
            }
            return;
        }
        BiomeGenBase biome = (BiomeGenBase)obj;
        ArrayList typeList = new ArrayList();
        BiomeDictionary.Type[] typeArray = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        Collections.addAll(typeList, typeArray);
        double air = typeList.contains(BiomeDictionary.Type.NETHER) ? -0.1 : 0.0;
        double sanity = typeList.contains(BiomeDictionary.Type.NETHER) ? -0.1 : 0.0;
        double water = typeList.contains(BiomeDictionary.Type.NETHER) || typeList.contains(BiomeDictionary.Type.DRY) ? 0.05 : 0.0;
        double temp = typeList.contains(BiomeDictionary.Type.NETHER) || typeList.contains(BiomeDictionary.Type.DRY) ? 0.005 : 0.0;
        double TemperatureMultiplier = 1.0;
        double d = typeList.contains(BiomeDictionary.Type.WATER) ? 8.0 : (TemperatureRainDecrease = typeList.contains(BiomeDictionary.Type.JUNGLE) ? 2.0 : 6.0);
        double TemperatureThunderDecrease = typeList.contains(BiomeDictionary.Type.WATER) ? 10.0 : (typeList.contains(BiomeDictionary.Type.JUNGLE) ? 4.0 : 8.0);
        boolean TemperatureRainBool = true;
        boolean TemperatureThunderBool = true;
        double TemperatureShadeDecrease = 2.5;
        String biomeWater = EnviroUtils.getBiomeWater(biome);
        double biomeTemp = EnviroUtils.getBiomeTemp(biome);
        double DAWN_TEMPERATURE_DECREASE = 4.0;
        double DAY_TEMPERATURE_DECREASE = 0.0;
        double DUSK_TEMPERATURE_DECREASE = 4.0;
        double NIGHT_TEMPERATURE_DECREASE = 8.0;
        double ambientTemp_TERRAFORMED = EnviroUtils.getBiomeTemp(biome);
        double DAWN_TEMPERATURE_DECREASE_TERRAFORMED = 4.0;
        double DAY_TEMPERATURE_DECREASE_TERRAFORMED = 0.0;
        double DUSK_TEMPERATURE_DECREASE_TERRAFORMED = 4.0;
        double NIGHT_TEMPERATURE_DECREASE_TERRAFORMED = 8.0;
        double tempRate_DAWN = temp;
        double tempRate_DAY = temp;
        double tempRate_DUSK = temp;
        double tempRate_NIGHT = temp;
        boolean tempRate_HARD = false;
        float TemperatureWaterDecrease = 10.0f;
        float dropSpeedWater = 0.01f;
        float dropSpeedRain = 0.01f;
        float dropSpeedThunder = 0.01f;
        if (WaterUtils.getTypeFromString((String)EnviroUtils.getBiomeWater((BiomeGenBase)biome)).isSalty) {
            SPRING_waterQuality = EnviroUtils.getBiomeWater(biome);
            SUMMER_waterQuality = WaterUtils.getStringFromType(WaterUtils.forceSaltDown(WaterUtils.heatUp(WaterUtils.getTypeFromString(EnviroUtils.getBiomeWater(biome)))));
            AUTUMN_waterQuality = EnviroUtils.getBiomeWater(biome);
            WINTER_waterQuality = WaterUtils.getStringFromType(WaterUtils.forceSaltDown(WaterUtils.coolDown(WaterUtils.getTypeFromString(EnviroUtils.getBiomeWater(biome)), 2)));
        } else if (WaterUtils.getTypeFromString((String)EnviroUtils.getBiomeWater((BiomeGenBase)biome)).isDirty) {
            SPRING_waterQuality = EnviroUtils.getBiomeWater(biome);
            SUMMER_waterQuality = WaterUtils.getStringFromType(WaterUtils.forcePollute(WaterUtils.heatUp(WaterUtils.getTypeFromString(EnviroUtils.getBiomeWater(biome)))));
            AUTUMN_waterQuality = EnviroUtils.getBiomeWater(biome);
            WINTER_waterQuality = WaterUtils.getStringFromType(WaterUtils.forcePollute(WaterUtils.coolDown(WaterUtils.getTypeFromString(EnviroUtils.getBiomeWater(biome)), 2)));
        } else {
            SPRING_waterQuality = EnviroUtils.getBiomeWater(biome);
            SUMMER_waterQuality = WaterUtils.getStringFromType(WaterUtils.heatUp(WaterUtils.getTypeFromString(EnviroUtils.getBiomeWater(biome))));
            AUTUMN_waterQuality = EnviroUtils.getBiomeWater(biome);
            WINTER_waterQuality = WaterUtils.getStringFromType(WaterUtils.coolDown(WaterUtils.getTypeFromString(EnviroUtils.getBiomeWater(biome)), 2));
        }
        double d2 = typeList.contains(BiomeDictionary.Type.HOT) && typeList.contains(BiomeDictionary.Type.SANDY) ? -3.0 : (typeList.contains(BiomeDictionary.Type.JUNGLE) ? 0.0 : (typeList.contains(BiomeDictionary.Type.HOT) ? 3.0 : (EARLY_SPRING_TEMPERATURE_DECREASE = typeList.contains(BiomeDictionary.Type.CONIFEROUS) ? 7.0 : 5.0)));
        double d3 = typeList.contains(BiomeDictionary.Type.HOT) && typeList.contains(BiomeDictionary.Type.SANDY) ? -10.0 : (typeList.contains(BiomeDictionary.Type.JUNGLE) ? -7.0 : (typeList.contains(BiomeDictionary.Type.HOT) ? -4.0 : (MID_SPRING_TEMPERATURE_DECREASE = typeList.contains(BiomeDictionary.Type.CONIFEROUS) ? 0.0 : -2.0)));
        double d4 = typeList.contains(BiomeDictionary.Type.HOT) && typeList.contains(BiomeDictionary.Type.SANDY) ? -9.0 : (typeList.contains(BiomeDictionary.Type.JUNGLE) ? -6.0 : (typeList.contains(BiomeDictionary.Type.HOT) ? -3.0 : (LATE_SPRING_TEMPERATURE_DECREASE = typeList.contains(BiomeDictionary.Type.CONIFEROUS) ? 1.0 : -1.0)));
        double d5 = typeList.contains(BiomeDictionary.Type.HOT) && typeList.contains(BiomeDictionary.Type.SANDY) ? -9.0 : (typeList.contains(BiomeDictionary.Type.JUNGLE) ? -6.0 : (typeList.contains(BiomeDictionary.Type.HOT) ? -3.0 : (EARLY_SUMMER_TEMPERATURE_DECREASE = typeList.contains(BiomeDictionary.Type.CONIFEROUS) ? 1.0 : -1.0)));
        double d6 = typeList.contains(BiomeDictionary.Type.HOT) && typeList.contains(BiomeDictionary.Type.SANDY) ? -11.0 : (typeList.contains(BiomeDictionary.Type.JUNGLE) ? -8.0 : (typeList.contains(BiomeDictionary.Type.HOT) ? -5.0 : (MID_SUMMER_TEMPERATURE_DECREASE = typeList.contains(BiomeDictionary.Type.CONIFEROUS) ? -1.0 : -3.0)));
        double d7 = typeList.contains(BiomeDictionary.Type.HOT) && typeList.contains(BiomeDictionary.Type.SANDY) ? -9.0 : (typeList.contains(BiomeDictionary.Type.JUNGLE) ? -6.0 : (typeList.contains(BiomeDictionary.Type.HOT) ? -3.0 : (LATE_SUMMER_TEMPERATURE_DECREASE = typeList.contains(BiomeDictionary.Type.CONIFEROUS) ? 1.0 : -1.0)));
        double d8 = typeList.contains(BiomeDictionary.Type.HOT) && typeList.contains(BiomeDictionary.Type.SANDY) ? -2.0 : (typeList.contains(BiomeDictionary.Type.JUNGLE) ? 1.0 : (typeList.contains(BiomeDictionary.Type.HOT) ? 4.0 : (EARLY_AUTUMN_TEMPERATURE_DECREASE = typeList.contains(BiomeDictionary.Type.CONIFEROUS) ? 8.0 : 6.0)));
        double d9 = typeList.contains(BiomeDictionary.Type.HOT) && typeList.contains(BiomeDictionary.Type.SANDY) ? 0.0 : (typeList.contains(BiomeDictionary.Type.JUNGLE) ? 3.0 : (typeList.contains(BiomeDictionary.Type.HOT) ? 6.0 : (MID_AUTUMN_TEMPERATURE_DECREASE = typeList.contains(BiomeDictionary.Type.CONIFEROUS) ? 10.0 : 8.0)));
        double d10 = typeList.contains(BiomeDictionary.Type.HOT) && typeList.contains(BiomeDictionary.Type.SANDY) ? -2.0 : (typeList.contains(BiomeDictionary.Type.JUNGLE) ? 5.0 : (typeList.contains(BiomeDictionary.Type.HOT) ? 8.0 : (LATE_AUTUMN_TEMPERATURE_DECREASE = typeList.contains(BiomeDictionary.Type.CONIFEROUS) ? 12.0 : 10.0)));
        double d11 = typeList.contains(BiomeDictionary.Type.HOT) && typeList.contains(BiomeDictionary.Type.SANDY) ? 4.0 : (typeList.contains(BiomeDictionary.Type.JUNGLE) ? 7.0 : (typeList.contains(BiomeDictionary.Type.HOT) ? 10.0 : (EARLY_WINTER_TEMPERATURE_DECREASE = typeList.contains(BiomeDictionary.Type.CONIFEROUS) ? 14.0 : 12.0)));
        double d12 = typeList.contains(BiomeDictionary.Type.HOT) && typeList.contains(BiomeDictionary.Type.SANDY) ? 8.0 : (typeList.contains(BiomeDictionary.Type.JUNGLE) ? 11.0 : (typeList.contains(BiomeDictionary.Type.HOT) ? 14.0 : (MID_WINTER_TEMPERATURE_DECREASE = typeList.contains(BiomeDictionary.Type.CONIFEROUS) ? 18.0 : 16.0)));
        double d13 = typeList.contains(BiomeDictionary.Type.HOT) && typeList.contains(BiomeDictionary.Type.SANDY) ? 2.0 : (typeList.contains(BiomeDictionary.Type.JUNGLE) ? 5.0 : (typeList.contains(BiomeDictionary.Type.HOT) ? 8.0 : (LATE_WINTER_TEMPERATURE_DECREASE = typeList.contains(BiomeDictionary.Type.CONIFEROUS) ? 12.0 : 10.0)));
        if (EnviroMine.isHbmLoaded) {
            try {
                BiomeProperties_NTM.registerNTMBiomes(config, biome, BOName, biomeWater, biomeTemp, DAWN_TEMPERATURE_DECREASE, DAY_TEMPERATURE_DECREASE, DUSK_TEMPERATURE_DECREASE, NIGHT_TEMPERATURE_DECREASE, ambientTemp_TERRAFORMED, SPRING_waterQuality, SUMMER_waterQuality, AUTUMN_waterQuality, WINTER_waterQuality);
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
        if (EnviroMine.isHbmSpaceLoaded) {
            try {
                BiomeProperties_NTM_SPACE.registerNTMSpaceBiomes(config, biome, BOName, biomeWater, biomeTemp, DAWN_TEMPERATURE_DECREASE, DAY_TEMPERATURE_DECREASE, DUSK_TEMPERATURE_DECREASE, NIGHT_TEMPERATURE_DECREASE, ambientTemp_TERRAFORMED, DAWN_TEMPERATURE_DECREASE_TERRAFORMED, DAY_TEMPERATURE_DECREASE_TERRAFORMED, DUSK_TEMPERATURE_DECREASE_TERRAFORMED, NIGHT_TEMPERATURE_DECREASE_TERRAFORMED, tempRate_DAWN, tempRate_DAY, tempRate_DUSK, tempRate_NIGHT, tempRate_HARD);
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
        String catName = this.categoryName() + "." + biome.field_76791_y;
        config.get(catName, BOName[0], biome.field_76756_M).getInt(biome.field_76756_M);
        config.get(catName, BOName[1], true).getBoolean(true);
        config.get(catName, BOName[2], biomeWater, "Water Quality: RADIOACTIVE_FROSTY, FROSTY, RADIOACTIVE_COLD, DIRTY_COLD, SALTY_COLD, CLEAN_COLD, RADIOACTIVE, DIRTY, SALTY, CLEAN, RADIOACTIVE_WARM, DIRTY_WARM, SALTY_WARM, CLEAN_WARM, RADIOACTIVE_HOT, HOT ").getString();
        config.get(catName, BOName[3], biomeTemp, "Biome temperature in celsius (Player body temp is offset by + 12C)").getDouble(25.0);
        config.get(catName, BOName[4], temp).getDouble(temp);
        config.get(catName, BOName[5], sanity).getDouble(sanity);
        config.get(catName, BOName[6], water).getDouble(water);
        config.get(catName, BOName[7], air).getDouble(air);
        config.get(catName, BOName[8], TemperatureMultiplier).getDouble(TemperatureMultiplier);
        config.get(catName, BOName[9], DAWN_TEMPERATURE_DECREASE).getDouble(DAWN_TEMPERATURE_DECREASE);
        config.get(catName, BOName[10], DAY_TEMPERATURE_DECREASE).getDouble(DAY_TEMPERATURE_DECREASE);
        config.get(catName, BOName[11], DUSK_TEMPERATURE_DECREASE).getDouble(DUSK_TEMPERATURE_DECREASE);
        config.get(catName, BOName[12], NIGHT_TEMPERATURE_DECREASE).getDouble(NIGHT_TEMPERATURE_DECREASE);
        config.get(catName, BOName[13], TemperatureRainDecrease).getDouble(TemperatureRainDecrease);
        config.get(catName, BOName[14], TemperatureThunderDecrease).getDouble(TemperatureThunderDecrease);
        config.get(catName, BOName[15], TemperatureRainBool).getBoolean(TemperatureRainBool);
        config.get(catName, BOName[16], TemperatureThunderBool).getBoolean(TemperatureThunderBool);
        config.get(catName, BOName[17], TemperatureShadeDecrease).getDouble(TemperatureShadeDecrease);
        config.get(catName, BOName[18], ambientTemp_TERRAFORMED).getDouble(ambientTemp_TERRAFORMED);
        config.get(catName, BOName[19], DAWN_TEMPERATURE_DECREASE_TERRAFORMED).getDouble(DAWN_TEMPERATURE_DECREASE_TERRAFORMED);
        config.get(catName, BOName[20], DAY_TEMPERATURE_DECREASE_TERRAFORMED).getDouble(DAY_TEMPERATURE_DECREASE_TERRAFORMED);
        config.get(catName, BOName[21], DUSK_TEMPERATURE_DECREASE_TERRAFORMED).getDouble(DUSK_TEMPERATURE_DECREASE_TERRAFORMED);
        config.get(catName, BOName[22], NIGHT_TEMPERATURE_DECREASE_TERRAFORMED).getDouble(NIGHT_TEMPERATURE_DECREASE_TERRAFORMED);
        config.get(catName, BOName[23], EARLY_SPRING_TEMPERATURE_DECREASE).getDouble(EARLY_SPRING_TEMPERATURE_DECREASE);
        config.get(catName, BOName[24], EARLY_SUMMER_TEMPERATURE_DECREASE).getDouble(EARLY_SUMMER_TEMPERATURE_DECREASE);
        config.get(catName, BOName[25], EARLY_WINTER_TEMPERATURE_DECREASE).getDouble(EARLY_WINTER_TEMPERATURE_DECREASE);
        config.get(catName, BOName[26], EARLY_AUTUMN_TEMPERATURE_DECREASE).getDouble(EARLY_AUTUMN_TEMPERATURE_DECREASE);
        config.get(catName, BOName[27], MID_SPRING_TEMPERATURE_DECREASE).getDouble(MID_SPRING_TEMPERATURE_DECREASE);
        config.get(catName, BOName[28], MID_SUMMER_TEMPERATURE_DECREASE).getDouble(MID_SUMMER_TEMPERATURE_DECREASE);
        config.get(catName, BOName[29], MID_WINTER_TEMPERATURE_DECREASE).getDouble(MID_WINTER_TEMPERATURE_DECREASE);
        config.get(catName, BOName[30], MID_AUTUMN_TEMPERATURE_DECREASE).getDouble(MID_AUTUMN_TEMPERATURE_DECREASE);
        config.get(catName, BOName[31], LATE_SPRING_TEMPERATURE_DECREASE).getDouble(LATE_SPRING_TEMPERATURE_DECREASE);
        config.get(catName, BOName[32], LATE_SUMMER_TEMPERATURE_DECREASE).getDouble(LATE_SUMMER_TEMPERATURE_DECREASE);
        config.get(catName, BOName[33], LATE_WINTER_TEMPERATURE_DECREASE).getDouble(LATE_WINTER_TEMPERATURE_DECREASE);
        config.get(catName, BOName[34], LATE_AUTUMN_TEMPERATURE_DECREASE).getDouble(LATE_AUTUMN_TEMPERATURE_DECREASE);
        config.get(catName, BOName[35], tempRate_DAWN).getDouble(tempRate_DAWN);
        config.get(catName, BOName[36], tempRate_DAY).getDouble(tempRate_DAY);
        config.get(catName, BOName[37], tempRate_DUSK).getDouble(tempRate_DUSK);
        config.get(catName, BOName[38], tempRate_NIGHT).getDouble(tempRate_NIGHT);
        config.get(catName, BOName[39], tempRate_HARD).getBoolean(tempRate_HARD);
        config.get(catName, BOName[40], (double)TemperatureWaterDecrease).getDouble((double)TemperatureWaterDecrease);
        config.get(catName, BOName[41], (double)dropSpeedWater).getDouble((double)dropSpeedWater);
        config.get(catName, BOName[42], (double)dropSpeedRain).getDouble((double)dropSpeedRain);
        config.get(catName, BOName[43], (double)dropSpeedThunder).getDouble((double)dropSpeedThunder);
        config.get(catName, BOName[44], SPRING_waterQuality, "Water Quality at spring").getString();
        config.get(catName, BOName[45], SUMMER_waterQuality, "Water Quality at summer").getString();
        config.get(catName, BOName[46], AUTUMN_waterQuality, "Water Quality at autumn").getString();
        config.get(catName, BOName[47], WINTER_waterQuality, "Water Quality at winter").getString();
    }

    @Override
    public boolean useCustomConfigs() {
        return true;
    }

    @Override
    public void customLoad() {
    }

    static {
        BiomeProperties.BOName[0] = "01.Biome ID";
        BiomeProperties.BOName[1] = "02.Allow Config Override";
        BiomeProperties.BOName[2] = "03.Water Quality";
        BiomeProperties.BOName[3] = "04.Ambient Temperature";
        BiomeProperties.BOName[4] = "05.Temperature Rate";
        BiomeProperties.BOName[5] = "06.Sanity Rate";
        BiomeProperties.BOName[6] = "07.Dehydrate Rate";
        BiomeProperties.BOName[7] = "08.Air Quality Rate";
        BiomeProperties.BOName[8] = "09.Temperature Multiplier";
        BiomeProperties.BOName[9] = "10.Dawn Biome Temperature Decrease";
        BiomeProperties.BOName[10] = "11.Day Biome Temperature Decrease";
        BiomeProperties.BOName[11] = "12.Dusk Biome Temperature Decrease";
        BiomeProperties.BOName[12] = "13.Night Biome Temperature Decrease";
        BiomeProperties.BOName[13] = "14.Biome Temperature Rain Decrease";
        BiomeProperties.BOName[14] = "15.Biome Temperature Thunder Decrease";
        BiomeProperties.BOName[15] = "16.Should Biome Temperature Decrease When Rain?";
        BiomeProperties.BOName[16] = "17.Should Biome Temperature Decrease When Thunder?";
        BiomeProperties.BOName[17] = "18.Biome Temperature Shadow Decrease";
        BiomeProperties.BOName[18] = "19.[HBM] Ambient Temperature Terraformed";
        BiomeProperties.BOName[19] = "20.[HBM] Dawn Biome Temperature Decrease Terraformed";
        BiomeProperties.BOName[20] = "21.[HBM] Day Biome Temperature Decrease Terraformed";
        BiomeProperties.BOName[21] = "22.[HBM] Dusk Biome Temperature Decrease Terraformed";
        BiomeProperties.BOName[22] = "23.[HBM] Night Biome Temperature Decrease Terraformed";
        BiomeProperties.BOName[23] = "24.[Serene Seasons] Early Spring Biome Temperature Decrease";
        BiomeProperties.BOName[24] = "25.[Serene Seasons] Early Summer Biome Temperature Decrease";
        BiomeProperties.BOName[25] = "26.[Serene Seasons] Early Winter Biome Temperature Decrease";
        BiomeProperties.BOName[26] = "27.[Serene Seasons] Early Autumn Biome Temperature Decrease";
        BiomeProperties.BOName[27] = "28.[Serene Seasons] Mid Spring Biome Temperature Decrease";
        BiomeProperties.BOName[28] = "29.[Serene Seasons] Mid Summer Biome Temperature Decrease";
        BiomeProperties.BOName[29] = "30.[Serene Seasons] Mid Winter Biome Temperature Decrease";
        BiomeProperties.BOName[30] = "31.[Serene Seasons] Mid Autumn Biome Temperature Decrease";
        BiomeProperties.BOName[31] = "32.[Serene Seasons] Late Spring Biome Temperature Decrease";
        BiomeProperties.BOName[32] = "33.[Serene Seasons] Late Summer Biome Temperature Decrease";
        BiomeProperties.BOName[33] = "34.[Serene Seasons] Late Winter Biome Temperature Decrease";
        BiomeProperties.BOName[34] = "35.[Serene Seasons] Late Autumn Biome Temperature Decrease";
        BiomeProperties.BOName[35] = "36.Dawn Biome Temperature Rate";
        BiomeProperties.BOName[36] = "37.Day Biome Temperature Rate";
        BiomeProperties.BOName[37] = "38.Dusk Biome Temperature Rate";
        BiomeProperties.BOName[38] = "39.Night Biome Temperature Rate";
        BiomeProperties.BOName[39] = "40.[HBM] Hard Biome Temperature Rate";
        BiomeProperties.BOName[40] = "41.Ambient Temperature Decrease Water";
        BiomeProperties.BOName[41] = "42.Drop Speed Water";
        BiomeProperties.BOName[42] = "43.Drop Speed Rain";
        BiomeProperties.BOName[43] = "44.Drop Speed Thunder";
        BiomeProperties.BOName[44] = "45.[Serene Seasons] Water Quality Spring";
        BiomeProperties.BOName[45] = "46.[Serene Seasons] Water Quality Summer";
        BiomeProperties.BOName[46] = "47.[Serene Seasons] Water Quality Autumn";
        BiomeProperties.BOName[47] = "48.[Serene Seasons] Water Quality Winter";
    }
}

