/*
 * Decompiled with CFR 0.152.
 */
package enviromine.network.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.network.packet.PacketServerOverride;
import enviromine.trackers.properties.helpers.SerialisableProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.Level;

public class PacketAutoOverride
extends PacketServerOverride
implements IMessage {
    public PacketAutoOverride() {
        if (!EnviroMine.proxy.isClient()) {
            this.tags = this.readFromSettings();
        }
    }

    private NBTTagCompound readFromSettings() {
        Field[] fields;
        NBTTagCompound nTags = new NBTTagCompound();
        for (Field f : fields = EM_Settings.class.getFields()) {
            try {
                EM_Settings.ShouldOverride anno = f.getAnnotation(EM_Settings.ShouldOverride.class);
                if (anno == null) continue;
                if (!f.isAccessible()) {
                    if (EM_Settings.loggerVerbosity < EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) continue;
                    EnviroMine.logger.log(Level.WARN, "Field " + f.getName() + " is protected and cannot be synced!");
                    continue;
                }
                if (!Modifier.isStatic(f.getModifiers())) {
                    if (EM_Settings.loggerVerbosity < EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) continue;
                    EnviroMine.logger.log(Level.WARN, "Cannot sync non-static field " + f.getName() + "!");
                    continue;
                }
                if (f.getType() == HashMap.class) {
                    HashMap map = (HashMap)f.get(null);
                    Set keys = map.keySet();
                    Iterator iterator = keys.iterator();
                    NBTTagList nbtList = new NBTTagList();
                    while (iterator.hasNext()) {
                        NBTTagCompound entry = new NBTTagCompound();
                        Object keyObj = iterator.next();
                        Object valObj = map.get(keyObj);
                        this.setNBTValue(entry, "key", keyObj);
                        this.setNBTValue(entry, "value", valObj);
                        nbtList.func_74742_a((NBTBase)entry);
                    }
                    nTags.func_74782_a(f.getName(), (NBTBase)nbtList);
                    continue;
                }
                if (f.getType() == ArrayList.class) {
                    ArrayList list = (ArrayList)f.get(null);
                    Iterator iterator = list.iterator();
                    NBTTagList nbtList = new NBTTagList();
                    while (iterator.hasNext()) {
                        NBTTagCompound entry = new NBTTagCompound();
                        Object valObj = iterator.next();
                        this.setNBTValue(entry, "value", valObj);
                        nbtList.func_74742_a((NBTBase)entry);
                    }
                    nTags.func_74782_a(f.getName(), (NBTBase)nbtList);
                    continue;
                }
                this.setNBTValue(nTags, f.getName(), f.get(null));
            }
            catch (Exception e) {
                if (EM_Settings.loggerVerbosity < EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) continue;
                EnviroMine.logger.log(Level.ERROR, "An error occured while syncing setting " + f.getName(), (Throwable)e);
            }
        }
        return nTags;
    }

    public void setNBTValue(NBTTagCompound tag, String key, Object value) {
        if (key == null || key.length() <= 0 || value == null) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Tried to set NBTTagCompound without a value and or key!");
            }
            return;
        }
        if (value instanceof Boolean) {
            tag.func_74757_a(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            tag.func_74768_a(key, ((Integer)value).intValue());
        } else if (value instanceof String) {
            tag.func_74778_a(key, (String)value);
        } else if (value instanceof Byte) {
            tag.func_74774_a(key, ((Byte)value).byteValue());
        } else if (value instanceof Float) {
            tag.func_74776_a(key, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            tag.func_74780_a(key, ((Double)value).doubleValue());
        } else if (value instanceof Short) {
            tag.func_74777_a(key, ((Short)value).shortValue());
        } else if (value instanceof Long) {
            tag.func_74772_a(key, ((Long)value).longValue());
        } else if (value instanceof Byte[]) {
            tag.func_74773_a(key, (byte[])value);
        } else if (value instanceof NBTBase) {
            tag.func_74782_a(key, (NBTBase)value);
        } else if (value instanceof SerialisableProperty) {
            tag.func_74782_a(key, (NBTBase)((SerialisableProperty)value).WriteToNBT());
        } else if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
            EnviroMine.logger.log(Level.ERROR, "Cannot set NBTTagCompound a value type of " + value.getClass().getSimpleName());
        }
    }

    public static class Handler
    implements IMessageHandler<PacketAutoOverride, IMessage> {
        public IMessage onMessage(PacketAutoOverride message, MessageContext ctx) {
            return new PacketServerOverride.Handler().onMessage(message, ctx);
        }
    }
}

