/*
 * Decompiled with CFR 0.152.
 */
package enviromine.gases.types;

import api.hbm.item.IGasMask;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.ArmorUtil;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.gases.EnviroGas;
import enviromine.gases.EnviroGasDictionary;
import enviromine.handlers.ObjectHandler;
import enviromine.trackers.EnviroDataTracker;
import enviromine.utils.EnviroUtils;
import enviromine.utils.misc.CompatDanger;
import java.awt.Color;
import mekanism.common.item.ItemGasMask;
import mekanism.common.item.ItemScubaTank;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

@CompatDanger
public class GasCarbonMonoxide
extends EnviroGas {
    boolean isCreative = false;
    boolean hasGasMask = false;
    boolean isHbmMask = false;

    public GasCarbonMonoxide(String name, int id) {
        super(name, id);
        this.setColor(new Color(64, 64, 64, 64));
        this.setDensity(-1.0f);
        this.setDecayRates(1, 0, 1, 100, 1, 100);
        this.setSuffocation(0.1f);
    }

    @Override
    public int getGasOnDeath(World world, int i, int j, int k) {
        return EnviroGasDictionary.carbonDioxide.gasID;
    }

    @Override
    public void applyEffects(EntityLivingBase entityLiving, int amplifier) {
        super.applyEffects(entityLiving, amplifier);
        if (entityLiving instanceof EntityPlayer) {
            this.isCreative = ((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d;
        }
        if (entityLiving.field_70170_p.field_72995_K || entityLiving.func_70662_br()) {
            return;
        }
        ItemStack helmet = entityLiving.func_71124_b(4);
        if (helmet != null && !this.isCreative && EnviroMine.isHbmLoaded) {
            Item item = helmet.func_77973_b();
            if (item instanceof IGasMask) {
                IGasMask mask = (IGasMask)item;
                ItemStack filter = mask.getFilter(helmet, entityLiving);
                if (filter != null) {
                    if (ArmorRegistry.hasProtection((EntityLivingBase)entityLiving, (int)3, (ArmorRegistry.HazardClass)ArmorRegistry.HazardClass.GAS_MONOXIDE)) {
                        this.hasGasMask = true;
                        this.isHbmMask = true;
                        if (entityLiving.func_70681_au().nextInt(Math.max(EM_Settings.HbmGasMaskBreakChanceNumber - 10, 1)) == 0) {
                            ArmorUtil.damageGasMaskFilter((EntityLivingBase)entityLiving, (int)MathHelper.func_76141_d((float)(1.5f * (float)EM_Settings.HbmGasMaskBreakMultiplier)));
                        }
                    } else {
                        this.hasGasMask = false;
                        this.isHbmMask = false;
                    }
                } else {
                    this.hasGasMask = false;
                    this.isHbmMask = false;
                }
            } else if (ArmorRegistry.hasProtection((EntityLivingBase)entityLiving, (int)3, (ArmorRegistry.HazardClass)ArmorRegistry.HazardClass.GAS_MONOXIDE)) {
                this.hasGasMask = true;
                this.isHbmMask = true;
                if (entityLiving.func_70681_au().nextInt(Math.max(EM_Settings.HbmGasMaskBreakChanceNumber - 10, 1)) == 0) {
                    ArmorUtil.damageGasMaskFilter((EntityLivingBase)entityLiving, (int)MathHelper.func_76141_d((float)(1.5f * (float)EM_Settings.HbmGasMaskBreakMultiplier)));
                }
            } else {
                this.hasGasMask = false;
                this.isHbmMask = false;
            }
        } else {
            this.hasGasMask = false;
            this.isHbmMask = false;
        }
        if (helmet != null && !this.isCreative && !this.isHbmMask) {
            if (entityLiving.func_71124_b(4).func_77973_b() == ObjectHandler.gasMask) {
                if (helmet.func_77942_o() && helmet.func_77978_p().func_74764_b("gasMaskFill")) {
                    NBTTagCompound tag = helmet.func_77978_p();
                    int maskFill = tag.func_74762_e("gasMaskFill");
                    if (maskFill > 0) {
                        this.hasGasMask = true;
                        if (entityLiving.field_70173_aa % 20 == 0) {
                            int newMaskQuality = maskFill - MathHelper.func_76141_d((float)(1.0f * (float)EM_Settings.EnviromineGasMaskBreakMultiplier));
                            if (newMaskQuality < 0) {
                                newMaskQuality = 0;
                            }
                            tag.func_74768_a("gasMaskFill", newMaskQuality);
                        }
                    } else {
                        this.hasGasMask = false;
                    }
                } else {
                    this.hasGasMask = false;
                }
            } else {
                this.hasGasMask = false;
            }
        } else if (!this.isHbmMask) {
            this.hasGasMask = false;
        }
        if (!this.hasGasMask && helmet != null && !this.isCreative && EnviroMine.isMCELoaded) {
            ItemScubaTank tank;
            Item item;
            this.hasGasMask = helmet.func_77973_b() instanceof ItemGasMask ? (entityLiving.func_71124_b(3) != null && (item = entityLiving.func_71124_b(3).func_77973_b()) instanceof ItemScubaTank ? (tank = (ItemScubaTank)item).getFlowing(entityLiving.func_71124_b(3)) && tank.getGas(entityLiving.func_71124_b(3)) != null : false) : false;
        }
        if (EM_Settings.CarbonMonoxideGasDebugLogger) {
            EnviroDataTracker.logger.warn("CarbonMonoxide: amplifier:  " + amplifier);
            EnviroDataTracker.logger.warn("CarbonMonoxide: hasGasMask:  " + this.hasGasMask);
            EnviroDataTracker.logger.warn("CarbonMonoxide: isCreative:  " + this.isCreative);
            EnviroDataTracker.logger.warn("CarbonMonoxide: entityLiving.getRNG().nextInt(CarbonMonoxidePoisoningChance) == 0?:  " + (entityLiving.func_70681_au().nextInt(EM_Settings.CarbonMonoxidePoisoningChance) == 0));
        }
        if (!this.hasGasMask && !this.isCreative && amplifier >= EM_Settings.CarbonMonoxidePoisoningAmplifier + (EM_Settings.witcheryVampireImmunities && entityLiving instanceof EntityPlayer ? EnviroUtils.getWitcheryVampireLevel((Entity)entityLiving) : 0) && entityLiving.func_70681_au().nextInt(EM_Settings.CarbonMonoxidePoisoningChance) == 0) {
            entityLiving.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, EM_Settings.CarbonMonoxidePoisoningTime, EM_Settings.CarbonMonoxidePoisoningLevel));
        }
    }
}

