/*
 * Decompiled with CFR 0.152.
 */
package enviromine.client.gui.menu.config;

import cpw.mods.fml.client.config.DummyConfigElement;
import cpw.mods.fml.client.config.GuiConfig;
import cpw.mods.fml.client.config.IConfigElement;
import cpw.mods.fml.common.registry.EntityRegistry;
import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.trackers.properties.ArmorProperties;
import enviromine.trackers.properties.BlockProperties;
import enviromine.trackers.properties.CaveBaseProperties;
import enviromine.trackers.properties.EntityProperties;
import enviromine.trackers.properties.ItemProperties;
import enviromine.trackers.properties.StabilityType;
import enviromine.utils.EnviroUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;

public class EM_ConfigMenu
extends GuiConfig {
    public static ArrayList<Configuration> tempConfigs = new ArrayList();

    public EM_ConfigMenu(GuiScreen parentScreen) {
        super(parentScreen, EM_ConfigMenu.getMainElements(), "enviromine", false, false, "EnviroMine", " ");
    }

    public EM_ConfigMenu(List<IConfigElement> list, Configuration config) {
        super(null, list, "enviromine", false, false, "EnviroMine", " ");
        tempConfigs.clear();
        tempConfigs.add(config);
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
    }

    protected void func_73864_a(int p_73864_1_, int p_73864_2_, int p_73864_3_) {
        super.func_73864_a(p_73864_1_, p_73864_2_, p_73864_3_);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    private static List<IConfigElement> getMainElements() {
        tempConfigs.clear();
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        File mainFile = new File(EM_ConfigHandler.configPath + "Global_Settings.cfg");
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Global Config", "editor.enviromine.global", EM_ConfigMenu.getConfigElements(mainFile)));
        File profilSettings = new File(EM_ConfigHandler.loadedProfile + EM_Settings.profileSelected + "_Settings.cfg");
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Profile Settings", "editor.enviromine.settings", EM_ConfigMenu.getConfigElements(profilSettings)));
        File caveFile = CaveBaseProperties.base.GetDefaultFile();
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Cave Dimension", "editor.enviromine.cave", EM_ConfigMenu.getConfigElements(caveFile)));
        File stabFile = StabilityType.base.GetDefaultFile();
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Stability Types", "editor.enviromine.stability", EM_ConfigMenu.getConfigElements(stabFile)));
        File[] customFiles = new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath).listFiles();
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Custom Configs", "editor.enviromine.custom", EM_ConfigMenu.getConfigElements(customFiles)));
        return list;
    }

    private static List<IConfigElement> getConfigElements(File ... files) {
        ArrayList<IConfigElement> customFileList = new ArrayList<IConfigElement>();
        for (File entry : files) {
            if (entry.getName().contains(".DS_Store")) continue;
            Configuration config = new Configuration(entry, true);
            tempConfigs.add(config);
            Iterator iterator = config.getCategoryNames().iterator();
            ArrayList<ConfigElement> customConfigList = new ArrayList<ConfigElement>();
            while (iterator.hasNext()) {
                ConfigCategory category = config.getCategory((String)iterator.next());
                if (category.isChild()) continue;
                customConfigList.add(new ConfigElement(category));
            }
            customFileList.add((IConfigElement)new DummyConfigElement.DummyCategoryElement(entry.getName(), "", customConfigList));
        }
        return customFileList;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"editor.enviromine.currentProfile", (Object[])new Object[0]) + ": " + EM_ConfigHandler.getProfileName(), this.field_146294_l / 2, 18, 0xFFFFFF);
    }

    private static String getCatFromObj(Object obj, Object type) {
        String catName = "";
        if (type instanceof BlockProperties) {
            Block block = (Block)obj;
            catName = BlockProperties.base.categoryName() + "." + EnviroUtils.replaceULN(block.func_149739_a());
        } else if (type instanceof ItemProperties) {
            Item item = (Item)obj;
            catName = ItemProperties.base.categoryName() + "." + EnviroUtils.replaceULN(item.func_77658_a());
        } else if (type instanceof ArmorProperties) {
            ItemArmor armor = (ItemArmor)obj;
            catName = ArmorProperties.base.categoryName() + "." + EnviroUtils.replaceULN(armor.func_77658_a());
        } else if (type instanceof EntityProperties) {
            Entity en = (Entity)obj;
            int id = 0;
            if (EntityList.func_75619_a((Entity)en) > 0) {
                id = EntityList.func_75619_a((Entity)en);
            } else if (EntityRegistry.instance().lookupModSpawn(en.getClass(), false) != null) {
                id = EntityRegistry.instance().lookupModSpawn(en.getClass(), false).getModEntityId() + 128;
            }
            catName = EntityProperties.base.categoryName() + "." + EntityList.func_75617_a((int)id);
        }
        return catName;
    }

    public static boolean ElementExist(Object obj, Object type) {
        Configuration config = EM_ConfigHandler.getConfigFromObj(obj);
        String catName = EM_ConfigMenu.getCatFromObj(obj, type);
        return config.hasCategory(catName);
    }

    public static List<IConfigElement> GetElement(Configuration config, Object obj, Object type) {
        ArrayList<IConfigElement> configElements = new ArrayList<IConfigElement>();
        String catName = EM_ConfigMenu.getCatFromObj(obj, type);
        if (config.hasCategory(catName)) {
            ConfigCategory catconfig = config.getCategory(catName);
            ConfigElement element = new ConfigElement(catconfig);
            configElements.add((IConfigElement)element);
            config = null;
            return configElements;
        }
        config = null;
        return null;
    }
}

