/*
 * Decompiled with CFR 0.152.
 */
package enviromine.client.gui.hud;

import enviromine.client.gui.UI_Settings;
import enviromine.client.gui.hud.HUDRegistry;
import enviromine.utils.Alignment;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public abstract class HudItem {
    public Alignment alignment = this.getDefaultAlignment();
    public int posX = this.getDefaultPosX();
    public int posY = this.getDefaultPosY();
    public int phase = 0;
    private int id = this.getDefaultID();
    public boolean rotated = false;
    public boolean blink = false;
    public static int blinkTick = 0;

    public abstract String getName();

    public abstract String getNameLoc();

    public abstract String getButtonLabel();

    public abstract Alignment getDefaultAlignment();

    public abstract int getDefaultPosX();

    public abstract int getDefaultPosY();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract ResourceLocation getResource(String var1);

    public abstract boolean isBlinking();

    public abstract int getDefaultID();

    public abstract void render();

    public abstract void renderScreenOverlay(int var1, int var2);

    public int getTextFrameWidth() {
        if (!UI_Settings.ShowText || this.rotated) {
            return 0;
        }
        return 32;
    }

    public int getIconPosX() {
        if (UI_Settings.minimalHud && !this.rotated) {
            if (!this.isLeftSide()) {
                return this.posX - this.getTextFrameWidth() - 16;
            }
            return this.posX + this.getTextFrameWidth();
        }
        if (this.rotated) {
            return this.posX - 16 + this.getHeight() / 2;
        }
        if (!this.isLeftSide()) {
            return this.posX - this.getTextFrameWidth() - 16 + (this.rotated ? this.getHeight() / 2 : 0);
        }
        return this.posX + this.getWidth() + this.getTextFrameWidth();
    }

    public int getTextPosX() {
        if (UI_Settings.minimalHud) {
            if (!this.isLeftSide()) {
                return this.posX - this.getTextFrameWidth();
            }
            return this.posX;
        }
        if (!this.isLeftSide()) {
            return this.posX - this.getTextFrameWidth();
        }
        return this.posX + this.getWidth();
    }

    public int getTotalBarWidth() {
        return this.getWidth() + this.getTextFrameWidth() + 16;
    }

    public boolean isLeftSide() {
        boolean Side2 = false;
        int ScreenHalf = HUDRegistry.screenWidth / 2;
        int BarPos = this.getTotalBarWidth() / 2 + this.posX;
        if (BarPos <= ScreenHalf) {
            Side2 = true;
        }
        return Side2;
    }

    public void rotate() {
        this.rotated = !this.rotated;
    }

    public boolean blink() {
        if (blinkTick >= 60) {
            this.blink = !this.blink;
            blinkTick = 1;
        }
        return this.blink;
    }

    public void tick() {
    }

    public boolean needsTick() {
        return false;
    }

    public boolean isMoveable() {
        return true;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean isRenderedInCreative() {
        return true;
    }

    public void fixBounds() {
        this.posX = Math.max(0, Math.min(HUDRegistry.screenWidth - (int)((float)this.getWidth() * UI_Settings.guiScale), this.posX));
        this.posY = Math.max(0, Math.min(HUDRegistry.screenHeight - (int)((float)this.getHeight() * UI_Settings.guiScale), this.posY));
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        this.posX = nbt.func_74764_b("posX") ? nbt.func_74762_e("posX") : this.getDefaultPosX();
        this.posY = nbt.func_74764_b("posY") ? nbt.func_74762_e("posY") : this.getDefaultPosY();
        this.alignment = nbt.func_74764_b("alignment") ? Alignment.fromString(nbt.func_74779_i("alignment")) : this.getDefaultAlignment();
        this.id = nbt.func_74764_b("id") ? nbt.func_74762_e("id") : this.getDefaultID();
        this.rotated = nbt.func_74764_b("rotated") ? nbt.func_74767_n("rotated") : false;
    }

    public void saveToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("posX", this.posX);
        nbt.func_74768_a("posY", this.posY);
        nbt.func_74778_a("alignment", this.alignment.toString());
        nbt.func_74768_a("id", this.id);
        nbt.func_74757_a("rotated", this.rotated);
    }

    public boolean shouldDrawOnMount() {
        return true;
    }

    public boolean shouldDrawAsPlayer() {
        return true;
    }

    public boolean canRotate() {
        return true;
    }
}

