/*
 * Decompiled with CFR 0.152.
 */
package enviromine.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enviromine.client.gui.UI_Settings;
import enviromine.client.gui.hud.HUDRegistry;
import enviromine.client.gui.hud.HudItem;
import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ReportedException;

@SideOnly(value=Side.CLIENT)
public class SaveController {
    static final String CONFIG_VERSION = "1.0.0";
    static String LOADED_VERSION = "1.0.0";
    protected static final String dirName = Minecraft.func_71410_x().field_71412_D + File.separator + "config" + File.separator + "enviromine";
    protected static File dir = new File(dirName);
    public static String UISettingsData = "UI_Settings";

    public static boolean loadConfig(String name) {
        return SaveController.loadConfig(name, null);
    }

    public static boolean loadConfig(String name, String dirName) {
        String fileName;
        File file;
        if (dirName != null) {
            dir = new File(Minecraft.func_71410_x().field_71412_D + File.separator + dirName);
        }
        if (!(file = new File(dir, fileName = name + ".dat")).exists()) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.warn("Config load canceled, file (" + file.getAbsolutePath() + ") does not exist. This is normal for first run.");
            }
            return false;
        }
        if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.ALL.getLevel()) {
            EnviroMine.logger.info("Config load successful.");
        }
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
            if (nbt.func_82582_d() || !nbt.func_74764_b(UISettingsData)) {
                return false;
            }
            UI_Settings.readFromNBT(nbt.func_74775_l(UISettingsData));
            HUDRegistry.readFromNBT(nbt.func_74775_l(UISettingsData));
            LOADED_VERSION = nbt.func_74775_l(UISettingsData).func_74779_i("CONFIG_VERSION");
            for (HudItem item : HUDRegistry.getHudItemList()) {
                NBTTagCompound itemNBT = nbt.func_74775_l(item.getName());
                item.loadFromNBT(itemNBT);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return LOADED_VERSION.equals(CONFIG_VERSION);
    }

    public static void saveConfig(String name) {
        SaveController.saveConfig(name, null);
    }

    public static void saveConfig(String name, String dirName) {
        if (dirName != null) {
            dir = new File(Minecraft.func_71410_x().field_71412_D + File.separator + dirName);
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new ReportedException(new CrashReport("Unable to create the configuration directories", new Throwable()));
        }
        String fileName = name + ".dat";
        File file = new File(dir, fileName);
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            NBTTagCompound globalNBT = new NBTTagCompound();
            HUDRegistry.writeToNBT(globalNBT);
            UI_Settings.writeToNBT(globalNBT);
            globalNBT.func_74778_a("CONFIG_VERSION", CONFIG_VERSION);
            nbt.func_74782_a(UISettingsData, (NBTBase)globalNBT);
            for (HudItem item : HUDRegistry.getHudItemList()) {
                NBTTagCompound itemNBT = new NBTTagCompound();
                item.saveToNBT(itemNBT);
                nbt.func_74782_a(item.getName(), (NBTBase)itemNBT);
            }
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.ALL.getLevel()) {
                EnviroMine.logger.info("Saved GUI properties");
            }
        }
        catch (IOException e) {
            throw new ReportedException(new CrashReport("An error occured while saving", new Throwable()));
        }
    }

    public static File[] getConfigs() {
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".dat");
            }
        });
    }
}

