/*
 * Decompiled with CFR 0.152.
 */
package enviromine.blocks.water;

import com.hbm.util.ContaminationUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enviromine.blocks.water.compat.BlockEnviroMineWater_NTM_SPACE;
import enviromine.core.EnviroMine;
import enviromine.utils.WaterUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class BlockEnviroMineWater
extends BlockFluidClassic {
    public static IIcon stillWater;
    public static IIcon flowingWater;

    public BlockEnviroMineWater(Fluid fluid, Material material) {
        super(fluid, material);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess worldIn, int x, int y, int z) {
        int l = 0;
        int i1 = 0;
        int j1 = 0;
        for (int k1 = -1; k1 <= 1; ++k1) {
            for (int l1 = -1; l1 <= 1; ++l1) {
                int i2 = worldIn.func_72807_a(x + l1, z + k1).getWaterColorMultiplier();
                l += (i2 & 0xFF0000) >> 16;
                i1 += (i2 & 0xFF00) >> 8;
                j1 += i2 & 0xFF;
            }
        }
        return (l / 9 & 0xFF) << 16 | (i1 / 9 & 0xFF) << 8 | j1 / 9 & 0xFF;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        Block block;
        if (!world.field_72995_K && (block = world.func_147439_a(x, y, z)) instanceof BlockEnviroMineWater) {
            BlockEnviroMineWater water = (BlockEnviroMineWater)block;
            if (WaterUtils.getTypeFromFluid((Fluid)water.getFluid()).isRadioactive && entity instanceof EntityLivingBase) {
                EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
                ContaminationUtil.contaminate((EntityLivingBase)entityLivingBase, (ContaminationUtil.HazardType)ContaminationUtil.HazardType.RADIATION, (ContaminationUtil.ContaminationType)ContaminationUtil.ContaminationType.CREATIVE, (float)0.125f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 0 || side == 1 ? stillWater : flowingWater;
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        return super.displaceIfPossible(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        stillWater = register.func_94245_a("water_still");
        flowingWater = register.func_94245_a("water_flow");
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (EnviroMine.isHbmSpaceLoaded && BlockEnviroMineWater_NTM_SPACE.checkEvaporation(world, x, y, z, this.tickRate)) {
            return;
        }
        if (!this.isSourceBlock((IBlockAccess)world, x, y, z)) {
            int densityDir;
            int adjacentSourceBlocks = (this.isSourceBlock((IBlockAccess)world, x - 1, y, z) ? 1 : 0) + (this.isSourceBlock((IBlockAccess)world, x + 1, y, z) ? 1 : 0) + (this.isSourceBlock((IBlockAccess)world, x, y, z - 1) ? 1 : 0) + (this.isSourceBlock((IBlockAccess)world, x, y, z + 1) ? 1 : 0);
            int n = densityDir = BlockEnviroMineWater.getDensity((IBlockAccess)world, (int)x, (int)y, (int)z) > 0 ? -1 : 1;
            if (adjacentSourceBlocks >= 2 && (world.func_147439_a(x, y + densityDir, z).func_149688_o().func_76220_a() || this.isSourceBlock((IBlockAccess)world, x, y + densityDir, z))) {
                world.func_72921_c(x, y, z, 0, 3);
            }
        }
        super.func_149674_a(world, x, y, z, rand);
    }
}

