/*
 * Decompiled with CFR 0.152.
 */
package enviromine.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enviromine.blocks.tiles.TileEntityGas;
import enviromine.core.EM_Settings;
import enviromine.gases.EnviroGas;
import enviromine.gases.EnviroGasDictionary;
import enviromine.gases.GasBuffer;
import enviromine.handlers.ObjectHandler;
import enviromine.utils.EnviroUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGas
extends Block
implements ITileEntityProvider {
    public IIcon gasIcon;
    public IIcon gasFireIcon;

    public BlockGas(Material par2Material) {
        super(par2Material);
        this.func_149675_a(true);
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149726_b(World world, int i, int j, int k) {
        super.func_149726_b(world, i, j, k);
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile == null) {
            tile = new TileEntityGas(world);
            world.func_147455_a(i, j, k, tile);
        }
        if (this == ObjectHandler.fireGasBlock) {
            for (int dir = 0; dir < ForgeDirection.VALID_DIRECTIONS.length; ++dir) {
                int xOff = ForgeDirection.VALID_DIRECTIONS[dir].offsetX + i;
                int yOff = ForgeDirection.VALID_DIRECTIONS[dir].offsetY + j;
                int zOff = ForgeDirection.VALID_DIRECTIONS[dir].offsetZ + k;
                Block sBlock = world.func_147439_a(xOff, yOff, zOff);
                if ((!sBlock.isFlammable((IBlockAccess)world, xOff, yOff, zOff, ForgeDirection.VALID_DIRECTIONS[dir].getOpposite()) || sBlock instanceof BlockGas) && sBlock != Blocks.field_150350_a) continue;
                world.func_147465_d(xOff, yOff, zOff, (Block)Blocks.field_150480_ab, 0, 3);
            }
        }
        GasBuffer.scheduleUpdate(world, i, j, k, this);
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityLiving, ItemStack itemStack) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityGas) {
            TileEntityGas gasTile = (TileEntityGas)tile;
            gasTile.addGas(7, 100);
            gasTile.updateRender();
        }
    }

    public int func_149720_d(IBlockAccess blockAccess, int i, int j, int k) {
        TileEntity tile = blockAccess.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityGas) {
            TileEntityGas gasTile = (TileEntityGas)tile;
            return gasTile.color.getRGB();
        }
        return Color.WHITE.getRGB();
    }

    public float getOpacity(IBlockAccess blockAccess, int i, int j, int k) {
        if (EM_Settings.renderGases) {
            return 0.75f;
        }
        if (EM_Settings.hardcoregases) {
            return 0.0f;
        }
        TileEntity tile = blockAccess.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityGas) {
            float maxOpacity = ((TileEntityGas)tile).opacity;
            return maxOpacity;
        }
        return 0.0f;
    }

    public void swtichIgnitionState(World world, int i, int j, int k) {
        TileEntity tile = world.func_147438_o(i, j, k);
        BlockGas newBlock = this;
        if (this == ObjectHandler.gasBlock) {
            world.func_147449_b(i, j, k, ObjectHandler.fireGasBlock);
            newBlock = ObjectHandler.fireGasBlock;
        } else {
            world.func_147449_b(i, j, k, ObjectHandler.gasBlock);
            newBlock = ObjectHandler.gasBlock;
        }
        if (tile != null) {
            tile.func_145829_t();
            world.func_147455_a(i, j, k, tile);
            tile.field_145854_h = newBlock;
            if (tile instanceof TileEntityGas) {
                ((TileEntityGas)tile).updateRender();
            }
        }
    }

    public int func_149738_a(World world) {
        if (this == ObjectHandler.fireGasBlock) {
            return EM_Settings.gasTickRate / 4;
        }
        return EM_Settings.gasTickRate;
    }

    public int func_149741_i(int meta) {
        return 0xFFFFFF;
    }

    public int func_149645_b() {
        return ObjectHandler.renderGasID;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149678_a(int par1, boolean par2) {
        return false;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean isBlockReplaceable(World world, int x, int y, int z) {
        return true;
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int i, int j, int k, int side) {
        double yMax = this.getMaxY(blockAccess, i, j, k);
        double yMin = this.getMinY(blockAccess, i, j, k);
        float opacity = this.getOpacity(blockAccess, i, j, k);
        if (opacity <= 0.1f) {
            return false;
        }
        int[] sideCoord = EnviroUtils.getAdjacentBlockCoordsFromSide(i, j, k, side);
        if (blockAccess.func_147439_a(sideCoord[0], sideCoord[1], sideCoord[2]) == ObjectHandler.gasBlock || blockAccess.func_147439_a(sideCoord[0], sideCoord[1], sideCoord[2]) == ObjectHandler.fireGasBlock) {
            double sideYMax = this.getMaxY(blockAccess, sideCoord[0], sideCoord[1], sideCoord[2]);
            double sideYMin = this.getMinY(blockAccess, sideCoord[0], sideCoord[1], sideCoord[2]);
            if (this.getOpacity(blockAccess, sideCoord[0], sideCoord[1], sideCoord[2]) <= 0.1f) {
                return true;
            }
            if (side > 1) {
                return sideYMin > yMin || sideYMax < yMax;
            }
            if (side == 0) {
                return sideYMax != 1.0 || yMin != 0.0;
            }
            if (side == 1) {
                return yMax != 1.0 || sideYMin != 0.0;
            }
            return true;
        }
        if (side == 0 && yMin != 0.0) {
            return true;
        }
        if (side == 1 && yMax != 1.0) {
            return true;
        }
        return !blockAccess.func_147439_a(sideCoord[0], sideCoord[1], sideCoord[2]).func_149662_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return 0;
    }

    public int func_149701_w() {
        return 1;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        if (EM_Settings.noGases) {
            world.func_147468_f(x, y, z);
            return;
        }
        boolean scheduleTick = false;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof TileEntityGas)) {
            world.func_147468_f(x, y, z);
            return;
        }
        TileEntityGas gasTile = (TileEntityGas)tile;
        int fireNum = gasTile.getGasQuantity(0);
        if (this.isTouchingIgnition(world, x, y, z) && this == ObjectHandler.gasBlock) {
            if (gasTile.burnGases()) {
                world.func_72908_a((double)x, (double)y, (double)z, "enviromine:gas_ignite", 1.0f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                return;
            }
        } else {
            if (fireNum >= 1 && this == ObjectHandler.gasBlock) {
                gasTile.burnGases();
                return;
            }
            if (fireNum <= 0 && this == ObjectHandler.fireGasBlock) {
                this.swtichIgnitionState(world, x, y, z);
                return;
            }
        }
        if (gasTile.gases.size() <= 0 || gasTile.amount <= 0) {
            world.func_147468_f(x, y, z);
            return;
        }
        if (gasTile.spreadGas()) {
            world.func_147459_d(x, y, z, (Block)this);
        } else if (gasTile.amount > 10 || this == ObjectHandler.fireGasBlock) {
            scheduleTick = true;
        }
        fireNum = gasTile.getGasQuantity(0);
        if (fireNum >= 1 && this == ObjectHandler.gasBlock) {
            gasTile.burnGases();
            this.swtichIgnitionState(world, x, y, z);
            return;
        }
        if (fireNum <= 0 && this == ObjectHandler.fireGasBlock) {
            this.swtichIgnitionState(world, x, y, z);
            return;
        }
        if (fireNum > 20) {
            if (gasTile.firePressure >= 10) {
                scheduleTick = false;
                world.func_147468_f(x, y, z);
                if (fireNum > 80) {
                    world.func_72885_a(null, (double)x, (double)y, (double)z, 16.0f, true, true);
                } else {
                    world.func_72885_a(null, (double)x, (double)y, (double)z, (float)fireNum / 5.0f, true, true);
                }
                return;
            }
            ++gasTile.firePressure;
        } else {
            gasTile.firePressure = 0;
        }
        if (gasTile.gases.size() <= 0 || gasTile.amount <= 0) {
            world.func_147468_f(x, y, z);
            scheduleTick = false;
            return;
        }
        gasTile.updateRender();
        if (scheduleTick) {
            GasBuffer.scheduleUpdate(world, x, y, z, this);
        }
    }

    public boolean isTouchingIgnition(World world, int x, int y, int z) {
        ArrayList<int[]> dir = new ArrayList<int[]>();
        dir.add(new int[]{-1, 0, 0});
        dir.add(new int[]{1, 0, 0});
        dir.add(new int[]{0, -1, 0});
        dir.add(new int[]{0, 1, 0});
        dir.add(new int[]{0, 0, -1});
        dir.add(new int[]{0, 0, 1});
        for (int i = 0; i < dir.size(); ++i) {
            TileEntityGas gasTile;
            int[] pos = (int[])dir.get(i);
            Block block = world.func_147439_a(x + pos[0], y + pos[1], z + pos[2]);
            int meta = world.func_72805_g(x + pos[0], y + pos[1], z + pos[2]);
            if (ObjectHandler.igniteList.containsKey(block) && (ObjectHandler.igniteList.get(block).isEmpty() || ObjectHandler.igniteList.get(block).contains(meta))) {
                return true;
            }
            TileEntity tile = world.func_147438_o(x + pos[0], y + pos[1], z + pos[2]);
            if (tile == null || !(tile instanceof TileEntityGas) || (gasTile = (TileEntityGas)tile).getGasQuantity(EnviroGasDictionary.gasFire.gasID) <= 0) continue;
            return true;
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile;
        GasBuffer.scheduleUpdate(world, x, y, z, this);
        if (world.field_72995_K && (block == ObjectHandler.gasBlock || block == ObjectHandler.fireGasBlock) && (tile = world.func_147438_o(x, y, z)) != null && tile instanceof TileEntityGas) {
            TileEntityGas gasTile = (TileEntityGas)tile;
            gasTile.updateOpacity();
            gasTile.updateColor();
            gasTile.updateSize();
            gasTile.updateRender();
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityGas) {
            TileEntityGas gasTile = (TileEntityGas)tile;
            if (entity.func_70027_ad() && this == ObjectHandler.gasBlock && gasTile.burnGases()) {
                return;
            }
            if (!(entity instanceof EntityLivingBase)) {
                return;
            }
            EntityLivingBase entityLiving = (EntityLivingBase)entity;
            gasTile.doAllEffects(entityLiving);
            if (entityLiving instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entityLiving;
                int state = 1;
                for (int jj = 0; jj < gasTile.gases.size(); ++jj) {
                    EnviroGas gasInfo = EnviroGasDictionary.gasList[gasTile.gases.get(jj)[0]];
                    if (gasInfo.volitility > 0.0f) {
                        state = 2;
                        break;
                    }
                    if (!(gasInfo.suffocation > 0.0f)) continue;
                    state = 0;
                }
                if (state == 1) {
                    return;
                }
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (stack == null || stack.func_77973_b() != Item.func_150898_a((Block)ObjectHandler.davyLampBlock) || stack.func_77960_j() <= 0) continue;
                    stack.func_77964_b(state);
                }
            }
        }
    }

    public TileEntity func_149915_a(World world, int i) {
        TileEntityGas tile = new TileEntityGas();
        return tile;
    }

    public IIcon func_149691_a(int par1, int par2) {
        if (this == ObjectHandler.fireGasBlock) {
            return this.gasFireIcon;
        }
        return this.gasIcon;
    }

    public void func_149651_a(IIconRegister register) {
        this.gasIcon = register.func_94245_a("enviromine:block_gas");
        this.gasFireIcon = register.func_94245_a("enviromine:block_gas_fire");
    }

    public boolean func_149659_a(Explosion par1Explosion) {
        return false;
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return null;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        if (world.func_147445_c(x, y - 1, z, false) && this == ObjectHandler.fireGasBlock) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
        }
        ArrayList<int[]> dir = new ArrayList<int[]>();
        dir.add(new int[]{-1, 0, 0});
        dir.add(new int[]{1, 0, 0});
        dir.add(new int[]{0, -1, 0});
        dir.add(new int[]{0, 1, 0});
        dir.add(new int[]{0, 0, -1});
        dir.add(new int[]{0, 0, 1});
        for (int i = 0; i < dir.size(); ++i) {
            TileEntityGas gasTile;
            int[] pos = (int[])dir.get(i);
            TileEntity tile = world.func_147438_o(x + pos[0], y + pos[1], z + pos[2]);
            if (tile == null || !(tile instanceof TileEntityGas) || !(gasTile = (TileEntityGas)tile).burnGases() || gasTile.func_145838_q() != ObjectHandler.fireGasBlock) continue;
            ((BlockGas)gasTile.func_145838_q()).swtichIgnitionState(world, x + pos[0], y + pos[1], z + pos[2]);
            world.func_72908_a((double)x, (double)y, (double)z, "enviromine:gas_ignite", 1.0f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
        }
    }

    public ArrayList<int[]> getGasInfo(World world, int i, int j, int k) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityGas) {
            TileEntityGas gasTile = (TileEntityGas)tile;
            return gasTile.gases;
        }
        return new ArrayList<int[]>();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int i, int j, int k, Random rand) {
        if (this == ObjectHandler.fireGasBlock) {
            if (rand.nextInt(24) == 0) {
                world.func_72980_b((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), "fire.fire", 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
            }
            double d0 = (float)i + 0.5f;
            double d1 = (float)j + 0.5f;
            double d2 = (float)k + 0.5f;
            double d3 = rand.nextDouble() - 0.5;
            double d4 = rand.nextDouble() - 0.5;
            world.func_72869_a("largesmoke", d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0);
        }
    }

    public double getMinY(IBlockAccess blockAccess, int i, int j, int k) {
        TileEntity tile = blockAccess.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityGas) {
            TileEntityGas gasTile = (TileEntityGas)tile;
            return gasTile.yMin;
        }
        return 0.0;
    }

    public double getMaxY(IBlockAccess blockAccess, int i, int j, int k) {
        TileEntity tile = blockAccess.func_147438_o(i, j, k);
        if (tile instanceof TileEntityGas) {
            TileEntityGas gasTile = (TileEntityGas)tile;
            return gasTile.yMax;
        }
        return 1.0;
    }
}

