/*
 * Decompiled with CFR 0.152.
 */
package enviromine;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import enviromine.EnviroDamageSource;
import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.EM_PhysManager;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class EntityPhysicsBlock
extends EntityFallingBlock
implements IEntityAdditionalSpawnData {
    public boolean isAnvil2 = true;
    public boolean isBreakingAnvil2;
    public int fallHurtMax2 = 40;
    public float fallHurtAmount2 = 2.0f;
    public boolean isLandSlide = false;
    public boolean earthquake = false;
    public int fallTime = 0;
    public Block block;
    public int meta;

    public EntityPhysicsBlock(World world) {
        super(world);
        List entityList;
        if (EM_Settings.entityFailsafe > 0 && !world.field_72995_K && (entityList = this.field_70170_p.func_72872_a(EntityPhysicsBlock.class, this.field_70121_D.func_72314_b(8.0, 8.0, 8.0))).size() >= 1024) {
            if (EM_Settings.entityFailsafe == 1) {
                if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                    EnviroMine.logger.log(Level.WARN, "Entity fail safe activated! Canceling new entities!");
                    EnviroMine.logger.log(Level.WARN, "Location: " + this.field_70165_t + "," + this.field_70163_u + "," + this.field_70161_v);
                    EnviroMine.logger.log(Level.WARN, "No.: " + entityList.size());
                }
                EM_PhysManager.physSchedule.clear();
                this.func_70106_y();
                return;
            }
            if (EM_Settings.entityFailsafe >= 2) {
                if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                    EnviroMine.logger.log(Level.ERROR, "Entity fail safe activated! Deleting excess entities!");
                    EnviroMine.logger.log(Level.ERROR, "Location: " + this.field_70165_t + "," + this.field_70163_u + "," + this.field_70161_v);
                    EnviroMine.logger.log(Level.ERROR, "No.: " + entityList.size());
                }
                for (EntityPhysicsBlock oldPhysBlock : entityList) {
                    if (oldPhysBlock.field_70128_L) continue;
                    oldPhysBlock.func_70106_y();
                }
                this.func_70106_y();
                EM_PhysManager.physSchedule.clear();
                return;
            }
        }
    }

    public EntityPhysicsBlock(World world, double x, double y, double z, Block block, int meta, boolean update) {
        super(world, x, y, z, EntityPhysicsBlock.flowerID(block), meta);
        List entityList;
        this.block = block;
        this.meta = meta;
        if (EM_Settings.entityFailsafe > 0 && !world.field_72995_K && (entityList = this.field_70170_p.func_72872_a(EntityPhysicsBlock.class, this.field_70121_D.func_72314_b(8.0, 8.0, 8.0))).size() >= 512) {
            if (EM_Settings.entityFailsafe == 1) {
                if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                    EnviroMine.logger.log(Level.WARN, "Entity fail safe activated: Level 1");
                    EnviroMine.logger.log(Level.WARN, "Location: " + this.field_70165_t + "," + this.field_70163_u + "," + this.field_70161_v);
                    EnviroMine.logger.log(Level.WARN, "No.: " + entityList.size());
                }
                EM_PhysManager.physSchedule.clear();
                this.func_70106_y();
                return;
            }
            if (EM_Settings.entityFailsafe >= 2) {
                if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                    EnviroMine.logger.log(Level.ERROR, "Entity fail safe activated: Level 2");
                    EnviroMine.logger.log(Level.ERROR, "Location: " + this.field_70165_t + "," + this.field_70163_u + "," + this.field_70161_v);
                    EnviroMine.logger.log(Level.ERROR, "No.: " + entityList.size());
                }
                for (EntityPhysicsBlock oldPhysBlock : entityList) {
                    if (oldPhysBlock.field_70128_L) continue;
                    oldPhysBlock.func_70106_y();
                }
                this.func_70106_y();
                EM_PhysManager.physSchedule.clear();
                return;
            }
        }
        EM_PhysManager.usedSlidePositions.add("" + MathHelper.func_76128_c((double)this.field_70165_t) + "," + MathHelper.func_76128_c((double)this.field_70161_v));
        if (update) {
            EM_PhysManager.schedulePhysUpdate(world, (int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z), false, this.earthquake ? "Quake" : "Collapse");
        }
    }

    public static Block flowerID(Block block) {
        if (block instanceof BlockFlower) {
            return Blocks.field_150350_a;
        }
        return block;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70071_h_() {
        if (this.block == null || this.block == Blocks.field_150350_a) {
            this.func_70106_y();
        } else {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            ++this.fallTime;
            this.field_70181_x -= (double)0.04f;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.98f;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y *= (double)0.98f;
            if (!this.field_70170_p.field_72995_K) {
                int i = MathHelper.func_76128_c((double)this.field_70165_t);
                int j = MathHelper.func_76128_c((double)this.field_70163_u);
                int k = MathHelper.func_76128_c((double)this.field_70161_v);
                if (this.fallTime == 1) {
                    if (this.field_70170_p.func_147439_a(i, j, k) != this.block && !this.isLandSlide) {
                        this.func_70106_y();
                        return;
                    }
                    List before = this.field_70170_p.func_72872_a(EntityItem.class, this.field_70121_D.func_72314_b(1.0, 1.0, 1.0));
                    this.field_70170_p.func_147468_f(i, j, k);
                    List after = this.field_70170_p.func_72872_a(EntityItem.class, this.field_70121_D.func_72314_b(1.0, 1.0, 1.0));
                    for (Entity e : before) {
                        after.remove(e);
                    }
                    for (Entity e : after) {
                        e.func_70106_y();
                    }
                }
                try {
                    AxisAlignedBB axisalignedbb = this.block.func_149668_a(this.field_70170_p, i, j - 1, k);
                    if (axisalignedbb != null) {
                        List fallingBlocks = this.field_70170_p.func_72872_a(EntityPhysicsBlock.class, axisalignedbb);
                        fallingBlocks.remove((Object)this);
                        if (fallingBlocks.size() >= 1 && this.isLandSlide) {
                            this.field_70181_x = 0.0;
                            this.func_70107_b((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
                        }
                    }
                }
                catch (NullPointerException axisalignedbb) {
                    // empty catch block
                }
                if (this.earthquake) {
                    int jj = j;
                    while (j >= MathHelper.func_76143_f((double)this.field_70181_x)) {
                        if (jj <= 5) {
                            this.func_70106_y();
                            return;
                        }
                        if (this.field_70170_p.func_147439_a(i, jj, k).func_149688_o() == Material.field_151587_i) {
                            this.func_70106_y();
                            return;
                        }
                        if (this.field_70170_p.func_147439_a(i, jj, k).func_149688_o() == Material.field_151586_h) {
                            this.func_70106_y();
                            return;
                        }
                        if ((this.field_70170_p.func_147439_a(i, jj, k) == Blocks.field_150343_Z || this.field_70170_p.func_147439_a(i, jj, k) == Blocks.field_150347_e) && this.field_70170_p.func_147439_a(i, jj - 1, k).func_149688_o() == Material.field_151587_i) {
                            this.func_70106_y();
                            return;
                        }
                        --j;
                    }
                }
                if (this.field_70122_E) {
                    this.field_70159_w *= (double)0.7f;
                    this.field_70179_y *= (double)0.7f;
                    this.field_70181_x *= -0.5;
                    if (this.field_70170_p.func_147439_a(i, j, k) != Blocks.field_150326_M) {
                        this.func_70106_y();
                        if (!this.field_70170_p.func_147472_a(Blocks.field_150467_bQ, i, j, k, true, 1, (Entity)null, (ItemStack)null) && !EM_PhysManager.blockNotSolid(this.field_70170_p, i, j, k, false)) {
                            ++j;
                        }
                        if (this.block == Blocks.field_150431_aC && this.field_70170_p.func_147439_a(i, j, k) == Blocks.field_150431_aC && this.field_70170_p.func_72805_g(i, j, k) < 15 || !this.isBreakingAnvil2 && this.field_70170_p.func_147472_a(Blocks.field_150467_bQ, i, j, k, true, 1, (Entity)null, (ItemStack)null) && !BlockFalling.func_149831_e((World)this.field_70170_p, (int)i, (int)(j - 1), (int)k) && this.field_70170_p.func_147465_d(i, j, k, this.block, this.meta, 3)) {
                            TileEntity tileentity;
                            if (this.block == Blocks.field_150431_aC && this.field_70170_p.func_147439_a(i, j, k) == Blocks.field_150431_aC && this.field_70170_p.func_72805_g(i, j, k) < 15) {
                                if (this.field_70170_p.func_72805_g(i, j, k) >= 14) {
                                    this.field_70170_p.func_147449_b(i, j, k, Blocks.field_150433_aE);
                                } else {
                                    this.field_70170_p.func_72921_c(i, j, k, this.field_70170_p.func_72805_g(i, j, k) + 1, 3);
                                }
                            } else if (this.meta != this.field_70170_p.func_72805_g(i, j, k)) {
                                this.field_70170_p.func_72921_c(i, j, k, this.meta, 2);
                            }
                            EM_PhysManager.schedulePhysUpdate(this.field_70170_p, i, j, k, true, this.earthquake ? "Quake" : "Collapse");
                            Block bSurface = null;
                            if (this.field_70170_p.func_147439_a(i, j - 1, k) != Blocks.field_150350_a && this.field_70170_p.func_147439_a(i, j - 1, k).func_149688_o() != Material.field_151579_a) {
                                bSurface = this.field_70170_p.func_147439_a(i, j - 1, k);
                                this.field_70170_p.func_72908_a((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), bSurface.field_149762_H.func_150496_b(), (bSurface.field_149762_H.func_150497_c() + 1.0f) / 2.0f, bSurface.field_149762_H.func_150494_d() * 0.5f);
                            }
                            if (bSurface == null || bSurface != this.block) {
                                this.field_70170_p.func_72908_a((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), this.block.field_149762_H.func_150496_b(), (this.block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.block.field_149762_H.func_150494_d() * 0.5f);
                            }
                            if (this.field_145810_d != null && this.block instanceof ITileEntityProvider && (tileentity = this.field_70170_p.func_147438_o(i, j, k)) != null) {
                                NBTTagCompound nbttagcompound = new NBTTagCompound();
                                tileentity.func_145841_b(nbttagcompound);
                                for (String s : this.field_145810_d.func_150296_c()) {
                                    NBTBase nbtbase = this.field_145810_d.func_74781_a(s);
                                    if (s.equals("x") || s.equals("y") || s.equals("z")) continue;
                                    nbttagcompound.func_74782_a(s, nbtbase.func_74737_b());
                                }
                                tileentity.func_145839_a(nbttagcompound);
                                tileentity.func_70296_d();
                            }
                        } else if (this.field_145813_c && !this.isBreakingAnvil2 && !this.earthquake) {
                            this.func_70099_a(new ItemStack(this.block, 1, this.block.func_149692_a(this.meta)), 0.0f);
                        }
                    }
                } else if (this.fallTime > 100 && !this.field_70170_p.field_72995_K && (j < 1 || j > 256) || this.fallTime > 600) {
                    if (this.field_145813_c && !this.earthquake) {
                        this.func_70099_a(new ItemStack(this.block, 1, this.block.func_149692_a(this.meta)), 0.0f);
                    }
                    this.func_70106_y();
                }
            }
        }
    }

    protected void func_70069_a(float par1) {
        if (this.isAnvil2) {
            int i = MathHelper.func_76123_f((float)(par1 - 1.0f));
            if (this.isLandSlide) {
                i = 2;
            }
            if (i > 0) {
                ArrayList arraylist = new ArrayList(this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D));
                DamageSource damagesource = this.isLandSlide ? (this.block.func_149688_o() == Material.field_151597_y ? EnviroDamageSource.avalanche : EnviroDamageSource.landslide) : (this.block == Blocks.field_150467_bQ ? DamageSource.field_82728_o : DamageSource.field_82729_p);
                for (Entity entity : arraylist) {
                    entity.func_70097_a(damagesource, (float)Math.min(MathHelper.func_76141_d((float)((float)i * this.fallHurtAmount2)), this.fallHurtMax2));
                }
                if (this.block == Blocks.field_150467_bQ && (double)this.field_70146_Z.nextFloat() < (double)0.05f + (double)i * 0.05) {
                    int j = this.meta >> 2;
                    int k = this.meta & 3;
                    if (++j > 2) {
                        this.isBreakingAnvil2 = true;
                    } else {
                        this.meta = k | j << 2;
                    }
                }
            }
        }
    }

    protected void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74774_a("Tile", (byte)Block.func_149682_b((Block)this.block));
        par1NBTTagCompound.func_74768_a("TileID", Block.func_149682_b((Block)this.block));
        par1NBTTagCompound.func_74774_a("Data", (byte)this.meta);
        par1NBTTagCompound.func_74757_a("HurtEntities2", this.isAnvil2);
        par1NBTTagCompound.func_74776_a("FallHurtAmount2", this.fallHurtAmount2);
        par1NBTTagCompound.func_74768_a("FallHurtMax2", this.fallHurtMax2);
        par1NBTTagCompound.func_74757_a("Landslide", this.isLandSlide);
    }

    protected void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.block = par1NBTTagCompound.func_150297_b("TileID", 99) ? Block.func_149729_e((int)par1NBTTagCompound.func_74762_e("TileID")) : Block.func_149729_e((int)(par1NBTTagCompound.func_74771_c("Tile") & 0xFF));
        this.meta = par1NBTTagCompound.func_74771_c("Data") & 0xFF;
        if (par1NBTTagCompound.func_74764_b("HurtEntities2")) {
            this.isAnvil2 = par1NBTTagCompound.func_74767_n("HurtEntities2");
            this.fallHurtAmount2 = par1NBTTagCompound.func_74760_g("FallHurtAmount2");
            this.fallHurtMax2 = par1NBTTagCompound.func_74762_e("FallHurtMax2");
        } else if (this.block == Blocks.field_150467_bQ) {
            this.isAnvil2 = true;
        }
        this.isLandSlide = par1NBTTagCompound.func_74767_n("Landslide");
    }

    public void writeSpawnData(ByteBuf buffer) {
        NBTTagCompound tags = new NBTTagCompound();
        this.func_70014_b(tags);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)tags);
    }

    public void readSpawnData(ByteBuf additionalData) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)additionalData);
        this.func_70037_a(tags);
    }
}

