/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.internal;

import codechicken.enderstorage.EnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.storage.EnderItemStoragePlugin;
import codechicken.enderstorage.storage.EnderLiquidStoragePlugin;
import codechicken.enderstorage.storage.item.EnderItemStorage;
import codechicken.enderstorage.storage.liquid.EnderLiquidStorage;
import codechicken.enderstorage.storage.liquid.TankSynchroniser;
import codechicken.lib.packet.PacketCustom;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;

public class EnderStorageSPH
implements PacketCustom.IServerPacketHandler {
    public static final String channel = "ES";

    public void handlePacket(PacketCustom packet, EntityPlayerMP sender, INetHandlerPlayServer handler) {
        switch (packet.getType()) {
            case 1: {
                TankSynchroniser.handleVisiblityPacket(sender, packet);
                break;
            }
            case 2: {
                this.sendStorageStored(packet, sender);
            }
        }
    }

    private void sendStorageStored(PacketCustom packet, EntityPlayerMP sender) {
        String owner;
        boolean global = packet.readBoolean();
        int type = packet.readInt();
        if (global) {
            if (!EnderStorage.allPlayerCanSeePublicInventory && MinecraftServer.func_71276_C().func_71203_ab().func_152603_m().func_152700_a(sender.getDisplayName()) == null) {
                return;
            }
            owner = "global";
        } else {
            owner = sender.getDisplayName();
        }
        PacketCustom res = new PacketCustom((Object)channel, 7);
        res.writeBoolean(global);
        res.writeInt(type);
        EnderStorageManager storageManager = EnderStorageManager.instance(false);
        NBTTagCompound data = new NBTTagCompound();
        ArrayList freqList = new ArrayList();
        String owner_ = owner;
        switch (type) {
            case 1: {
                LinkedHashMap chestMap = new LinkedHashMap();
                IntStream.rangeClosed(0, 4095).forEach(freq -> chestMap.put(freq, (EnderItemStorage)storageManager.getStorage(owner_, freq, "item")));
                chestMap.entrySet().stream().filter(entry -> !EnderItemStoragePlugin.isEmpty((EnderItemStorage)entry.getValue())).forEach(chest -> {
                    freqList.add(chest.getKey());
                    data.func_74782_a(((Integer)chest.getKey()).toString(), (NBTBase)((EnderItemStorage)chest.getValue()).saveToTag());
                });
                break;
            }
            case 2: {
                LinkedHashMap liquidMap = new LinkedHashMap();
                IntStream.rangeClosed(0, 4095).forEach(freq -> liquidMap.put(freq, (EnderLiquidStorage)storageManager.getStorage(owner_, freq, "liquid")));
                liquidMap.entrySet().stream().filter(entry -> !EnderLiquidStoragePlugin.isEmpty((EnderLiquidStorage)entry.getValue())).forEach(tank -> {
                    freqList.add(tank.getKey());
                    data.func_74782_a(((Integer)tank.getKey()).toString(), (NBTBase)((EnderLiquidStorage)tank.getValue()).saveToTag());
                });
                break;
            }
            default: {
                EnderStorage.LOGGER.error("EnderStorageSPH:Unknown EnderStorageStoredEvent TYPE,no information is returned.");
                return;
            }
        }
        data.func_74783_a("freqs", freqList.stream().mapToInt(i -> i).toArray());
        res.writeNBTTagCompound(data);
        res.sendToPlayer((EntityPlayer)sender);
    }

    public static void sendOpenUpdateTo(EntityPlayer player, String owner, int freq, boolean open) {
        PacketCustom packet = new PacketCustom((Object)channel, 3);
        packet.writeString(owner);
        packet.writeShort(freq);
        packet.writeBoolean(open);
        packet.sendToPlayer(player);
    }
}

