/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.mixin.mixins.client.rple;

import com.falsepattern.rple.api.client.ClientColorHelper;
import com.falsepattern.rple.internal.client.storage.RPLEClientBlockStorage;
import com.falsepattern.rple.internal.client.storage.RPLEClientChunk;
import com.falsepattern.rple.internal.common.cache.RPLEBlockStorageRoot;
import com.falsepattern.rple.internal.common.chunk.RPLEChunkRoot;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Unique
@Mixin(value={World.class, ChunkCache.class})
public abstract class RPLEClientBlockStorageImplMixin
implements RPLEClientBlockStorage,
RPLEBlockStorageRoot {
    @Override
    public int rple$getRGBLightValue(boolean useNeighborValues, int posX, int posY, int posZ) {
        int lightValueZN;
        int lightValueZP;
        int lightValueXN;
        int lightValueXP;
        int lightValueYP;
        if (!this.lumi$hasSky()) {
            return this.rple$getRGBLightValueNoSky(useNeighborValues, posX, posY, posZ);
        }
        if (!RPLEClientBlockStorageImplMixin.rple$worldBoundsCheck(posX, posY, posZ)) {
            return posY >= 0 ? 0xFFF000 : 0;
        }
        int centerChunkPosX = posX >> 4;
        int centerChunkPosZ = posZ >> 4;
        RPLEClientChunk centerChunk = this.rple$getClientFromChunkPosIfExists(centerChunkPosX, centerChunkPosZ);
        if (centerChunk == null) {
            return 0xFFF000;
        }
        int centerSubChunkPosX = posX & 0xF;
        int centerSubChunkPosZ = posZ & 0xF;
        if (!useNeighborValues) {
            return centerChunk.rple$getRGBLightValueHasSky(centerSubChunkPosX, posY, centerSubChunkPosZ);
        }
        int n = lightValueYP = posY == 255 ? 0xFFF000 : centerChunk.rple$getRGBLightValueHasSky(centerSubChunkPosX, posY + 1, centerSubChunkPosZ);
        if (centerSubChunkPosX == 0) {
            lightValueXP = centerChunk.rple$getRGBLightValueHasSky(1, posY, centerSubChunkPosZ);
            RPLEClientChunk chunkXN = this.rple$getClientFromChunkPosIfExists(centerChunkPosX - 1, centerChunkPosZ);
            lightValueXN = chunkXN == null ? 0xFFF000 : chunkXN.rple$getRGBLightValueHasSky(15, posY, centerSubChunkPosZ);
        } else if (centerSubChunkPosX == 15) {
            RPLEClientChunk chunkXP = this.rple$getClientFromChunkPosIfExists(centerChunkPosX + 1, centerChunkPosZ);
            lightValueXP = chunkXP == null ? 0xFFF000 : chunkXP.rple$getRGBLightValueHasSky(0, posY, centerSubChunkPosZ);
            lightValueXN = centerChunk.rple$getRGBLightValueHasSky(14, posY, centerSubChunkPosZ);
        } else {
            lightValueXP = centerChunk.rple$getRGBLightValueHasSky(centerSubChunkPosX + 1, posY, centerSubChunkPosZ);
            lightValueXN = centerChunk.rple$getRGBLightValueHasSky(centerSubChunkPosX - 1, posY, centerSubChunkPosZ);
        }
        if (centerSubChunkPosZ == 0) {
            lightValueZP = centerChunk.rple$getRGBLightValueHasSky(centerSubChunkPosX, posY, 1);
            RPLEClientChunk chunkXN = this.rple$getClientFromChunkPosIfExists(centerChunkPosX, centerChunkPosZ - 1);
            lightValueZN = chunkXN == null ? 0xFFF000 : chunkXN.rple$getRGBLightValueHasSky(centerSubChunkPosX, posY, 15);
        } else if (centerSubChunkPosZ == 15) {
            RPLEClientChunk chunkXP = this.rple$getClientFromChunkPosIfExists(centerChunkPosX, centerChunkPosZ + 1);
            lightValueZP = chunkXP == null ? 0xFFF000 : chunkXP.rple$getRGBLightValueHasSky(centerSubChunkPosX, posY, 0);
            lightValueZN = centerChunk.rple$getRGBLightValueHasSky(centerSubChunkPosX, posY, 14);
        } else {
            lightValueZP = centerChunk.rple$getRGBLightValueHasSky(centerSubChunkPosX, posY, centerSubChunkPosZ + 1);
            lightValueZN = centerChunk.rple$getRGBLightValueHasSky(centerSubChunkPosX, posY, centerSubChunkPosZ - 1);
        }
        return ClientColorHelper.RGB32Max(lightValueYP, lightValueXN, lightValueXP, lightValueZP, lightValueZN);
    }

    @Override
    public int rple$getRGBLightValueNoSky(boolean useNeighborValues, int posX, int posY, int posZ) {
        int lightValueZN;
        int lightValueZP;
        int lightValueXN;
        int lightValueXP;
        int lightValueYP;
        if (!RPLEClientBlockStorageImplMixin.rple$worldBoundsCheck(posX, posY, posZ)) {
            return 0;
        }
        int centerChunkPosX = posX >> 4;
        int centerChunkPosZ = posZ >> 4;
        RPLEClientChunk centerChunk = this.rple$getClientFromChunkPosIfExists(centerChunkPosX, centerChunkPosZ);
        if (centerChunk == null) {
            return 0;
        }
        int centerSubChunkPosX = posX & 0xF;
        int centerSubChunkPosZ = posZ & 0xF;
        if (!useNeighborValues) {
            return centerChunk.rple$getRGBLightValueNoSky(centerSubChunkPosX, posY, centerSubChunkPosZ);
        }
        int n = lightValueYP = posY == 255 ? 0 : centerChunk.rple$getRGBLightValueNoSky(centerSubChunkPosX, posY + 1, centerSubChunkPosZ);
        if (centerSubChunkPosX == 0) {
            lightValueXP = centerChunk.rple$getRGBLightValueNoSky(1, posY, centerSubChunkPosZ);
            RPLEClientChunk chunkXN = this.rple$getClientFromChunkPosIfExists(centerChunkPosX - 1, centerChunkPosZ);
            lightValueXN = chunkXN == null ? 0 : chunkXN.rple$getRGBLightValueNoSky(15, posY, centerSubChunkPosZ);
        } else if (centerSubChunkPosX == 15) {
            RPLEClientChunk chunkXP = this.rple$getClientFromChunkPosIfExists(centerChunkPosX + 1, centerChunkPosZ);
            lightValueXP = chunkXP == null ? 0 : chunkXP.rple$getRGBLightValueNoSky(0, posY, centerSubChunkPosZ);
            lightValueXN = centerChunk.rple$getRGBLightValueNoSky(14, posY, centerSubChunkPosZ);
        } else {
            lightValueXP = centerChunk.rple$getRGBLightValueNoSky(centerSubChunkPosX + 1, posY, centerSubChunkPosZ);
            lightValueXN = centerChunk.rple$getRGBLightValueNoSky(centerSubChunkPosX - 1, posY, centerSubChunkPosZ);
        }
        if (centerSubChunkPosZ == 0) {
            lightValueZP = centerChunk.rple$getRGBLightValueNoSky(centerSubChunkPosX, posY, 1);
            RPLEClientChunk chunkXN = this.rple$getClientFromChunkPosIfExists(centerChunkPosX, centerChunkPosZ - 1);
            lightValueZN = chunkXN == null ? 0 : chunkXN.rple$getRGBLightValueNoSky(centerSubChunkPosX, posY, 15);
        } else if (centerSubChunkPosZ == 15) {
            RPLEClientChunk chunkXP = this.rple$getClientFromChunkPosIfExists(centerChunkPosX, centerChunkPosZ + 1);
            lightValueZP = chunkXP == null ? 0 : chunkXP.rple$getRGBLightValueNoSky(centerSubChunkPosX, posY, 0);
            lightValueZN = centerChunk.rple$getRGBLightValueNoSky(centerSubChunkPosX, posY, 14);
        } else {
            lightValueZP = centerChunk.rple$getRGBLightValueNoSky(centerSubChunkPosX, posY, centerSubChunkPosZ + 1);
            lightValueZN = centerChunk.rple$getRGBLightValueNoSky(centerSubChunkPosX, posY, centerSubChunkPosZ - 1);
        }
        return ClientColorHelper.RGB32Max(lightValueYP, lightValueXN, lightValueXP, lightValueZP, lightValueZN);
    }

    @Nullable
    private RPLEClientChunk rple$getClientFromChunkPosIfExists(int chunkPosX, int chunkPosZ) {
        RPLEChunkRoot chunk = this.rple$getChunkRootFromChunkPosIfExists(chunkPosX, chunkPosZ);
        if (chunk instanceof RPLEClientChunk) {
            return (RPLEClientChunk)((Object)chunk);
        }
        return null;
    }

    private static boolean rple$worldBoundsCheck(int posX, int posY, int posZ) {
        if (posX >= -30000000 && posX <= 30000000 && posZ >= -30000000 && posZ <= 30000000) {
            return posY >= 0 && posY <= 255;
        }
        return false;
    }
}

