/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.mixin.helper;

import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.minecraft.IPartMeta;
import codechicken.multipart.minecraft.McBlockPart;
import com.falsepattern.rple.api.common.ServerColorHelper;
import com.falsepattern.rple.api.common.block.RPLEBlock;
import com.falsepattern.rple.api.common.block.RPLECustomBlockBrightness;
import com.falsepattern.rple.api.common.color.LightValueColor;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import scala.collection.Iterator;

public final class MultiPartHelper {
    public static short getMultiPartBrightnessColor(TileMultipart multiPart) {
        int multiPartRed = 0;
        int multiPartGreen = 0;
        int multiPartBlue = 0;
        for (TMultiPart part : multiPart.jPartList()) {
            short partColor;
            if (part instanceof RPLECustomBlockBrightness) {
                RPLECustomBlockBrightness colorProvider = (RPLECustomBlockBrightness)part;
                partColor = colorProvider.rple$getCustomBrightnessColor();
            } else {
                if (!(part instanceof McBlockPart)) continue;
                McBlockPart partBlock = (McBlockPart)part;
                Block blockBase = partBlock.getBlock();
                RPLEBlock rpleBlock = RPLEBlock.of(blockBase);
                if (part instanceof IPartMeta) {
                    IPartMeta partMeta = (IPartMeta)part;
                    int blockMeta = partMeta.getMetadata();
                    partColor = rpleBlock.rple$getBrightnessColor(blockMeta);
                } else {
                    partColor = rpleBlock.rple$getBrightnessColor();
                }
            }
            multiPartRed = Math.max(multiPartRed, ServerColorHelper.red(partColor));
            multiPartGreen = Math.max(multiPartGreen, ServerColorHelper.green(partColor));
            multiPartBlue = Math.max(multiPartBlue, ServerColorHelper.blue(partColor));
        }
        return ServerColorHelper.RGB16FromRGBChannel4Bit(multiPartRed, multiPartGreen, multiPartBlue);
    }

    public static short getMultiPartTranslucencyColor(TileMultipart multiPart) {
        return LightValueColor.LIGHT_VALUE_15.rgb16();
    }

    public static int getColoredLightValue(Block vBlock, IBlockAccess world, int meta, int colorChannel, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileMultipart)) {
            return -1;
        }
        TileMultipart tileMultipart = (TileMultipart)tileEntity;
        Iterator iter = tileMultipart.partList().iterator();
        int sum = 0;
        return ServerColorHelper.clampColorComponent(sum);
    }

    @Generated
    private MultiPartHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

