/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.util;

import com.falsepattern.rple.internal.common.config.RPLEConfig;
import lombok.Generated;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LogHelper {
    public static final Logger RPLE_LOG = LogManager.getLogger((String)"RPLE");

    public static Logger createLogger(String name) {
        Logger logger = LogManager.getLogger((String)("RPLE|" + name));
        if (RPLEConfig.Debug.DEBUG_FORCE_LOG_TO_CONSOLE) {
            LogHelper.tryForcingLoggingToConsole(logger);
        }
        return logger;
    }

    public static boolean shouldLogDebug(boolean configuredOption) {
        switch (RPLEConfig.Debug.DEBUG_LOG_MODE) {
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
        }
        return configuredOption;
    }

    private static void tryForcingLoggingToConsole(Logger logger) {
        try {
            ((org.apache.logging.log4j.core.Logger)logger).setLevel(Level.ALL);
        }
        catch (Throwable t) {
            logger.warn("Failed to force [DEBUG] and [TRACE] logging to console, messages will still appear in: 'fml-client-*.log'", t);
        }
    }

    @Generated
    private LogHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        if (RPLEConfig.Debug.DEBUG_FORCE_LOG_TO_CONSOLE) {
            LogHelper.tryForcingLoggingToConsole(RPLE_LOG);
        }
    }
}

