/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.util;

import com.falsepattern.rple.internal.common.config.RPLEConfig;
import com.falsepattern.rple.internal.common.util.LogHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;

public final class ClassBlockList {
    private final Logger log;
    private final Set<String> permitted = new HashSet<String>();
    private final Map<Class<?>, Boolean> blockListCache = new WeakHashMap();
    private final Function<Class<?>, Boolean> shouldBlockFn;
    private final String condName;
    private final Class<?> baseClass;

    public ClassBlockList(String name, String conditionTypeName, Class<?> baseClass, Function<Class<?>, Boolean> shouldBlockFn) {
        this.log = LogHelper.createLogger(name);
        this.shouldBlockFn = shouldBlockFn;
        this.condName = conditionTypeName;
        this.baseClass = baseClass;
    }

    public void permit(Class<?> klass) {
        this.permit(klass.getName());
    }

    public void permit(String klass) {
        this.permitted.add(klass);
    }

    public boolean isOnBlockList(Class<?> klass) {
        if (this.blockListCache.containsKey(klass)) {
            return this.blockListCache.get(klass);
        }
        ArrayList classChain = new ArrayList();
        boolean blocked = false;
        do {
            if (this.blockListCache.containsKey(klass)) {
                blocked = this.blockListCache.get(klass);
                break;
            }
            classChain.add(klass);
            if (this.permitted.contains(klass.getName()) || !this.shouldBlockFn.apply(klass).booleanValue()) continue;
            blocked = true;
            break;
        } while ((klass = klass.getSuperclass()) != null && klass != this.baseClass);
        for (Class clazz : classChain) {
            if (LogHelper.shouldLogDebug(RPLEConfig.Debug.DEBUG_CLASS_BLOCK_LIST)) {
                this.log.debug("{} {} for {}", new Object[]{blocked ? "Blocking" : "Permitting", this.condName, clazz.getName()});
            }
            this.blockListCache.put(clazz, blocked);
        }
        return blocked;
    }
}

