/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.config.container;

import com.falsepattern.rple.api.common.color.DefaultColor;
import com.falsepattern.rple.api.common.color.RPLENamedColor;
import com.falsepattern.rple.internal.common.config.container.ColorPalette;
import com.falsepattern.rple.internal.common.config.container.HexColor;
import java.util.Optional;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public final class ColorReference {
    public static final String INVALID_COLOR = "invalid_color";
    public static final ColorReference INVALID_COLOR_REFERENCE = new ColorReference("invalid_color");
    @Nullable
    private final String paletteColorName;
    @Nullable
    private final HexColor uniqueColor;
    private final boolean isValid;

    public static ColorReference paletteOrRaw(RPLENamedColor palette, short raw) {
        return palette == null ? new ColorReference(new HexColor(raw)) : new ColorReference(palette);
    }

    public ColorReference(RPLENamedColor color) {
        this.uniqueColor = null;
        String paletteColorName = color.paletteColorName();
        if (ColorPalette.isValidPaletteColorName(paletteColorName)) {
            this.paletteColorName = paletteColorName;
            this.isValid = true;
            return;
        }
        this.paletteColorName = INVALID_COLOR;
        this.isValid = false;
    }

    public ColorReference(@Nullable HexColor uniqueColor) {
        this.paletteColorName = null;
        this.uniqueColor = uniqueColor;
        this.isValid = this.uniqueColor != null;
    }

    public ColorReference(@Nullable String color) {
        if (color != null) {
            if (HexColor.isValidColorHex(color)) {
                this.paletteColorName = null;
                this.uniqueColor = new HexColor(color);
                this.isValid = true;
                return;
            }
            if (ColorPalette.isValidPaletteColorName(color)) {
                this.paletteColorName = color;
                this.uniqueColor = null;
                this.isValid = true;
                return;
            }
        }
        this.paletteColorName = null;
        this.uniqueColor = null;
        this.isValid = false;
    }

    public short color(ColorPalette palette) {
        Optional<HexColor> paletteColor;
        if (!this.isValid) {
            return DefaultColor.ERROR.rgb16();
        }
        if (this.uniqueColor != null) {
            return this.uniqueColor.rgb16();
        }
        if (this.paletteColorName != null && (paletteColor = palette.colour(this.paletteColorName)).isPresent()) {
            return paletteColor.get().rgb16();
        }
        return DefaultColor.ERROR.rgb16();
    }

    public int hashCode() {
        if (this.uniqueColor != null) {
            return this.uniqueColor.hashCode();
        }
        if (this.paletteColorName != null) {
            return this.paletteColorName.hashCode();
        }
        return INVALID_COLOR.hashCode();
    }

    public String toString() {
        if (this.uniqueColor != null) {
            return this.uniqueColor.toString();
        }
        if (this.paletteColorName != null) {
            return this.paletteColorName;
        }
        return INVALID_COLOR;
    }

    @Generated
    public boolean isValid() {
        return this.isValid;
    }
}

