/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.colorizer;

import com.falsepattern.rple.internal.common.block.RPLEBlockInit;
import gnu.trove.map.TIntShortMap;
import gnu.trove.map.hash.TIntShortHashMap;
import java.util.Arrays;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public final class ColoredBlockedReference {
    private final RPLEBlockInit block;
    private short baseBrightnessColor = (short)-1;
    private short baseTranslucencyColor = (short)-1;
    private final TIntShortMap metaBrightnessColorsMap = new TIntShortHashMap();
    private final TIntShortMap metaTranslucencyColorsMap = new TIntShortHashMap();

    public void metaBrightnessColorsMap(int blockMeta, short color) {
        if (blockMeta >= 0) {
            this.metaBrightnessColorsMap.put(blockMeta, color);
        }
    }

    public void metaTranslucencyColorsMap(int blockMeta, short color) {
        if (blockMeta >= 0) {
            this.metaTranslucencyColorsMap.put(blockMeta, color);
        }
    }

    public void apply() {
        this.block.rple$initBaseBrightnessColor(this.baseBrightnessColor);
        this.block.rple$initBaseTranslucencyColor(this.baseTranslucencyColor);
        this.block.rple$initMetaBrightnessColors(this.metaColorsArrayFromMap(this.metaBrightnessColorsMap));
        this.block.rple$initMetaTranslucencyColors(this.metaColorsArrayFromMap(this.metaTranslucencyColorsMap));
        this.block.rple$finishColorInit();
    }

    private short @Nullable [] metaColorsArrayFromMap(TIntShortMap metaColorsMap) {
        if (metaColorsMap.isEmpty()) {
            return null;
        }
        int[] blockMetas = metaColorsMap.keys();
        int maxBlockMeta = Arrays.stream(blockMetas).max().orElse(-1);
        if (maxBlockMeta < 0) {
            return null;
        }
        int metaColorsLength = maxBlockMeta + 1;
        short[] metaColors = new short[metaColorsLength];
        for (int blockMeta : blockMetas) {
            metaColors[blockMeta] = metaColorsMap.get(blockMeta);
        }
        return metaColors;
    }

    @Generated
    public ColoredBlockedReference(RPLEBlockInit block) {
        this.block = block;
    }

    @Generated
    public void baseBrightnessColor(short baseBrightnessColor) {
        this.baseBrightnessColor = baseBrightnessColor;
    }

    @Generated
    public void baseTranslucencyColor(short baseTranslucencyColor) {
        this.baseTranslucencyColor = baseTranslucencyColor;
    }
}

