/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.colorizer;

import com.falsepattern.rple.api.common.color.RPLENamedColor;
import com.falsepattern.rple.api.common.colorizer.RPLEBlockColorRegistry;
import com.falsepattern.rple.api.common.colorizer.RPLEBlockColorizer;
import com.falsepattern.rple.api.common.entity.EntityColorizerFunction;
import com.falsepattern.rple.api.common.entity.RPLEEntityColorRegistry;
import com.falsepattern.rple.api.common.item.ItemColorizerFunction;
import com.falsepattern.rple.api.common.item.RPLEItemColorRegistry;
import com.falsepattern.rple.internal.RPLEDefaultValues;
import com.falsepattern.rple.internal.common.block.RPLEBlockInit;
import com.falsepattern.rple.internal.common.colorizer.BlockColorizer;
import com.falsepattern.rple.internal.common.colorizer.ColoredBlockedReference;
import com.falsepattern.rple.internal.common.colorizer.Colorizer;
import com.falsepattern.rple.internal.common.colorizer.NullBlockColorizer;
import com.falsepattern.rple.internal.common.config.ColorConfigLoader;
import com.falsepattern.rple.internal.common.config.container.BlockColorConfig;
import com.falsepattern.rple.internal.common.config.container.BlockReference;
import com.falsepattern.rple.internal.common.config.container.ColorPalette;
import com.falsepattern.rple.internal.common.config.container.ColorReference;
import com.falsepattern.rple.internal.common.event.EventPoster;
import com.falsepattern.rple.internal.common.util.LogHelper;
import com.falsepattern.rple.internal.common.world.RPLEWorldProvider;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.block.Block;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockColorManager
implements RPLEBlockColorRegistry,
RPLEItemColorRegistry,
RPLEEntityColorRegistry {
    private static final Logger LOG = LogHelper.createLogger("BlockColorManager");
    private static final BlockColorManager INSTANCE = new BlockColorManager();
    private BlockColorConfig config;
    private final List<Colorizer<ItemColorizerFunction>> itemColorizers = new ArrayList<Colorizer<ItemColorizerFunction>>();
    private final List<Colorizer<EntityColorizerFunction>> entityColorizers = new ArrayList<Colorizer<EntityColorizerFunction>>();
    private boolean registryLocked = false;

    public static BlockColorManager blockColorManager() {
        return INSTANCE;
    }

    public void registerBlockColors() {
        Optional<Integer> blockMeta;
        ColoredBlockedReference colouredBlock;
        ColorReference blockColorReference;
        RPLEBlockInit block;
        BlockReference blockReference;
        if (this.registryLocked) {
            return;
        }
        this.config = new BlockColorConfig();
        RPLEDefaultValues.preloadDefaultColorPalette(this.config);
        RPLEDefaultValues.registerDefaultBlockBrightnessColors(this);
        RPLEDefaultValues.registerDefaultBlockTranslucencyColors(this);
        EventPoster.postBlockColorRegistrationEvent(this);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            EventPoster.postItemColorRegistrationEvent(this);
            EventPoster.postEntityColorRegistrationEvent(this);
        }
        try {
            ColorConfigLoader.saveGeneratedConfig(this.config);
        }
        catch (IOException e) {
            LOG.error("Failed to save generated config", (Throwable)e);
        }
        try {
            ColorConfigLoader.loadCustomConfig().ifPresent(customConfig -> {
                this.config = customConfig;
            });
        }
        catch (IOException e) {
            LOG.error("Failed to load custom config", (Throwable)e);
            this.config = new BlockColorConfig();
        }
        ColorPalette colorPalette = this.config.palette();
        Map<BlockReference, ColorReference> blockBrightnessMap = this.config.brightness();
        Map<BlockReference, ColorReference> blockTranslucencyMap = this.config.translucency();
        IdentityHashMap<RPLEBlockInit, ColoredBlockedReference> colouredBlocks = new IdentityHashMap<RPLEBlockInit, ColoredBlockedReference>();
        for (Map.Entry<BlockReference, ColorReference> blockBrightness : blockBrightnessMap.entrySet()) {
            blockReference = blockBrightness.getKey();
            if (!blockReference.isValid() || (block = this.blockFromBlockReference(blockReference)) == null) continue;
            blockColorReference = blockBrightness.getValue();
            short brightness = blockColorReference.color(colorPalette);
            colouredBlock = colouredBlocks.computeIfAbsent(block, ColoredBlockedReference::new);
            blockMeta = blockReference.meta();
            if (blockMeta.isPresent()) {
                colouredBlock.metaBrightnessColorsMap(blockMeta.get(), brightness);
                continue;
            }
            colouredBlock.baseBrightnessColor(brightness);
        }
        for (Map.Entry<BlockReference, ColorReference> blockTranslucency : blockTranslucencyMap.entrySet()) {
            blockReference = blockTranslucency.getKey();
            if (!blockReference.isValid() || (block = this.blockFromBlockReference(blockReference)) == null) continue;
            blockColorReference = blockTranslucency.getValue();
            short translucency = blockColorReference.color(colorPalette);
            colouredBlock = colouredBlocks.computeIfAbsent(block, ColoredBlockedReference::new);
            blockMeta = blockReference.meta();
            if (blockMeta.isPresent()) {
                colouredBlock.metaTranslucencyColorsMap(blockMeta.get(), translucency);
                continue;
            }
            colouredBlock.baseTranslucencyColor(translucency);
        }
        colouredBlocks.values().forEach(ColoredBlockedReference::apply);
        String configHashCode = "0x" + String.format("%08x", this.config.hashCode()).toUpperCase();
        RPLEWorldProvider.redRPLEWorldProvider().applyConfigHashCode(configHashCode);
        RPLEWorldProvider.greenRPLEWorldProvider().applyConfigHashCode(configHashCode);
        RPLEWorldProvider.blueRPLEWorldProvider().applyConfigHashCode(configHashCode);
        this.registryLocked = true;
    }

    @Override
    @NotNull
    public RPLEBlockColorizer colorizeBlock(@NotNull Block block) {
        if (this.registryLocked) {
            LOG.error("Block cannot be colorized after post init", new Throwable());
            return NullBlockColorizer.nullBlockColorizer();
        }
        String blockID = this.blockIDFromBlock(block);
        if (blockID == null) {
            return NullBlockColorizer.nullBlockColorizer();
        }
        return new BlockColorizer(new BlockReference(blockID), this::applyBlockColors);
    }

    @Override
    @NotNull
    public RPLEBlockColorizer colorizeBlock(@NotNull Block block, int blockMeta) {
        if (this.registryLocked) {
            LOG.error("Block cannot be colorized after post init", new Throwable());
            return NullBlockColorizer.nullBlockColorizer();
        }
        String blockID = this.blockIDFromBlock(block);
        if (blockID == null) {
            return NullBlockColorizer.nullBlockColorizer();
        }
        return new BlockColorizer(new BlockReference(blockID + ":" + blockMeta), this::applyBlockColors);
    }

    @Override
    @NotNull
    public RPLEBlockColorizer colorizeBlock(@NotNull String blockID) {
        if (this.registryLocked) {
            LOG.error("Block cannot be colorized after post init", new Throwable());
            return NullBlockColorizer.nullBlockColorizer();
        }
        if (blockID == null) {
            LOG.error("Block ID can't be null", new Throwable());
            return NullBlockColorizer.nullBlockColorizer();
        }
        return new BlockColorizer(new BlockReference(blockID), this::applyBlockColors);
    }

    @Nullable
    private String blockIDFromBlock(@Nullable Block block) {
        if (block == null) {
            LOG.error("Block can't be null", new Throwable());
            return null;
        }
        GameRegistry.UniqueIdentifier blockID = GameRegistry.findUniqueIdentifierFor((Block)block);
        if (blockID == null) {
            LOG.error("Block not registered", new Throwable());
            return null;
        }
        String blockDomain = blockID.modId;
        if (blockDomain == null) {
            LOG.error("Block domain can't be null", new Throwable());
            return null;
        }
        String blockName = blockID.name;
        if (blockName == null) {
            LOG.error("Block name can't be null", new Throwable());
            return null;
        }
        return blockDomain + ":" + blockName;
    }

    @Nullable
    private RPLEBlockInit blockFromBlockReference(BlockReference blockReference) {
        if (blockReference == null) {
            return null;
        }
        String blockDomain = blockReference.domain();
        String blockName = blockReference.name();
        if (blockDomain == null || blockName == null) {
            return null;
        }
        Block block = GameRegistry.findBlock((String)blockDomain, (String)blockName);
        if (block instanceof RPLEBlockInit) {
            return (RPLEBlockInit)block;
        }
        return null;
    }

    private void applyBlockColors(BlockColorizer colorizer) {
        if (this.registryLocked) {
            LOG.error("Cannot to apply block colors after post init", new Throwable());
            return;
        }
        colorizer.paletteBrightness().ifPresent(this::addPaletteColor);
        colorizer.paletteTranslucency().ifPresent(this::addPaletteColor);
        colorizer.brightness().ifPresent(this::setBlockBrightness);
        colorizer.translucency().ifPresent(this::setBlockTranslucency);
    }

    private void setBlockBrightness(BlockColorizer.BlockColorReference blockColor) {
        ColorReference color;
        if (!blockColor.isValid()) {
            LOG.error("Failed to apply invalid block brightness color", (Throwable)new IllegalArgumentException());
            return;
        }
        BlockReference block = blockColor.block();
        Optional<ColorReference> oldColor = this.config.setBlockBrightness(block, color = blockColor.color());
        if (oldColor.isPresent()) {
            LOG.warn("Re-Colorized block [{}] with old brightness [{}] to [{}]", new Object[]{block, oldColor.get(), color});
        } else {
            LOG.info("Colorized block [{}] with brightness [{}]", new Object[]{block, color});
        }
    }

    private void setBlockTranslucency(BlockColorizer.BlockColorReference blockColor) {
        ColorReference color;
        if (!blockColor.isValid()) {
            LOG.error("Failed to apply invalid block translucency color", (Throwable)new IllegalArgumentException());
            return;
        }
        BlockReference block = blockColor.block();
        Optional<ColorReference> oldColor = this.config.setBlockTranslucency(block, color = blockColor.color());
        if (oldColor.isPresent()) {
            LOG.warn("Re-Colorized block [{}] with old translucency [{}] to [{}]", new Object[]{block, oldColor.get(), color});
        } else {
            LOG.info("Colorized block [{}] with translucency [{}]", new Object[]{block, color});
        }
    }

    private void addPaletteColor(RPLENamedColor color) {
        this.config.addPaletteColor(color);
    }

    @Override
    public void registerItemColorCallback(ItemColorizerFunction callback, int sortingIndex) {
        this.itemColorizers.add(new Colorizer<ItemColorizerFunction>(callback, sortingIndex));
    }

    @Override
    public void registerEntityColorCallback(EntityColorizerFunction callback, int sortingIndex) {
        this.entityColorizers.add(new Colorizer<EntityColorizerFunction>(callback, sortingIndex));
    }

    @Generated
    private BlockColorManager() {
    }

    @Generated
    public List<Colorizer<ItemColorizerFunction>> itemColorizers() {
        return this.itemColorizers;
    }

    @Generated
    public List<Colorizer<EntityColorizerFunction>> entityColorizers() {
        return this.entityColorizers;
    }
}

