/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.chunk;

import com.falsepattern.chunk.api.ArrayUtil;
import com.falsepattern.lumi.api.LumiChunkAPI;
import com.falsepattern.lumi.api.chunk.LumiChunk;
import com.falsepattern.lumi.api.chunk.LumiSubChunk;
import com.falsepattern.lumi.api.lighting.LightType;
import com.falsepattern.rple.api.common.block.RPLEBlock;
import com.falsepattern.rple.api.common.color.ColorChannel;
import com.falsepattern.rple.internal.common.chunk.RPLEChunk;
import com.falsepattern.rple.internal.common.chunk.RPLEChunkRoot;
import com.falsepattern.rple.internal.common.chunk.RPLESubChunk;
import com.falsepattern.rple.internal.common.chunk.RPLESubChunkRoot;
import com.falsepattern.rple.internal.common.world.RPLEWorld;
import com.falsepattern.rple.internal.common.world.RPLEWorldRoot;
import java.nio.ByteBuffer;
import java.util.BitSet;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RPLEChunkContainer
implements RPLEChunk {
    private static final String RED_CHUNK_ID = "rple_" + (Object)((Object)ColorChannel.RED_CHANNEL) + "_chunk";
    private static final String GREEN_CHUNK_ID = "rple_" + (Object)((Object)ColorChannel.GREEN_CHANNEL) + "_chunk";
    private static final String BLUE_CHUNK_ID = "rple_" + (Object)((Object)ColorChannel.BLUE_CHANNEL) + "_chunk";
    private final ColorChannel channel;
    private final RPLEWorld world;
    private final RPLEChunkRoot root;
    private final LumiChunk lumiChunk;
    private final int chunkPosX;
    private final int chunkPosZ;
    private int[] skyLightHeightMap;
    private final BitSet upToDateSkylightColumns;
    private int minSkyLightHeight;
    private int queuedRandomLightUpdates;
    private boolean isLightingInitialized;
    private boolean upToDateSkylightColumnsClear;

    public RPLEChunkContainer(ColorChannel channel, RPLEWorldRoot worldRoot, RPLEChunkRoot root, LumiChunk lumiChunk) {
        this.channel = channel;
        this.world = worldRoot.rple$world(channel);
        this.lumiChunk = lumiChunk;
        this.root = root;
        this.chunkPosX = lumiChunk.lumi$chunkPosX();
        this.chunkPosZ = lumiChunk.lumi$chunkPosZ();
        this.skyLightHeightMap = new int[256];
        this.upToDateSkylightColumns = new BitSet(256);
        this.minSkyLightHeight = Integer.MAX_VALUE;
        this.queuedRandomLightUpdates = 0;
        this.isLightingInitialized = false;
        this.upToDateSkylightColumnsClear = true;
    }

    @Override
    @NotNull
    public ColorChannel rple$channel() {
        return this.channel;
    }

    @Override
    @NotNull
    public RPLEChunkRoot lumi$root() {
        return this.root;
    }

    @Override
    @NotNull
    public RPLEWorld lumi$world() {
        return this.world;
    }

    @NotNull
    public String lumi$chunkID() {
        switch (this.channel) {
            default: {
                return RED_CHUNK_ID;
            }
            case GREEN_CHANNEL: {
                return GREEN_CHUNK_ID;
            }
            case BLUE_CHANNEL: 
        }
        return BLUE_CHUNK_ID;
    }

    public void lumi$writeToNBT(@NotNull NBTTagCompound output) {
        output.func_74783_a("sky_light_height_map", this.skyLightHeightMap);
        output.func_74757_a("lighting_initialized", this.isLightingInitialized);
    }

    public void lumi$readFromNBT(@NotNull NBTTagCompound input) {
        int[] skyLightHeightMapInput;
        boolean isLightInitializedInput;
        this.isLightingInitialized = false;
        if (input.func_150297_b("lighting_initialized", 1) && (isLightInitializedInput = input.func_74767_n("lighting_initialized")) && input.func_150297_b("sky_light_height_map", 11) && (skyLightHeightMapInput = input.func_74759_k("sky_light_height_map")).length == 256) {
            System.arraycopy(skyLightHeightMapInput, 0, this.skyLightHeightMap, 0, 256);
            this.isLightingInitialized = true;
        }
        if (!this.isLightingInitialized) {
            LumiChunkAPI.scheduleChunkLightingEngineInit((LumiChunk)this);
        }
    }

    public void lumi$cloneFrom(@NotNull LumiChunk from) {
        this.skyLightHeightMap = ArrayUtil.copyArray((int[])from.lumi$skyLightHeightMap(), (int[])this.lumi$skyLightHeightMap());
        this.isLightingInitialized = from.lumi$isLightingInitialized();
    }

    public void lumi$writeToPacket(@NotNull ByteBuffer output) {
    }

    public void lumi$readFromPacket(@NotNull ByteBuffer input) {
        this.isLightingInitialized = true;
    }

    @Override
    @Nullable
    public RPLESubChunk lumi$getSubChunkIfPrepared(int chunkPosY) {
        LumiSubChunk lumiSubChunk = this.lumiChunk.lumi$getSubChunkIfPrepared(chunkPosY);
        if (!(lumiSubChunk instanceof RPLESubChunkRoot)) {
            return null;
        }
        RPLESubChunkRoot subChunkRoot = (RPLESubChunkRoot)lumiSubChunk;
        return subChunkRoot.rple$subChunk(this.channel);
    }

    @Override
    @NotNull
    public RPLESubChunk lumi$getSubChunk(int chunkPosY) {
        LumiSubChunk lumiSubChunk = this.lumiChunk.lumi$getSubChunk(chunkPosY);
        RPLESubChunkRoot subChunkRoot = (RPLESubChunkRoot)lumiSubChunk;
        return subChunkRoot.rple$subChunk(this.channel);
    }

    public int lumi$chunkPosX() {
        return this.chunkPosX;
    }

    public int lumi$chunkPosZ() {
        return this.chunkPosZ;
    }

    public void lumi$queuedRandomLightUpdates(int queuedRandomLightUpdates) {
        this.queuedRandomLightUpdates = queuedRandomLightUpdates;
    }

    public int lumi$queuedRandomLightUpdates() {
        return this.queuedRandomLightUpdates;
    }

    public void lumi$resetQueuedRandomLightUpdates() {
        this.queuedRandomLightUpdates = 0;
    }

    public int lumi$getBrightness(@NotNull LightType lightType, int subChunkPosX, int posY, int subChunkPosZ) {
        switch (lightType) {
            case BLOCK_LIGHT_TYPE: {
                return this.lumi$getBrightness(subChunkPosX, posY, subChunkPosZ);
            }
            case SKY_LIGHT_TYPE: {
                return this.lumi$getSkyLightValue(subChunkPosX, posY, subChunkPosZ);
            }
        }
        return 0;
    }

    public int lumi$getBrightness(int subChunkPosX, int posY, int subChunkPosZ) {
        int blockBrightness = this.lumi$getBlockBrightness(subChunkPosX, posY, subChunkPosZ);
        int blockLightValue = this.lumi$getBlockLightValue(subChunkPosX, posY, subChunkPosZ);
        return Math.max(blockBrightness, blockLightValue);
    }

    public int lumi$getLightValue(int subChunkPosX, int posY, int subChunkPosZ) {
        int blockLightValue = this.lumi$getBlockLightValue(subChunkPosX, posY, subChunkPosZ);
        int skyLightValue = this.lumi$getSkyLightValue(subChunkPosX, posY, subChunkPosZ);
        return Math.max(blockLightValue, skyLightValue);
    }

    public void lumi$setLightValue(@NotNull LightType lightType, int subChunkPosX, int posY, int subChunkPosZ, int lightValue) {
        switch (lightType) {
            case BLOCK_LIGHT_TYPE: {
                this.lumi$setBlockLightValue(subChunkPosX, posY, subChunkPosZ, lightValue);
                break;
            }
            case SKY_LIGHT_TYPE: {
                this.lumi$setSkyLightValue(subChunkPosX, posY, subChunkPosZ, lightValue);
                break;
            }
        }
    }

    public int lumi$getLightValue(@NotNull LightType lightType, int subChunkPosX, int posY, int subChunkPosZ) {
        switch (lightType) {
            case BLOCK_LIGHT_TYPE: {
                return this.lumi$getBlockLightValue(subChunkPosX, posY, subChunkPosZ);
            }
            case SKY_LIGHT_TYPE: {
                return this.lumi$getSkyLightValue(subChunkPosX, posY, subChunkPosZ);
            }
        }
        return 0;
    }

    public void lumi$setBlockLightValue(int subChunkPosX, int posY, int subChunkPosZ, int lightValue) {
        int chunkPosY = (posY & 0xFF) / 16;
        int subChunkPosY = posY & 0xF;
        RPLESubChunk subChunk = this.lumi$getSubChunk(chunkPosY);
        subChunk.lumi$setBlockLightValue(subChunkPosX &= 0xF, subChunkPosY, subChunkPosZ &= 0xF, lightValue);
        this.root.lumi$markDirty();
    }

    public int lumi$getBlockLightValue(int subChunkPosX, int posY, int subChunkPosZ) {
        int chunkPosY = (posY & 0xFF) / 16;
        RPLESubChunk subChunk = this.lumi$getSubChunkIfPrepared(chunkPosY);
        if (subChunk == null) {
            return LightType.BLOCK_LIGHT_TYPE.defaultLightValue();
        }
        int subChunkPosY = posY & 0xF;
        return subChunk.lumi$getBlockLightValue(subChunkPosX &= 0xF, subChunkPosY, subChunkPosZ &= 0xF);
    }

    public void lumi$setSkyLightValue(int subChunkPosX, int posY, int subChunkPosZ, int lightValue) {
        if (!this.world.lumi$root().lumi$hasSky()) {
            return;
        }
        int chunkPosY = (posY & 0xFF) / 16;
        int subChunkPosY = posY & 0xF;
        RPLESubChunk subChunk = this.lumi$getSubChunk(chunkPosY);
        subChunk.lumi$setSkyLightValue(subChunkPosX &= 0xF, subChunkPosY, subChunkPosZ &= 0xF, lightValue);
        this.root.lumi$markDirty();
    }

    public int lumi$getSkyLightValue(int subChunkPosX, int posY, int subChunkPosZ) {
        if (!this.world.lumi$root().lumi$hasSky()) {
            return 0;
        }
        int chunkPosY = (posY & 0xFF) >> 4;
        subChunkPosX &= 0xF;
        subChunkPosZ &= 0xF;
        RPLESubChunk subChunk = this.lumi$getSubChunkIfPrepared(chunkPosY);
        if (subChunk == null) {
            if (this.lumi$canBlockSeeSky(subChunkPosX, posY, subChunkPosZ)) {
                return LightType.SKY_LIGHT_TYPE.defaultLightValue();
            }
            return 0;
        }
        int subChunkPosY = posY & 0xF;
        return subChunk.lumi$getSkyLightValue(subChunkPosX, subChunkPosY, subChunkPosZ);
    }

    public int lumi$getBlockBrightness(int subChunkPosX, int posY, int subChunkPosZ) {
        Block blockBase = this.root.lumi$getBlock(subChunkPosX, posY, subChunkPosZ);
        int blockMeta = this.root.lumi$getBlockMeta(subChunkPosX, posY, subChunkPosZ);
        return this.lumi$getBlockBrightness(blockBase, blockMeta, subChunkPosX, posY, subChunkPosZ);
    }

    public int lumi$getBlockOpacity(int subChunkPosX, int posY, int subChunkPosZ) {
        Block blockBase = this.root.lumi$getBlock(subChunkPosX, posY, subChunkPosZ);
        int blockMeta = this.root.lumi$getBlockMeta(subChunkPosX, posY, subChunkPosZ);
        return this.lumi$getBlockOpacity(blockBase, blockMeta, subChunkPosX, posY, subChunkPosZ);
    }

    public int lumi$getBlockBrightness(@NotNull Block blockBase, int blockMeta, int subChunkPosX, int posY, int subChunkPosZ) {
        if (!this.isLightingInitialized) {
            RPLEBlock block = RPLEBlock.of(blockBase);
            return this.channel.componentFromColor(block.rple$getRawBrightnessColor(blockMeta));
        }
        int posX = (this.chunkPosX << 4) + subChunkPosX;
        int posZ = (this.chunkPosZ << 4) + subChunkPosZ;
        return this.world.lumi$getBlockBrightness(blockBase, blockMeta, posX, posY, posZ);
    }

    public int lumi$getBlockOpacity(@NotNull Block blockBase, int blockMeta, int subChunkPosX, int posY, int subChunkPosZ) {
        if (!this.isLightingInitialized) {
            RPLEBlock block = RPLEBlock.of(blockBase);
            return this.channel.componentFromColor(block.rple$getRawOpacityColor(blockMeta));
        }
        int posX = (this.chunkPosX << 4) + subChunkPosX;
        int posZ = (this.chunkPosZ << 4) + subChunkPosZ;
        return this.world.lumi$getBlockOpacity(blockBase, blockMeta, posX, posY, posZ);
    }

    public boolean lumi$canBlockSeeSky(int subChunkPosX, int posY, int subChunkPosZ) {
        int index = (subChunkPosX &= 0xF) + ((subChunkPosZ &= 0xF) << 4);
        int maxPosY = this.skyLightHeightMap[index];
        return maxPosY <= posY;
    }

    public void lumi$skyLightHeight(int subChunkPosX, int subChunkPosZ, int skyLightHeight) {
        int index = (subChunkPosX &= 0xF) + ((subChunkPosZ &= 0xF) << 4);
        this.skyLightHeightMap[index] = skyLightHeight;
    }

    public int lumi$skyLightHeight(int subChunkPosX, int subChunkPosZ) {
        int index = (subChunkPosX &= 0xF) + ((subChunkPosZ &= 0xF) << 4);
        return this.skyLightHeightMap[index];
    }

    public void lumi$minSkyLightHeight(int minSkyLightHeight) {
        this.minSkyLightHeight = minSkyLightHeight;
    }

    public int lumi$minSkyLightHeight() {
        return this.minSkyLightHeight;
    }

    public void lumi$resetSkyLightHeightMap() {
        LumiChunkAPI.resetHeightMapArray((int[])this.skyLightHeightMap);
        this.minSkyLightHeight = Integer.MAX_VALUE;
    }

    public void lumi$isHeightOutdated(int subChunkPosX, int subChunkPosZ, boolean isHeightOutdated) {
        int index = (subChunkPosX &= 0xF) + ((subChunkPosZ &= 0xF) << 4);
        this.upToDateSkylightColumns.set(index, !isHeightOutdated);
        this.upToDateSkylightColumnsClear = false;
    }

    public boolean lumi$isHeightOutdated(int subChunkPosX, int subChunkPosZ) {
        int index = (subChunkPosX &= 0xF) + ((subChunkPosZ &= 0xF) << 4);
        return !this.upToDateSkylightColumns.get(index);
    }

    public void lumi$resetOutdatedHeightFlags() {
        if (!this.upToDateSkylightColumnsClear) {
            this.upToDateSkylightColumns.clear();
            this.upToDateSkylightColumnsClear = true;
        }
    }

    public void lumi$isLightingInitialized(boolean isLightingInitialized) {
        this.isLightingInitialized = isLightingInitialized;
    }

    public boolean lumi$isLightingInitialized() {
        return this.isLightingInitialized;
    }

    public void lumi$resetLighting() {
        this.isLightingInitialized = false;
        this.world.lumi$lightingEngine().handleChunkInit((LumiChunk)this);
    }

    public int[] lumi$skyLightHeightMap() {
        return this.skyLightHeightMap;
    }
}

