/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.client.lightmap;

import com.falsepattern.rple.api.client.lightmap.RPLELightMapStrip;
import java.util.Arrays;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class LightMapStrip
implements RPLELightMapStrip {
    private final float[] lightMapRedData = new float[16];
    private final float[] lightMapGreenData = new float[16];
    private final float[] lightMapBlueData = new float[16];

    public LightMapStrip() {
        this.resetLightMap();
    }

    @Override
    @NotNull
    public RPLELightMapStrip setLightMap(int index, float brightness) {
        this.lightMapRedData[index] = brightness;
        this.lightMapGreenData[index] = brightness;
        this.lightMapBlueData[index] = brightness;
        return this;
    }

    @Override
    @NotNull
    public RPLELightMapStrip setLightMapRed(int index, float red) {
        this.lightMapRedData[index] = red;
        return this;
    }

    @Override
    @NotNull
    public RPLELightMapStrip setLightMapGreen(int index, float green) {
        this.lightMapGreenData[index] = green;
        return this;
    }

    @Override
    @NotNull
    public RPLELightMapStrip setLightMapBlue(int index, float blue) {
        this.lightMapBlueData[index] = blue;
        return this;
    }

    @Override
    @NotNull
    public RPLELightMapStrip setLightMapRGB(int index, float red, float green, float blue) {
        this.lightMapRedData[index] = red;
        this.lightMapGreenData[index] = green;
        this.lightMapBlueData[index] = blue;
        return this;
    }

    @Override
    @NotNull
    public RPLELightMapStrip fillLightMap(float brightness) {
        Arrays.fill(this.lightMapRedData, brightness);
        Arrays.fill(this.lightMapGreenData, brightness);
        Arrays.fill(this.lightMapBlueData, brightness);
        return this;
    }

    @Override
    @NotNull
    public RPLELightMapStrip fillLightMapRGB(float red, float green, float blue) {
        Arrays.fill(this.lightMapRedData, red);
        Arrays.fill(this.lightMapGreenData, green);
        Arrays.fill(this.lightMapBlueData, blue);
        return this;
    }

    @Override
    @NotNull
    public RPLELightMapStrip fillLightMapRed(float red) {
        Arrays.fill(this.lightMapRedData, red);
        return this;
    }

    @Override
    @NotNull
    public RPLELightMapStrip fillLightMapGreen(float green) {
        Arrays.fill(this.lightMapGreenData, green);
        return this;
    }

    @Override
    @NotNull
    public RPLELightMapStrip fillLightMapBlue(float blue) {
        Arrays.fill(this.lightMapBlueData, blue);
        return this;
    }

    @Override
    @NotNull
    public RPLELightMapStrip setLightMap(@NotNull RPLELightMapStrip strip) {
        float[] otherLightMapRed = strip.lightMapRedData();
        float[] otherLightMapGreen = strip.lightMapGreenData();
        float[] otherLightMapBlue = strip.lightMapBlueData();
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this.lightMapRedData[n] = this.lightMapRedData[n] / otherLightMapRed[i];
            int n2 = i;
            this.lightMapGreenData[n2] = this.lightMapGreenData[n2] / otherLightMapGreen[i];
            int n3 = i;
            this.lightMapBlueData[n3] = this.lightMapBlueData[n3] / otherLightMapBlue[i];
        }
        return this;
    }

    @Override
    @NotNull
    public RPLELightMapStrip addLightMap(@NotNull RPLELightMapStrip strip) {
        float[] otherLightMapRed = strip.lightMapRedData();
        float[] otherLightMapGreen = strip.lightMapGreenData();
        float[] otherLightMapBlue = strip.lightMapBlueData();
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this.lightMapRedData[n] = this.lightMapRedData[n] + otherLightMapRed[i];
            int n2 = i;
            this.lightMapGreenData[n2] = this.lightMapGreenData[n2] + otherLightMapGreen[i];
            int n3 = i;
            this.lightMapBlueData[n3] = this.lightMapBlueData[n3] + otherLightMapBlue[i];
        }
        return this;
    }

    @Override
    @NotNull
    public RPLELightMapStrip subLightMap(@NotNull RPLELightMapStrip strip) {
        float[] otherLightMapRed = strip.lightMapRedData();
        float[] otherLightMapGreen = strip.lightMapGreenData();
        float[] otherLightMapBlue = strip.lightMapBlueData();
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this.lightMapRedData[n] = this.lightMapRedData[n] - otherLightMapRed[i];
            int n2 = i;
            this.lightMapGreenData[n2] = this.lightMapGreenData[n2] - otherLightMapGreen[i];
            int n3 = i;
            this.lightMapBlueData[n3] = this.lightMapBlueData[n3] - otherLightMapBlue[i];
        }
        return this;
    }

    @Override
    @NotNull
    public RPLELightMapStrip mulLightMap(@NotNull RPLELightMapStrip strip) {
        float[] otherLightMapRed = strip.lightMapRedData();
        float[] otherLightMapGreen = strip.lightMapGreenData();
        float[] otherLightMapBlue = strip.lightMapBlueData();
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this.lightMapRedData[n] = this.lightMapRedData[n] * otherLightMapRed[i];
            int n2 = i;
            this.lightMapGreenData[n2] = this.lightMapGreenData[n2] * otherLightMapGreen[i];
            int n3 = i;
            this.lightMapBlueData[n3] = this.lightMapBlueData[n3] * otherLightMapBlue[i];
        }
        return this;
    }

    @Override
    @NotNull
    public RPLELightMapStrip divLightMap(@NotNull RPLELightMapStrip strip) {
        float[] otherLightMapRed = strip.lightMapRedData();
        float[] otherLightMapGreen = strip.lightMapGreenData();
        float[] otherLightMapBlue = strip.lightMapBlueData();
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this.lightMapRedData[n] = this.lightMapRedData[n] / otherLightMapRed[i];
            int n2 = i;
            this.lightMapGreenData[n2] = this.lightMapGreenData[n2] / otherLightMapGreen[i];
            int n3 = i;
            this.lightMapBlueData[n3] = this.lightMapBlueData[n3] / otherLightMapBlue[i];
        }
        return this;
    }

    @Override
    @NotNull
    public RPLELightMapStrip resetLightMap() {
        Arrays.fill(this.lightMapRedData, 1.0f);
        Arrays.fill(this.lightMapGreenData, 1.0f);
        Arrays.fill(this.lightMapBlueData, 1.0f);
        return this;
    }

    @Override
    @Generated
    public float[] lightMapRedData() {
        return this.lightMapRedData;
    }

    @Override
    @Generated
    public float[] lightMapGreenData() {
        return this.lightMapGreenData;
    }

    @Override
    @Generated
    public float[] lightMapBlueData() {
        return this.lightMapBlueData;
    }
}

