/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.client.dynlights;

import com.falsepattern.falsetweaks.api.dynlights.DynamicLightsDriver;
import com.falsepattern.falsetweaks.api.dynlights.FTDynamicLights;
import com.falsepattern.lib.util.MathUtil;
import com.falsepattern.rple.api.client.ClientColorHelper;
import com.falsepattern.rple.api.client.CookieMonster;
import com.falsepattern.rple.api.common.ServerColorHelper;
import com.falsepattern.rple.api.common.block.RPLEBlock;
import com.falsepattern.rple.api.common.color.LightValueColor;
import com.falsepattern.rple.api.common.entity.EntityColorizerFunction;
import com.falsepattern.rple.api.common.item.ItemColorizerFunction;
import com.falsepattern.rple.internal.client.dynlights.ColorDynamicLight;
import com.falsepattern.rple.internal.common.colorizer.BlockColorManager;
import com.falsepattern.rple.internal.common.colorizer.Colorizer;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class ColorDynamicLights
implements DynamicLightsDriver {
    public static final ColorDynamicLights INSTANCE = new ColorDynamicLights();
    private static final Int2ObjectMap<ColorDynamicLight> mapDynamicLights = new Int2ObjectArrayMap();
    private static final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static long timeUpdateMs = 0L;
    private static final double MAX_DIST = 16.0;
    private static final double MAX_DIST_SQ = 256.0;
    private static final int LIGHT_LEVEL_MAX = 15;

    private static ReentrantReadWriteLock.WriteLock busyWaitWriteLock() {
        ReentrantReadWriteLock.WriteLock lock = rwLock.writeLock();
        while (!lock.tryLock()) {
            Thread.yield();
        }
        return lock;
    }

    private static ReentrantReadWriteLock.ReadLock busyWaitReadLock() {
        ReentrantReadWriteLock.ReadLock lock = rwLock.readLock();
        while (!lock.tryLock()) {
            Thread.yield();
        }
        return lock;
    }

    private ColorDynamicLights() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onReload(ConfigChangedEvent e) {
        if (e.modID.equals("falsetweaks")) {
            this.removeLights(Minecraft.func_71410_x().field_71438_f);
        }
    }

    public boolean enabled() {
        return FTDynamicLights.isDynamicLights();
    }

    public void entityAdded(Entity entityIn, RenderGlobal renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityRemoved(Entity entityIn, RenderGlobal renderGlobal) {
        ReentrantReadWriteLock.WriteLock lock = ColorDynamicLights.busyWaitWriteLock();
        try {
            ColorDynamicLight dynamicLight = (ColorDynamicLight)mapDynamicLights.remove(entityIn.func_145782_y());
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(RenderGlobal renderGlobal) {
        long timeNowMs = System.currentTimeMillis();
        if (timeNowMs < timeUpdateMs + 50L) {
            return;
        }
        timeUpdateMs = timeNowMs;
        ReentrantReadWriteLock.WriteLock lock = ColorDynamicLights.busyWaitWriteLock();
        try {
            this.updateMapDynamicLights(renderGlobal);
            if (!mapDynamicLights.isEmpty()) {
                for (ColorDynamicLight dynamicLight : mapDynamicLights.values()) {
                    dynamicLight.update(renderGlobal);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void updateMapDynamicLights(RenderGlobal renderGlobal) {
        block5: {
            WorldClient world;
            block6: {
                boolean lightHand;
                block4: {
                    world = renderGlobal.field_72769_h;
                    if (world == null) {
                        this.removeLights(renderGlobal);
                    }
                    if (world == null) {
                        return;
                    }
                    boolean lightEntity = FTDynamicLights.isDynamicEntityLight();
                    lightHand = FTDynamicLights.isDynamicHandLight();
                    if (!lightEntity || !lightHand) break block4;
                    for (Entity entity : world.func_72910_y()) {
                        this.updateMapDynamicLightsEntity(renderGlobal, entity);
                    }
                    break block5;
                }
                if (!lightHand) break block6;
                EntityLivingBase player = Minecraft.func_71410_x().field_71451_h;
                if (player == null) break block5;
                this.updateMapDynamicLightsEntity(renderGlobal, (Entity)player);
                break block5;
            }
            EntityLivingBase player = Minecraft.func_71410_x().field_71451_h;
            for (Entity entity : world.func_72910_y()) {
                if (entity == player) continue;
                this.updateMapDynamicLightsEntity(renderGlobal, entity);
            }
        }
    }

    private void updateMapDynamicLightsEntity(RenderGlobal renderGlobal, Entity entity) {
        short lightLevel = this.getLightLevel(entity);
        if (ServerColorHelper.red(lightLevel) > 0 || ServerColorHelper.green(lightLevel) > 0 || ServerColorHelper.blue(lightLevel) > 0) {
            int key = entity.func_145782_y();
            ColorDynamicLight dynamicLight = (ColorDynamicLight)mapDynamicLights.get(key);
            if (dynamicLight == null) {
                dynamicLight = new ColorDynamicLight(entity);
                mapDynamicLights.put(key, (Object)dynamicLight);
            }
        } else {
            int key = entity.func_145782_y();
            ColorDynamicLight dynamicLight = (ColorDynamicLight)mapDynamicLights.remove(key);
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    public int getCombinedLight(int x, int y, int z, int combinedLight) {
        DoubleBrightness lightPlayer = this.getLightLevel(x, y, z);
        return ColorDynamicLights.getCombinedLight(lightPlayer, combinedLight);
    }

    public int getCombinedLight(Entity entity, int combinedLight) {
        short lightPlayer = this.getLightLevel(entity);
        return ColorDynamicLights.getCombinedLight(new DoubleBrightness(ServerColorHelper.red(lightPlayer), ServerColorHelper.green(lightPlayer), ServerColorHelper.blue(lightPlayer)), combinedLight);
    }

    private static int getCombinedLight(DoubleBrightness lightPlayer, int combinedLight) {
        if (lightPlayer.r > 0.0 || lightPlayer.g > 0.0 || lightPlayer.b > 0.0) {
            long splitCombined = CookieMonster.RGB64FromCookie(combinedLight);
            int combinedR = ClientColorHelper.vanillaFromRGB64Red(splitCombined);
            int combinedG = ClientColorHelper.vanillaFromRGB64Green(splitCombined);
            int combinedB = ClientColorHelper.vanillaFromRGB64Blue(splitCombined);
            int combinedSr = ClientColorHelper.sky8BitFromVanilla(combinedR);
            int combinedSg = ClientColorHelper.sky8BitFromVanilla(combinedG);
            int combinedSb = ClientColorHelper.sky8BitFromVanilla(combinedB);
            int combinedBr = ClientColorHelper.block8BitFromVanilla(combinedR);
            int combinedBg = ClientColorHelper.block8BitFromVanilla(combinedG);
            int combinedBb = ClientColorHelper.block8BitFromVanilla(combinedB);
            int lightPlayerR = (int)(lightPlayer.r * 16.0);
            int lightPlayerG = (int)(lightPlayer.g * 16.0);
            int lightPlayerB = (int)(lightPlayer.b * 16.0);
            if (lightPlayerR > combinedBr) {
                combinedBr = lightPlayerR;
            }
            if (lightPlayerG > combinedBg) {
                combinedBg = lightPlayerG;
            }
            if (lightPlayerB > combinedBb) {
                combinedBb = lightPlayerB;
            }
            combinedLight = CookieMonster.cookieFromRGB64(ClientColorHelper.RGB64FromVanillaRGB(ClientColorHelper.vanillaFromBlockSky8Bit(combinedBr, combinedSr), ClientColorHelper.vanillaFromBlockSky8Bit(combinedBg, combinedSg), ClientColorHelper.vanillaFromBlockSky8Bit(combinedBb, combinedSb)));
        }
        return combinedLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DoubleBrightness getLightLevel(int x, int y, int z) {
        EntityLivingBase rve = Minecraft.func_71410_x().field_71451_h;
        double lightLevelMaxR = 0.0;
        double lightLevelMaxG = 0.0;
        double lightLevelMaxB = 0.0;
        ReentrantReadWriteLock.ReadLock lock = ColorDynamicLights.busyWaitReadLock();
        try {
            for (ColorDynamicLight dynamicLight : mapDynamicLights.values()) {
                double lightB;
                double lightG;
                double lightR;
                boolean isHand;
                boolean bl = isHand = dynamicLight.getEntity() == rve;
                if (isHand && !FTDynamicLights.isDynamicHandLight() || !isHand && !FTDynamicLights.isDynamicEntityLight()) continue;
                short dynamicLightLevel = dynamicLight.getLastLightLevel();
                double dynamicR = ServerColorHelper.red(dynamicLightLevel);
                double dynamicG = ServerColorHelper.green(dynamicLightLevel);
                double dynamicB = ServerColorHelper.blue(dynamicLightLevel);
                if (!(dynamicR > 0.0) && !(dynamicG > 0.0) && !(dynamicB > 0.0)) continue;
                double px = dynamicLight.getLastPosX();
                double py = dynamicLight.getLastPosY();
                double pz = dynamicLight.getLastPosZ();
                double dx = (double)x - px;
                double dy = (double)y - py;
                double dz = (double)z - pz;
                if (dynamicLight.isUnderwater()) {
                    dynamicR = MathUtil.clamp((double)(dynamicR - 2.0), (double)0.0, (double)15.0);
                    dynamicG = MathUtil.clamp((double)(dynamicG - 2.0), (double)0.0, (double)15.0);
                    dynamicB = MathUtil.clamp((double)(dynamicB - 2.0), (double)0.0, (double)15.0);
                    dx *= 2.0;
                    dy *= 2.0;
                    dz *= 2.0;
                }
                if (FTDynamicLights.isCircular()) {
                    double distSq = dx * dx + dy * dy + dz * dz;
                    if (distSq <= 256.0) {
                        float dist = MathUtil.sqrt((double)distSq);
                        lightR = MathUtil.clamp((double)(dynamicR - (double)dist), (double)0.0, (double)15.0);
                        lightG = MathUtil.clamp((double)(dynamicG - (double)dist), (double)0.0, (double)15.0);
                        lightB = MathUtil.clamp((double)(dynamicB - (double)dist), (double)0.0, (double)15.0);
                    } else {
                        lightB = 0.0;
                        lightG = 0.0;
                        lightR = 0.0;
                    }
                } else {
                    dx = Math.abs(dx);
                    dy = Math.abs(dy);
                    dz = Math.abs(dz);
                    double dist = Math.max(dx - 0.25, 0.0) + Math.max(dy - 0.25, 0.0) + Math.max(dz - 0.25, 0.0);
                    lightR = MathUtil.clamp((double)(dynamicR - dist), (double)0.0, (double)15.0);
                    lightG = MathUtil.clamp((double)(dynamicG - dist), (double)0.0, (double)15.0);
                    lightB = MathUtil.clamp((double)(dynamicB - dist), (double)0.0, (double)15.0);
                }
                if (lightR > lightLevelMaxR) {
                    lightLevelMaxR = lightR;
                }
                if (lightG > lightLevelMaxG) {
                    lightLevelMaxG = lightG;
                }
                if (!(lightB > lightLevelMaxB)) continue;
                lightLevelMaxB = lightB;
            }
        }
        finally {
            lock.unlock();
        }
        lightLevelMaxR = MathUtil.clamp((double)lightLevelMaxR, (double)0.0, (double)15.0);
        lightLevelMaxG = MathUtil.clamp((double)lightLevelMaxG, (double)0.0, (double)15.0);
        lightLevelMaxB = MathUtil.clamp((double)lightLevelMaxB, (double)0.0, (double)15.0);
        return new DoubleBrightness(lightLevelMaxR, lightLevelMaxG, lightLevelMaxB);
    }

    public static short getLightLevel(ItemStack itemStack) {
        if (itemStack == null) {
            return LightValueColor.LIGHT_VALUE_0.rgb16();
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            Block block = itemBlock.field_150939_a;
            if (block != null) {
                return RPLEBlock.of(block).rple$getBrightnessColor(itemStack.func_77960_j());
            }
            return LightValueColor.LIGHT_VALUE_0.rgb16();
        }
        for (Colorizer<ItemColorizerFunction> colorizer : BlockColorManager.blockColorManager().itemColorizers()) {
            short color = colorizer.function().get(itemStack);
            if (color == -1) continue;
            return color;
        }
        return LightValueColor.LIGHT_VALUE_0.rgb16();
    }

    public short getLightLevel(Entity entity) {
        for (Colorizer<EntityColorizerFunction> colorizer : BlockColorManager.blockColorManager().entityColorizers()) {
            short color = colorizer.function().get(entity);
            if (color == -1) continue;
            return color;
        }
        return LightValueColor.LIGHT_VALUE_0.rgb16();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLights(RenderGlobal renderGlobal) {
        ReentrantReadWriteLock.WriteLock lock = ColorDynamicLights.busyWaitWriteLock();
        try {
            for (ColorDynamicLight dynamicLight : mapDynamicLights.values()) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
            mapDynamicLights.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public void clear() {
        ReentrantReadWriteLock.WriteLock lock = ColorDynamicLights.busyWaitWriteLock();
        try {
            mapDynamicLights.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public int getCount() {
        ReentrantReadWriteLock.ReadLock lock = ColorDynamicLights.busyWaitReadLock();
        try {
            int n = mapDynamicLights.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public static ItemStack getItemStack(EntityItem entityItem) {
        return entityItem.func_70096_w().func_82710_f(10);
    }

    private static class DoubleBrightness {
        public final double r;
        public final double g;
        public final double b;

        @Generated
        public DoubleBrightness(double r, double g, double b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }
    }
}

