/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal;

import com.falsepattern.falsetweaks.api.ThreadedChunkUpdates;
import com.ventooth.swansong.pbr.PBRTextureEngine;
import com.ventooth.swansong.shader.ShaderEngine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import lombok.Generated;
import makamys.neodymium.Neodymium;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.launchwrapper.Launch;

public final class Compat {
    private static final boolean IS_SWANSONG_PRESENT;
    private static final boolean IS_FALSETWEAKS_PRESENT;
    private static Boolean NEODYMIUM;

    public static boolean falseTweaksThreadedChunksEnabled() {
        if (IS_FALSETWEAKS_PRESENT) {
            return ThreadedChunkUpdates.isEnabled();
        }
        return false;
    }

    public static boolean neodymiumInstalled() {
        if (NEODYMIUM != null) {
            return NEODYMIUM;
        }
        try {
            NEODYMIUM = Launch.classLoader.getClassBytes("makamys.neodymium.Neodymium") != null;
        }
        catch (IOException e) {
            e.printStackTrace();
            NEODYMIUM = false;
        }
        return NEODYMIUM;
    }

    public static boolean neodymiumActive() {
        return Compat.neodymiumInstalled() && Neodymium.isActive();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean shadersEnabled() {
        if (IS_SWANSONG_PRESENT) {
            return SwanSongCompat.initialized();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void optiFineSetActiveTexture(int texture) {
        SwanSongCompat.isDefaultTexUnit(OpenGlHelper.field_77478_a == texture);
    }

    @SideOnly(value=Side.CLIENT)
    public static Tessellator tessellator() {
        if (ThreadedChunkUpdates.isEnabled()) {
            return ThreadedChunkUpdates.getThreadTessellator();
        }
        return Tessellator.field_78398_a;
    }

    @Generated
    private Compat() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        NEODYMIUM = null;
        boolean swanSongPresent = false;
        try {
            swanSongPresent = Launch.classLoader.getClassBytes("com.ventooth.swansong.SwanSong") != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IS_SWANSONG_PRESENT = swanSongPresent;
        boolean falseTweaksPresent = false;
        try {
            falseTweaksPresent = Launch.classLoader.getClassBytes("com.falsepattern.falsetweaks.FalseTweaks") != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IS_FALSETWEAKS_PRESENT = falseTweaksPresent;
    }

    private static class SwanSongCompat {
        private SwanSongCompat() {
        }

        public static void isDefaultTexUnit(boolean toggle) {
            PBRTextureEngine.isDefaultTexUnit((boolean)toggle);
        }

        public static boolean initialized() {
            return ShaderEngine.isInitialized();
        }
    }
}

