/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.api.common.color;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.rple.api.common.ServerColorHelper;
import com.falsepattern.rple.api.common.color.RPLENamedColor;
import org.jetbrains.annotations.NotNull;

@StableAPI(since="1.0.0")
public enum LightValueColor implements RPLENamedColor
{
    LIGHT_VALUE_0,
    LIGHT_VALUE_1,
    LIGHT_VALUE_2,
    LIGHT_VALUE_3,
    LIGHT_VALUE_4,
    LIGHT_VALUE_5,
    LIGHT_VALUE_6,
    LIGHT_VALUE_7,
    LIGHT_VALUE_8,
    LIGHT_VALUE_9,
    LIGHT_VALUE_10,
    LIGHT_VALUE_11,
    LIGHT_VALUE_12,
    LIGHT_VALUE_13,
    LIGHT_VALUE_14,
    LIGHT_VALUE_15;

    private static final LightValueColor[] VALUES;
    @StableAPI.Internal
    public static final String LIGHT_LEVEL_COLOR_DOMAIN = "light_value";
    private final String paletteColorName;
    private final short rgb16;

    private LightValueColor() {
        int lightValue = this.ordinal();
        this.rgb16 = ServerColorHelper.RGB16FromRGBChannel4Bit(lightValue, lightValue, lightValue);
        this.paletteColorName = "light_value:" + lightValue;
    }

    @Override
    public String paletteColorName() {
        return this.paletteColorName;
    }

    @Override
    public short rgb16() {
        return this.rgb16;
    }

    @StableAPI.Expose
    @NotNull
    public static LightValueColor fromVanillaLightValue(int vanillaLightValue) {
        int index = vanillaLightValue & 0xF;
        return VALUES[index];
    }

    @StableAPI.Expose
    @NotNull
    public static LightValueColor fromVanillaLightOpacity(int vanillaLightOpacity) {
        int index = 15 - (vanillaLightOpacity & 0xF);
        return VALUES[index];
    }

    static {
        VALUES = LightValueColor.values();
    }
}

