/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.api.common;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.util.MathUtil;

@StableAPI(since="1.0.0")
public final class ServerColorHelper {
    public static final int COLOR_MIN = 0;
    public static final int COLOR_MAX = 15;
    public static final int CHANNEL_4BIT_MASK = 15;
    public static final int CHANNEL_4BIT_TO_RGB16_RED = 8;
    public static final int CHANNEL_4BIT_TO_RGB16_GREEN = 4;
    public static final int CHANNEL_4BIT_TO_RGB16_BLUE = 0;

    private ServerColorHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @StableAPI.Expose
    public static short RGB16OpacityTranslucentSwap(short val) {
        if (val == -1) {
            return -1;
        }
        int red = ServerColorHelper.invertColorComponent(ServerColorHelper.red(val));
        int green = ServerColorHelper.invertColorComponent(ServerColorHelper.green(val));
        int blue = ServerColorHelper.invertColorComponent(ServerColorHelper.blue(val));
        return ServerColorHelper.RGB16FromRGBChannel4Bit(red, green, blue);
    }

    @StableAPI.Expose
    public static short RGB16FromRGBChannel4Bit(int red, int green, int blue) {
        return (short)((red & 0xF) << 8 | (green & 0xF) << 4 | (blue & 0xF) << 0);
    }

    @StableAPI.Expose
    public static int red(short rgb16) {
        return rgb16 >> 8 & 0xF;
    }

    @StableAPI.Expose
    public static int green(short rgb16) {
        return rgb16 >> 4 & 0xF;
    }

    @StableAPI.Expose
    public static int blue(short rgb16) {
        return rgb16 >> 0 & 0xF;
    }

    @StableAPI.Expose
    public static int lightValueFromRGB16(short rgb16) {
        return ServerColorHelper.maxColorComponent(rgb16);
    }

    @StableAPI.Expose
    public static int lightOpacityFromRGB16(short rgb16) {
        return ServerColorHelper.invertColorComponent(ServerColorHelper.maxColorComponent(rgb16));
    }

    @StableAPI.Expose
    public static int clampColorComponent(int component) {
        return MathUtil.clamp((int)component, (int)0, (int)15);
    }

    @StableAPI.Expose
    public static int invertColorComponent(int component) {
        return 15 - ServerColorHelper.clampColorComponent(component);
    }

    @StableAPI.Expose
    public static int minColorComponent(short rgb16) {
        return ServerColorHelper.minColorComponent(ServerColorHelper.red(rgb16), ServerColorHelper.green(rgb16), ServerColorHelper.blue(rgb16));
    }

    @StableAPI.Expose
    public static int maxColorComponent(short rgb16) {
        return ServerColorHelper.maxColorComponent(ServerColorHelper.red(rgb16), ServerColorHelper.green(rgb16), ServerColorHelper.blue(rgb16));
    }

    @StableAPI.Expose
    public static int minColorComponent(int red, int green, int blue) {
        return Math.min(red, Math.min(green, blue));
    }

    @StableAPI.Expose
    public static int maxColorComponent(int red, int green, int blue) {
        return Math.max(red, Math.max(green, blue));
    }

    public static short max(short a, short b) {
        return ServerColorHelper.RGB16FromRGBChannel4Bit(Math.max(ServerColorHelper.red(a), ServerColorHelper.red(b)), Math.max(ServerColorHelper.green(a), ServerColorHelper.green(b)), Math.max(ServerColorHelper.blue(a), ServerColorHelper.blue(b)));
    }
}

